/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.CredentialsInterface;
import com.sas.management.MetadataFactory;
import com.sas.management.ValidatorException;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.servers.ApplicationServerInterface;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorInterface;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.Machine;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.information.Filter;
import com.sas.services.information.FilterInterface;
import com.sas.services.user.UserContextInterface;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class LogicalServerImpl
extends MetadataImpl
implements LogicalServerInterface,
ServerValidatorInterface,
CredentialsInterface {
    private String m_strType = null;
    private ServerInterface[] m_aryServers = new ServerInterface[0];
    private ApplicationServerInterface m_svrApplication = null;
    private MetaServerConnection m_metaConn;
    private Properties m_serverParms;
    private UserContextInterface m_usrContext = null;
    private PasswordAuthentication m_credentials;
    private Logger m_logger;

    public LogicalServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID);
        this.setMetaConnection(metaConn);
        this.setServerParms(serverParms);
        this.setUserContext(user);
        if (metaConn != null && this.getID() != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            LogicalServer server = (LogicalServer)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><LogicalServer><UsingComponents/><UsedByComponents/></LogicalServer><ServerComponent><SoftwareTrees/></ServerComponent><Tree><Members/></Tree></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "LogicalServer", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (LogicalServer)objectList.get(0);
                }
            }
            this.setType(server.getClassIdentifier());
            AssociationList usingComponentsList = server.getUsingComponents();
            for (int compIndex = 0; compIndex < usingComponentsList.size(); ++compIndex) {
                ServerComponent component = (ServerComponent)usingComponentsList.get(compIndex);
                if (!component.getClassIdentifier().equalsIgnoreCase(server.getClassIdentifier())) continue;
                Machine[] aryMachine = ServerUtil.getHosts(component);
                for (int hostIndex = 0; hostIndex < aryMachine.length; ++hostIndex) {
                    Machine host = aryMachine[hostIndex];
                    String strHostID = host.getFQID();
                    ServerInterface s = (ServerInterface)ServerFactory.getServers().get(ServerUtil.getServerMapKey(component.getFQID(), strHostID));
                    if (s == null) {
                        s = ServerFactory.newServer(this.getMetaConnection(), component.getFQID(), strHostID, component.getClassIdentifier(), null, this.getUserContext());
                    }
                    if (s == null) continue;
                    this.addServer(s);
                }
                if (aryMachine.length != 0) continue;
                ServerInterface s = (ServerInterface)ServerFactory.getServers().get(component.getFQID());
                if (s == null) {
                    s = ServerFactory.newServer(this.getMetaConnection(), component.getFQID(), component.getClassIdentifier(), null, this.getUserContext());
                }
                if (s == null) continue;
                this.addServer(s);
            }
            AssociationList lstUsedByComponents = server.getUsedByComponents();
            for (int compIndex = 0; compIndex < lstUsedByComponents.size(); ++compIndex) {
                DeployedComponent component = (DeployedComponent)lstUsedByComponents.get(compIndex);
                if (!(component instanceof ServerContext)) continue;
                ApplicationServerInterface applicationServer = (ApplicationServerInterface)ServerFactory.getServers().get(component.getFQID());
                if (applicationServer == null) {
                    applicationServer = ServerFactory.newApplicationServer(this.getMetaConnection(), component.getFQID(), this.getServerParms(), this.getUserContext());
                }
                this.setApplicationServer(applicationServer);
            }
            this.setObjectState(1);
            for (int serverIndex = 0; serverIndex < this.getServers().length; ++serverIndex) {
                ServerInterface s = this.getServers()[serverIndex];
                if (s.getLogicalServer() == null || s.getLogicalServer().getObjectState() != 0) continue;
                s.setLogicalServer(this);
            }
        }
        catch (ServerException exc) {
            ServerUtil.logServerException((Throwable)((Object)exc), this.getLogger());
        }
        catch (MdException exc) {
            ServerUtil.logServerException(exc, this.getLogger());
        }
        catch (RemoteException exc) {
            ServerUtil.logServerException(exc, this.getLogger());
        }
    }

    @Override
    public String getType() {
        return this.m_strType;
    }

    @Override
    public ServerInterface[] getServers() {
        return this.m_aryServers;
    }

    @Override
    public ApplicationServerInterface getApplicationServer() {
        return this.m_svrApplication;
    }

    @Override
    public void setType(String type) {
        this.m_strType = type;
    }

    @Override
    public void addServer(ServerInterface server) throws ServerException {
        if (server.getObjectState() == 1 && !server.getType().equalsIgnoreCase(this.getType())) {
            throw new ServerException("Argument 'server' should be of type '" + this.getType() + "'");
        }
        ServerInterface[] aryServers = new ServerInterface[this.m_aryServers.length + 1];
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            ServerInterface svr;
            aryServers[serverIndex] = svr = this.m_aryServers[serverIndex];
        }
        aryServers[aryServers.length - 1] = server;
        this.m_aryServers = aryServers;
    }

    @Override
    public void deleteServer(ServerInterface server) throws ServerException {
        if (server.getObjectState() == 1 && !server.getType().equalsIgnoreCase(this.getType())) {
            throw new ServerException("Argument 'server' should be of type '" + this.getType() + "'");
        }
        boolean bContainsServer = false;
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            ServerInterface svr = this.m_aryServers[serverIndex];
            if (svr != server) continue;
            bContainsServer = true;
            break;
        }
        if (!bContainsServer) {
            throw new ServerException("Server is not on list - cannot remove!");
        }
        ServerInterface[] aryServers = new ServerInterface[this.m_aryServers.length - 1];
        int index = -1;
        for (int serverIndex = 0; serverIndex < this.m_aryServers.length; ++serverIndex) {
            ServerInterface svr = this.m_aryServers[serverIndex];
            if (svr == server) continue;
            aryServers[++index] = svr;
        }
        this.m_aryServers = aryServers;
    }

    @Override
    public void setApplicationServer(ApplicationServerInterface server) {
        this.m_svrApplication = server;
    }

    @Override
    public abstract void validateSimple() throws ServerValidatorException;

    @Override
    public abstract void validateExtended() throws ServerValidatorException;

    @Override
    public void validate() throws ValidatorException {
        this.validateSimple();
        this.validateExtended();
    }

    @Override
    public MetaServerConnection getMetaConnection() {
        return this.m_metaConn;
    }

    @Override
    public void setMetaConnection(MetaServerConnection metaConn) {
        this.m_metaConn = metaConn;
    }

    public Properties getServerParms() {
        return this.m_serverParms;
    }

    public void setServerParms(Properties serverParms) {
        this.m_serverParms = serverParms;
    }

    @Override
    public UserContextInterface getUserContext() {
        return this.m_usrContext;
    }

    @Override
    public void setUserContext(UserContextInterface user) {
        this.m_usrContext = user;
    }

    public PasswordAuthentication getCredentials() {
        return this.m_credentials;
    }

    public void setCredentials(PasswordAuthentication credentials) {
        this.m_credentials = credentials;
    }

    @Override
    public boolean isUsingMetaConnection() {
        return this.m_metaConn != null;
    }

    protected com.sas.services.information.metadata.LogicalServerInterface getInfoLogicalServer() throws ServiceException, RemoteException {
        com.sas.services.information.metadata.LogicalServerInterface logicalServer = null;
        com.sas.services.information.ServerInterface authServer = this.getUserContext().getAuthServer();
        Filter filter = new Filter();
        filter.setType("LogicalServer");
        filter.setName(this.getName());
        filter.setOMRRepository(this.getMetaConnection().getReposId());
        List serverList = authServer.search((FilterInterface)filter);
        int serverIndex = 0;
        if (serverIndex < serverList.size()) {
            logicalServer = (com.sas.services.information.metadata.LogicalServerInterface)serverList.get(serverIndex);
        }
        return logicalServer;
    }

    protected ServerValidatorException logServerValidatorException(String message, String validationType, int validationLevel) {
        return ServerValidatorUtil.logServerValidatorException(message, validationType, validationLevel, this.getLogger());
    }

    protected ServerValidatorException logServerValidatorException(Throwable throwable, String validationType, int validationLevel) {
        return ServerValidatorUtil.logServerValidatorException(throwable, validationType, validationLevel, this.getLogger());
    }

    @Override
    public Logger getLogger() {
        return this.m_logger;
    }

    @Override
    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }
}

