/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerAdministrationHelper;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerInformationHelper;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMCommon.IServerLogHelper;
import com.sas.iom.SASIOMCommon.IServerSessions;
import com.sas.iom.SASIOMCommon.IServerSessionsHelper;
import com.sas.iom.SASIOMDefs.UUID;
import com.sas.management.servers.InstanceServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnedServerInterface;
import com.sas.management.servers.impl.IOMServerImpl;
import com.sas.management.servers.options.ServerOptionInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.ServiceException;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class InstanceServerImpl
extends IOMServerImpl
implements InstanceServerInterface {
    private SpawnedServerInterface m_server = null;
    private UUID m_uuid = null;
    private String m_strProcessID = null;
    private int m_iPort = -1;
    private ConnectionFactoryConfiguration m_cxfConfig = null;
    private ConnectionInterface m_cx = null;
    protected static WAdminResource bundle = new WAdminResource(InstanceServerImpl.class);

    public InstanceServerImpl(SpawnedServerInterface server, UUID uuid, MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, hostID, serverParms, user);
        this.m_server = server;
        this.m_uuid = uuid;
    }

    @Override
    public UUID getUUID() {
        return this.m_uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.m_uuid = uuid;
    }

    @Override
    public SpawnedServerInterface getServer() {
        return this.m_server;
    }

    @Override
    public void setServer(SpawnedServerInterface server) {
        this.m_server = server;
    }

    @Override
    public String getProcessID() throws ServerException {
        ServerOptionInterface[] optionArray = this.getServerOptions();
        for (int optionIndex = 0; optionIndex < optionArray.length; ++optionIndex) {
            ServerOptionInterface option = optionArray[optionIndex];
            if (!option.getName().equalsIgnoreCase("Server.ProcessIdentifier")) continue;
            this.m_strProcessID = option.getValue();
            break;
        }
        return this.m_strProcessID;
    }

    @Override
    public void setProcessID(String ID) {
        this.m_strProcessID = ID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void connect() throws ServerException {
        if (this.isConnected()) {
            return;
        }
        UserContextInterface user = this.getUserContext();
        try {
            if (this.getType().equalsIgnoreCase("510A5F10-8E07-44AC-942B-EFB5A4782A39")) {
                BridgeServer bridgeServer = new BridgeServer(this.getType(), this.getHost(), this.getPort());
                bridgeServer.setDomain(this.getDomain());
                bridgeServer.setOption("resource", "0");
                this.m_cxfConfig = new ManualConnectionFactoryConfiguration((Server)bridgeServer);
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                UserIdentityInterface userIdentity = user.getAuthServer().generatePassword(null);
                if (userIdentity == null) throw this.logServerException(bundle.getString("ServerImpl.NoCredentials.txt"));
                String strUser = (String)userIdentity.getPrincipal();
                ConnectionInterface cx = cxf.getConnection(strUser, (String)userIdentity.getCredential(), this.getDomain());
                this.setServerConnection(cx);
            } else {
                this.m_cxfConfig = new PlatformConnectionFactoryConfiguration(this.getInfoLogicalServer(), ServerUtil.getServerURI(this), this.getHost(), this.getPort(), true);
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                ConnectionInterface cx = cxf.getConnection(user);
                this.setServerConnection(cx);
            }
            Object obj = ((ConnectionInterface)this.getServerConnection()).getObject();
            IServerAdministration admin = IServerAdministrationHelper.narrow((Object)obj);
            this.setAdministrator(admin);
            IServerInformation info = IServerInformationHelper.narrow((Object)obj);
            this.setInfo(info);
            IServerSessions session = IServerSessionsHelper.narrow((Object)obj);
            this.setSession(session);
            IServerLog log = IServerLogHelper.narrow((Object)obj);
            this.setLog(log);
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        catch (ServiceException exc) {
            throw this.logServerException(exc);
        }
        catch (RemoteException exc) {
            throw this.logServerException(exc);
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    @Override
    public void disconnect() throws ServerException {
        if (!this.isConnected()) {
            return;
        }
        ConnectionFactoryAdminInterface admin = null;
        try {
            PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
            admin = cxf.getAdminInterface();
        }
        catch (ConnectionFactoryException exc) {
            throw this.logServerException(exc);
        }
        finally {
            this.m_cx = (ConnectionInterface)this.getServerConnection();
            if (this.m_cx != null) {
                this.m_cx.close();
                this.setServerConnection(null);
                this.m_cx = null;
            }
            if (admin != null) {
                admin.shutdown();
            }
        }
        this.cleanupUponLostConnection();
    }

    @Override
    protected void cleanupUponLostConnection() {
        for (int serverIndex = 0; serverIndex < this.getServer().getInstanceServers().length; ++serverIndex) {
            InstanceServerInterface server = this.getServer().getInstanceServers()[serverIndex];
            if (server != this) continue;
            this.getServer().removeInstanceServer(server);
            break;
        }
        super.cleanupUponLostConnection();
    }

    protected int getPort() {
        return this.m_iPort;
    }

    protected void setPort(int port) {
        this.m_iPort = port;
    }

    @Override
    public void validateSimple() {
    }

    @Override
    public void validateExtended() {
    }
}

