/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.PathInterface;
import com.sas.management.ValidatorException;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.ContentServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.util.Properties;

public class DMVHTTPServerImpl
extends ContentServerImpl {
    private String m_strProtocol = "http";
    private String m_strAuthType = "user/password";
    private String m_strAuthDomain = "DefaultAuth";
    private String m_strHost = "localhost";
    private int m_port = 80;
    private String m_strContentLocation = "/";
    private SpawnerInterface m_spawner = null;
    private Object m_objConn = null;
    protected static WAdminResource bundle = new WAdminResource(DMVHTTPServerImpl.class);

    public DMVHTTPServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        ConnectionInterface[] connectionArray = this.getConnections();
        for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            ConnectionInterface conn = connectionArray[connIndex];
            this.m_strProtocol = conn.getApplicationProtocol();
            this.m_strAuthType = conn.getAuthenticationType();
            this.m_strAuthDomain = conn.getAuthenticationDomain();
            this.m_port = conn.getPort();
        }
        this.m_strHost = this.getHost();
        PathInterface[] pathArray = this.getPaths();
        for (int pathIndex = 0; pathIndex < pathArray.length; ++pathIndex) {
            PathInterface path = pathArray[pathIndex];
            if (path.supportsDAV()) continue;
            this.removePath(path);
        }
        if (pathArray.length > 0) {
            this.m_strContentLocation = pathArray[0].getPath();
        }
    }

    @Override
    public Object getServerConnection() {
        return this.m_objConn;
    }

    @Override
    public void setServerConnection(Object connection) {
        this.m_objConn = connection;
    }

    @Override
    public void validate() throws ValidatorException {
        if (this.getConnections().length == 0) {
            throw this.logServerValidatorException(bundle.getString("DMVHTTPServerImpl.NoConnection.txt"), "Simple", 1);
        }
        super.validate();
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        ServerValidatorUtil.validateServerPing("HTTP", this.getLogger(), this.m_strHost, this.m_port, 1);
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
    }

    @Override
    public SpawnerInterface getSpawner() {
        return this.m_spawner;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
        this.m_spawner = spawner;
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strContentLocation;
            String strPort;
            String strHost;
            String strAuthDomain;
            String strAuthType;
            String strProtocol = (String)this.getServerParms().get("protocol");
            if (strProtocol != null) {
                this.m_strProtocol = strProtocol;
            }
            if ((strAuthType = (String)this.getServerParms().get("authtype")) != null) {
                this.m_strAuthType = strAuthType;
            }
            if ((strAuthDomain = (String)this.getServerParms().get("authdomain")) != null) {
                this.m_strAuthDomain = strAuthDomain;
            }
            if ((strHost = (String)this.getServerParms().get("host")) != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
            if ((strContentLocation = (String)this.getServerParms().get("contentlocation")) != null) {
                this.m_strContentLocation = strContentLocation;
            }
        }
    }
}

