/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.ConnectSpawner.IConnectSpawnerInformation;
import com.sas.iom.ConnectSpawner.IConnectSpawnerInformationHelper;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.iom.SASIOMDefs.UUIDSeqHolder;
import com.sas.management.servers.ConnectSpawnedServerInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.administrator.ServerStateEvent;
import com.sas.management.servers.administrator.ServerStateModelInterface;
import com.sas.management.servers.impl.ConnectSpawnerImpl;
import com.sas.management.servers.impl.ServerImpl;
import com.sas.management.servers.monitor.SpawnerEvent;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.workspace.WAdminResource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public abstract class ConnectSpawnedServerImpl
extends ServerImpl
implements ConnectSpawnedServerInterface {
    private ConnectionInterface m_cx = null;
    private SpawnerInterface m_spawner = null;
    private SpawnerInterface m_origSpawner = null;
    private static WAdminResource bundle = new WAdminResource(ConnectSpawnedServerImpl.class);
    private ConnectSpawnedServerInterface[] m_spawnedServerArray = new ConnectSpawnedServerInterface[0];

    public ConnectSpawnedServerImpl(MetaServerConnection metaConn, String ID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, serverParms, user);
    }

    public ConnectSpawnedServerImpl(MetaServerConnection metaConn, String ID, String hostID, Properties serverParms, UserContextInterface user) {
        super(metaConn, ID, hostID, serverParms, user);
    }

    @Override
    public void connect() throws ServerException {
        this.m_origSpawner = this.getSpawner();
        if (this.m_origSpawner == null) {
            throw this.logServerException(bundle.getString("SpawnedServerImpl.ServerNotAssociatedToSpawner.txt"));
        }
        this.m_spawner = this.copySpawner(this.m_origSpawner);
        this.setSpawner(this.m_spawner);
        PrivilegedAction action = new PrivilegedAction(){

            public java.lang.Object run() {
                ConnectSpawnedServerImpl.this.getSpawner().getLogger().setParent(ConnectSpawnedServerImpl.this.getLogger());
                ConnectSpawnedServerImpl.this.getSpawner().getLogger().setUseParentHandlers(true);
                return null;
            }
        };
        try {
            AccessController.doPrivileged(action);
        }
        catch (SecurityException exc) {
            this.logServerException(exc);
        }
        this.m_spawner.connect();
        this.m_cx = (ConnectionInterface)this.m_spawner.getServerConnection();
        if (!((ServerAdministratorInterface)((java.lang.Object)this.m_spawner)).isAdministrator()) {
            this.disconnect();
            throw this.logServerException(bundle.getString("SpawnedServerImpl.NoAdminPrivileges.txt"));
        }
        this.fireServerConnectedChanged();
        this.fireServerStateChanged();
    }

    public ConnectSpawnedServerInterface[] getLaunchedServers(SpawnerInterface spawner) throws ServerException {
        ConnectionInterface spCx = (ConnectionInterface)spawner.getServerConnection();
        this.setSpawnerConnection(spCx);
        this.setServerConnection(spCx);
        Object obj = spCx.getObject();
        try {
            IConnectSpawnerInformation spawnerInfo = IConnectSpawnerInformationHelper.narrow((Object)obj);
            String strServerFilter = new String();
            StringSeqHolder strSHServerComponents = new StringSeqHolder();
            UUIDSeqHolder uuidSHServerClasses = new UUIDSeqHolder();
            StringSeqHolder strSHProcessOwners = new StringSeqHolder();
            UUIDSeqHolder uuidSHServerIDs = new UUIDSeqHolder();
            try {
                spawnerInfo.ListLaunchedServers(strServerFilter, strSHServerComponents, uuidSHServerClasses, strSHProcessOwners, uuidSHServerIDs);
            }
            catch (GenericError error) {
                throw this.logServerException(error);
            }
            String[] scArray = strSHServerComponents.value;
            String[] processOwnerArray = strSHProcessOwners.value;
            int scIndex = 0;
            this.m_spawnedServerArray = new ConnectSpawnedServerInterface[scArray.length];
            for (scIndex = 0; scIndex < scArray.length; ++scIndex) {
                String strUser = "";
                String host = "";
                String strSC = scArray[scIndex];
                String processOwner = processOwnerArray[scIndex];
                String delimiter = "[!\\[]";
                String[] tokens = processOwner.split(delimiter);
                if (tokens.length == 2) {
                    strUser = tokens[0];
                    host = tokens[1];
                } else {
                    strUser = tokens[0];
                }
                ConnectSpawnedServerInterface server = ServerFactory.newConnectSpawnedServer(this, strUser);
                server.setHost(host);
                server.setServerName(strSC);
                this.m_spawnedServerArray[scIndex] = server;
            }
        }
        catch (SystemException exc) {
            throw this.logServerException(exc);
        }
        return this.m_spawnedServerArray;
    }

    public ConnectSpawnedServerInterface[] getSpawnedSingleServerArray(SpawnerInterface spawner) throws ServerException {
        ConnectSpawnedServerInterface[] newArray = this.getLaunchedServers(spawner);
        String myServerName = this.getServerName();
        for (ConnectSpawnedServerInterface connectServer : newArray) {
            if (myServerName.equalsIgnoreCase(connectServer.getServerName())) continue;
            newArray = this.removeElements(newArray, connectServer);
        }
        if (newArray.length > 0) {
            newArray[0].setServerName(this.m_spawner.getName());
        }
        return newArray;
    }

    private ConnectSpawnedServerInterface[] removeElements(ConnectSpawnedServerInterface[] input, ConnectSpawnedServerInterface deleteMe) {
        if (input != null) {
            ArrayList<ConnectSpawnedServerInterface> list = new ArrayList<ConnectSpawnedServerInterface>(Arrays.asList(input));
            for (int i = 0; i < list.size(); ++i) {
                if (!((ConnectSpawnedServerInterface)list.get(i)).equals(deleteMe)) continue;
                list.remove(i);
            }
            return list.toArray(new ConnectSpawnedServerInterface[0]);
        }
        return new ConnectSpawnedServerInterface[0];
    }

    @Override
    public void disconnect() throws ServerException {
        if (this.m_cx != null) {
            this.m_cx.close();
            this.m_cx = null;
        }
        this.cleanupUponLostConnection();
    }

    @Override
    protected void cleanupUponLostConnection() {
        this.setServerConnection(null);
        this.fireServerDisconnectedChanged();
        this.fireUnknownServerStateChanged();
    }

    @Override
    public boolean isConnected() {
        if (this.m_spawner != null) {
            return ((ConnectSpawnerImpl)this.m_spawner).isConnected();
        }
        return super.isConnected();
    }

    @Override
    public String getState() throws ServerException {
        if (this.getSpawner() != null) {
            return ((ConnectSpawnerImpl)this.getSpawner()).getState();
        }
        return super.getState();
    }

    public void serverFailed(SpawnerEvent event) {
        this.getLogger().warning("Server " + event.getName() + " failed to start!");
    }

    protected ConnectionInterface getSpawnerConnection() {
        return this.m_cx;
    }

    protected void setSpawnerConnection(ConnectionInterface connection) {
        this.m_cx = connection;
    }

    private SpawnerInterface copySpawner(SpawnerInterface spawner) {
        ConnectSpawnerImpl impl = new ConnectSpawnerImpl(this.getMetaConnection(), spawner.getID(), ((ConnectSpawnerImpl)spawner).getHostID(), ((ConnectSpawnerImpl)spawner).getServerParms(), ((ConnectSpawnerImpl)spawner).getUserContext()){

            @Override
            public void stateChanged(ServerStateEvent event) {
                ServerStateModelInterface mdlState = ServerFactory.getServerStateModel(ConnectSpawnedServerImpl.this);
                mdlState.fireServerStateChanged(event);
                if (event.getState().equalsIgnoreCase("Stopped")) {
                    try {
                        ConnectSpawnedServerImpl.this.disconnect();
                    }
                    catch (ServerException exc) {
                        this.logServerException((Throwable)((java.lang.Object)exc));
                    }
                }
            }
        };
        return impl;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    public ConnectSpawnedServerInterface[] getSpawnedServers() throws ServerException {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        return this.m_spawnedServerArray;
    }

    public void setSpawnedServers(ConnectSpawnedServerInterface[] servers) {
        this.m_spawnedServerArray = servers;
    }
}

