/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.iom.SAS.ILanguageService;
import com.sas.iom.SAS.ILanguageServicePackage.CarriageControlSeqHolder;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.iom.SAS.ILanguageServicePackage.LineTypeSeqHolder;
import com.sas.iom.SAS.IWorkspace;
import com.sas.iom.SAS.IWorkspaceHelper;
import com.sas.iom.SASIOMCommon.IServerAdministration;
import com.sas.iom.SASIOMCommon.IServerInformation;
import com.sas.iom.SASIOMCommon.IServerLog;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.iom.SASIOMDefs.StringSeqHolder;
import com.sas.management.MetadataFactory;
import com.sas.management.MetadataInterface;
import com.sas.management.PropertyInterface;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.SpawnerInterface;
import com.sas.management.servers.administrator.ServerAdministratorInterface;
import com.sas.management.servers.impl.ConnectSpawnedServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.ServerContext;
import com.sas.net.connect.ConnectClient;
import com.sas.net.connect.ConnectException;
import com.sas.net.connect.ConnectLoginException;
import com.sas.net.connect.TelnetConnectClient;
import com.sas.net.connect.privapp.PrivilegedApplicationExtension;
import com.sas.services.ServiceException;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ConnectionFactoryInterface;
import com.sas.services.connection.ConnectionInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryConfiguration;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.information.FilterInterface;
import com.sas.services.information.metadata.LogicalServerInterface;
import com.sas.services.information.metadata.ServerFilter;
import com.sas.services.user.UserContextInterface;
import com.sas.services.user.UserIdentityInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class ConnectServerImpl
extends ConnectSpawnedServerImpl {
    private String m_strAuthDomain = "";
    private String m_strHost = "";
    private String strHostID = null;
    private int m_port = 0;
    private SpawnerInterface m_spawner = null;
    private java.lang.Object m_objConn = null;
    private String m_strCode = "proc options;run;";
    private String m_strLoginPrompt = "Username:";
    private String m_strPasswordPrompt = "Password:";
    private String m_strCommandPrompt = "Hello>";
    private String m_strCommandPromptTimeout = "60";
    private String m_strCommand = "";
    private String m_strSASTagTimeout = "120";
    private String m_encryptionAlgorithm = "";
    private String m_netencrypt = "";
    protected static WAdminResource bundle = new WAdminResource(ConnectServerImpl.class);
    private String m_serverName = null;
    private ServerComponent m_workspace = null;
    UserContextInterface m_userContext;
    private String m_strUser;
    private PasswordAuthentication m_pwAuth = null;
    private String m_strServerType = null;
    private String m_strLevel = null;
    private String m_strValidationMethod = null;
    private static String m_signonPrefixV = "signon serverv=";
    private static String m_signonPrefix = "signon server=";
    private static String m_signoffPrefix = "signoff server=";
    private String signonCode = null;
    private String signoffCode = null;
    private boolean m_scriptSignon = false;
    private boolean m_sascmdSignon = false;
    private boolean m_spawnerSignon = false;
    private ConnectionFactoryConfiguration m_cxfConfig = null;
    private ConnectionInterface m_cx = null;
    private ConnectionFactoryInterface m_cxf = null;
    private ConnectionFactoryAdminInterface m_connectAdmin = null;
    UserContextInterface m_user = null;
    UserIdentityInterface m_userIdentity = null;
    private IServerAdministration m_admin = null;
    private IServerInformation m_info = null;
    private IServerLog m_log = null;
    protected Logger m_logger = Logger.getLogger("com.sas.management.servers.impl.ConnectServerImpl");
    private static WAdminResource m_bundle = new WAdminResource(ConnectServerImpl.class);

    public ConnectServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
        this.initialize();
        this.setServerParms(properties);
    }

    private void initialize() {
        int connIndex;
        com.sas.management.servers.connections.ConnectionInterface[] connectionArray = this.getConnections();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_strAuthDomain = connectionArray[connIndex].getAuthenticationDomain();
            if (this.m_strAuthDomain != null) break;
        }
        this.m_strHost = this.getHost();
        for (connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
            this.m_port = connectionArray[connIndex].getPort();
            if (this.m_port > 0) break;
        }
        PropertyInterface[] aryProperties = this.getProperties();
        for (int propIndex = 0; propIndex < aryProperties.length; ++propIndex) {
            PropertyInterface property = aryProperties[propIndex];
            if (property.getPropertyName().equalsIgnoreCase("Command")) {
                this.m_strCommand = property.getDefaultValue();
            }
            if (property.getPropertyName().equalsIgnoreCase("NETENCRYPTALGORITHM")) {
                this.m_encryptionAlgorithm = property.getDefaultValue();
            }
            if (!property.getPropertyName().equalsIgnoreCase("NETENCRYPT")) continue;
            this.m_netencrypt = property.getDefaultValue();
        }
        if (this.getMetaConnection() != null && this.getID() != null) {
            this.initializeMetadata();
        }
    }

    protected void initializeMetadata() {
        try {
            ServerComponent server = (ServerComponent)MetadataFactory.getStore().getObject(this.getID());
            if (server == null) {
                String strTemplate = "<TEMPLATES><ServerComponent><UsingComponents/></ServerComponent></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "ServerComponent", flags, strOptions, true);
                if (objectList.size() > 0) {
                    server = (ServerComponent)objectList.get(0);
                }
            }
            String strHostID = server.getAssociatedMachine().getName();
            AssociationList usingComponentsList = server.getUsingComponents();
            for (int compIndex = 0; compIndex < usingComponentsList.size(); ++compIndex) {
                DeployedComponent component = (DeployedComponent)usingComponentsList.get(compIndex);
                if (!(component instanceof ServerComponent) || !component.getAssociatedMachine().getName().equalsIgnoreCase(strHostID)) continue;
                String key = ServerUtil.getServerMapKey(component.getFQID(), strHostID);
                Map<String, MetadataInterface> serverMap = ServerFactory.getServers();
                SpawnerInterface s = (SpawnerInterface)serverMap.get(key);
                if (s == null) {
                    s = (SpawnerInterface)ServerFactory.newServer(this.getMetaConnection(), component.getFQID(), strHostID, "Connect Spawner", null, this.getUserContext());
                }
                this.setSpawner(s);
            }
            this.setObjectState(1);
            if (this.getSpawner() != null) {
                ServerInterface[] serverArray = this.getSpawner().getServers();
                for (int serverIndex = 0; serverIndex < serverArray.length; ++serverIndex) {
                    ServerInterface s = serverArray[serverIndex];
                    if (s.getID() == null || !s.getID().equalsIgnoreCase(this.getID())) continue;
                    try {
                        if (s.getObjectState() != 0) continue;
                        this.getSpawner().removeServer(s);
                        this.getSpawner().addServer(this);
                        continue;
                    }
                    catch (ServerException serverException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (MdException exc) {
            this.logServerException(exc);
        }
        catch (RemoteException re) {
            this.logServerException(re);
        }
    }

    @Override
    public java.lang.Object getServerConnection() {
        return this.m_objConn;
    }

    @Override
    public void setServerConnection(java.lang.Object connection) {
        this.m_objConn = connection;
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
        this.initialize();
        this.m_scriptSignon = false;
        this.m_sascmdSignon = false;
        this.m_spawnerSignon = false;
        this.m_serverName = this.getName();
        com.sas.management.servers.connections.ConnectionInterface[] cList = this.getConnections();
        if (cList.length == 1) {
            PropertyInterface[] pList = cList[0].getProperties();
            for (int i = 0; i < pList.length; ++i) {
                if (pList[i].getPropertyName().contains("Prompt")) {
                    this.m_spawnerSignon = true;
                    break;
                }
                if (!pList[i].getPropertyName().contains("SASCMD")) continue;
                this.m_sascmdSignon = true;
                break;
            }
        }
        if (!this.m_spawnerSignon && !this.m_sascmdSignon) {
            this.m_scriptSignon = true;
        }
        if (this.m_sascmdSignon || this.m_scriptSignon) {
            String server = "\"" + this.m_serverName + "\";";
            this.signonCode = m_signonPrefix.concat(server);
            this.signonCode = m_signonPrefix.concat(server);
            String signonCode2 = m_signonPrefixV.concat(server);
            this.signonCode = signonCode2.concat(this.signonCode);
            this.signoffCode = m_signoffPrefix.concat(server);
            this.signonCode = this.signonCode.concat(this.signoffCode);
        }
        if (this.m_spawnerSignon) {
            ServerValidatorUtil.validateServerPing("SAS/CONNECT", this.getLogger(), this.m_strHost, this.m_port, 1);
        }
    }

    @Override
    public void validateExtended() throws ServerValidatorException {
        this.initialize();
        this.m_strServerType = "SAS/CONNECT";
        this.m_strLevel = String.valueOf(1);
        this.m_strValidationMethod = bundle.getString("ServerImpl.MakingConnection.txt");
        this.getLogger().info(bundle.formatString("ServerImpl.StartExtendedValidation.fmt.txt", (java.lang.Object)this.m_strServerType, (java.lang.Object)this.m_strLevel, (java.lang.Object)this.m_strValidationMethod));
        boolean getError = false;
        if (this.m_spawnerSignon) {
            this.validateSpawnerSignon();
        } else {
            block19: {
                try {
                    this.getWorkSpaceServer();
                    if (this.m_workspace != null) {
                        LogicalServerInterface logicalServer = this.getWorkSpaceLogicalServer();
                        this.m_cxfConfig = new PlatformConnectionFactoryConfiguration(logicalServer);
                        this.m_cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)this.m_cxfConfig);
                        this.m_cx = ((PlatformConnectionFactoryInterface)this.m_cxf).getConnection(this.getUserContext());
                        break block19;
                    }
                    ServerValidatorException exc = new ServerValidatorException(bundle.getString("ConnectServerImpl.NoWorkSpace.txt"), "Extended", 1);
                    this.getLogger().severe(exc.getLocalizedMessage());
                    getError = true;
                    throw exc;
                }
                catch (RemoteException exc) {
                    getError = true;
                    throw this.logServerValidatorException(exc, "Extended", 1);
                }
                catch (MdException exc) {
                    getError = true;
                    throw this.logServerValidatorException(exc, "Extended", 1);
                }
                catch (ServiceException exc) {
                    getError = true;
                    throw this.logServerValidatorException(exc, "Extended", 1);
                }
                catch (ConnectionFactoryException e) {
                    getError = true;
                    throw this.logServerValidatorException(e, "Extended", 1);
                }
                finally {
                    try {
                        if (this.m_cxf != null) {
                            this.m_connectAdmin = this.m_cxf.getAdminInterface();
                        }
                    }
                    catch (ConnectionFactoryException e) {
                        getError = true;
                        throw this.logServerValidatorException(e, "Extended", 1);
                    }
                    if (getError) {
                        this.closeFactory();
                    }
                }
            }
            try {
                this.validateConnectServerCodeSubmit(this.signonCode, 2);
            }
            catch (GenericError e) {
                this.closeFactory();
                throw this.logServerValidatorException(e, "Extended", 1);
            }
        }
        this.closeFactory();
    }

    private void closeFactory() {
        if (this.m_cx != null) {
            this.m_cx.close();
        }
        if (this.m_connectAdmin != null) {
            this.m_connectAdmin.shutdown();
        }
    }

    protected LogicalServerInterface getWorkSpaceLogicalServer() throws ServiceException, RemoteException {
        LogicalServerInterface logicalServer = null;
        com.sas.services.information.ServerInterface authServer = this.getUserContext().getAuthServer();
        ServerFilter filter = new ServerFilter();
        filter.setType("ServerComponent");
        filter.setName(this.m_workspace.getName());
        filter.setOMRRepository(this.getMetaConnection().getReposId());
        List serverList = authServer.search((FilterInterface)filter);
        block0: for (int serverIndex = 0; serverIndex < serverList.size(); ++serverIndex) {
            com.sas.services.information.metadata.ServerInterface server = (com.sas.services.information.metadata.ServerInterface)serverList.get(serverIndex);
            List servedObjectList = server.getServed();
            for (int ssIndex = 0; ssIndex < servedObjectList.size(); ++ssIndex) {
                java.lang.Object servedObj = servedObjectList.get(ssIndex);
                if (!(servedObj instanceof LogicalServerInterface)) continue;
                logicalServer = (LogicalServerInterface)servedObj;
                continue block0;
            }
        }
        return logicalServer;
    }

    public void validateConnectServerCodeSubmit(String code, int validationLevel) throws ServerValidatorException, GenericError {
        IWorkspace iWorkspace = null;
        try {
            Object obj = this.m_cx.getObject();
            iWorkspace = IWorkspaceHelper.narrow((Object)obj);
            ILanguageService m_sasLanguage = iWorkspace.LanguageService();
            this.getLogger().fine(bundle.formatString("ConnectServerImpl.CodeToSubmit.fmt.txt", (java.lang.Object)code));
            m_sasLanguage.Submit(code);
            CarriageControlSeqHolder m_logCCHolder = new CarriageControlSeqHolder();
            LineTypeSeqHolder m_logTypeHolder = new LineTypeSeqHolder();
            StringSeqHolder m_logLinesHolder = new StringSeqHolder();
            m_sasLanguage.FlushLogLines(Integer.MAX_VALUE, m_logCCHolder, m_logTypeHolder, m_logLinesHolder);
            LineType[] linetypes = m_logTypeHolder.value;
            String[] lines = m_logLinesHolder.value;
            StringBuffer errormsg = new StringBuffer();
            String previous = null;
            for (int i = 0; i < linetypes.length; ++i) {
                switch (linetypes[i].value()) {
                    case 6: {
                        if (previous == null || lines[i].compareTo(previous) == 0) break;
                        if (errormsg.length() != 0) {
                            errormsg.append("\n");
                        }
                        errormsg.append(lines[i]);
                    }
                }
                previous = lines[i];
                this.getLogger().fine(lines[i].toString());
            }
            if (errormsg.length() > 0) {
                this.getLogger().severe(errormsg.toString());
                throw this.logServerValidatorException(bundle.getString("ConnectServerImpl.signonserver.failed.txt"), "Extended", 1);
            }
            this.getLogger().fine(bundle.getString("ConnectServerImpl.signonserver.ok.txt"));
            iWorkspace.Close();
            this.closeFactory();
        }
        catch (SystemException exc) {
            throw this.logServerValidatorException(exc, "Extended", 1);
        }
    }

    private void validateSpawnerSignon() throws ServerValidatorException {
        if (this.getUserContext() == null) {
            throw this.logServerValidatorException(bundle.getString("ServerImpl.NoCredentials.txt"), "Extended", 1);
        }
        try {
            this.m_user = this.getUserContext();
            List lstIdentities = this.m_user.getIdentitiesByDomain(this.m_strAuthDomain, true, null);
            for (int idIndex = 0; idIndex < lstIdentities.size(); ++idIndex) {
                UserIdentityInterface m_userIdentity = (UserIdentityInterface)lstIdentities.get(idIndex);
                if (m_userIdentity != null) {
                    this.m_strUser = (String)m_userIdentity.getPrincipal();
                    this.m_pwAuth = new PasswordAuthentication(this.m_strUser, ((String)m_userIdentity.getCredential()).toCharArray());
                }
                Properties telnetProperties = new Properties();
                telnetProperties.put("prompt1", this.m_strLoginPrompt);
                telnetProperties.put("response1", this.m_strUser);
                telnetProperties.put("prompt2", this.m_strPasswordPrompt);
                telnetProperties.put("response2", String.valueOf(this.m_pwAuth.getPassword()));
                telnetProperties.put("prompt3", this.m_strCommandPrompt);
                telnetProperties.put("promptTimeout3", this.m_strCommandPromptTimeout);
                telnetProperties.put("response3", this.m_strCommand);
                telnetProperties.put("sasPortTagTimeout", this.m_strSASTagTimeout);
                telnetProperties.put("passwordResponse", "response2");
                telnetProperties.put("invalidLoginTag", "access denied.");
                if (this.m_encryptionAlgorithm != null && this.m_encryptionAlgorithm.trim().length() > 0) {
                    telnetProperties.put("encryptionPolicy", "optional");
                    telnetProperties.put("encryptionAlgorithms", this.m_encryptionAlgorithm);
                }
                telnetProperties.put("serverName", this.m_serverName);
                if (this.m_netencrypt != null && this.m_netencrypt.equalsIgnoreCase("TRUE")) {
                    telnetProperties.put("encryptionPolicy", "required");
                }
                if (Workspace.isDebug()) {
                    telnetProperties.put("debugTelnetConnectClient", "true");
                    telnetProperties.put("connectClientDebugLevel", "3");
                    System.out.println("Telnet properties: " + telnetProperties.toString());
                }
                TelnetConnectClient client = null;
                try {
                    client = new TelnetConnectClient(telnetProperties);
                    try {
                        String extensionKey = "com.sas.net.connect.privapp.PrivilegedApplicationExtension";
                        client.addExtension(extensionKey, this.getClass().getClassLoader());
                        PrivilegedApplicationExtension extension = (PrivilegedApplicationExtension)client.getExtension(extensionKey);
                        Method hook = this.getClass().getMethod("hook", byte[].class);
                        extension.installHook(hook);
                    }
                    catch (NoSuchMethodException extensionKey) {
                        // empty catch block
                    }
                    client.connect(this.m_strHost, this.m_port);
                    this.getLogger().info(bundle.getString("ServerImpl.ConnectionSuccess.txt"));
                    this.m_strLevel = "2";
                    this.m_strValidationMethod = bundle.getString("ServerImpl.SubmittingCode.txt");
                    this.getLogger().info(bundle.formatString("ServerImpl.StartExtendedValidation.fmt.txt", (java.lang.Object)this.m_strServerType, (java.lang.Object)this.m_strLevel, (java.lang.Object)this.m_strValidationMethod));
                    this.getLogger().info(bundle.formatString("ServerImpl.CodeToSubmit.fmt.txt", (java.lang.Object)this.m_strCode));
                    client.rsubmit(this.m_strCode);
                    this.getLogger().info(bundle.getString("ServerImpl.SubmittingCodeSuccess.txt"));
                    int logLineCount = client.getLogLineCount();
                    String[] logLines = new String[logLineCount];
                    Integer[] logLineTypes = new Integer[logLineCount];
                    client.getLogLines(logLines, logLineTypes);
                    StringBuffer errorLinesBuf = new StringBuffer();
                    for (int i = 0; i < logLineCount; ++i) {
                        if (logLineTypes[i] != ConnectClient.LINE_TYPE_ERROR) continue;
                        if (errorLinesBuf.length() > 0) {
                            errorLinesBuf.append("\n");
                        }
                        errorLinesBuf.append(logLines[i]);
                    }
                    String errorMsg = errorLinesBuf.length() > 0 ? errorLinesBuf.toString() : null;
                    this.getLogger().fine(bundle.formatString("ServerImpl.CodeLog.fmt.txt", (java.lang.Object)client.getLogLines()));
                    if (errorMsg != null) {
                        this.getLogger().severe(errorMsg);
                        throw this.logServerValidatorException(bundle.getString("ConnectServerImpl.signonserver.failed.txt"), "Extended", 1);
                    }
                    this.getLogger().fine(bundle.getString("ConnectServerImpl.signonserver.ok.txt"));
                    String strLine = client.getListLines();
                    this.getLogger().finer(bundle.formatString("ServerImpl.CodeLog.fmt.txt", (java.lang.Object)strLine));
                    continue;
                }
                catch (ConnectLoginException exc) {
                    this.m_user = this.getUserContext();
                    if (this.m_user != null) {
                        try {
                            this.m_user.removeIdentity(m_userIdentity);
                        }
                        catch (RemoteException e) {
                            throw this.logServerValidatorException(e, "Extended", 1);
                        }
                    }
                    if (idIndex != lstIdentities.size() - 1) continue;
                    this.m_user = null;
                    this.m_pwAuth = null;
                    throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 1, this.getLogger());
                }
                catch (ConnectException exc) {
                    throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 1, this.getLogger());
                }
                finally {
                    this.m_pwAuth = null;
                    telnetProperties.clear();
                    telnetProperties = null;
                    try {
                        if (client != null) {
                            client.disconnect();
                        }
                    }
                    catch (ConnectException exc) {
                        this.getLogger().fine(exc.getLocalizedMessage());
                    }
                }
            }
        }
        catch (ServiceException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 1, this.getLogger());
        }
        catch (RemoteException exc) {
            throw ServerValidatorUtil.logServerValidatorException(exc, "Extended", 1, this.getLogger());
        }
    }

    public void getWorkSpaceServer() throws MdException, RemoteException {
        String fqid = this.getMetaConnection().getReposId();
        if (fqid != null) {
            String strTemplate = "<TEMPLATES><ServerComponent><UsedByComponents/></ServerComponent></TEMPLATES>";
            String strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + this.getName() + "'][UsedByComponents/LogicalServer[@ClassIdentifier='" + "028e4060-d545-11d5-880d-aa0004006d06" + "']]\" />";
            String strOptions = strTemplate + strXMLSelect;
            int flags = 8604;
            List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), fqid, "ServerComponent", flags, strOptions, true);
            if (objectList.size() == 1) {
                ServerComponent connectServer = (ServerComponent)objectList.get(0);
                LogicalServer lc = (LogicalServer)connectServer.getUsedByComponents().get(0);
                ServerContext sc = (ServerContext)lc.getUsedByComponents().get(0);
                AssociationList usingComponents = sc.getUsingComponents();
                for (LogicalServer logicalServer : usingComponents) {
                    String classID = logicalServer.getClassIdentifier();
                    if (!classID.equalsIgnoreCase("440196d4-90f0-11d0-9f41-00a024bb830c")) continue;
                    this.m_workspace = (ServerComponent)logicalServer.getUsingComponents().get(0);
                }
            }
        }
    }

    @Override
    public SpawnerInterface getSpawner() {
        return this.m_spawner;
    }

    @Override
    public void setSpawner(SpawnerInterface spawner) {
        this.m_spawner = spawner;
    }

    @Override
    public void setServerParms(Properties serverParms) {
        String strSASTagTimeout;
        String strCommand;
        String strCommandPromptTimeout;
        String strCommandPrompt;
        String strPasswordPrompt;
        String strLoginPrompt;
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        if (this.getMetaConnection() == null) {
            String strPort;
            String strHost;
            String strAuthDomain = (String)this.getServerParms().get("authdomain");
            if (strAuthDomain != null) {
                this.m_strAuthDomain = strAuthDomain;
            }
            if ((strHost = (String)this.getServerParms().get("host")) != null) {
                this.m_strHost = strHost;
            }
            if ((strPort = (String)this.getServerParms().get("port")) != null) {
                this.m_port = Integer.valueOf(strPort);
            }
        }
        if ((strLoginPrompt = (String)this.getServerParms().get("loginprompt")) != null) {
            this.m_strLoginPrompt = strLoginPrompt;
        }
        if ((strPasswordPrompt = (String)this.getServerParms().get("passwordprompt")) != null) {
            this.m_strPasswordPrompt = strPasswordPrompt;
        }
        if ((strCommandPrompt = (String)this.getServerParms().get("commandprompt")) != null) {
            this.m_strCommandPrompt = strCommandPrompt;
        }
        if ((strCommandPromptTimeout = (String)this.getServerParms().get("commandprompttimeout")) != null) {
            this.m_strCommandPromptTimeout = strCommandPromptTimeout;
        }
        if ((strCommand = (String)this.getServerParms().get("Command")) != null) {
            this.m_strCommand = strCommand;
        }
        if ((strSASTagTimeout = (String)this.getServerParms().get("sastagtimeout")) != null) {
            this.m_strSASTagTimeout = strSASTagTimeout;
        }
    }

    public static byte[] hook(byte[] in) {
        byte[] out = new byte[]{(byte)(in[0] ^ in[4]), (byte)(in[1] ^ in[5]), (byte)(in[2] ^ in[6]), (byte)(in[3] ^ in[7])};
        return out;
    }

    @Override
    public boolean isAdministrator() throws ServerException {
        boolean bIsAdmin = true;
        if (!this.isConnected()) {
            throw new IllegalStateException("Not yet connected to server!");
        }
        if (this.getSpawner() != null) {
            return ((ServerAdministratorInterface)((java.lang.Object)this.m_spawner)).isAdministrator();
        }
        return !bIsAdmin;
    }

    @Override
    public String getUser() {
        return this.getUser();
    }

    @Override
    public String getServerName() {
        return this.getName();
    }

    @Override
    public void setUser(String user) {
    }

    @Override
    public void setServerName(String server) {
        this.m_serverName = server;
    }
}

