/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.impl;

import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.servers.impl.IOMLogicalServerImpl;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorUtil;
import com.sas.management.util.MetaServerConnection;
import com.sas.services.connection.BridgeServer;
import com.sas.services.connection.Cluster;
import com.sas.services.connection.ConnectionFactoryAdminInterface;
import com.sas.services.connection.ConnectionFactoryConfiguration;
import com.sas.services.connection.ConnectionFactoryException;
import com.sas.services.connection.ManualConnectionFactoryConfiguration;
import com.sas.services.connection.Server;
import com.sas.services.connection.platform.PlatformConnectionFactoryInterface;
import com.sas.services.connection.platform.PlatformConnectionFactoryManager;
import com.sas.services.user.UserContextInterface;
import java.util.ArrayList;
import java.util.Properties;

public class ABMLogicalServerImpl
extends IOMLogicalServerImpl {
    private String m_strResource = "0";
    private String m_strAuthDomain = null;

    public ABMLogicalServerImpl(MetaServerConnection metaConn, String ID, Properties properties, UserContextInterface user) {
        super(metaConn, ID, properties, user);
    }

    @Override
    public void validateSimple() throws ServerValidatorException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateExtended() throws ServerValidatorException {
        ArrayList<BridgeServer> lstBridgeServers = new ArrayList<BridgeServer>();
        ServerInterface[] aryServers = this.getServers();
        for (int serverIndex = 0; serverIndex < aryServers.length; ++serverIndex) {
            ServerInterface server = aryServers[serverIndex];
            String strAuthDomain = null;
            ConnectionInterface[] connectionArray = server.getConnections();
            for (int connIndex = 0; connIndex < connectionArray.length; ++connIndex) {
                strAuthDomain = connectionArray[connIndex].getAuthenticationDomain();
                if (strAuthDomain == null) continue;
                if (this.m_strAuthDomain != null) break;
                this.m_strAuthDomain = strAuthDomain;
                break;
            }
            int iPort = -1;
            for (int connIndex = 0; connIndex < connectionArray.length && (iPort = connectionArray[connIndex].getPort()) <= 0; ++connIndex) {
            }
            BridgeServer bridgeServer = new BridgeServer(server.getType(), server.getHost(), iPort);
            bridgeServer.setDomain(strAuthDomain);
            bridgeServer.setOption("resource", this.m_strResource);
            lstBridgeServers.add(bridgeServer);
        }
        Server[] aryBridgeServers = lstBridgeServers.toArray(new Server[0]);
        Cluster cluster = Cluster.getInstance((Server[])aryBridgeServers, (int)0);
        ManualConnectionFactoryConfiguration cxfConfig = null;
        com.sas.services.connection.ConnectionInterface cx = null;
        try {
            cxfConfig = new ManualConnectionFactoryConfiguration(cluster);
            cx = ServerValidatorUtil.validateABMServerMakeConnection((ConnectionFactoryConfiguration)cxfConfig, "ABM", this.m_strAuthDomain, this.getUserContext(), this.getLogger(), 1);
        }
        finally {
            ConnectionFactoryAdminInterface admin = null;
            try {
                PlatformConnectionFactoryInterface cxf = PlatformConnectionFactoryManager.getPlatformConnectionFactory((ConnectionFactoryConfiguration)cxfConfig);
                admin = cxf.getAdminInterface();
            }
            catch (ConnectionFactoryException exc) {
                throw this.logServerValidatorException(exc, "Extended", 1);
            }
            finally {
                if (cx != null) {
                    cx.close();
                }
                if (admin != null) {
                    admin.shutdown();
                }
            }
        }
    }

    @Override
    public void setServerParms(Properties serverParms) {
        super.setServerParms(serverParms);
        if (this.getServerParms() == null) {
            return;
        }
        String strResource = (String)this.getServerParms().get("resource");
        if (strResource != null) {
            this.m_strResource = strResource;
        }
    }
}

