/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.connections.impl;

import com.sas.management.MetadataException;
import com.sas.management.MetadataFactory;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.connections.impl.ConnectionImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class TCPConnectionImpl
extends ConnectionImpl {
    private String m_strCommProtocol = "TCP";
    private String m_strAppProtocol = "Bridge";
    private int m_iPort = 0;
    private String m_strName = "TCP Connection";

    public TCPConnectionImpl(MetaServerConnection metaConn, ServerInterface server, String ID) {
        super(metaConn, server, ID);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            TCPIPConnection conn = (TCPIPConnection)MetadataFactory.getStore().getObject(this.getID());
            if (conn == null) {
                String strTemplate = "<TEMPLATES><TCPIPConnection/></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "TCPIPConnection", flags, strOptions, true);
                if (objectList.size() > 0) {
                    conn = (TCPIPConnection)objectList.get(0);
                }
            }
            this.setCommunicationProtocol(conn.getCommunicationProtocol());
            this.setApplicationProtocol(conn.getApplicationProtocol());
            this.setPort(conn.getPort());
            this.setService(conn.getService());
            this.setName(conn.getName());
        }
        catch (MdException exc) {
            MetadataException mdExc = new MetadataException(exc);
            this.getLogger().severe(mdExc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            this.getLogger().severe(exc.getLocalizedMessage());
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    @Override
    public String getCommunicationProtocol() {
        return this.m_strCommProtocol;
    }

    @Override
    public String getApplicationProtocol() {
        return this.m_strAppProtocol;
    }

    @Override
    public int getPort() {
        return this.m_iPort;
    }

    @Override
    public void setCommunicationProtocol(String commProtocol) {
        this.m_strCommProtocol = commProtocol;
    }

    @Override
    public void setApplicationProtocol(String appProtocol) {
        this.m_strAppProtocol = appProtocol;
    }

    @Override
    public void setPort(int port) {
        this.m_iPort = port;
    }

    @Override
    public String getName() {
        return this.m_strName;
    }
}

