/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers.connections.impl;

import com.sas.management.MetadataException;
import com.sas.management.MetadataFactory;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.connections.ConnectionInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.COMConnection;
import com.sas.metadata.remote.Connection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SASClientConnection;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public abstract class ConnectionImpl
extends MetadataImpl
implements ConnectionInterface {
    private int m_iType = 2;
    private String m_strService = "";
    private String m_strAuthDomain = "DefaultAuth";
    private String m_strAuthType = "user/password";
    private ServerInterface m_server = null;

    public ConnectionImpl(MetaServerConnection metaConn, ServerInterface server, String ID) {
        super(metaConn, ID);
        this.setServer(server);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            Connection conn = (Connection)MetadataFactory.getStore().getObject(this.getID());
            if (conn == null) {
                String strTemplate = "<TEMPLATES><Connection><Domain/></Connection></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "Connection", flags, strOptions, true);
                if (objectList.size() > 0) {
                    conn = (Connection)objectList.get(0);
                }
            }
            if (conn instanceof TCPIPConnection) {
                this.setType(0);
            } else if (conn instanceof COMConnection) {
                this.setType(1);
            } else if (conn instanceof SASClientConnection) {
                this.setType(2);
            }
            this.setCommunicationProtocol(conn.getCommunicationProtocol());
            this.setApplicationProtocol(conn.getApplicationProtocol());
            if (conn.getDomain() != null) {
                this.setAuthenticationDomain(conn.getDomain().getName());
            }
            this.setAuthenticationType(conn.getAuthenticationType());
        }
        catch (MdException exc) {
            MetadataException mdExc = new MetadataException(exc);
            this.getLogger().severe(mdExc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            this.getLogger().severe(exc.getLocalizedMessage());
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    @Override
    public int getType() {
        return this.m_iType;
    }

    @Override
    public abstract String getCommunicationProtocol();

    @Override
    public abstract String getApplicationProtocol();

    @Override
    public abstract int getPort();

    @Override
    public String getService() {
        return this.m_strService;
    }

    @Override
    public String getAuthenticationDomain() {
        return this.m_strAuthDomain;
    }

    @Override
    public String getAuthenticationType() {
        return this.m_strAuthType;
    }

    @Override
    public ServerInterface getServer() {
        return this.m_server;
    }

    @Override
    public void setType(int type) {
        this.m_iType = type;
    }

    @Override
    public abstract void setCommunicationProtocol(String var1);

    @Override
    public abstract void setApplicationProtocol(String var1);

    @Override
    public abstract void setPort(int var1);

    @Override
    public void setService(String service) {
        this.m_strService = service;
    }

    @Override
    public void setAuthenticationDomain(String domain) {
        this.m_strAuthDomain = domain;
    }

    @Override
    public void setAuthenticationType(String type) {
        this.m_strAuthType = type;
    }

    @Override
    public void setServer(ServerInterface server) {
        this.m_server = server;
    }
}

