/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.servers;

import com.sas.management.MetadataInterface;
import com.sas.management.servers.LogicalServerInterface;
import com.sas.management.servers.ServerInterface;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.impl.ServerImpl;
import java.util.EventObject;

public class ServerFactoryEvent
extends EventObject {
    private String m_strID = null;
    private MetadataInterface m_svrOld = null;
    private MetadataInterface m_svrNew = null;
    private static final long serialVersionUID = 8699511699466259577L;

    public ServerFactoryEvent(Object source, String serverID, ServerInterface oldServer, ServerInterface newServer) {
        super(source);
        String strHostID = null;
        if (newServer != null) {
            strHostID = ((ServerImpl)newServer).getHostID();
        } else if (oldServer != null) {
            strHostID = ((ServerImpl)oldServer).getHostID();
        }
        this.m_strID = ServerUtil.getServerMapKey(serverID, strHostID);
        this.m_svrOld = oldServer;
        this.m_svrNew = newServer;
    }

    public ServerFactoryEvent(Object source, String serverID, LogicalServerInterface oldServer, LogicalServerInterface newServer) {
        super(source);
        this.m_strID = serverID;
        this.m_svrOld = oldServer;
        this.m_svrNew = newServer;
    }

    public String getServerID() {
        return this.m_strID;
    }

    public MetadataInterface getOldServer() {
        return this.m_svrOld;
    }

    public MetadataInterface getNewServer() {
        return this.m_svrNew;
    }
}

