/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.interpreters;

import com.sas.management.ValidatorException;
import com.sas.management.servers.ServerException;
import com.sas.management.servers.ServerFactory;
import com.sas.management.servers.ServerUtil;
import com.sas.management.servers.validator.ServerValidatorException;
import com.sas.management.servers.validator.ServerValidatorInterface;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.Util;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.ServerComponent;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.PasswordAuthentication;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;

public class ValidateServer {
    private MetaServerConnection m_metaConnection;
    private String m_strServerType;
    private String m_strServerName;
    private String m_strServerID;
    private int m_returnCode = 0;
    private Handler m_handler;
    private MdFactory m_objectFactory;
    protected static WAdminResource bundle = new WAdminResource(ValidateServer.class);

    public ValidateServer() {
        try {
            this.m_objectFactory = Workspace.getMdFactory().getInstance();
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    private void setLogging(Properties properties) {
        try {
            StreamHandler handler = new StreamHandler(System.out, new SimpleFormatter());
            handler.setLevel(Level.ALL);
            this.setHandler(handler);
            this.m_objectFactory.setDebug(false);
            this.m_objectFactory.setLoggingEnabled(false);
            Util.setLogStream((OutputStream)System.out);
            boolean bLogSet = properties.containsKey("log");
            if (bLogSet) {
                String strLogFileName = System.getProperty("user.home") + File.separator + "ServerValidation.log";
                try {
                    handler = new FileHandler(strLogFileName);
                    this.setHandler(handler);
                    FileOutputStream fileStream = new FileOutputStream(strLogFileName);
                    PrintStream printStream = new PrintStream(fileStream);
                    System.setOut(printStream);
                    System.setErr(printStream);
                    Util.setLogStream((OutputStream)printStream);
                }
                catch (FileNotFoundException exc) {
                    ServerUtil.printLog(exc.getLocalizedMessage());
                }
                catch (IOException exc) {
                    ServerUtil.printLog(exc.getLocalizedMessage());
                }
            }
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
    }

    public int getReturnCode() {
        return this.m_returnCode;
    }

    public void setReturnCode(int code) {
        this.m_returnCode = code;
    }

    private boolean validateArgs(Properties argProperties, Properties serverProperties, Properties metaserverProperties) {
        boolean bValidated = true;
        String strServerType = argProperties.getProperty("servertype");
        if (strServerType == null) {
            strServerType = argProperties.getProperty("st");
        }
        if (!(strServerType == null || strServerType.equalsIgnoreCase("metadata") || strServerType.equalsIgnoreCase("workspace") || strServerType.equalsIgnoreCase("storedprocess") || strServerType.equalsIgnoreCase("olap") || strServerType.equalsIgnoreCase("connect") || strServerType.equalsIgnoreCase("webdav"))) {
            ServerUtil.printLog(bundle.getString("ValidateServer.WrongServerType.txt"));
            bValidated = false;
            return bValidated;
        }
        if (!this.validateServerParms(serverProperties)) {
            bValidated = false;
            return bValidated;
        }
        if (!this.validateMetaServerParms(metaserverProperties)) {
            bValidated = false;
            return bValidated;
        }
        String strMetaServerParms = argProperties.getProperty("metaserverparms");
        if (strMetaServerParms == null) {
            strMetaServerParms = argProperties.getProperty("msp");
        }
        if (strMetaServerParms != null && argProperties.getProperty("servername") == null && argProperties.getProperty("sn") == null && argProperties.getProperty("serverid") == null && argProperties.getProperty("sid") == null) {
            String strOption = "-servername | -sn | -serverid | -sid";
            ServerUtil.printLog(bundle.messageString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
            bValidated = false;
            return bValidated;
        }
        String strServerName = argProperties.getProperty("servername");
        if (strServerName == null) {
            strServerName = argProperties.getProperty("sn");
        }
        if (strServerName != null && argProperties.getProperty("metaserverparms") == null && argProperties.getProperty("msp") == null) {
            String strOption = "-metaserverparms | -msp";
            ServerUtil.printLog(bundle.messageString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
            bValidated = false;
            return bValidated;
        }
        String strServerID = argProperties.getProperty("serverid");
        if (strServerID == null) {
            strServerID = argProperties.getProperty("sid");
        }
        if (strServerID != null) {
            if (strServerID.length() != 17 || strServerID.indexOf(".") != 8) {
                ServerUtil.printLog(bundle.getString("ValidateServer.WrongServerID.txt"));
                bValidated = false;
                return bValidated;
            }
            if (argProperties.getProperty("metaserverparms") == null && argProperties.getProperty("msp") == null) {
                String strOption = "-metaserverparms | -msp";
                ServerUtil.printLog(bundle.messageString("ValidateServer.NoOptionSpecified.fmt.txt", (Object)strOption));
                bValidated = false;
                return bValidated;
            }
        }
        return bValidated;
    }

    private boolean validateServerParms(Properties properties) {
        boolean bValidated = true;
        String strPort = properties.getProperty("port");
        if (strPort != null) {
            try {
                Integer portObj = Integer.valueOf(strPort);
                if (portObj == null || portObj < 0 || portObj >= 65536) {
                    ServerUtil.printLog(bundle.getString("ValidateServer.WrongPortRange.txt"));
                    bValidated = false;
                    return bValidated;
                }
            }
            catch (NumberFormatException exc) {
                ServerUtil.printLog(bundle.messageString("ValidateServer.WrongPortFormat.fmt.txt", (Object)strPort));
                bValidated = false;
                return bValidated;
            }
        }
        return bValidated;
    }

    private boolean validateMetaServerParms(Properties properties) {
        String strReposID;
        boolean bValidated = true;
        String strPort = properties.getProperty("port");
        if (strPort != null) {
            try {
                Integer portObj = Integer.valueOf(strPort);
                if (portObj == null || portObj < 0 || portObj >= 65536) {
                    ServerUtil.printLog(bundle.getString("ValidateServer.WrongPortRange.txt"));
                    bValidated = false;
                    return bValidated;
                }
            }
            catch (NumberFormatException exc) {
                ServerUtil.printLog(bundle.messageString("ValidateServer.WrongPortFormat.fmt.txt", (Object)strPort));
                bValidated = false;
                return bValidated;
            }
        }
        if ((strReposID = properties.getProperty("reposid")) != null && (strReposID.length() != 17 || strReposID.indexOf(".") != 8)) {
            ServerUtil.printLog(bundle.getString("ValidateServer.WrongReposID.txt"));
            bValidated = false;
            return bValidated;
        }
        String strWorkspaceFile = properties.getProperty("metadataprofile");
        if (strWorkspaceFile != null && !strWorkspaceFile.endsWith(".swa")) {
            ServerUtil.printLog(bundle.getString("ValidateServer.WrongWorkspaceFile.txt"));
            bValidated = false;
            return bValidated;
        }
        return bValidated;
    }

    private boolean setArgs(Properties argProperties, Properties serverProperties, Properties metaserverProperties, Properties credentialProperties) {
        boolean bPropertiesSet = true;
        if (argProperties.isEmpty() && serverProperties.isEmpty() && metaserverProperties.isEmpty() && credentialProperties.isEmpty() || argProperties.containsKey("help")) {
            this.printHelpInfo();
            bPropertiesSet = false;
            return bPropertiesSet;
        }
        String strServerType = argProperties.getProperty("servertype");
        if (strServerType == null) {
            strServerType = argProperties.getProperty("st");
        }
        if (strServerType.equalsIgnoreCase("metadata")) {
            strServerType = "0217e202-b560-11db-ad91-001083ff6836";
        }
        if (strServerType.equalsIgnoreCase("workspace")) {
            strServerType = "440196d4-90f0-11d0-9f41-00a024bb830c";
        }
        if (strServerType.equalsIgnoreCase("storedprocess")) {
            strServerType = "15931e31-667f-11d5-8804-00c04f35ac8c";
        }
        if (strServerType.equalsIgnoreCase("olap")) {
            strServerType = "f3f46472-1e31-11d5-87c2-00c04f38f9f6";
        }
        if (strServerType.equalsIgnoreCase("connect")) {
            strServerType = "028e4060-d545-11d5-880d-aa0004006d06";
        }
        if (strServerType.equalsIgnoreCase("webdav")) {
            strServerType = "DAC0D7F0-10DA-11D6-8816-AA0004006D06";
        }
        this.m_strServerType = strServerType;
        this.m_strServerName = argProperties.getProperty("servername");
        if (this.m_strServerName == null) {
            this.m_strServerName = argProperties.getProperty("sn");
        }
        if (this.m_strServerName != null) {
            serverProperties.put("servername", this.m_strServerName);
        }
        this.m_strServerID = argProperties.getProperty("serverid");
        if (this.m_strServerID == null) {
            this.m_strServerID = argProperties.getProperty("sid");
        }
        if (this.m_strServerID != null) {
            serverProperties.put("serverid", this.m_strServerID);
        }
        return bPropertiesSet;
    }

    private void printHelpInfo() {
        ServerUtil.printLog("ValidateServer validates a specified server type with given server attributes.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("Usage:", false);
        ServerUtil.printLog("      java -classpath sas.servermgr.jar com.sas.management.interpreters.ValidateServer <options>", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("Where <options> are:", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-servertype Type (or -st Type)", false);
        ServerUtil.printLog("      The type of server to be validated.", false);
        ServerUtil.printLog("      Valid values are 'metadata', 'workspace', 'storedprocess', 'olap', 'connect', 'webdav'.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-serverparms \"<parms>\" (or -sp \"<parms>\")", false);
        ServerUtil.printLog("      Consists of name/value pairs of server/connection attributes for the server to be validated.", false);
        ServerUtil.printLog("      e.g. <parms>: \"host=XXX port=XXX\"", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-metaserverparms \"<parms>\" (or -msp \"<parms>\")", false);
        ServerUtil.printLog("      Consists of name/value pairs of methods to connect to a metadata server i.e. metadata connection attributes or metadata profile", false);
        ServerUtil.printLog("      Valid values are:", false);
        ServerUtil.printLog("          <parms>: \"host=XXX port=XXX userid=XXX password=XXX reposid=XXX\"", false);
        ServerUtil.printLog("          <parms>: \"metadataprofile=XXX.swa\"", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-servername Name (or -sn Name)", false);
        ServerUtil.printLog("      Used in conjunction with -metaserverparms, this is the name of the server metadata definition of the server to be validated.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-serverid ID (or -sid ID)", false);
        ServerUtil.printLog("      Used in conjunction with -metaserverparms, this is the ID of the server metadata definition of the server to be validated.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-credentials \"<parms>\" (or -cred \"<parms>\")", false);
        ServerUtil.printLog("      Consists of a userid and password", false);
        ServerUtil.printLog("      Valid values are:", false);
        ServerUtil.printLog("          <parms>: \"userid=XXX password=XXX\"", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-log", false);
        ServerUtil.printLog("      Writes out logging information out to a file.", false);
        ServerUtil.printLog("      File: <user profile directory>\\ServerValidation.log", false);
        ServerUtil.printLog("      If not specified, logging information is written out to the system output stream.", false);
        ServerUtil.printLog("", false);
        ServerUtil.printLog("-help", false);
        ServerUtil.printLog("      Prints this help information", false);
        ServerUtil.printLog("", false);
    }

    private void newMetaConnection(Properties properties) {
        String strHost = properties.getProperty("host");
        String strPort = properties.getProperty("port");
        String strUserID = properties.getProperty("userid");
        String strPassword = properties.getProperty("password");
        String strReposID = properties.getProperty("reposid");
        String strReposName = properties.getProperty("reposname");
        String strWorkspaceFile = properties.getProperty("metadataprofile");
        if (strWorkspaceFile != null) {
            WorkspaceFile workspaceFile = new WorkspaceFile(strWorkspaceFile);
            this.m_metaConnection = new MetaServerConnection(workspaceFile);
        } else {
            this.m_metaConnection = new MetaServerConnection(strHost, strPort, strUserID, strPassword, strReposName);
            if (strReposID != null) {
                this.m_metaConnection.setReposId(strReposID);
            }
        }
    }

    private ServerValidatorInterface newServer(ServerFactory factory, Properties serverProperties, Properties credentialProperties, Handler handler) throws ServerException, MdException, RemoteException {
        String strUserID = credentialProperties.getProperty("userid");
        String strPassword = credentialProperties.getProperty("password");
        PasswordAuthentication credentials = null;
        if (strUserID != null && strPassword == null) {
            credentials = ServerUtil.getCredentials(strUserID, "");
        }
        if (credentials == null && strUserID != null && strPassword != null) {
            credentials = ServerUtil.getCredentials(strUserID, strPassword);
        }
        ServerValidatorInterface server = null;
        if (this.m_metaConnection != null) {
            server = this.newServer(factory, serverProperties, credentials, handler);
        }
        if (server == null) {
            if (this.m_strServerType != null) {
                serverProperties.setProperty("classidentifier", this.m_strServerType);
                server = factory.newServerValidator(null, serverProperties, credentials, handler);
            } else {
                ServerUtil.printLog(bundle.getString("ValidateServer.WrongServerType.txt"));
            }
        }
        return server;
    }

    private ServerValidatorInterface newServer(ServerFactory factory, Properties serverProperties, PasswordAuthentication credentials, Handler handler) throws ServerException, MdException, RemoteException {
        ServerValidatorInterface server = null;
        if (this.m_strServerType != null) {
            serverProperties.setProperty("classidentifier", this.m_strServerType);
        }
        server = this.isLogicalServer(this.m_metaConnection, serverProperties) ? factory.newLogicalServerValidator(this.m_metaConnection, serverProperties, null, handler) : factory.newServerValidator(this.m_metaConnection, serverProperties, credentials, handler);
        return server;
    }

    private boolean isLogicalServer(MetaServerConnection metaConn, Properties properties) throws MdException, RemoteException {
        boolean bLogicalServer = false;
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        String strName = properties.getProperty("servername");
        String strID = properties.getProperty("serverid");
        String strReposID = metaConn.getReposId();
        if (strID != null) {
            strReposID = ServerUtil.getReposID(strID);
        }
        if (strReposID == null) {
            return bLogicalServer;
        }
        String strType = "ServerComponent";
        int flags = 408;
        String strXMLSelect = "";
        if (strName != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Name='" + strName + "']\" />";
        }
        if (strID != null) {
            strXMLSelect = "<XMLSELECT search=\"ServerComponent[@Id='" + strID + "']\" />";
        }
        String strOptions = strXMLSelect;
        List serversList = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)store, strReposID, strType, flags, strOptions, true);
        for (int serverIndex = 0; serverIndex < serversList.size(); ++serverIndex) {
            ServerComponent serverComponent = (ServerComponent)serversList.get(serverIndex);
            if (!(serverComponent instanceof LogicalServer)) continue;
            bLogicalServer = true;
            break;
        }
        return bLogicalServer;
    }

    private Handler getHandler() {
        return this.m_handler;
    }

    private void setHandler(Handler handler) {
        this.m_handler = handler;
    }

    public static void main(String[] argsArray) {
        boolean bPropertiesSet;
        ValidateServer vs = new ValidateServer();
        Properties argProperties = (Properties)com.sas.management.util.Util.tokenize((String[])argsArray);
        vs.setLogging(argProperties);
        Properties serverProperties = null;
        Properties metaserverProperties = null;
        Properties credentialProperties = null;
        try {
            serverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"serverparms", (Properties)argProperties);
            if (serverProperties.isEmpty()) {
                serverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"sp", (Properties)argProperties);
            }
            if ((metaserverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"metaserverparms", (Properties)argProperties)).isEmpty()) {
                metaserverProperties = (Properties)com.sas.management.util.Util.tokenize((String)"msp", (Properties)argProperties);
            }
            if ((credentialProperties = (Properties)com.sas.management.util.Util.tokenize((String)"credentials", (Properties)argProperties)).isEmpty()) {
                credentialProperties = (Properties)com.sas.management.util.Util.tokenize((String)"cred", (Properties)argProperties);
            }
        }
        catch (IOException exc) {
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        boolean bPropertiesValidated = vs.validateArgs(argProperties, serverProperties, metaserverProperties);
        if (!bPropertiesValidated) {
            vs.setReturnCode(1);
            System.exit(vs.getReturnCode());
        }
        if (!(bPropertiesSet = vs.setArgs(argProperties, serverProperties, metaserverProperties, credentialProperties))) {
            vs.setReturnCode(1);
            System.exit(vs.getReturnCode());
        }
        ServerFactory factory = new ServerFactory();
        if (!metaserverProperties.isEmpty()) {
            vs.newMetaConnection(metaserverProperties);
        }
        try {
            ServerValidatorInterface server = vs.newServer(factory, serverProperties, credentialProperties, vs.getHandler());
            if (server != null) {
                server.validate();
            } else {
                vs.setReturnCode(1);
            }
        }
        catch (ValidatorException exc) {
            if (exc instanceof ServerValidatorException) {
                ServerValidatorException svExc = (ServerValidatorException)exc;
                vs.setReturnCode(svExc.getReturnLevel());
            }
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (ServerException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (MdException exc) {
            vs.setReturnCode(1);
            ServerUtil.printLog(exc.getLocalizedMessage());
        }
        catch (RemoteException re) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)re);
        }
        ServerFactory.dispose();
        ServerUtil.printLog(bundle.messageString("ValidateServer.ReturnCode.fmt.txt", (Object)String.valueOf(vs.getReturnCode())));
        System.exit(vs.getReturnCode());
    }
}

