/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.impl;

import com.sas.management.MetadataException;
import com.sas.management.MetadataFactory;
import com.sas.management.MetadataUtil;
import com.sas.management.PropertyInterface;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class PropertyImpl
extends MetadataImpl
implements PropertyInterface {
    private String m_strPropertyName = null;
    private char m_chrDelimiter = (char)61;
    private String m_strDefaultValue = "";
    private String[] m_valuesArray = new String[]{this.m_strDefaultValue};
    private boolean m_bValueOnly = false;
    private int m_iSQLType = 12;
    private int m_iMaxLength = Integer.MAX_VALUE;
    private String m_strName = "Property";

    public PropertyImpl(MetaServerConnection metaConn, String ID, String propertyName) {
        super(metaConn, ID);
        this.setPropertyName(propertyName);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            Property prop = (Property)MetadataFactory.getStore().getObject(this.getID());
            if (prop == null) {
                String strTemplate = "<TEMPLATES><Property><OwningType/></Property><PropertyType><StoredConfiguration/></PropertyType></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "Property", flags, strOptions, true);
                if (objectList.size() > 0) {
                    prop = (Property)objectList.get(0);
                }
            }
            this.setPropertyName(prop.getPropertyName());
            if (prop.getDelimiter().length() > 0) {
                this.setDelimiter(prop.getDelimiter().charAt(0));
            }
            this.setDefaultValue(prop.getDefaultValue());
            this.setValues(MetadataUtil.getValues(prop));
            this.setIsUseValueOnly(prop.getUseValueOnly() == 1);
            this.setSQLType(prop.getSQLType());
            this.setMaxLength(prop.getDefaultValueMaxLength());
        }
        catch (MdException exc) {
            MetadataException mdExc = new MetadataException(exc);
            this.getLogger().severe(mdExc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            this.getLogger().severe(exc.getLocalizedMessage());
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    @Override
    public String getPropertyName() {
        return this.m_strPropertyName;
    }

    @Override
    public char getDelimiter() {
        return this.m_chrDelimiter;
    }

    @Override
    public String getDefaultValue() {
        return this.m_strDefaultValue;
    }

    @Override
    public String[] getValues() {
        return this.m_valuesArray;
    }

    @Override
    public boolean useValueOnly() {
        return this.m_bValueOnly;
    }

    @Override
    public int getSQLType() {
        return this.m_iSQLType;
    }

    @Override
    public int getMaxLength() {
        return this.m_iMaxLength;
    }

    @Override
    public void setPropertyName(String propertyName) {
        this.m_strPropertyName = propertyName;
    }

    @Override
    public void setDelimiter(char delimiter) {
        this.m_chrDelimiter = delimiter;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.m_strDefaultValue = defaultValue;
    }

    @Override
    public void setValues(String[] values) {
        this.m_valuesArray = values;
    }

    @Override
    public void setIsUseValueOnly(boolean flag) {
        this.m_bValueOnly = flag;
    }

    @Override
    public void setSQLType(int type) {
        this.m_iSQLType = type;
    }

    @Override
    public void setMaxLength(int maxLength) {
        this.m_iMaxLength = maxLength;
    }

    @Override
    public String getName() {
        return this.m_strName;
    }
}

