/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management.impl;

import com.sas.management.MetadataException;
import com.sas.management.MetadataFactory;
import com.sas.management.PathInterface;
import com.sas.management.impl.MetadataImpl;
import com.sas.management.util.MetaServerConnection;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.List;

public class PathImpl
extends MetadataImpl
implements PathInterface {
    private String m_strPath = null;
    private boolean m_bRelative = false;
    private boolean m_bSupportsDAV = false;

    public PathImpl(MetaServerConnection metaConn, String ID, String path) {
        super(metaConn, ID);
        this.setPath(path);
        if (metaConn != null && ID != null) {
            this.initializeMetadata();
        }
    }

    private void initializeMetadata() {
        try {
            Directory dir = (Directory)MetadataFactory.getStore().getObject(this.getID());
            if (dir == null) {
                String strTemplate = "<TEMPLATES><Directory/></TEMPLATES>";
                String strXMLSelect = "<XMLSELECT search=\"*[@ID='" + this.getID() + "']\" />";
                String strOptions = strTemplate + strXMLSelect;
                int flags = 8604;
                List objectList = MetadataFactory.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)MetadataFactory.getStore(), this.getMetaConnection().getReposId(), "Directory", flags, strOptions, true);
                if (objectList.size() > 0) {
                    dir = (Directory)objectList.get(0);
                }
            }
            this.setPath(dir.getDirectoryName());
            this.setIsRelative(dir.getIsRelative() == 1);
            AssociationList propertyList = dir.getProperties();
            for (int propIndex = 0; propIndex < propertyList.size(); ++propIndex) {
                Property prop = (Property)propertyList.get(propIndex);
                if (!prop.getPropertyName().equalsIgnoreCase("SupportsWebDAV")) continue;
                this.setSupportsDAV(prop.getDefaultValue().equalsIgnoreCase("1"));
                break;
            }
        }
        catch (MdException exc) {
            MetadataException mdExc = new MetadataException(exc);
            this.getLogger().severe(mdExc.getLocalizedMessage());
        }
        catch (RemoteException exc) {
            this.getLogger().severe(exc.getLocalizedMessage());
            Workspace.getDefaultLogger().error((Object)exc.getLocalizedMessage());
        }
    }

    @Override
    public String getPath() {
        return this.m_strPath;
    }

    @Override
    public boolean isRelative() {
        return this.m_bRelative;
    }

    @Override
    public boolean supportsDAV() {
        return this.m_bSupportsDAV;
    }

    @Override
    public void setPath(String path) {
        this.m_strPath = path;
    }

    @Override
    public void setIsRelative(boolean flag) {
        this.m_bRelative = flag;
    }

    @Override
    public void setSupportsDAV(boolean flag) {
        this.m_bSupportsDAV = flag;
    }
}

