/*
 * Decompiled with CFR 0.152.
 */
package com.sas.management;

import com.sas.management.MetadataFactory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.PropertyType;
import com.sas.metadata.remote.TextStore;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetadataUtil {
    public static String[] getValues(Property property) throws MdException, RemoteException {
        TextStore store;
        String[] valuesArray = new String[]{};
        PropertyType type = property.getOwningType();
        if (type != null && (store = (TextStore)type.getStoredConfiguration()) != null) {
            Document doc = MetadataFactory.getMdFactory().getOMIUtil().parseXML(store.getStoredText());
            Vector valuesList = new Vector();
            MetadataUtil.parseValuesDoc(doc, valuesList);
            valuesArray = new String[valuesList.size()];
            for (int valueIndex = 0; valueIndex < valuesList.size(); ++valueIndex) {
                String strValue;
                valuesArray[valueIndex] = strValue = (String)valuesList.get(valueIndex);
            }
        }
        return valuesArray;
    }

    private static void parseValuesDoc(Node node, List valuesList) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 9: {
                NodeList children = node.getChildNodes();
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    MetadataUtil.parseValuesDoc(children.item(childIndex), valuesList);
                }
                break;
            }
            case 1: {
                if (node.getNodeName().equals("Value")) {
                    NamedNodeMap childNodeMap = node.getAttributes();
                    String item = childNodeMap.getNamedItem("name").getNodeValue();
                    valuesList.add(item);
                    break;
                }
                NodeList children = node.getChildNodes();
                if (children == null) break;
                for (int childIndex = 0; childIndex < children.getLength(); ++childIndex) {
                    MetadataUtil.parseValuesDoc(children.item(childIndex), valuesList);
                }
                break;
            }
        }
    }
}

