/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.PermutationPolicy;
import com.sas.sg.datamodel.impl.SgObsSortContext;
import java.util.ArrayList;

public class SgObsSortPolicy
implements PermutationPolicy {
    DataModel m_dataModel;
    ArrayList m_keys = new ArrayList();
    boolean[] m_orders;
    String m_name;

    public SgObsSortPolicy(DataModel dataModel, int varIndex, boolean ascendOrder, String name) {
        if (dataModel == null || varIndex < 0 || varIndex >= dataModel.getNumVars()) {
            throw new IllegalArgumentException();
        }
        this.m_dataModel = dataModel;
        this.m_orders = new boolean[1];
        this.m_keys.add(new Integer(varIndex));
        this.m_orders[0] = ascendOrder;
    }

    public SgObsSortPolicy(DataModel dataModel, int[] varIndices, boolean[] ascendOrders, String name) {
        if (dataModel == null || varIndices == null || ascendOrders != null && varIndices.length != ascendOrders.length) {
            throw new IllegalArgumentException();
        }
        if (ascendOrders == null) {
            ascendOrders = new boolean[varIndices.length];
            for (int i = 0; i < ascendOrders.length; ++i) {
                ascendOrders[i] = true;
            }
        }
        this.m_dataModel = dataModel;
        int numKeys = varIndices.length;
        this.m_orders = new boolean[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            this.m_keys.add(new Integer(varIndices[i]));
            this.m_orders[i] = ascendOrders[i];
        }
    }

    public SgObsSortPolicy(DataModel dataModel, ObsPropertyModel[] propModels, boolean[] ascendOrders, String name) {
        if (dataModel == null || propModels == null || ascendOrders != null && propModels.length != ascendOrders.length) {
            throw new IllegalArgumentException();
        }
        if (ascendOrders == null) {
            ascendOrders = new boolean[propModels.length];
            for (int i = 0; i < ascendOrders.length; ++i) {
                ascendOrders[i] = true;
            }
        }
        this.m_dataModel = dataModel;
        int numKeys = propModels.length;
        this.m_orders = new boolean[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            this.m_keys.add(propModels[i]);
            this.m_orders[i] = ascendOrders[i];
        }
    }

    public SgObsSortPolicy(DataModel dataModel, Object[] keys, boolean[] ascendOrders, String name) {
        if (dataModel == null || keys == null || ascendOrders != null && keys.length != ascendOrders.length) {
            throw new IllegalArgumentException();
        }
        if (ascendOrders == null) {
            ascendOrders = new boolean[keys.length];
            for (int i = 0; i < ascendOrders.length; ++i) {
                ascendOrders[i] = true;
            }
        }
        this.m_dataModel = dataModel;
        int numKeys = keys.length;
        this.m_orders = new boolean[numKeys];
        for (int i = 0; i < numKeys; ++i) {
            this.m_keys.add(keys[i]);
            this.m_orders[i] = ascendOrders[i];
        }
    }

    public DataModel getDataModel() {
        return this.m_dataModel;
    }

    public int getNumKeys() {
        return this.m_keys.size();
    }

    public Object getKey(int keyIndex) {
        return this.m_keys.get(keyIndex);
    }

    public Class getPermutationClass() {
        return SgObsSortContext.class;
    }

    public boolean getOrder(int keyIndex) {
        return this.m_orders[keyIndex];
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof SgObsSortPolicy)) {
            return false;
        }
        SgObsSortPolicy policy = (SgObsSortPolicy)obj;
        boolean result = this.m_dataModel == policy.getDataModel() && this.getNumKeys() == policy.getNumKeys();
        for (int i = 0; i < this.getNumKeys() && result; ++i) {
            result = this.m_orders[i] == policy.getOrder(i) && this.m_keys.get(i).equals(policy.getKey(i));
        }
        return result;
    }
}

