/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.ObsPermutationListener;
import com.sas.sg.datamodel.ObsPermutationModel;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.PermutationPolicy;
import com.sas.sg.datamodel.impl.SgObsSortPolicy;
import java.util.ArrayList;
import java.util.Arrays;

public class SgObsSortContext
implements ObsPermutationModel {
    protected DataModel m_dataModel;
    protected SgObsSortPolicy m_policy;
    protected int m_numKeys;
    protected SgObsComparator[] m_comparators;
    protected int[] m_obs;
    protected int m_fromIndex;
    protected int m_toIndex;
    protected int m_numGroups;
    protected int[] m_firstInGroups;
    protected boolean m_isNaturalInGroups;
    protected boolean m_isInverted;
    protected int m_refCount;
    protected ArrayList m_listenerList = new ArrayList();

    public void setNaturalInGroups(boolean isNatural) {
        if (this.isNaturalInGroups() != isNatural) {
            this.m_isNaturalInGroups = isNatural;
            this.doPermutation();
        }
    }

    public boolean isNaturalInGroups() {
        return this.m_isNaturalInGroups;
    }

    public void addObsPermutationListener(ObsPermutationListener listener) {
        if (listener != null && this.m_listenerList.indexOf(listener) < 0) {
            this.m_listenerList.add(listener);
        }
    }

    public void removeObsPermutationListener(ObsPermutationListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected void fireSortContextChanged() {
        int numListeners = this.m_listenerList.size();
        for (int i = 0; i < numListeners; ++i) {
            ((ObsPermutationListener)this.m_listenerList.get(i)).obsRepermuted((ObsPermutationModel)this);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(DataModel dataModel, PermutationPolicy policy) {
        if (this.m_policy != null || this.m_dataModel != null) {
            throw new IllegalArgumentException("Try to initialize a permutation more than once");
        }
        if (dataModel == null || policy == null) {
            throw new IllegalArgumentException();
        }
        this.m_policy = (SgObsSortPolicy)policy;
        this.m_dataModel = dataModel;
        this.m_numKeys = this.m_policy.getNumKeys();
        this.m_comparators = new SgObsComparator[this.m_numKeys];
        for (int i = 0; i < this.m_numKeys; ++i) {
            Object key = this.m_policy.getKey(i);
            if (key instanceof Integer) {
                int varIndex = (Integer)key;
                if (this.m_dataModel.isVarNumeric(varIndex)) {
                    this.m_comparators[i] = new SgObsNumericComparator(this.m_dataModel, varIndex);
                } else if (this.m_dataModel.isVarCharacter(varIndex)) {
                    this.m_comparators[i] = new SgObsStringComparator(this.m_dataModel, varIndex);
                } else {
                    if (!this.m_dataModel.isVarGeneric(varIndex)) throw new IllegalArgumentException("wrong variable type");
                    this.m_comparators[i] = new SgObsGenericComparator(this.m_dataModel, varIndex);
                }
            } else if (key instanceof ObsPropertyModel) {
                this.m_comparators[i] = new SgObsPropertyComparator((ObsPropertyModel)key);
            }
            this.m_comparators[i].setOrder(this.m_policy.getOrder(i));
        }
    }

    public DataModel getDataModel() {
        return this.m_dataModel;
    }

    public PermutationPolicy getPolicy() {
        return this.m_policy;
    }

    public boolean checkPolicy(PermutationPolicy policy) {
        return this.m_policy.equals(policy);
    }

    public void addReference() {
        ++this.m_refCount;
        this.fireReferenceCountChanged();
    }

    public void release() {
        --this.m_refCount;
        this.fireReferenceCountChanged();
    }

    public int getNumReferences() {
        return this.m_refCount;
    }

    public void doPermutation() {
        int group;
        int i;
        this.m_numGroups = 0;
        int numObs = this.m_dataModel.getNumObs();
        if (numObs == 0) {
            return;
        }
        if (this.m_obs == null || this.m_obs.length < numObs || (double)this.m_obs.length * 0.75 > (double)numObs) {
            this.m_obs = new int[numObs];
        }
        for (i = 0; i < numObs; ++i) {
            this.m_obs[i] = i;
        }
        this.sort(0, numObs);
        if (numObs > 0) {
            this.m_numGroups = 1;
            for (i = 1; i < numObs; ++i) {
                if (this.compare(i - 1, i) == 0) continue;
                ++this.m_numGroups;
            }
        } else {
            this.m_numGroups = 0;
        }
        if (this.m_firstInGroups == null || this.m_firstInGroups.length < this.m_numGroups || (double)this.m_firstInGroups.length > (double)this.m_numGroups * 1.1) {
            this.m_firstInGroups = new int[this.m_numGroups];
        }
        if (this.m_numGroups > 0) {
            this.m_firstInGroups[0] = 0;
            group = 1;
            for (i = 1; i < numObs; ++i) {
                if (this.compare(i - 1, i) == 0) continue;
                this.m_firstInGroups[group] = i;
                ++group;
            }
        }
        if (this.isNaturalInGroups()) {
            for (group = 0; group < this.m_numGroups; ++group) {
                int first = this.m_firstInGroups[group];
                int last = this.getLastInGroup(group);
                for (int obsOrdinal = first + 1; obsOrdinal <= last; ++obsOrdinal) {
                    int obsIndex = this.m_obs[obsOrdinal];
                    for (i = obsOrdinal - 1; i >= first && obsIndex < this.m_obs[i]; --i) {
                    }
                    if (i >= obsOrdinal - 1) continue;
                    System.arraycopy(this.m_obs, ++i, this.m_obs, i + 1, obsOrdinal - i);
                    this.m_obs[i] = obsIndex;
                }
            }
        }
        this.fireSortContextChanged();
    }

    public void invertPermutation() {
        int i;
        int count;
        if (this.m_obs[0] == 0) {
            count = 1;
            i = 1;
        } else {
            count = 0;
            i = 0;
        }
        while (count < this.m_obs.length) {
            int i1 = this.m_obs[i];
            if (i1 > 0) {
                int i0 = i;
                int i2 = this.m_obs[i1];
                do {
                    this.m_obs[i1] = -i0;
                    ++count;
                    i0 = i1;
                    i1 = i2;
                    i2 = this.m_obs[i1];
                } while (i0 != i);
            }
            ++i;
        }
        for (i = 0; i < this.m_obs.length; ++i) {
            this.m_obs[i] = -this.m_obs[i];
        }
        this.m_isInverted = !this.m_isInverted;
    }

    public boolean isInverted() {
        return this.m_isInverted;
    }

    public int findIndex(int obsOrdinal) {
        int obsIndex = -1;
        if (!this.m_isInverted) {
            obsIndex = this.m_obs[obsOrdinal];
        } else {
            for (int i = 0; i < this.m_obs.length; ++i) {
                if (this.m_obs[i] != obsOrdinal) continue;
                obsIndex = i;
                break;
            }
        }
        return obsIndex;
    }

    public int findOrdinal(int obsIndex) {
        int obsOrdinal = -1;
        if (this.m_isInverted) {
            obsOrdinal = this.m_obs[obsIndex];
        } else {
            for (int i = 0; i < this.m_obs.length; ++i) {
                if (this.m_obs[i] != obsIndex) continue;
                obsOrdinal = i;
                break;
            }
        }
        return obsOrdinal;
    }

    public int getNumGroups() {
        return this.m_numGroups;
    }

    public int getFirstInGroup(int groupIndex) {
        return this.m_firstInGroups[groupIndex];
    }

    public int getLastInGroup(int groupIndex) {
        return (groupIndex < this.m_numGroups - 1 ? this.m_firstInGroups[groupIndex + 1] : this.m_dataModel.getNumObs()) - 1;
    }

    public int getNumObsInGroup(int groupIndex) {
        return this.getLastInGroup(groupIndex) - this.getFirstInGroup(groupIndex) + 1;
    }

    public int findGroup(int obsIndex) {
        if (this.m_numGroups == 0) {
            return -1;
        }
        int result = Arrays.binarySearch(this.m_firstInGroups, this.findOrdinal(obsIndex));
        if (result < 0) {
            result = -result - 2;
        }
        return result;
    }

    public boolean isObsInGroup(int obsIndex, int groupIndex) {
        boolean found = false;
        int firstObs = this.getFirstInGroup(groupIndex);
        int lastObs = this.getLastInGroup(groupIndex);
        if (this.m_isInverted) {
            int obsOrdinal = this.m_obs[obsIndex];
            found = obsOrdinal >= firstObs && obsOrdinal <= lastObs;
        } else {
            for (int obsOrdinal = firstObs; obsOrdinal <= lastObs; ++obsOrdinal) {
                if (this.m_obs[obsOrdinal] != obsIndex) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    public void obsAdded(int obsIndex, int numObs) {
        this.doPermutation();
    }

    public void obsMoved(int fromIndex, int toIndex, int numObs) {
        this.doPermutation();
    }

    public void obsMoved(int[] obsIndices, int numObs, int toIndex) {
        this.doPermutation();
    }

    public void obsDeleted(int startIndex, int endIndex) {
        this.doPermutation();
    }

    public void obsDeleted(int[] obsIndices, int numObs) {
        this.doPermutation();
    }

    public void valueChanged(int varIndex, int obsIndex) {
        boolean found = false;
        for (int i = 0; i < this.m_comparators.length; ++i) {
            if (!this.m_comparators[i].isBasedOn(varIndex)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.doPermutation();
    }

    public void valueChanged(int varIndex, int fromObsIndex, int toObsIndex) {
        boolean found = false;
        for (int i = 0; i < this.m_comparators.length; ++i) {
            if (!this.m_comparators[i].isBasedOn(varIndex)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.doPermutation();
    }

    public void obsPropertyChanged(int obsIndex, ObsPropertyModel obsPropModel) {
        boolean found = false;
        for (int i = 0; i < this.m_comparators.length; ++i) {
            if (!this.m_comparators[i].isBasedOn(obsPropModel)) continue;
            found = true;
            break;
        }
        if (!found) {
            return;
        }
        this.doPermutation();
    }

    public void fireReferenceCountChanged() {
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }

    protected void sort(int fromIndex, int toIndex) {
        SgObsSortContext.rangeCheck(this.m_obs.length, fromIndex, toIndex);
        this.m_fromIndex = fromIndex;
        this.m_toIndex = toIndex;
        this.sort2(fromIndex, toIndex);
    }

    protected int compare(int obsOrdinal1, int obsOrdinal2) {
        int result = 0;
        int obsIndex1 = this.m_obs[obsOrdinal1];
        int obsIndex2 = this.m_obs[obsOrdinal2];
        for (int i = 0; result == 0 && i < this.m_numKeys; ++i) {
            result = this.m_comparators[i].compare(obsIndex1, obsIndex2);
        }
        return result;
    }

    protected int compareToMedian(int obsOrdinal) {
        int result = 0;
        int obsIndex = this.m_obs[obsOrdinal];
        for (int i = 0; result == 0 && i < this.m_numKeys; ++i) {
            result = this.m_comparators[i].compareToMedian(obsIndex);
        }
        return result;
    }

    protected final boolean isMissing(int keyIndex, int obsOrdinal) {
        return this.m_comparators[keyIndex].isMissing(this.m_obs[obsOrdinal]);
    }

    private void sort1(int off, int len) {
        int c;
        int a;
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && this.compare(j - 1, j) > 0; --j) {
                    this.swap(j, j - 1);
                }
            }
            return;
        }
        int m = off + len / 2;
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = this.med3(l, l + s, l + 2 * s);
                m = this.med3(m - s, m, m + s);
                n = this.med3(n - 2 * s, n - s, n);
            }
            m = this.med3(l, m, n);
        }
        this.setMedian(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            int comp;
            if (b <= c && (comp = this.compareToMedian(b)) <= 0) {
                if (comp == 0) {
                    this.swap(a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && (comp = this.compareToMedian(c)) >= 0) {
                if (comp == 0) {
                    this.swap(c, d--);
                }
                --c;
            }
            if (b > c) break;
            this.swap(b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        this.vecswap(off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        this.vecswap(b, n - s, s);
        s = b - a;
        if (s > 1) {
            this.sort1(off, s);
        }
        if ((s = d - c) > 1) {
            this.sort1(n - s, s);
        }
    }

    private void swap(int a, int b) {
        int t = this.m_obs[a];
        this.m_obs[a] = this.m_obs[b];
        this.m_obs[b] = t;
    }

    private void vecswap(int a, int b, int n) {
        int i = 0;
        while (i < n) {
            this.swap(a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    private int med3(int a, int b, int c) {
        return this.compare(a, b) < 0 ? (this.compare(b, c) < 0 ? b : (this.compare(a, c) < 0 ? c : a)) : (this.compare(b, c) > 0 ? b : (this.compare(a, c) > 0 ? c : a));
    }

    private void setMedian(int obsOrdinal) {
        int obsIndex = this.m_obs[obsOrdinal];
        for (int i = 0; i < this.m_numKeys; ++i) {
            this.m_comparators[i].setMedian(obsIndex);
        }
    }

    private void sort2(int fromIndex, int toIndex) {
        int n = toIndex;
        int i = fromIndex;
        while (i < n) {
            if (this.isMissing(0, i)) {
                this.swap(i, --n);
                continue;
            }
            ++i;
        }
        this.sort1(fromIndex, n - fromIndex);
    }

    abstract class SgObsComparator {
        protected boolean m_isAscend;

        SgObsComparator() {
        }

        public void setOrder(boolean ascend) {
            this.m_isAscend = ascend;
        }

        public abstract void setMedian(int var1);

        public abstract int compareToMedian(int var1);

        public abstract int compare(int var1, int var2);

        public abstract boolean isMissing(int var1);

        public abstract boolean isBasedOn(int var1);

        public abstract boolean isBasedOn(Object var1);
    }

    class SgObsNumericComparator
    extends SgObsComparator {
        protected DataModel m_dataModel;
        protected int m_varIndex;
        protected double m_medianValue;

        public SgObsNumericComparator(DataModel dataModel, int varIndex) {
            this.m_dataModel = dataModel;
            this.m_varIndex = varIndex;
        }

        @Override
        public void setMedian(int obsIndex) {
            this.m_medianValue = this.m_dataModel.getDoubleValue(this.m_varIndex, obsIndex);
        }

        @Override
        public int compareToMedian(int obsIndex) {
            int result;
            double value = this.m_dataModel.getDoubleValue(this.m_varIndex, obsIndex);
            if (value == Double.NaN) {
                result = 1;
            } else {
                int n = value < this.m_medianValue ? -1 : (result = value > this.m_medianValue ? 1 : 0);
            }
            if (!this.m_isAscend) {
                result = -result;
            }
            return result;
        }

        @Override
        public int compare(int obsIndex1, int obsIndex2) {
            int result;
            double value1 = this.m_dataModel.getDoubleValue(this.m_varIndex, obsIndex1);
            double value2 = this.m_dataModel.getDoubleValue(this.m_varIndex, obsIndex2);
            if (value1 == Double.NaN || value2 == Double.NaN) {
                result = value1 != Double.NaN ? -1 : (value2 != Double.NaN ? 1 : 0);
            } else {
                int n = value1 < value2 ? -1 : (result = value1 > value2 ? 1 : 0);
            }
            if (!this.m_isAscend) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean isMissing(int obsIndex) {
            return this.m_dataModel.getDoubleValue(this.m_varIndex, obsIndex) == Double.NaN;
        }

        @Override
        public boolean isBasedOn(int varIndex) {
            return this.m_varIndex == varIndex;
        }

        @Override
        public boolean isBasedOn(Object object) {
            return false;
        }
    }

    class SgObsStringComparator
    extends SgObsComparator {
        protected DataModel m_dataModel;
        protected int m_varIndex;
        protected String m_medianValue;

        public SgObsStringComparator(DataModel dataModel, int varIndex) {
            this.m_dataModel = dataModel;
            this.m_varIndex = varIndex;
        }

        @Override
        public void setMedian(int obsIndex) {
            this.m_medianValue = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex);
        }

        @Override
        public int compareToMedian(int obsIndex) {
            int result = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex).compareTo(this.m_medianValue);
            return this.m_isAscend ? result : -result;
        }

        @Override
        public int compare(int obsIndex1, int obsIndex2) {
            String value1 = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex1);
            String value2 = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex2);
            int result = value1.compareTo(value2);
            return this.m_isAscend ? result : -result;
        }

        @Override
        public boolean isMissing(int obsIndex) {
            return this.m_dataModel.isValueMissing(this.m_varIndex, obsIndex);
        }

        @Override
        public boolean isBasedOn(int varIndex) {
            return this.m_varIndex == varIndex;
        }

        @Override
        public boolean isBasedOn(Object object) {
            return false;
        }
    }

    class SgObsGenericComparator
    extends SgObsComparator {
        protected DataModel m_dataModel;
        protected int m_varIndex;
        protected String m_medianValue;

        public SgObsGenericComparator(DataModel dataModel, int varIndex) {
            this.m_dataModel = dataModel;
            this.m_varIndex = varIndex;
        }

        @Override
        public void setMedian(int obsIndex) {
            this.m_medianValue = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex);
        }

        @Override
        public int compareToMedian(int obsIndex) {
            int result = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex).compareTo(this.m_medianValue);
            return this.m_isAscend ? result : -result;
        }

        @Override
        public int compare(int obsIndex1, int obsIndex2) {
            String value1 = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex1);
            String value2 = this.m_dataModel.getStringValue(this.m_varIndex, obsIndex2);
            int result = value1.compareTo(value2);
            return this.m_isAscend ? result : -result;
        }

        @Override
        public boolean isMissing(int obsIndex) {
            return this.m_dataModel.isValueMissing(this.m_varIndex, obsIndex);
        }

        @Override
        public boolean isBasedOn(int varIndex) {
            return this.m_varIndex == varIndex;
        }

        @Override
        public boolean isBasedOn(Object object) {
            return false;
        }
    }

    class SgObsPropertyComparator
    extends SgObsComparator {
        protected ObsPropertyModel m_propModel;
        protected int m_medianIndex;

        public SgObsPropertyComparator(ObsPropertyModel propModel) {
            if (!propModel.isComparable()) {
                throw new IllegalArgumentException(propModel.toString() + " is not comparable");
            }
            this.m_propModel = propModel;
        }

        @Override
        public void setMedian(int obsIndex) {
            this.m_medianIndex = obsIndex;
        }

        @Override
        public int compareToMedian(int obsIndex) {
            int result;
            int n = this.m_propModel.less(obsIndex, this.m_medianIndex) ? -1 : (result = this.m_propModel.greater(obsIndex, this.m_medianIndex) ? 1 : 0);
            if (!this.m_isAscend) {
                result = -result;
            }
            return result;
        }

        @Override
        public int compare(int obsIndex1, int obsIndex2) {
            int result;
            int n = this.m_propModel.less(obsIndex1, obsIndex2) ? -1 : (result = this.m_propModel.greater(obsIndex1, obsIndex2) ? 1 : 0);
            if (!this.m_isAscend) {
                result = -result;
            }
            return result;
        }

        @Override
        public boolean isMissing(int obsIndex) {
            return false;
        }

        @Override
        public boolean isBasedOn(int varIndex) {
            return false;
        }

        @Override
        public boolean isBasedOn(Object object) {
            return this.m_propModel.equals(object);
        }
    }
}

