/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.impl.SgDataModel;

class SgObsManager {
    protected SgDataModel m_dataModel;

    public SgObsManager(SgDataModel dataModel) {
        this.m_dataModel = dataModel;
    }

    public void addObs(int obsIndex, int numNewObs) {
        int i;
        if (obsIndex < 0 || obsIndex > this.m_dataModel.m_numObs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this.m_dataModel.m_numVars == 0) {
            return;
        }
        int[] obsHandles = this.m_dataModel.m_obsHandles;
        int[] obsOrdinals = this.m_dataModel.m_obsOrdinals;
        int numValidObs = this.m_dataModel.getNumObs();
        int capacity = obsHandles != null ? obsHandles.length : 0;
        boolean capacityChanged = false;
        if (numNewObs > capacity - numValidObs) {
            int blockSize = this.m_dataModel.getBlockSize();
            int newCapacity = blockSize * ((numNewObs + numValidObs + blockSize) / blockSize);
            this.changeCapacity(newCapacity);
            obsHandles = this.m_dataModel.m_obsHandles;
            obsOrdinals = this.m_dataModel.m_obsOrdinals;
            capacity = newCapacity;
            capacityChanged = true;
        }
        for (i = 0; i < capacity; ++i) {
            if (obsOrdinals[i] < obsIndex) continue;
            int n = i;
            obsOrdinals[n] = obsOrdinals[n] + numNewObs;
        }
        System.arraycopy(obsHandles, obsIndex, obsHandles, obsIndex + numNewObs, numValidObs - obsIndex);
        i = 0;
        int j = obsIndex;
        while (j < obsIndex + numNewObs) {
            if (obsOrdinals[i] == -1) {
                obsOrdinals[i] = j;
                obsHandles[j] = i;
                ++j;
            }
            ++i;
        }
        if (capacityChanged) {
            for (i = 0; i < this.m_dataModel.m_numVars; ++i) {
                this.m_dataModel.m_vars[i].changeCapacity(capacity);
            }
        }
        this.m_dataModel.m_numObs += numNewObs;
    }

    public void deleteObs(int startIndex, int endIndex) {
        int blockSize;
        int newCapacity;
        int i;
        if (startIndex < 0 || startIndex >= this.m_dataModel.m_numObs || endIndex < 0 || endIndex >= this.m_dataModel.m_numObs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("startIndex > endIndex");
        }
        int[] obsHandles = this.m_dataModel.m_obsHandles;
        int[] obsOrdinals = this.m_dataModel.m_obsOrdinals;
        int numDeletedObs = endIndex - startIndex + 1;
        int numObs = this.m_dataModel.getNumObs();
        for (i = 0; i < this.m_dataModel.m_numVars; ++i) {
            this.m_dataModel.m_vars[i].toDeleteValues(startIndex, endIndex);
        }
        for (i = startIndex; i <= endIndex; ++i) {
            obsOrdinals[obsHandles[i]] = -1;
        }
        if (endIndex < numObs - 1) {
            System.arraycopy(obsHandles, endIndex + 1, obsHandles, startIndex, numObs - endIndex - 1);
        }
        for (i = numObs - numDeletedObs; i < numObs; ++i) {
            obsHandles[i] = -1;
        }
        for (i = numObs - numDeletedObs - 1; i >= startIndex; --i) {
            int n = obsHandles[i];
            obsOrdinals[n] = obsOrdinals[n] - numDeletedObs;
        }
        this.m_dataModel.m_numObs -= numDeletedObs;
        numObs = this.m_dataModel.getNumObs();
        int capacity = obsHandles.length;
        boolean capacityChanged = false;
        if ((double)capacity > 1.2 * (double)numObs && (newCapacity = (blockSize = this.m_dataModel.getBlockSize()) * ((numObs + blockSize) / blockSize)) < capacity) {
            this.changeCapacity(newCapacity);
            obsHandles = this.m_dataModel.m_obsHandles;
            obsOrdinals = this.m_dataModel.m_obsOrdinals;
            capacity = newCapacity;
            capacityChanged = true;
        }
        if (capacityChanged) {
            for (i = 0; i < this.m_dataModel.m_numVars; ++i) {
                this.m_dataModel.m_vars[i].changeCapacity(capacity);
            }
        }
        for (i = 0; i < this.m_dataModel.m_numVars; ++i) {
            this.m_dataModel.m_vars[i].calcFracts(-1);
        }
    }

    public void moveObs(int fromIndex, int toIndex, int numObs) {
        int numValidObs = this.m_dataModel.getNumObs();
        if (fromIndex < 0 || fromIndex >= numValidObs || toIndex < 0 || toIndex >= numValidObs || numObs < 0 || fromIndex + numObs >= numValidObs) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (fromIndex == toIndex || numObs == 0) {
            return;
        }
        boolean moveToBottom = fromIndex < toIndex;
        int[] obsHandles = this.m_dataModel.m_obsHandles;
        int[] obsOrdinals = this.m_dataModel.m_obsOrdinals;
        if (numObs == 1) {
            int tmp = obsHandles[fromIndex];
            if (moveToBottom) {
                for (int i = fromIndex + 1; i <= toIndex; ++i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] - 1;
                }
                obsOrdinals[tmp] = toIndex;
                System.arraycopy(obsHandles, fromIndex + 1, obsHandles, fromIndex, toIndex - fromIndex);
                obsHandles[toIndex] = tmp;
            } else {
                for (int i = fromIndex - 1; i >= toIndex; --i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] + 1;
                }
                obsOrdinals[tmp] = toIndex;
                System.arraycopy(obsHandles, toIndex, obsHandles, toIndex + 1, fromIndex - toIndex);
                obsHandles[toIndex] = tmp;
            }
        } else {
            int[] movedHandles = new int[numObs];
            System.arraycopy(obsHandles, fromIndex, movedHandles, 0, numObs);
            if (moveToBottom) {
                for (int i = fromIndex + numObs; i <= toIndex; ++i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] - numObs;
                }
                int shift = toIndex - fromIndex - numObs + 1;
                for (int i = fromIndex + numObs - 1; i >= fromIndex; --i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] + shift;
                }
                System.arraycopy(obsHandles, fromIndex + numObs, obsHandles, fromIndex, toIndex - fromIndex - numObs + 1);
                System.arraycopy(movedHandles, 0, obsHandles, toIndex - numObs + 1, numObs);
            } else {
                for (int i = toIndex; i <= fromIndex; ++i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] + numObs;
                }
                int shift = fromIndex - toIndex;
                for (int i = fromIndex + numObs - 1; i >= fromIndex; --i) {
                    int n = obsHandles[i];
                    obsOrdinals[n] = obsOrdinals[n] - shift;
                }
                System.arraycopy(obsHandles, toIndex, obsHandles, toIndex + numObs, fromIndex - toIndex);
                System.arraycopy(movedHandles, 0, obsHandles, toIndex, numObs);
            }
        }
    }

    public void moveObs(int[] obsIndices, int numMovedObs, int toIndex, int middle) {
        block5: {
            block6: {
                block4: {
                    if (toIndex >= obsIndices[0] || middle >= 0) break block4;
                    int i = 0;
                    while (i < numMovedObs) {
                        this.moveObs(obsIndices[i], toIndex, 1);
                        ++i;
                        ++toIndex;
                    }
                    break block5;
                }
                if (toIndex <= obsIndices[numMovedObs - 1] || middle < numMovedObs) break block6;
                int i = numMovedObs - 1;
                while (i >= 0) {
                    this.moveObs(obsIndices[i], toIndex, 1);
                    --i;
                    --toIndex;
                }
                break block5;
            }
            if (middle < 0 || middle >= numMovedObs) break block5;
            int b = toIndex;
            int i = middle;
            while (i >= 0) {
                this.moveObs(obsIndices[i], b, 1);
                --i;
                --b;
            }
            b = toIndex + 1;
            i = middle + 1;
            while (i < numMovedObs) {
                this.moveObs(obsIndices[i], b, 1);
                ++i;
                ++b;
            }
        }
    }

    protected void changeCapacity(int newCapacity) {
        int oldCapacity;
        int[] obsHandles = this.m_dataModel.m_obsHandles;
        int[] obsOrdinals = this.m_dataModel.m_obsOrdinals;
        int n = oldCapacity = obsHandles != null ? obsHandles.length : 0;
        if (oldCapacity >= newCapacity && oldCapacity <= (int)(1.2 * (double)newCapacity + 1.0)) {
            return;
        }
        if (newCapacity > oldCapacity) {
            this.m_dataModel.m_obsHandles = new int[newCapacity];
            this.m_dataModel.m_obsOrdinals = new int[newCapacity];
            if (oldCapacity > 0) {
                System.arraycopy(obsHandles, 0, this.m_dataModel.m_obsHandles, 0, oldCapacity);
                System.arraycopy(obsOrdinals, 0, this.m_dataModel.m_obsOrdinals, 0, oldCapacity);
            }
        } else {
            this.m_dataModel.m_obsHandles = new int[newCapacity];
            int[] newObsOrdinals = new int[newCapacity];
            System.arraycopy(obsHandles, 0, this.m_dataModel.m_obsHandles, 0, newCapacity);
            int j = 0;
            for (int i = 0; i < oldCapacity; ++i) {
                int obsOrdinal = obsOrdinals[i];
                if (obsOrdinal == -1) continue;
                newObsOrdinals[j] = obsOrdinal;
                int oldObsHandle = obsHandles[obsOrdinal];
                if (oldObsHandle != j) {
                    this.m_dataModel.m_obsHandles[obsOrdinal] = j;
                    for (int k = 0; k < this.m_dataModel.m_numVars; ++k) {
                        this.m_dataModel.m_vars[k].copyValue(oldObsHandle, j);
                    }
                }
                ++j;
            }
            this.m_dataModel.m_obsOrdinals = newObsOrdinals;
        }
        obsHandles = this.m_dataModel.m_obsHandles;
        obsOrdinals = this.m_dataModel.m_obsOrdinals;
        for (int i = this.m_dataModel.getNumObs(); i < newCapacity; ++i) {
            obsHandles[i] = -1;
            obsOrdinals[i] = -1;
        }
    }
}

