/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.ObsPropertyEvent;
import com.sas.sg.datamodel.ObsPropertyListener;
import com.sas.sg.datamodel.ObsPropertyModel;
import java.util.ArrayList;

public class SgObsByteProp
implements ObsPropertyModel {
    protected DataModel m_dataModel;
    protected byte[] m_values;
    protected int m_numObs;
    protected int m_numUniqueValues;
    protected byte m_defaultValue = 1;
    protected ArrayList m_listenerList = new ArrayList();
    protected int[] m_obsList;
    protected int m_numBatched;

    public SgObsByteProp(DataModel dataModel) {
        this.m_dataModel = dataModel;
        int numObs = this.m_dataModel.getNumObs();
        if (numObs <= 0) {
            numObs = 1;
        }
        this.m_values = new byte[numObs];
        this.m_numObs = numObs;
    }

    public void setValue(int obsIndex, byte newValue) {
        this.m_values[obsIndex] = newValue;
        this.fireValueChanged(obsIndex);
    }

    public int getByteValue(int obsIndex) {
        return this.m_values[obsIndex];
    }

    public void setValues(int[] obsIndices, byte[] newValues) {
        if (obsIndices == null || obsIndices.length == 0 || newValues == null) {
            return;
        }
        if (obsIndices.length <= newValues.length) {
            for (int i = 0; i < obsIndices.length; ++i) {
                this.m_values[obsIndices[i]] = newValues[i];
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < obsIndices.length) {
                if (j >= newValues.length) {
                    j = 0;
                }
                this.m_values[obsIndices[i]] = newValues[j];
                ++i;
                ++j;
            }
        }
        this.fireValueChanged(obsIndices);
    }

    public void setAllValues(byte newValue) {
        if (this.m_numUniqueValues == 1 && this.m_numObs > 0 && this.m_values[0] == newValue) {
            return;
        }
        for (int i = 0; i < this.m_numObs; ++i) {
            this.m_values[i] = newValue;
        }
        this.m_numUniqueValues = 1;
        this.fireValueChanged(null);
    }

    public void setDefaultValue(byte Value) {
        this.m_defaultValue = Value;
    }

    public int getDefaultValue() {
        return this.m_defaultValue;
    }

    public void addObsPropertyListener(ObsPropertyListener listener) {
        if (listener != null && this.m_listenerList.indexOf(listener) < 0) {
            this.m_listenerList.add(listener);
        }
    }

    public void removeObsPropertyListener(ObsPropertyListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected void fireValueChanged(int[] obsIndices) {
        int numListeners = this.m_listenerList.size();
        if (numListeners == 0) {
            return;
        }
        ObsPropertyEvent eventObj = obsIndices != null ? new ObsPropertyEvent((ObsPropertyModel)this, -1, obsIndices) : new ObsPropertyEvent((ObsPropertyModel)this, -1, null, this.m_numObs);
        for (int i = 0; i < numListeners; ++i) {
            ((ObsPropertyListener)this.m_listenerList.get(i)).obsPropertyChanged(eventObj);
        }
    }

    protected void fireValueChanged(int obsIndex) {
        this.fireValueChanged(new int[]{obsIndex});
    }

    protected void changeCapacity(int newCapacity) {
        int oldCapacity = this.m_values != null ? this.m_values.length : 0;
        int copyLength = 0;
        byte[] newValues = null;
        int blockSize = this.m_dataModel.getBlockSize();
        if (newCapacity > oldCapacity) {
            newValues = new byte[newCapacity + blockSize];
            copyLength = oldCapacity;
        } else if ((double)oldCapacity > 1.2 * (double)newCapacity) {
            newValues = new byte[newCapacity + blockSize];
            copyLength = newCapacity;
        }
        if (copyLength > 0) {
            System.arraycopy(this.m_values, 0, newValues, 0, copyLength);
            this.m_values = newValues;
        }
    }

    public DataModel getDataModel() {
        return this.m_dataModel;
    }

    public int getNumListeners() {
        return this.m_listenerList.size();
    }

    public void setValues(int[] obsIndices, ArrayList newPropValues) {
        try {
            int numNewValues = newPropValues.size();
            byte[] Values2 = new byte[numNewValues];
            for (int i = 0; i < numNewValues; ++i) {
                Values2[i] = (Byte)newPropValues.get(i);
            }
            this.setValues(obsIndices, Values2);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void setValue(int obsIndex, Object newPropValue) {
        try {
            this.setValue(obsIndex, (Byte)newPropValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void setAllValues(Object newPropValue) {
        try {
            this.setAllValues((Byte)newPropValue);
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public Object getValue(int obsIndex) {
        return new Byte(this.m_values[obsIndex]);
    }

    public int getNumObsWith(Object propValue) {
        byte shape;
        try {
            shape = (Byte)propValue;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
        int count = 0;
        for (int i = 0; i < this.m_values.length; ++i) {
            if (this.m_values[i] != shape) continue;
            ++count;
        }
        return count;
    }

    public void obsAdded(int obsIndex, int numObs) {
        int oldCapacity = this.m_numObs;
        this.changeCapacity(this.m_numObs + numObs);
        if (this.m_values != null) {
            System.arraycopy(this.m_values, obsIndex, this.m_values, obsIndex + numObs, oldCapacity - obsIndex);
            for (int i = obsIndex; i < obsIndex + numObs; ++i) {
                this.m_values[i] = this.m_defaultValue;
            }
            this.m_numObs += numObs;
        }
    }

    public void obsMoved(int fromIndex, int toIndex, int numObs) {
        boolean moveToBottom;
        boolean bl = moveToBottom = fromIndex < toIndex;
        if (numObs == 1) {
            byte tmp = this.m_values[fromIndex];
            if (moveToBottom) {
                System.arraycopy(this.m_values, fromIndex + 1, this.m_values, fromIndex, toIndex - fromIndex);
            } else {
                System.arraycopy(this.m_values, toIndex, this.m_values, toIndex + 1, fromIndex - toIndex);
            }
            this.m_values[toIndex] = tmp;
        } else {
            byte[] tmps = new byte[numObs];
            System.arraycopy(this.m_values, fromIndex, tmps, 0, numObs);
            if (moveToBottom) {
                System.arraycopy(this.m_values, fromIndex + numObs, this.m_values, fromIndex, toIndex - fromIndex - numObs + 1);
                System.arraycopy(tmps, 0, this.m_values, toIndex - numObs + 1, numObs);
            } else {
                System.arraycopy(this.m_values, toIndex, this.m_values, toIndex + numObs, fromIndex - toIndex);
                System.arraycopy(tmps, 0, this.m_values, toIndex, numObs);
            }
        }
    }

    public void obsMoved(int[] obsIndices, int numObs, int toIndex) {
        int i;
        int middle = -1;
        for (i = 0; i < numObs; ++i) {
            if (obsIndices[i] >= toIndex) continue;
            middle = i;
        }
        if (middle == numObs - 1 && obsIndices[middle] < toIndex) {
            middle = numObs;
        }
        if (middle < 0) {
            i = 0;
            while (i < numObs) {
                this.obsMoved(obsIndices[i], toIndex, 1);
                ++i;
                ++toIndex;
            }
        } else if (middle >= numObs) {
            i = numObs - 1;
            while (i >= 0) {
                this.obsMoved(obsIndices[i], toIndex, 1);
                --i;
                --toIndex;
            }
        } else {
            int b = toIndex;
            i = middle;
            while (i >= 0) {
                this.obsMoved(obsIndices[i], b, 1);
                --i;
                --b;
            }
            b = toIndex + 1;
            i = middle + 1;
            while (i < numObs) {
                this.obsMoved(obsIndices[i], b, 1);
                ++i;
                ++b;
            }
        }
    }

    public void obsDeleted(int startIndex, int endIndex) {
        System.arraycopy(this.m_values, endIndex + 1, this.m_values, startIndex, this.m_numObs - endIndex - 1);
        this.m_numObs -= endIndex - startIndex + 1;
        this.changeCapacity(this.m_numObs);
    }

    public void obsDeleted(int[] obsIndices, int numObs) {
        if (numObs == 1) {
            this.obsDeleted(obsIndices[0], obsIndices[0]);
            return;
        }
        int start = obsIndices[0];
        for (int i = 0; i < numObs; ++i) {
            int a;
            int b = (i < numObs - 1 ? obsIndices[i + 1] : this.m_numObs) - 1;
            if (b < (a = obsIndices[i] + 1)) continue;
            System.arraycopy(this.m_values, a, this.m_values, start, b - a + 1);
            start += b - a + 1;
        }
        this.m_numObs -= numObs;
        this.changeCapacity(this.m_numObs);
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isMissing(int obsIndex) {
        return false;
    }

    public int compare(int obsIndex1, int obsIndex2) {
        return this.m_values[obsIndex1] - this.m_values[obsIndex2];
    }

    public boolean less(int obsIndex1, int obsIndex2) {
        return this.m_values[obsIndex1] < this.m_values[obsIndex2];
    }

    public boolean equal(int obsIndex1, int obsIndex2) {
        return this.m_values[obsIndex1] == this.m_values[obsIndex2];
    }

    public boolean greater(int obsIndex1, int obsIndex2) {
        return this.m_values[obsIndex1] > this.m_values[obsIndex2];
    }

    public void beginBatchList(int size) {
        if (size <= 0 || size > this.m_numObs) {
            size = this.m_numObs;
        }
        if (this.m_obsList == null) {
            this.m_obsList = new int[size + 2];
        }
        this.m_numBatched = 0;
    }

    public void addToBatchList(int obsIndex) {
        if (this.m_numBatched == this.m_obsList.length) {
            int[] newList = new int[this.m_numBatched + this.m_numBatched / 2];
            System.arraycopy(this.m_obsList, 0, newList, 0, this.m_numBatched);
            this.m_obsList = newList;
        }
        this.m_obsList[this.m_numBatched] = obsIndex;
        ++this.m_numBatched;
    }

    public void processBatchList(byte[] newValues) {
        if (newValues == null) {
            throw new IllegalArgumentException("no Value specified");
        }
        if (this.m_numBatched == 0) {
            return;
        }
        if (this.m_numBatched < this.m_obsList.length) {
            int[] newList = new int[this.m_numBatched];
            System.arraycopy(this.m_obsList, 0, newList, 0, this.m_numBatched);
            this.m_obsList = newList;
        }
        this.setValues(this.m_obsList, newValues);
    }

    public void endBatchList() {
        this.m_obsList = null;
    }
}

