/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.DataModel;
import com.sas.sg.datamodel.ObsPropertyEvent;
import com.sas.sg.datamodel.ObsPropertyListener;
import com.sas.sg.datamodel.ObsPropertyModel;
import com.sas.sg.datamodel.impl.SgObsBooleanPropEvent;
import java.util.ArrayList;
import java.util.BitSet;

public class SgObsBooleanProp
implements ObsPropertyModel {
    public static final int ACTION_SET = 1;
    public static final int ACTION_TOGGLE = 2;
    public static final int ACTION_CLEAR = 3;
    protected DataModel m_dataModel;
    protected BitSet m_bits;
    protected int m_numObs;
    protected int m_numNonZeroBits;
    protected boolean m_defaultValue;
    protected ArrayList m_listenerList = new ArrayList();
    protected int[] m_obsList;
    protected int m_numBatched;
    protected boolean m_isAdjusting;

    public SgObsBooleanProp(DataModel dataModel, boolean defaultValue) {
        this.m_dataModel = dataModel;
        this.m_defaultValue = defaultValue;
        this.m_numObs = this.m_dataModel.getNumObs();
        this.m_bits = new BitSet(this.m_numObs);
        if (this.m_defaultValue) {
            for (int i = 0; i < this.m_dataModel.getNumObs(); ++i) {
                this.m_bits.set(i);
                this.m_numNonZeroBits = this.m_dataModel.getNumObs();
            }
        } else {
            for (int i = 0; i < this.m_dataModel.getNumObs(); ++i) {
                this.m_bits.clear(i);
            }
        }
    }

    public void set(int obsIndex) {
        if (this.m_bits.get(obsIndex)) {
            return;
        }
        this.m_bits.set(obsIndex);
        ++this.m_numNonZeroBits;
        this.fireValueChanged(1, obsIndex);
    }

    public void set(int[] obsIndices) {
        if (obsIndices == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < obsIndices.length; ++i) {
            int obsIndex = obsIndices[i];
            if (this.m_bits.get(obsIndex)) continue;
            this.m_bits.set(obsIndex);
            ++this.m_numNonZeroBits;
        }
        this.fireValueChanged(1, obsIndices, obsIndices.length);
    }

    public void setAll() {
        if (this.m_numNonZeroBits == this.m_numObs) {
            return;
        }
        for (int i = 0; i < this.m_numObs; ++i) {
            if (this.m_bits.get(i)) continue;
            this.m_bits.set(i);
        }
        this.m_numNonZeroBits = this.m_numObs;
        this.fireValueChanged(1, null, 0);
    }

    public void clear(int obsIndex) {
        if (!this.m_bits.get(obsIndex)) {
            return;
        }
        this.m_bits.clear(obsIndex);
        --this.m_numNonZeroBits;
        this.fireValueChanged(3, obsIndex);
    }

    public void clear(int[] obsIndices) {
        if (obsIndices == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < obsIndices.length; ++i) {
            int obsIndex = obsIndices[i];
            if (!this.m_bits.get(obsIndex)) continue;
            this.m_bits.clear(obsIndex);
            --this.m_numNonZeroBits;
        }
        this.fireValueChanged(3, obsIndices, obsIndices.length);
    }

    public void clearAll() {
        if (this.m_numNonZeroBits == 0) {
            return;
        }
        this.m_bits.andNot(this.m_bits);
        this.m_numNonZeroBits = 0;
        this.fireValueChanged(3, null, 0);
    }

    public void toggle(int obsIndex) {
        if (this.m_bits.get(obsIndex)) {
            this.m_bits.clear(obsIndex);
            --this.m_numNonZeroBits;
        } else {
            this.m_bits.set(obsIndex);
            ++this.m_numNonZeroBits;
        }
        this.fireValueChanged(2, obsIndex);
    }

    public void toggle(int[] obsIndices) {
        if (obsIndices == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < obsIndices.length; ++i) {
            int obsIndex = obsIndices[i];
            if (this.m_bits.get(obsIndex)) {
                this.m_bits.clear(obsIndex);
                --this.m_numNonZeroBits;
                continue;
            }
            this.m_bits.set(obsIndex);
            ++this.m_numNonZeroBits;
        }
        this.fireValueChanged(2, obsIndices, obsIndices.length);
    }

    public void toggleAll() {
        for (int i = 0; i < this.m_numObs; ++i) {
            if (this.m_bits.get(i)) {
                this.m_bits.clear(i);
                --this.m_numNonZeroBits;
                continue;
            }
            this.m_bits.set(i);
            ++this.m_numNonZeroBits;
        }
        this.fireValueChanged(2, null, 0);
    }

    public final boolean get(int obsIndex) {
        return this.m_bits.get(obsIndex);
    }

    public void addObsPropertyListener(ObsPropertyListener listener) {
        if (listener != null && this.m_listenerList.indexOf(listener) < 0) {
            this.m_listenerList.add(listener);
        }
    }

    public void removeObsPropertyListener(ObsPropertyListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected void fireValueChanged(int eventType, int[] obsIndices, int length) {
        if (this.isAdjusting()) {
            return;
        }
        int numListeners = this.m_listenerList.size();
        if (numListeners == 0) {
            return;
        }
        SgObsBooleanPropEvent event = new SgObsBooleanPropEvent(this, eventType, obsIndices, length);
        for (int i = 0; i < numListeners; ++i) {
            ((ObsPropertyListener)this.m_listenerList.get(i)).obsPropertyChanged((ObsPropertyEvent)event);
        }
    }

    protected void fireValueChanged(int eventType, int obsIndex) {
        this.fireValueChanged(eventType, new int[]{obsIndex}, 1);
    }

    public DataModel getDataModel() {
        return this.m_dataModel;
    }

    public int getNumListeners() {
        return this.m_listenerList.size();
    }

    public void setValues(int[] obsIndices, ArrayList newPropValues) {
        try {
            int[] myObsIndices = new int[obsIndices.length];
            this.setAdjusting(true);
            int numSets = 0;
            int numClears = 0;
            int i = 0;
            int j = 0;
            while (i < obsIndices.length) {
                int obsIndex = obsIndices[i];
                if (j >= newPropValues.size()) {
                    j = 0;
                }
                if (((Boolean)newPropValues.get(j)).booleanValue()) {
                    if (!this.m_bits.get(obsIndex)) {
                        this.set(obsIndex);
                        myObsIndices[numSets++] = obsIndex;
                    }
                } else if (this.m_bits.get(obsIndex)) {
                    this.clear(obsIndex);
                    myObsIndices[obsIndices.length - ++numClears] = obsIndex;
                }
                ++i;
                ++j;
            }
            this.setAdjusting(false);
            if (numSets > 0) {
                this.fireValueChanged(1, myObsIndices, numSets);
            }
            if (numClears > 0) {
                if (numClears < obsIndices.length) {
                    System.arraycopy(myObsIndices, obsIndices.length - numClears, myObsIndices, 0, numClears);
                }
                this.fireValueChanged(3, myObsIndices, numClears);
            }
        }
        catch (Exception e) {
            this.setAdjusting(false);
            throw new IllegalArgumentException();
        }
    }

    public void setValue(int obsIndex, Object newPropValue) {
        try {
            if (((Boolean)newPropValue).booleanValue()) {
                this.set(obsIndex);
            } else {
                this.clear(obsIndex);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void setAllValues(Object newPropValue) {
        try {
            if (((Boolean)newPropValue).booleanValue()) {
                this.setAll();
            } else {
                this.clearAll();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public Object getValue(int obsIndex) {
        return new Boolean(this.get(obsIndex));
    }

    public int getNumObsWith(Object propValue) {
        try {
            return (Boolean)propValue != false ? this.m_numNonZeroBits : this.m_numObs - this.m_numNonZeroBits;
        }
        catch (Exception e) {
            throw new IllegalArgumentException();
        }
    }

    public void obsAdded(int obsIndex, int numObs) {
        int i;
        for (i = this.m_numObs - 1; i >= obsIndex; --i) {
            if (this.m_bits.get(i)) {
                this.m_bits.set(i + numObs);
                continue;
            }
            this.m_bits.clear(i + numObs);
        }
        if (this.m_defaultValue) {
            for (i = obsIndex; i < obsIndex + numObs; ++i) {
                this.m_bits.set(i);
            }
            this.m_numNonZeroBits += numObs;
        } else {
            for (i = obsIndex; i < obsIndex + numObs; ++i) {
                this.m_bits.clear(i);
            }
        }
        this.m_numObs += numObs;
    }

    public void obsMoved(int fromIndex, int toIndex, int numObs) {
        boolean[] values = new boolean[numObs];
        int i = 0;
        int j = fromIndex;
        while (i < numObs) {
            values[i] = this.m_bits.get(j);
            ++i;
            ++j;
        }
        if (fromIndex < toIndex) {
            i = fromIndex + numObs;
            j = fromIndex;
            while (i <= toIndex) {
                if (this.m_bits.get(i)) {
                    this.m_bits.set(j);
                } else {
                    this.m_bits.clear(j);
                }
                ++i;
                ++j;
            }
            j = toIndex - numObs + 1;
        } else if (fromIndex > toIndex) {
            i = fromIndex - 1;
            j = fromIndex + numObs - 1;
            while (i >= toIndex) {
                if (this.m_bits.get(i)) {
                    this.m_bits.set(j);
                } else {
                    this.m_bits.clear(j);
                }
                --i;
                --j;
            }
            j = toIndex;
        }
        i = 0;
        while (i < numObs) {
            if (values[i]) {
                this.m_bits.set(j);
            } else {
                this.m_bits.clear(j);
            }
            ++i;
            ++j;
        }
    }

    public void obsMoved(int[] obsIndices, int numObs, int toIndex) {
        int i;
        int middle = -1;
        for (i = 0; i < numObs; ++i) {
            if (obsIndices[i] >= toIndex) continue;
            middle = i;
        }
        if (middle == numObs - 1 && obsIndices[middle] < toIndex) {
            middle = numObs;
        }
        if (middle < 0) {
            i = 0;
            while (i < numObs) {
                this.obsMoved(obsIndices[i], toIndex, 1);
                ++i;
                ++toIndex;
            }
        } else if (middle >= numObs) {
            i = numObs - 1;
            while (i >= 0) {
                this.obsMoved(obsIndices[i], toIndex, 1);
                --i;
                --toIndex;
            }
        } else {
            int b = toIndex;
            i = middle;
            while (i >= 0) {
                this.obsMoved(obsIndices[i], b, 1);
                --i;
                --b;
            }
            b = toIndex + 1;
            i = middle + 1;
            while (i < numObs) {
                this.obsMoved(obsIndices[i], b, 1);
                ++i;
                ++b;
            }
        }
    }

    public void obsDeleted(int startIndex, int endIndex) {
        int i;
        if (this.m_numNonZeroBits > 0) {
            for (i = startIndex; i <= endIndex; ++i) {
                if (!this.m_bits.get(i)) continue;
                --this.m_numNonZeroBits;
            }
        }
        i = startIndex;
        for (int j = endIndex + 1; j < this.m_numObs; ++j) {
            if (this.m_bits.get(j)) {
                this.m_bits.set(i);
            } else {
                this.m_bits.clear(i);
            }
            ++i;
        }
        this.m_numObs -= endIndex - startIndex + 1;
    }

    public void obsDeleted(int[] obsIndices, int numObs) {
        if (numObs == 1) {
            this.obsDeleted(obsIndices[0], obsIndices[0]);
            return;
        }
        if (this.m_numNonZeroBits > 0) {
            for (int i = 0; i < numObs; ++i) {
                if (!this.m_bits.get(obsIndices[i])) continue;
                --this.m_numNonZeroBits;
            }
        }
        int start = obsIndices[0];
        for (int i = 0; i < numObs; ++i) {
            int k = i < numObs - 1 ? obsIndices[i + 1] : this.m_numObs;
            for (int j = obsIndices[i] + 1; j < k; ++j) {
                if (this.m_bits.get(j)) {
                    this.m_bits.set(start);
                } else {
                    this.m_bits.clear(start);
                }
                ++start;
            }
        }
        this.m_numObs -= numObs;
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isMissing(int obsIndex) {
        return false;
    }

    public int compare(int obsIndex1, int obsIndex2) {
        int value1 = this.get(obsIndex1) ? 1 : 0;
        int value2 = this.get(obsIndex2) ? 1 : 0;
        return value1 - value2;
    }

    public boolean less(int obsIndex1, int obsIndex2) {
        return !this.get(obsIndex1) && this.get(obsIndex2);
    }

    public boolean equal(int obsIndex1, int obsIndex2) {
        return this.get(obsIndex1) == this.get(obsIndex2);
    }

    public boolean greater(int obsIndex1, int obsIndex2) {
        return this.get(obsIndex1) && !this.get(obsIndex2);
    }

    public void beginBatchList(int size) {
        if (size <= 0 || size > this.m_numObs) {
            size = this.m_numObs;
        }
        if (this.m_obsList == null) {
            this.m_obsList = new int[size + 2];
        }
        this.m_numBatched = 0;
    }

    public void addToBatchList(int obsIndex) {
        if (this.m_numBatched == this.m_obsList.length) {
            int[] newList = new int[this.m_numBatched + this.m_numBatched / 2];
            System.arraycopy(this.m_obsList, 0, newList, 0, this.m_numBatched);
            this.m_obsList = newList;
        }
        this.m_obsList[this.m_numBatched] = obsIndex;
        ++this.m_numBatched;
    }

    public void processBatchList(int action) {
        if (this.m_numBatched == 0) {
            return;
        }
        if (this.m_numBatched < this.m_obsList.length) {
            int[] newList = new int[this.m_numBatched];
            System.arraycopy(this.m_obsList, 0, newList, 0, this.m_numBatched);
            this.m_obsList = newList;
        }
        switch (action) {
            case 1: {
                this.set(this.m_obsList);
                break;
            }
            case 3: {
                this.clear(this.m_obsList);
                break;
            }
            case 2: {
                this.toggle(this.m_obsList);
            }
        }
    }

    public void endBatchList() {
        this.m_obsList = null;
        this.m_numBatched = 0;
    }

    public int getNumObsInBatchList() {
        return this.m_numBatched;
    }

    protected void setAdjusting(boolean isAdjusting) {
        this.m_isAdjusting = isAdjusting;
    }

    protected boolean isAdjusting() {
        return this.m_isAdjusting;
    }
}

