/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.impl.SgDataModel;
import com.sas.sg.datamodel.impl.SgFract;
import com.sas.sg.datamodel.impl.SgObsBooleanProp;
import com.sas.sg.datamodel.impl.SgVariable;

class SgNumericVar
extends SgVariable {
    private static final double EPSILON = 1.1E-16;
    private static final double ABSOLUTE_FUZZ = 1.1E-13;
    protected double[] m_values;
    protected double m_min = Double.NaN;
    protected double m_max = Double.NaN;
    protected boolean m_isMissingValueNaN = true;
    protected double m_missingValue = Double.NaN;
    protected boolean m_isNominal;
    protected boolean m_isRangeValid;

    public SgNumericVar(SgDataModel dataModel, int varHandle, int numObs) {
        super(dataModel, varHandle, numObs);
        this.m_valueType = "Numeric Variable";
        this.m_isNominal = false;
        if (numObs <= 0) {
            numObs = 1;
        }
        this.m_values = new double[numObs];
        this.setMissingValues(0, numObs - 1);
        this.m_min = Double.NaN;
        this.m_max = Double.NaN;
        this.setFractOn(false);
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public void setNominal(boolean isNominal) {
        this.m_isNominal = isNominal;
        this.calcFracts(-1);
    }

    @Override
    public boolean isNominal() {
        return this.m_isNominal;
    }

    @Override
    public void changeCapacity(int newObsCapacity) {
        int oldCapacity;
        int n = oldCapacity = this.m_values != null ? this.m_values.length : 0;
        if (oldCapacity >= newObsCapacity && oldCapacity <= (int)(1.2 * (double)newObsCapacity + 1.0)) {
            return;
        }
        int validCapacity = Math.min(newObsCapacity, oldCapacity);
        double[] newValues = new double[newObsCapacity];
        if (this.m_values != null && validCapacity > 0) {
            System.arraycopy(this.m_values, 0, newValues, 0, validCapacity);
        }
        this.m_values = newValues;
        this.setMissingValues(oldCapacity, newObsCapacity - 1);
        if (this.isFractOn()) {
            int[] newFractValues = new int[newObsCapacity];
            if (this.m_fractValues != null && validCapacity > 0) {
                System.arraycopy(this.m_fractValues, 0, newFractValues, 0, validCapacity);
            }
            this.m_fractValues = newFractValues;
            for (int i = oldCapacity; i < newObsCapacity; ++i) {
                this.m_fractValues[i] = 0;
            }
        }
    }

    @Override
    protected int getCapacity() {
        return this.m_values != null ? this.m_values.length : 0;
    }

    @Override
    public void calcFracts(int obsOrdinal) {
        if (!this.isFractOn()) {
            return;
        }
        if (!this.isNominal()) {
            int j;
            int k;
            if (!this.m_isRangeValid) {
                this.calcMinMax();
            }
            if (Double.isNaN(this.m_min) || Double.isNaN(this.m_max)) {
                return;
            }
            SgObsBooleanProp obsGraphed = (SgObsBooleanProp)this.m_dataModel.getObsPropertyModel("Obs Graphed");
            if (obsOrdinal >= 0) {
                j = k = obsOrdinal;
            } else {
                double absMin;
                double absMax = Math.abs(this.m_max);
                double relativeFuzz = 1.1E-13 * Math.max(absMax, absMin = Math.abs(this.m_min));
                this.m_fractScale = this.m_max - this.m_min < relativeFuzz || absMin < (double)1.401E-42f && absMax < (double)1.401E-42f ? 1.0 - 2.0 * this.m_fractMargin : (1.0 - 2.0 * this.m_fractMargin) / (this.m_max - this.m_min);
                j = 0;
                k = this.m_dataModel.getNumObs() - 1;
            }
            int[] obsHandles = this.m_dataModel.m_obsHandles;
            for (int i = j; i <= k; ++i) {
                int obsHandle = obsHandles[i];
                this.m_fractValues[obsHandle] = Double.isNaN(this.m_values[obsHandle]) || obsGraphed != null && !obsGraphed.get(i) ? SgFract.doubleToFract(0.0) : SgFract.doubleToFract(2.0 * (this.m_fractMargin + this.m_values[obsHandle] - this.m_min) * this.m_fractScale - 1.0);
            }
        } else {
            this.calcNominalFracts(obsOrdinal);
        }
    }

    @Override
    public final boolean setValue(int obsHandle, double value) {
        double oldValue = this.m_values[obsHandle];
        if (Double.isNaN(oldValue) && Double.isNaN(value)) {
            return false;
        }
        double fuzz = 1.1E-13;
        if (!Double.isNaN(oldValue) && !Double.isNaN(value)) {
            double absOldValue = Math.abs(oldValue);
            double absNewValue = Math.abs(value);
            fuzz *= Math.max(absOldValue, absNewValue);
            if (Math.abs(oldValue - value) < fuzz) {
                return false;
            }
        } else if (!Double.isNaN(oldValue)) {
            fuzz *= Math.abs(oldValue);
        }
        if (this.isNominal()) {
            // empty if block
        }
        this.m_values[obsHandle] = value;
        boolean toRecalcAllFracts = false;
        if (Double.isNaN(this.m_min) || Double.isNaN(this.m_max)) {
            this.m_min = value;
            this.m_max = value;
            toRecalcAllFracts = true;
        } else if (!Double.isNaN(value) && !Double.isNaN(oldValue)) {
            if (oldValue >= this.m_min + fuzz && oldValue <= this.m_max - fuzz) {
                if (this.m_min > value) {
                    this.m_min = value;
                    toRecalcAllFracts = true;
                }
                if (this.m_max < value) {
                    this.m_max = value;
                    toRecalcAllFracts = true;
                }
            } else {
                this.calcMinMax();
                toRecalcAllFracts = true;
            }
        } else if (!Double.isNaN(value)) {
            if (this.m_min > value) {
                this.m_min = value;
                toRecalcAllFracts = true;
            }
            if (this.m_max < value) {
                this.m_max = value;
                toRecalcAllFracts = true;
            }
        } else if (!Double.isNaN(oldValue) && (oldValue < this.m_min + fuzz || oldValue > this.m_max - fuzz)) {
            this.calcMinMax();
            toRecalcAllFracts = true;
        }
        this.calcFracts(toRecalcAllFracts ? -1 : this.m_dataModel.m_obsOrdinals[obsHandle]);
        return true;
    }

    @Override
    public boolean setValue(int obsHandle, Object value) {
        try {
            return this.setValue(obsHandle, ((Number)value).doubleValue());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("numeric variable doesn't support this value");
        }
    }

    @Override
    public final double getDoubleValue(int obsHandle) {
        return this.m_values[obsHandle];
    }

    @Override
    public final Object getValue(int obsHandle) {
        return new Double(this.m_values[obsHandle]);
    }

    @Override
    public void copyValue(int fromHandle, int toHandle) {
        this.m_values[toHandle] = this.m_values[fromHandle];
        if (this.isFractOn()) {
            this.m_fractValues[toHandle] = this.m_fractValues[fromHandle];
        }
    }

    @Override
    public double getMinValue() {
        if (!this.m_isRangeValid) {
            this.calcMinMax();
        }
        return this.m_min;
    }

    @Override
    public double getMaxValue() {
        if (!this.m_isRangeValid) {
            this.calcMinMax();
        }
        return this.m_max;
    }

    public void setValueArray(double[] values) {
        this.m_values = values;
    }

    public double[] getValueArray() {
        return this.m_values;
    }

    @Override
    public double getFractMargin() {
        return this.m_fractMargin;
    }

    @Override
    public void setDefaultMissingValue(Object missingValue) {
        this.m_missingValue = (Double)missingValue;
        this.m_isMissingValueNaN = Double.isNaN(this.m_missingValue);
    }

    @Override
    public Object getDefaultMissingValue() {
        return new Double(this.m_missingValue);
    }

    @Override
    protected void setMissingValues(int fromHandle, int toHandle) {
        for (int obsHandle = fromHandle; obsHandle <= toHandle; ++obsHandle) {
            this.m_values[obsHandle] = this.m_missingValue;
        }
    }

    @Override
    public boolean isValueMissing(int obsHandle) {
        return this.m_isMissingValueNaN && Double.isNaN(this.m_values[obsHandle]) || this.m_values[obsHandle] == this.m_missingValue;
    }

    protected boolean isValueMissing(double value) {
        return value == this.m_missingValue;
    }

    @Override
    protected void toDeleteValues(int fromIndex, int toIndex) {
        this.m_isRangeValid = false;
    }

    protected void calcMinMax() {
        this.m_min = Double.MAX_VALUE;
        this.m_max = -1.7976931348623157E308;
        int[] obsHandles = this.m_dataModel.m_obsHandles;
        for (int oord = 0; oord < this.m_dataModel.getNumObs(); ++oord) {
            int ohand = obsHandles[oord];
            double value = this.m_values[ohand];
            if (this.m_min > value) {
                this.m_min = value;
            }
            if (!(this.m_max < value)) continue;
            this.m_max = value;
        }
        if (this.m_min > this.m_max) {
            this.m_min = Double.NaN;
            this.m_max = Double.NaN;
        }
        this.m_isRangeValid = true;
    }

    protected void updateMinMax(double newValue) {
        if (newValue == Double.NaN) {
            return;
        }
        if (this.m_min == Double.NaN && this.m_max == Double.NaN) {
            this.m_min = newValue;
            this.m_max = newValue;
        } else {
            if (this.m_min > newValue) {
                this.m_min = newValue;
            }
            if (this.m_max < newValue) {
                this.m_max = newValue;
            }
        }
        this.m_isRangeValid = true;
    }
}

