/*
 * Decompiled with CFR 0.152.
 */
package com.sas.sg.datamodel.impl;

import com.sas.sg.datamodel.impl.SgDataModel;
import com.sas.sg.datamodel.impl.SgVariable;

class SgCharacterVar
extends SgVariable {
    protected String[] m_values;
    protected String m_missingValue = new String();

    public SgCharacterVar(SgDataModel dataModel, int varHandle, int numObs) {
        super(dataModel, varHandle, numObs);
        this.m_valueType = "Charater Variable";
        if (numObs <= 0) {
            numObs = 1;
        }
        this.m_values = new String[numObs];
        this.setFractOn(false);
        this.setMissingValues(0, numObs - 1);
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    public void setNominal(boolean isNominal) {
    }

    @Override
    public boolean isNominal() {
        return true;
    }

    @Override
    public void changeCapacity(int newObsCapacity) {
        int oldCapacity;
        int n = oldCapacity = this.m_values != null ? this.m_values.length : 0;
        if (oldCapacity >= newObsCapacity && oldCapacity <= (int)(1.2 * (double)newObsCapacity + 1.0)) {
            return;
        }
        int validCapacity = Math.min(newObsCapacity, oldCapacity);
        String[] newValues = new String[newObsCapacity];
        if (this.m_values != null && validCapacity > 0) {
            System.arraycopy(this.m_values, 0, newValues, 0, validCapacity);
        }
        this.m_values = newValues;
        this.setMissingValues(oldCapacity, newObsCapacity - 1);
        if (this.isFractOn()) {
            int[] newFractValues = new int[newObsCapacity];
            if (this.m_fractValues != null && validCapacity > 0) {
                System.arraycopy(this.m_fractValues, 0, newFractValues, 0, validCapacity);
            }
            this.m_fractValues = newFractValues;
            for (int i = oldCapacity; i < newObsCapacity; ++i) {
                this.m_fractValues[i] = 0;
            }
        }
    }

    @Override
    protected int getCapacity() {
        return this.m_values != null ? this.m_values.length : 0;
    }

    @Override
    public boolean setValue(int obsHandle, Object value) {
        if (value == null && this.m_values[obsHandle] == null) {
            return false;
        }
        String strValue = ((String)value).trim();
        if (strValue.equals(this.m_values[obsHandle])) {
            return false;
        }
        this.m_values[obsHandle] = strValue;
        this.calcFracts(this.m_dataModel.m_obsOrdinals[obsHandle]);
        return true;
    }

    @Override
    public Object getValue(int obsHandle) {
        return this.m_values[obsHandle];
    }

    @Override
    public String getStringValue(int obsHandle) {
        return this.m_values[obsHandle];
    }

    @Override
    public void copyValue(int fromHandle, int toHandle) {
        this.m_values[toHandle] = this.m_values[fromHandle];
        if (this.isFractOn()) {
            this.m_fractValues[toHandle] = this.m_fractValues[fromHandle];
        }
    }

    @Override
    public void setDefaultMissingValue(Object missingValue) {
        this.m_missingValue = missingValue.toString();
    }

    @Override
    public Object getDefaultMissingValue() {
        return this.m_missingValue;
    }

    @Override
    protected void setMissingValues(int fromHandle, int toHandle) {
        for (int obsHandle = fromHandle; obsHandle <= toHandle; ++obsHandle) {
            this.m_values[obsHandle] = this.m_missingValue;
        }
    }

    @Override
    public boolean isValueMissing(int obsHandle) {
        return this.m_values[obsHandle] == null || this.m_values[obsHandle].equals(this.m_missingValue);
    }
}

