/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.etl.models.job.IJob;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.WAdminResource;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class JobPropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(JobPropertiesModel.class);
    protected static final int JOB_PROPERTIES_COUNT = 12;
    protected int m_iTablesLoaded;
    protected int m_iDisableCheckpoints;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;
    private IJob m_mdlJob;

    public JobPropertiesModel(Job job) {
        this(job, null);
    }

    public JobPropertiesModel(Job job, IJob mdlJob) {
        super((Root)job);
        this.m_mdlJob = mdlJob;
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iTablesLoaded = 4;
        this.m_iDisableCheckpoints = 5;
        this.m_iLastModifiedBy = 6;
        this.m_iDateUpdated = 7;
        this.m_iDateCreated = 8;
        this.m_iLogicalType = 9;
        this.m_iMetadataID = 10;
        this.m_iUsageVersion = 11;
    }

    @Override
    public int getNumberOfProperties() {
        return 12;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<ClassifierMap><ClassifierTargets/></ClassifierMap>");
            template.append("<Select><ClassifierTargets/></Select>");
            template.append("<SyncStep><Transformations/></SyncStep>");
            template.append("<TransformationActivity><Steps/></TransformationActivity>");
            template.append("<TransformationStep><Transformations/></TransformationStep>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("JobActivities");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iTablesLoaded, bundle.getString("JobPropertiesModel.TablesLoaded.txt"), null, JobPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iDisableCheckpoints, bundle.getString("JobPropertiesModel.DisableCheckpoints.txt"), null, JobPropertiesModel.getDefaultBooleanRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        Job job = (Job)this.m_mdoObject;
        AssociationList alActivities = job.getJobActivities();
        ArrayList<String> tableNames = new ArrayList<String>();
        for (int i = 0; i < alActivities.size(); ++i) {
            AssociationList alSteps = ((TransformationActivity)alActivities.get(i)).getSteps();
            for (int j = 0; j < alSteps.size(); ++j) {
                AssociationList alTransformations = ((TransformationStep)alSteps.get(j)).getTransformations();
                for (int k = 0; k < alTransformations.size(); ++k) {
                    if (!(alTransformations.get(k) instanceof ClassifierMap)) continue;
                    AssociationList alTargets = ((ClassifierMap)alTransformations.get(k)).getClassifierTargets();
                    for (int m = 0; m < alTargets.size(); ++m) {
                        CMetadata cm = (CMetadata)alTargets.get(m);
                        if (cm == null || !cm.getCMetadataType().equals("PhysicalTable") && !cm.getCMetadataType().equals("ExternalTable")) continue;
                        tableNames.add(cm.getName());
                    }
                }
            }
        }
        this.m_aTempValues[this.m_iTablesLoaded] = this.createCommaDelimitedString(tableNames);
        if (this.m_mdlJob != null) {
            this.m_aTempValues[this.m_iDisableCheckpoints] = this.m_mdlJob.isDisableCheckpoints();
        }
    }
}

