/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.ExternalTable;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.wadmin.visuals.properties.RootPropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.metadata.EFIDataModel;
import java.rmi.RemoteException;
import java.text.NumberFormat;

public class ExternalTablePropertiesModel
extends RootPropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ExternalTablePropertiesModel.class);
    protected static final int EXTERNALTABLE_PROPERTIES_COUNT = 13;
    protected int m_iPath;
    protected int m_iServer;
    protected int m_iNumberOfColumns;

    public ExternalTablePropertiesModel(ExternalTable et) {
        super((Root)et);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iPath = 4;
        this.m_iServer = 5;
        this.m_iNumberOfColumns = 6;
        this.m_iLastModifiedBy = 7;
        this.m_iDateUpdated = 8;
        this.m_iDateCreated = 9;
        this.m_iLogicalType = 10;
        this.m_iMetadataID = 11;
        this.m_iUsageVersion = 12;
    }

    @Override
    public int getNumberOfProperties() {
        return 13;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iPath, bundle.getString("ExternalTablePropertiesModel.Path.txt"), null, ExternalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iServer, bundle.getString("ExternalTablePropertiesModel.Server.txt"), null, ExternalTablePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iNumberOfColumns, bundle.getString("ExternalTablePropertiesModel.NumberOfColumns.txt"), null, ExternalTablePropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        ExternalTable et = (ExternalTable)this.m_mdoObject;
        EFIDataModel etModel = new EFIDataModel();
        etModel.setExternalTable(et);
        etModel.populateStore();
        this.m_aTempValues[this.m_iPath] = etModel.getFilename();
        WsAppServer appserver = etModel.getAppServer();
        this.m_aTempValues[this.m_iServer] = appserver != null ? appserver.getServerName() : null;
        NumberFormat nf = NumberFormat.getIntegerInstance();
        this.m_aTempValues[this.m_iNumberOfColumns] = nf.format(etModel.getColumns().size());
        etModel.dispose();
    }
}

