/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.models.SimpleBrowseObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BrowseMessageQueuePropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseMessageQueuePropertiesModel.class);
    protected static final int TRANSFORMATION_PROPERTIES_COUNT = 14;
    protected static final int TRANSFORMATION_TYPE_OTHER = 0;
    protected static final int TRANSFORMATION_TYPE_WSMQ = 1;
    protected static final int TRANSFORMATION_TYPE_MSMQ = 2;
    protected int m_iType;
    protected int m_iQueueManager;
    int iTransformationType;
    String m_QueueManagerName;
    private static List s_lAttributes = null;

    public BrowseMessageQueuePropertiesModel(SimpleBrowseObject transformation) {
        super(transformation);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iType = 4;
        this.m_iQueueManager = 5;
        this.m_iLastModifiedBy = 6;
        this.m_iDateUpdated = 7;
        this.m_iDateCreated = 8;
        this.m_iDateArchived = 9;
        this.m_iArchiveName = 10;
        this.m_iLogicalType = 11;
        this.m_iMetadataID = 12;
        this.m_iUsageVersion = 13;
    }

    @Override
    public int getNumberOfProperties() {
        return 14;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("DeployedComponents");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iType, bundle.getString("TransformationPropertiesModel.QueueType.txt"), null, BrowseMessageQueuePropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iQueueManager, bundle.getString("TransformationPropertiesModel.QueueManagerName.txt"), null, BrowseMessageQueuePropertiesModel.getDefaultRenderer());
    }

    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        this.setTransformationType();
        if (this.iTransformationType == 1) {
            this.m_aTempValues[this.m_iType] = bundle.getString("TransformationPropertiesModel.WebsphereQueue.txt");
            this.m_aTempValues[this.m_iQueueManager] = this.m_QueueManagerName;
        } else if (this.iTransformationType == 2) {
            this.m_aTempValues[this.m_iType] = bundle.getString("TransformationPropertiesModel.MicrosoftQueue.txt");
            this.m_aTempValues[this.m_iQueueManager] = this.m_QueueManagerName;
        }
    }

    private void setTransformationType() {
        BrowseMetadataInterface browse = this.m_browseObject.getBrowseObject();
        List alDC = null;
        alDC = (List)browse.get("DeployedComponents");
        BrowseMetadataInterface deployedComponent = null;
        if (alDC != null && alDC.size() > 0) {
            deployedComponent = (BrowseMetadataInterface)alDC.get(0);
        }
        if (deployedComponent != null) {
            String classId = (String)deployedComponent.get("ClassIdentifier");
            if ("MessageQueue.Websphere".compareToIgnoreCase(classId) == 0) {
                this.iTransformationType = 1;
                this.m_QueueManagerName = deployedComponent.getName();
            } else if ("MessageQueue.MSMQ".compareToIgnoreCase(classId) == 0) {
                this.iTransformationType = 2;
                this.m_QueueManagerName = deployedComponent.getName();
            }
        }
    }
}

