/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.properties;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdObjectStoreImpl;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.MdStoreListener;
import com.sas.metadata.remote.SASLibrary;
import com.sas.services.ServiceException;
import com.sas.services.information.browse.BrowseMetadataInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.properties.BrowseObjectUtil;
import com.sas.wadmin.visuals.properties.BrowsePropertiesModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class BrowseLibraryPropertiesModel
extends BrowsePropertiesModel {
    private static WAdminResource bundle = WAdminResource.getBundle(BrowseLibraryPropertiesModel.class);
    protected static final int LIBRARY_PROPERTIES_COUNT = 16;
    protected int m_iLibref;
    protected int m_iPath;
    protected int m_iServer;
    protected int m_iLibname;
    private static String s_strTemplate = null;
    private static List s_lAttributes = null;
    public static String TEMPLATE_LIBACCESS_PATH = "<Templates>  <SASLibrary>      <UsingPackages/>      <Properties/>  </SASLibrary>  <Directory>       <DeployedComponents/>  </Directory></Templates>";

    public BrowseLibraryPropertiesModel(SimpleBrowseObject lib) {
        super(lib);
    }

    @Override
    protected void initializePropertyIndexes() {
        this.m_iName = 0;
        this.m_iDescription = 1;
        this.m_iFolderLocation = 2;
        this.m_iCheckedOutBy = 3;
        this.m_iLibref = 4;
        this.m_iPath = 5;
        this.m_iServer = 6;
        this.m_iLibname = 7;
        this.m_iLastModifiedBy = 8;
        this.m_iDateUpdated = 9;
        this.m_iDateCreated = 10;
        this.m_iDateArchived = 11;
        this.m_iArchiveName = 12;
        this.m_iLogicalType = 13;
        this.m_iMetadataID = 14;
        this.m_iUsageVersion = 15;
    }

    @Override
    public int getNumberOfProperties() {
        return 16;
    }

    @Override
    protected String getPopulateTemplate() {
        if (s_strTemplate == null) {
            StringBuffer template = new StringBuffer();
            template.append("<DeployedDataPackage><DeployedComponents/></DeployedDataPackage>");
            s_strTemplate = template.toString();
        }
        return super.getPopulateTemplate() + s_strTemplate;
    }

    @Override
    protected List getPopulateAttributes() {
        if (s_lAttributes == null) {
            s_lAttributes = new ArrayList();
            s_lAttributes.addAll(super.getPopulateAttributes());
            s_lAttributes.add("DeployedComponents");
            s_lAttributes.add("Properties");
            s_lAttributes.add("UsingPackages");
        }
        return s_lAttributes;
    }

    @Override
    protected void initializeProperties() {
        super.initializeProperties();
        this.setProperty(this.m_iLibref, bundle.getString("LibraryPropertiesModel.Libref.txt"), null, BrowseLibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iPath, bundle.getString("LibraryPropertiesModel.Path.txt"), null, BrowseLibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iServer, bundle.getString("LibraryPropertiesModel.Server.txt"), null, BrowseLibraryPropertiesModel.getDefaultRenderer());
        this.setProperty(this.m_iLibname, bundle.getString("LibraryPropertiesModel.Libname.txt"), null, BrowseLibraryPropertiesModel.getDefaultRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadPropertyValues() throws MdException, RemoteException, ServiceException, LogicalTypeException {
        super.loadPropertyValues();
        BrowseMetadataInterface browseLibrary = this.m_browseObject.getBrowseObject();
        String strLibRef = BrowseObjectUtil.generateLibRef(browseLibrary);
        List paths = BrowseObjectUtil.getLibraryPaths(browseLibrary);
        ArrayList<String> deplCompNames = new ArrayList<String>();
        List deplComp = (List)browseLibrary.get("DeployedComponents");
        if (deplComp != null) {
            for (BrowseMetadataInterface object : deplComp) {
                deplCompNames.add(object.getName());
            }
        }
        this.m_aTempValues[this.m_iLibref] = strLibRef;
        this.m_aTempValues[this.m_iPath] = this.createCommaDelimitedString(paths);
        this.m_aTempValues[this.m_iServer] = this.createCommaDelimitedString(deplCompNames);
        MdObjectStore myStore = Workspace.getMdFactory().createObjectStore(null, "BrowseLibraryProperties::getAccessPath");
        String accessPath = "";
        try {
            MdObjectStoreImpl currentStore = (MdObjectStoreImpl)myStore;
            currentStore.getOwningStore().removeMdStoreListener((MdStoreListener)currentStore);
            currentStore.getOwningStore().removeChildStore((MdStore)currentStore);
            SASLibrary library = (SASLibrary)ObjectConverter.getInstance().convertToJOMAObject(myStore, (SimpleObject)this.m_browseObject, TEMPLATE_LIBACCESS_PATH);
            accessPath = LibraryUtil.getAccessPath((SASLibrary)library, (String)strLibRef, (boolean)true, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().error((Object)e.getLocalizedMessage(), (Throwable)e);
            accessPath = bundle.getString("LibraryPropertiesModel.AccessPathInvalid.txt");
        }
        finally {
            myStore.dispose();
        }
        this.m_aTempValues[this.m_iLibname] = accessPath;
    }
}

