/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.Section;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionUpdateListener;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionUpdatedEvent;
import java.util.ArrayList;
import java.util.List;

public class SectionsInfo {
    private static final int NORMAL_LINE = 0;
    private static final int SECTION_START = 1;
    private static final int IN_COLLAPSE = 2;
    private List<Section> sections;
    private int lineCount;
    private int[] flags;
    private List<SectionUpdateListener> sectionlisteners = new ArrayList<SectionUpdateListener>();

    public void setTopSections(List<Section> sections, int count) {
        this.lineCount = count;
        this.sections = sections;
        this.flags = null;
        if (this.lineCount > 0) {
            this.flags = new int[this.lineCount];
            this.updateSectionStartLine(this.sections);
            for (Section item : this.sections) {
                this.updateFlags(item);
            }
        }
        this.fireSectionChanged();
    }

    public List<Section> getTopSections() {
        return this.sections;
    }

    public int[] getTopLevelLines(int firstVisibleLine, int count) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int lineIndex = firstVisibleLine; lineIndex < this.lineCount; ++lineIndex) {
            if (!this.isLineInCollpase(lineIndex)) {
                --count;
                list.add(lineIndex);
            }
            if (count == 0) break;
        }
        return this.copyToArray(list);
    }

    public int[] getTopLevelLines() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int lineIndex = 0; lineIndex < this.lineCount; ++lineIndex) {
            if (this.isLineInCollpase(lineIndex)) continue;
            list.add(lineIndex);
        }
        return this.copyToArray(list);
    }

    private int[] copyToArray(ArrayList<Integer> list) {
        int[] result = new int[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = list.get(i);
        }
        return result;
    }

    public int getViewLineNumber(int startLine) {
        int line = startLine;
        for (int i = 0; i < startLine; ++i) {
            if (!this.isLineInCollpase(i)) continue;
            --line;
        }
        return line;
    }

    private Section findSectionByID(List<Section> sectionList, int sectionid) {
        if (sectionList == null) {
            return null;
        }
        Section section = null;
        for (Section item : sectionList) {
            if (item.id == sectionid) {
                section = item;
                break;
            }
            section = this.findSectionByID(item.subSection, sectionid);
            if (section == null) continue;
            break;
        }
        return section;
    }

    private Section findSectionByStartLine(List<Section> sectionList, int startLine) {
        if (sectionList == null) {
            return null;
        }
        Section section = null;
        for (Section item : sectionList) {
            if (item.startLine == startLine) {
                section = item;
                break;
            }
            section = this.findSectionByStartLine(item.subSection, startLine);
            if (section == null) continue;
            break;
        }
        return section;
    }

    public boolean setSectionCollapse(int sectionid, boolean isCollapse) {
        Section section = this.findSectionByID(this.sections, sectionid);
        return this.setSectionCollapse(section, isCollapse);
    }

    public boolean setSectionCollapse(Section section, boolean isCollapse) {
        if (section != null) {
            section.isCollapse = isCollapse;
            this.updateFlags(section);
            this.fireSectionUpdated(new SectionUpdatedEvent(section));
            return true;
        }
        return false;
    }

    public boolean changeSectionCollapse(int sectionid) {
        Section section = this.findSectionByID(this.sections, sectionid);
        return this.setSectionCollapse(section, !section.isCollapse);
    }

    private void updateSectionStartLine(List<Section> subsecs) {
        if (subsecs == null || subsecs.size() == 0) {
            return;
        }
        for (Section item : subsecs) {
            if (item.startLine > this.flags.length) {
                return;
            }
            this.flags[item.startLine] = 1;
            this.updateSectionStartLine(item.subSection);
        }
    }

    private void updateFlags(Section section) {
        block4: {
            block3: {
                this.flags[section.startLine] = 1;
                if (!section.isCollapse) break block3;
                for (int i = section.startLine + 1; i <= section.endLine; ++i) {
                    this.flags[i] = 2;
                }
                break block4;
            }
            for (int i = section.startLine + 1; i <= section.endLine; ++i) {
                this.flags[i] = 0;
            }
            List<Section> ss = section.subSection;
            if (ss == null) break block4;
            for (Section item : ss) {
                this.updateFlags(item);
            }
        }
    }

    private void fireSectionUpdated(SectionUpdatedEvent event) {
        for (SectionUpdateListener listener : this.sectionlisteners) {
            listener.sectionUpdated(event);
        }
    }

    private void fireSectionChanged() {
        for (SectionUpdateListener listener : this.sectionlisteners) {
            listener.sectionChanged();
        }
    }

    public void addSectionUpdatedListener(SectionUpdateListener listener) {
        this.sectionlisteners.add(listener);
    }

    public void removeSectionUpdatedListener(SectionUpdateListener listener) {
        this.sectionlisteners.remove(listener);
    }

    public boolean isLineInCollpase(int line) {
        if (this.flags == null || line >= this.flags.length || line < 0) {
            return false;
        }
        return this.flags[line] == 2;
    }

    public int getNextTopLevelLine(int startLine, int jumps) {
        int nextLine = startLine + jumps;
        if (nextLine != 0 && nextLine < this.lineCount && this.isLineInCollpase(nextLine)) {
            nextLine = this.getPreviousTopLevelLine(nextLine, jumps);
        }
        return nextLine;
    }

    public int getPreviousTopLevelLine(int startLine, int jumps) {
        int previousLine = startLine - jumps;
        if (previousLine != 0 && this.isLineInCollpase(previousLine)) {
            previousLine = this.getPreviousTopLevelLine(previousLine, jumps);
        }
        return previousLine;
    }

    public boolean isSectionStartLine(int lineIndex) {
        if (lineIndex >= this.flags.length) {
            return false;
        }
        return this.flags[lineIndex] == 1;
    }

    public boolean isSectionCollapsed(int startLine) {
        Section item = this.findSectionByStartLine(this.sections, startLine);
        if (item != null) {
            return item.isCollapse;
        }
        return false;
    }

    public int getVisableLineCount(Section section) {
        int count = 0;
        if (section != null) {
            if (section.isCollapse) {
                count = 1;
            } else {
                count = section.endLine - section.startLine + 1;
                if (section.subSection != null) {
                    for (Section item : section.subSection) {
                        count -= this.getUnvisableLineCount(item);
                    }
                }
            }
        }
        return count;
    }

    public int getUnvisableLineCount(Section section) {
        int count = 0;
        if (section != null && section.isCollapse) {
            count = section.endLine - section.startLine;
        }
        return count;
    }

    public int getFirstTopLevelLine() {
        int lineIndex = 0;
        while (this.isLineInCollpase(lineIndex)) {
            ++lineIndex;
        }
        return lineIndex;
    }

    public int getTopLevelLineCount() {
        int count = this.lineCount;
        for (int i = 0; i < this.lineCount; ++i) {
            if (!this.isLineInCollpase(i)) continue;
            --count;
        }
        return count;
    }

    public int getNthTopLevelLine(int count) {
        int lineIndex;
        for (lineIndex = this.getFirstTopLevelLine(); lineIndex < this.lineCount; ++lineIndex) {
            if (!this.isLineInCollpase(lineIndex)) {
                --count;
            }
            if (count == 0) break;
        }
        return lineIndex;
    }

    public void expand(int changeLine) {
    }

    public int getLastTopLevelLine() {
        int lineIndex = 0;
        if (this.lineCount != 0) {
            lineIndex = this.lineCount - 1;
            while (this.isLineInCollpase(lineIndex)) {
                --lineIndex;
            }
        }
        return lineIndex;
    }
}

