/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.CompletionInfoProvider;
import com.sas.wadmin.visuals.common.enhancededitor.DecoratorProvider;
import com.sas.wadmin.visuals.common.enhancededitor.IEnhancedEditorKit;
import com.sas.wadmin.visuals.common.enhancededitor.Lexer;
import com.sas.wadmin.visuals.common.enhancededitor.ParseData;
import com.sas.wadmin.visuals.common.enhancededitor.Parser;
import com.sas.wadmin.visuals.common.enhancededitor.Render;
import com.sas.wadmin.visuals.common.enhancededitor.RenderProvider;
import com.sas.wadmin.visuals.common.enhancededitor.SectionsParser;
import com.sas.wadmin.visuals.common.enhancededitor.Token;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedCompletionInfoProvider;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDecoratorProvider;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorView;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedRender;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedSectionsParser;
import com.sas.wadmin.visuals.common.enhancededitor.impl.ErrorInfo;
import com.sas.wadmin.visuals.common.enhancededitor.impl.WarningInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class EnhancedEditorKit
extends DefaultEditorKit
implements ViewFactory,
IEnhancedEditorKit {
    @Override
    public Document createDefaultDocument() {
        return new EnhancedDocument(this.createLexer(), this.createSectionParser(), this.createParser(), this.createCompletionInfoProvider());
    }

    @Override
    public Lexer createLexer() {
        return new Lexer(){

            @Override
            public void parse(Segment segment, int ofst, List<Token> tokens) {
            }
        };
    }

    @Override
    public RenderProvider createRenderProvider() {
        return new RenderProvider(){

            @Override
            public Render getRenderByToken(Token token) {
                return new EnhancedRender();
            }
        };
    }

    @Override
    public DecoratorProvider createDecoratorProvider() {
        return new EnhancedDecoratorProvider();
    }

    @Override
    public SectionsParser createSectionParser() {
        return new EnhancedSectionsParser();
    }

    @Override
    public Parser createParser() {
        return new Parser(){

            @Override
            public List<ParseData> parse(List<Token> tokens) {
                ArrayList<ParseData> info = new ArrayList<ParseData>();
                if (!tokens.isEmpty()) {
                    Token t;
                    int i;
                    int size = tokens.size();
                    int errorCount = size / 15;
                    int warningCount = size / 20;
                    Random rand = new Random(System.currentTimeMillis());
                    for (i = 0; i < errorCount; ++i) {
                        t = tokens.get(Math.abs(rand.nextInt()) % size);
                        info.add(new ErrorInfo(t.startIndex, t.lineIndex));
                    }
                    for (i = 0; i < warningCount; ++i) {
                        t = tokens.get(Math.abs(rand.nextInt()) % size);
                        info.add(new WarningInfo(t.startIndex, t.lineIndex));
                    }
                }
                return info;
            }
        };
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new EnhancedEditorView(element, this.createRenderProvider(), this.createDecoratorProvider());
    }

    @Override
    public CompletionInfoProvider createCompletionInfoProvider() {
        return new EnhancedCompletionInfoProvider();
    }
}

