/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.impl;

import com.sas.wadmin.visuals.common.enhancededitor.CompletionInfoProvider;
import com.sas.wadmin.visuals.common.enhancededitor.Lexer;
import com.sas.wadmin.visuals.common.enhancededitor.ParseData;
import com.sas.wadmin.visuals.common.enhancededitor.Parser;
import com.sas.wadmin.visuals.common.enhancededitor.Section;
import com.sas.wadmin.visuals.common.enhancededitor.SectionsParser;
import com.sas.wadmin.visuals.common.enhancededitor.Token;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorDocumentEvent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorUndoManager;
import com.sas.wadmin.visuals.common.enhancededitor.impl.ParseResultInfo;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionsInfo;
import com.sas.wadmin.visuals.common.enhancededitor.impl.TokenMapInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;

public class EnhancedDocument
extends PlainDocument {
    private EnhancedEditorUndoManager m_UndoManager = new EnhancedEditorUndoManager();
    private Lexer lexer;
    private List<Token> tokens;
    private TokenMapInfo tokenMapInfo;
    private Parser parser;
    private ParseResultInfo parseData;
    private SectionsParser sectionsParser;
    private SectionsInfo sectionsInfo;
    private CompletionInfoProvider compInfoProvider;

    public EnhancedDocument(Lexer lexer, SectionsParser sectionsParser, Parser parser, CompletionInfoProvider compInfoProvider) {
        this.lexer = lexer;
        this.sectionsParser = sectionsParser;
        this.sectionsParser.setDocument(this);
        this.parser = parser;
        this.compInfoProvider = compInfoProvider;
        this.sectionsInfo = new SectionsInfo();
        this.tokenMapInfo = new TokenMapInfo();
        this.parseData = new ParseResultInfo();
    }

    private void lex() {
        ArrayList<Token> toks = new ArrayList<Token>(this.getLength() / 10);
        try {
            Segment seg = new Segment();
            this.getText(0, this.getLength(), seg);
            this.lexer.parse(seg, 0, toks);
            this.tokenMapInfo.setTokens(toks);
        }
        catch (BadLocationException badLocationException) {
        }
        finally {
            this.tokens = toks;
        }
    }

    private void parse() {
        if (this.parser != null) {
            List<ParseData> infos = this.parser.parse(this.tokens);
            this.parseData.setParseData(infos);
        }
    }

    private void parseSections() {
        ArrayList<Section> tl = new ArrayList<Section>();
        this.sectionsParser.parseSections(this.tokens, tl);
        this.sectionsInfo.setTopSections(tl, this.getDefaultRootElement().getElementCount());
    }

    private final void addEdit(DocumentEvent e) {
        EnhancedEditorUndoManager undoManager = this.getUndoManager();
        if (undoManager != null && e instanceof UndoableEdit) {
            EnhancedEditorDocumentEvent event = new EnhancedEditorDocumentEvent(e);
            undoManager.addEdit(event);
        }
    }

    public EnhancedEditorUndoManager getUndoManager() {
        return this.m_UndoManager;
    }

    @Override
    protected void fireChangedUpdate(DocumentEvent e) {
        this.addEdit(e);
        this.updateSyntax();
        super.fireChangedUpdate(e);
    }

    @Override
    protected void fireInsertUpdate(DocumentEvent e) {
        this.addEdit(e);
        this.updateSyntax();
        super.fireInsertUpdate(e);
    }

    @Override
    protected void fireRemoveUpdate(DocumentEvent e) {
        this.addEdit(e);
        this.updateSyntax();
        super.fireRemoveUpdate(e);
    }

    private void updateSyntax() {
        this.lex();
        this.parseSections();
        this.parse();
    }

    public Iterator<Token> getTokens(int start, int end) {
        return new TokenIterator(start, end);
    }

    public ParseResultInfo getParseData() {
        return this.parseData;
    }

    public SectionsInfo getSectionsInfo() {
        return this.sectionsInfo;
    }

    public TokenMapInfo getTokenMapInfo() {
        return this.tokenMapInfo;
    }

    public CompletionInfoProvider getInfoProvider() {
        return this.compInfoProvider;
    }

    public boolean ParserExist() {
        return this.parser != null;
    }

    class TokenIterator
    implements ListIterator<Token> {
        int start;
        int end;
        int ndx = 0;

        private TokenIterator(int start, int end) {
            this.start = start;
            this.end = end;
            if (EnhancedDocument.this.tokens != null && !EnhancedDocument.this.tokens.isEmpty()) {
                while (this.ndx < EnhancedDocument.this.tokens.size() && ((Token)EnhancedDocument.this.tokens.get(this.ndx)).end() < start) {
                    ++this.ndx;
                }
            }
        }

        @Override
        public boolean hasNext() {
            if (EnhancedDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx >= EnhancedDocument.this.tokens.size()) {
                return false;
            }
            Token t = (Token)EnhancedDocument.this.tokens.get(this.ndx);
            return t.startIndex < this.end;
        }

        @Override
        public Token next() {
            return (Token)EnhancedDocument.this.tokens.get(this.ndx++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasPrevious() {
            if (EnhancedDocument.this.tokens == null) {
                return false;
            }
            if (this.ndx <= 0) {
                return false;
            }
            Token t = (Token)EnhancedDocument.this.tokens.get(this.ndx);
            return t.end() > this.start;
        }

        @Override
        public Token previous() {
            return (Token)EnhancedDocument.this.tokens.get(this.ndx--);
        }

        @Override
        public int nextIndex() {
            return this.ndx + 1;
        }

        @Override
        public int previousIndex() {
            return this.ndx - 1;
        }

        @Override
        public void set(Token e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Token e) {
            throw new UnsupportedOperationException();
        }
    }
}

