/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.component.MarkerComponent;
import com.sas.wadmin.visuals.common.enhancededitor.component.RowHeaderComponent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.SectionUpdatedEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;

public abstract class RowMarkerComponent
extends RowHeaderComponent {
    protected List<Component> markers;

    public RowMarkerComponent() {
        this.setLayout(null);
        this.markers = new ArrayList<Component>();
    }

    @Override
    protected void setPreferredWidth() {
        int width = 18;
        Insets insets = this.getInsets();
        int preferredWidth = insets.left + insets.right + width;
        Dimension d = this.getPreferredSize();
        d.setSize(preferredWidth, 20);
        this.setPreferredSize(d);
        this.setSize(d);
    }

    @Override
    protected void updateComponent() {
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        Insets insets = this.getInsets();
        int lh = fontMetrics.getHeight();
        int width = this.getWidth() - insets.left - insets.right;
        int height = lh - 2;
        this.removeAll();
        this.markers.clear();
        this.createMarkers(this.markers);
        for (Component item : this.markers) {
            item.setSize(width, height);
            this.add(item);
        }
        this.updateMarkerLocation();
    }

    protected int getRowHeight() {
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        int lh = fontMetrics.getHeight();
        return lh;
    }

    protected abstract void createMarkers(List<Component> var1);

    protected void updateMarkerLocation() {
        FontMetrics fontMetrics = this.editor.getFontMetrics(this.editor.getFont());
        int lh = fontMetrics.getHeight();
        for (Component cpt : this.markers) {
            MarkerComponent mc = (MarkerComponent)((Object)cpt);
            if (this.sectionsInfo.isLineInCollpase(mc.getLineIndex())) {
                cpt.setVisible(false);
                continue;
            }
            cpt.setVisible(true);
            cpt.setLocation(cpt.getLocation().x, this.sectionsInfo.getViewLineNumber(mc.getLineIndex()) * lh + 3);
        }
    }

    @Override
    public void sectionUpdated(SectionUpdatedEvent event) {
        this.repaint();
        this.updateMarkerLocation();
        this.editor.repaint();
    }
}

