/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.component;

import com.sas.wadmin.visuals.common.enhancededitor.component.EnhancedEditorComponent;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedDocument;
import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class EhancedComponent
extends JPanel
implements DocumentListener,
PropertyChangeListener,
EnhancedEditorComponent {
    protected JEditorPane editor;
    protected EnhancedDocument doc;

    @Override
    public void install(JEditorPane editor) {
        this.editor = editor;
        this.setFont(editor.getFont());
        this.editor.addPropertyChangeListener(this);
        this.installDocument(editor.getDocument());
    }

    protected void installDocument(Document doc) {
        if (doc instanceof EnhancedDocument) {
            this.doc = (EnhancedDocument)doc;
        }
        doc.addDocumentListener(this);
    }

    protected void deinstallDocument(Document doc) {
        doc.removeDocumentListener(this);
    }

    @Override
    public void deinstall() {
        this.editor.removePropertyChangeListener(this);
        this.doc.removeDocumentListener(this);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.documentChanged();
    }

    protected void documentChanged() {
    }

    protected void setPreferredWidth() {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            if (evt.getOldValue() instanceof EnhancedDocument) {
                this.deinstallDocument((EnhancedDocument)evt.getOldValue());
            }
            if (evt.getNewValue() instanceof EnhancedDocument) {
                EnhancedDocument doc = (EnhancedDocument)evt.getNewValue();
                this.installDocument(doc);
            }
        } else if (evt.getNewValue() instanceof Font) {
            this.setPreferredWidth();
            this.repaint();
        }
    }
}

