/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.actions.gui;

import com.sas.wadmin.visuals.common.enhancededitor.actions.gui.EnhancedEditorDialog;
import com.sas.wadmin.visuals.common.enhancededitor.impl.FindHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class FindReplaceDialog
extends EnhancedEditorDialog {
    private JLabel infoLabel;
    private JTextField findField;
    private JTextField replaceField;
    private JButton btnFindNext;
    private JButton btnReplace;
    private JButton btnReplaceFind;
    private JButton btnCancle;
    private JCheckBox cbCaseSensitive;
    private JCheckBox cbWholeWord;
    private JRadioButton rbtnForward;
    private JRadioButton rbtnBackward;

    public FindReplaceDialog() {
        this.setTitle("Find Replace");
        this.initWidget();
        this.layoutWidget();
    }

    private void initWidget() {
        this.infoLabel = new JLabel();
        this.findField = new JTextField();
        this.findField.setEditable(true);
        this.replaceField = new JTextField();
        this.replaceField.setEditable(true);
        this.btnFindNext = new JButton(new FindNextAction());
        this.btnReplace = new JButton(new ReplaceAction());
        this.btnReplaceFind = new JButton(new ReplaceAllAction());
        this.btnCancle = new JButton(new CancleAction());
        this.cbCaseSensitive = new JCheckBox("Case Sensitive");
        this.cbWholeWord = new JCheckBox("Whole Word");
        ButtonGroup directionGrp = new ButtonGroup();
        this.rbtnBackward = new JRadioButton("Backward");
        this.rbtnForward = new JRadioButton("Forward");
        this.rbtnForward.setSelected(true);
        directionGrp.add(this.rbtnBackward);
        directionGrp.add(this.rbtnForward);
    }

    private void layoutWidget() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new GridLayout(0, 1));
        JPanel fieldsPanel = new JPanel();
        fieldsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 1, 1);
        fieldsPanel.add((Component)new JLabel("Find:"), c);
        c.gridy = 1;
        fieldsPanel.add((Component)new JLabel("Replace:"), c);
        c.gridx = 1;
        c.gridwidth = 3;
        c.fill = 2;
        c.gridy = 0;
        fieldsPanel.add((Component)this.findField, c);
        c.gridy = 1;
        fieldsPanel.add((Component)this.replaceField, c);
        contentPanel.add(fieldsPanel);
        JPanel directionPanel = new JPanel(new GridLayout(0, 1));
        directionPanel.setBorder(BorderFactory.createTitledBorder("Direction"));
        directionPanel.add(this.rbtnForward);
        directionPanel.add(this.rbtnBackward);
        contentPanel.add(directionPanel);
        JPanel optionsPanel = new JPanel(new GridLayout(0, 1));
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Options"));
        optionsPanel.add(this.cbCaseSensitive);
        optionsPanel.add(this.cbWholeWord);
        contentPanel.add(optionsPanel);
        contentPanel.add(this.infoLabel);
        JPanel btnsPanel = new JPanel();
        btnsPanel.setLayout(new GridLayout(2, 2));
        btnsPanel.add(this.btnFindNext);
        btnsPanel.add(this.btnReplace);
        btnsPanel.add(this.btnReplaceFind);
        btnsPanel.add(this.btnCancle);
        this.setLayout(new BorderLayout());
        this.add((Component)contentPanel, "Center");
        this.add((Component)btnsPanel, "South");
    }

    public void cancle() {
        this.setVisible(false);
    }

    private FindHelper getHelper() {
        FindHelper helper = this.pane.getFindHelper();
        helper.setFindString(this.findField.getText());
        helper.setReplaceString(this.replaceField.getText());
        helper.setCaseSensitive(this.cbCaseSensitive.isSelected());
        helper.setForward(this.rbtnForward.isSelected());
        helper.setWholeWord(this.cbWholeWord.isSelected());
        return helper;
    }

    private class FindNextAction
    extends AbstractAction {
        public FindNextAction() {
            super("FindNext");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FindReplaceDialog.this.getHelper().findNext()) {
                FindReplaceDialog.this.infoLabel.setText("Not found");
            } else {
                FindReplaceDialog.this.infoLabel.setText("");
            }
        }
    }

    private class ReplaceAction
    extends AbstractAction {
        public ReplaceAction() {
            super("Replace");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!FindReplaceDialog.this.getHelper().replace()) {
                FindReplaceDialog.this.infoLabel.setText("Not found");
            } else {
                FindReplaceDialog.this.infoLabel.setText("");
            }
        }
    }

    private class ReplaceAllAction
    extends AbstractAction {
        public ReplaceAllAction() {
            super("ReplaceAll");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.getHelper().replaceAll();
        }
    }

    private class CancleAction
    extends AbstractAction {
        public CancleAction() {
            super("Cancle");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FindReplaceDialog.this.cancle();
        }
    }
}

