/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common.enhancededitor.actions;

import com.sas.wadmin.visuals.common.enhancededitor.actions.EnhancedAction;
import com.sas.wadmin.visuals.common.enhancededitor.impl.EnhancedEditorPane;
import java.awt.Dimension;
import java.awt.Point;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.text.Caret;

public class ActionUtils {
    public static HashMap<String, String> ActionsList = new HashMap();

    public static Point getCaretPoint(EnhancedEditorPane pane) {
        Caret caret = pane.getCaret();
        Point cp = caret.getMagicCaretPosition();
        Point pp = pane.getLocationOnScreen();
        cp.x += pp.x;
        cp.y += pp.y;
        return cp;
    }

    public static void calulatePostionToPane(EnhancedEditorPane pane, JDialog dialog) {
        Point p = pane.getLocationOnScreen();
        Dimension size = pane.getSize();
        p.x += size.width / 2;
        p.y += size.height / 2 - dialog.getWidth() / 2;
        dialog.setLocation(p);
    }

    public static void addActions(EnhancedEditorPane editorPane) {
        InputMap imap = new InputMap();
        imap.setParent(editorPane.getInputMap());
        ActionMap amap = new ActionMap();
        amap.setParent(editorPane.getActionMap());
        Iterator<String> iterator = ActionsList.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            String actionName = key = iterator.next();
            String actionClass = ActionsList.get(key);
            EnhancedAction action = ActionUtils.createAction(actionClass);
            action.setEnhancedEditorPane(editorPane);
            amap.put(actionName, action);
            String keyStrokeString = action.getKeyStrokeString();
            KeyStroke ks = KeyStroke.getKeyStroke(keyStrokeString);
            if (ks == null) {
                throw new IllegalArgumentException("Invalid KeyStroke: " + keyStrokeString);
            }
            action.putValue("AcceleratorKey", ks);
            imap.put(ks, actionName);
        }
        editorPane.setActionMap(amap);
        editorPane.setInputMap(0, imap);
    }

    private static EnhancedAction createAction(String actionClassName) {
        EnhancedAction action = null;
        try {
            Class<?> clazz = Class.forName(actionClassName);
            action = (EnhancedAction)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName + ". Ensure it has default constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        return action;
    }

    static {
        ActionsList.put("GotoAction", "com.sas.wadmin.visuals.common.enhancededitor.actions.GotoLineAction");
        ActionsList.put("RedoAction", "com.sas.wadmin.visuals.common.enhancededitor.actions.RedoAction");
        ActionsList.put("UndoAction", "com.sas.wadmin.visuals.common.enhancededitor.actions.UndoAction");
    }
}

