/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.editor.LogListHolder;
import com.sas.etl.models.IModel;
import com.sas.etl.models.data.ILibrary;
import com.sas.etl.models.data.dbmstypes.IDBMSType;
import com.sas.etl.models.impl.BaseModel;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.other.IProperty;
import com.sas.iom.SAS.ILanguageServicePackage.LineType;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.rio.MVAResultSet;
import com.sas.wadmin.visuals.common.UserDefinedFunctionsXMLModel;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsMessagesPropertyTab;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.SASLogDialog;
import com.sas.workspace.visuals.expression.BaseCategory;
import com.sas.workspace.visuals.expression.BaseFunction;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.Function;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import java.awt.Frame;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class UserDefinedFunctionsModel {
    private static final String USER_DEFINED_HELP_FILE = "UserDefinedHelp";
    private static final String CATEGORIES = "Categories";
    private static final String CATEGORY = "Category";
    private static final String NAME = "Name";
    private static final String DISPLAYNAME = "DisplayName";
    private IModel m_model;
    private ILibrary m_oLibrary;
    private String m_sContainer;
    private WsAppServer m_defaultServer;
    private WsAppServer m_libServer;
    private LogListHolder m_logLinesHolder;
    private WsMessagesPropertyTab msgWindow = WsMessagesPropertyTab.getInstance();
    private int m_udfsImported;
    private static WAdminResource bundle = WAdminResource.getBundle(UserDefinedFunctionsModel.class);

    public ILibrary getLibrary() {
        return this.m_oLibrary;
    }

    public int getNumberOfUDFsImported() {
        return this.m_udfsImported;
    }

    public void dispose() {
        this.m_model.dispose();
        this.m_defaultServer.dispose();
        if (this.m_defaultServer != this.m_libServer) {
            this.m_libServer.dispose();
        }
        this.m_libServer = null;
        this.m_defaultServer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importFunctionSets(boolean bNative, List typesSelected) {
        List<UserDefinedFunction> sets;
        block42: {
            sets = new ArrayList();
            this.m_udfsImported = 0;
            if (!this.m_oLibrary.getDBMSType().isNativeFunctionSetsSupported() && !this.m_oLibrary.getDBMSType().isModelManagerFunctionSetsSupported()) {
                return false;
            }
            try {
                MVAResultSet rsltSet2;
                if (this.m_libServer == null) {
                    this.addLogLine(bundle.getString("UserDefinedFunctionModel.Error.InvalidLibrary.txt"), 6, "ERROR:");
                    return false;
                }
                if (!this.m_libServer.isOpen()) {
                    this.m_libServer.open();
                }
                if (bNative) {
                    try {
                        rsltSet2 = this.m_libServer.submitSQLStatement(this.m_oLibrary.getDBMSType().getNativeFunctionSetsQuery(this.m_oLibrary, this.isQuotesNeeded()).toString());
                        if (rsltSet2 != null) {
                            sets = this.m_oLibrary.getDBMSType().createNativeFunctionsFromQueryResults(rsltSet2);
                        }
                    }
                    catch (WsAppServerFailException rsltSet2) {
                    }
                    catch (SQLException rsltSet2) {
                        // empty catch block
                    }
                }
                if (typesSelected.size() <= 0) break block42;
                try {
                    rsltSet2 = this.m_libServer.submitSQLStatement(this.m_oLibrary.getDBMSType().getModelManagerFunctionSetsQuery(this.m_oLibrary, this.isQuotesNeeded(), typesSelected).toString());
                    if (rsltSet2 != null) {
                        UserDefinedFunction func;
                        StringBuffer sbAlgor;
                        StringBuffer sbSpecificName;
                        String sDescription;
                        String name = null;
                        String signature = null;
                        String model_name = null;
                        String model_function = null;
                        String mining_algorithm = null;
                        String oldName = null;
                        String sStartDescription = bundle.getString("UserDefinedFunctionModel.ImportUserDefinedFunctionsDescription.txt");
                        while (rsltSet2.next()) {
                            name = rsltSet2.getString(2).trim();
                            if (!name.equals(oldName) && oldName != null) {
                                sDescription = sStartDescription;
                                sbSpecificName = new StringBuffer();
                                if (model_function != null) {
                                    sbSpecificName.append("<o:p></o:p></span></p>");
                                    sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                                    sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                                    sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("UserDefinedFunctionModel.modelFunction.txt")).append("<o:p></o:p></span></b></h2>");
                                    sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                                    sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                                    sbSpecificName.append("   Arial'>").append(model_function).append("<o:p></o:p></span></p>");
                                    sDescription = sDescription + sbSpecificName;
                                }
                                sbAlgor = new StringBuffer();
                                if (mining_algorithm != null) {
                                    sbAlgor.append("<o:p></o:p></span></p>");
                                    sbAlgor.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                                    sbAlgor.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                                    sbAlgor.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("UserDefinedFunctionModel.miningAlgorithm.txt")).append("<o:p></o:p></span></b></h2>");
                                    sbAlgor.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                                    sbAlgor.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                                    sbAlgor.append("   Arial'>").append(mining_algorithm).append("<o:p></o:p></span></p>");
                                    sDescription = sDescription + sbAlgor;
                                }
                                func = new UserDefinedFunction(oldName, signature, sDescription, signature);
                                sets.add(func);
                                signature = null;
                                model_name = null;
                                model_function = null;
                                mining_algorithm = null;
                            }
                            model_name = rsltSet2.getString(1).trim();
                            signature = rsltSet2.getString(3).trim();
                            model_function = rsltSet2.getString(4).trim();
                            mining_algorithm = rsltSet2.getString(5).trim();
                            oldName = name;
                        }
                        rsltSet2.close();
                        if (name.equals(oldName) && oldName != null) {
                            sDescription = sStartDescription;
                            sbSpecificName = new StringBuffer();
                            if (model_function != null) {
                                sbSpecificName.append("<o:p></o:p></span></p>");
                                sbSpecificName.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                                sbSpecificName.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                                sbSpecificName.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("UserDefinedFunctionModel.modelFunction.txt")).append("<o:p></o:p></span></b></h2>");
                                sbSpecificName.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                                sbSpecificName.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                                sbSpecificName.append("   Arial'>").append(model_function).append("<o:p></o:p></span></p>");
                                sDescription = sDescription + sbSpecificName;
                            }
                            sbAlgor = new StringBuffer();
                            if (mining_algorithm != null) {
                                sbAlgor.append("<o:p></o:p></span></p>");
                                sbAlgor.append("<h2 style='margin-top:12.0pt;margin-right:0in;margin-bottom:3.0pt;margin-left:");
                                sbAlgor.append(".25in;page-break-after:avoid;tab-stops:.25in .5in .75in'><b><span");
                                sbAlgor.append("style='mso-bidi-font-family:Arial'>").append(bundle.getString("UserDefinedFunctionModel.miningAlgorithm.txt")).append("<o:p></o:p></span></b></h2>");
                                sbAlgor.append("<p class=MsoNormal style='margin-top:0in;margin-right:0in;margin-bottom:6.0pt;");
                                sbAlgor.append("   margin-left:.25in;tab-stops:.25in .5in .75in'><span style='mso-bidi-font-family:");
                                sbAlgor.append("   Arial'>").append(mining_algorithm).append("<o:p></o:p></span></p>");
                                sDescription = sDescription + sbAlgor;
                            }
                            func = new UserDefinedFunction(oldName, signature, sDescription, signature);
                            sets.add(func);
                        }
                    }
                }
                catch (WsAppServerFailException rsltSet3) {
                }
                catch (SQLException rsltSet3) {}
            }
            catch (WsAppServerFailException exc) {
                exc.printStackTrace();
                return false;
            }
        }
        if (sets != null) {
            if (sets.size() == 0) {
                this.addLogLine(bundle.formatString("UserDefinedFunctionModel.Information.NoSetsToImport.txt", (Object)this.m_oLibrary.getName()), 7, "WARNING:");
                MessageUtil.displayMessage((String)bundle.formatString("UserDefinedFunctionModel.Information.NoSetsToImport.txt", (Object)this.m_oLibrary.getName()), (int)2, (int)-1);
                return false;
            }
            try {
                UserDefinedFunctionsXMLModel model = new UserDefinedFunctionsXMLModel();
                String sFileName = System.getProperty("UserDefinedFunctionsPath");
                if (sFileName == null) {
                    Workspace.getWorkspace();
                    sFileName = Workspace.getAppDataFilePath((String)"UserDefinedFunctions.xml");
                }
                try {
                    FileInputStream strmInput = new FileInputStream(sFileName);
                    model.loadXML(strmInput);
                }
                catch (FileNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                Category category = model.findCategory(this.getContainer());
                if (category == null) {
                    category = new BaseCategory(this.getContainer(), this.getContainer());
                } else {
                    int response = MessageUtil.displayMessage((String)bundle.getString("UserDefinedFunctionModel.Warning.ReplaceCategoryandFunctions.txt"), (int)2, (int)2);
                    if (response != 0) {
                        return false;
                    }
                    category.clearAllFunctions();
                }
                for (int iSet = 0; iSet < sets.size(); ++iSet) {
                    ++this.m_udfsImported;
                    UserDefinedFunction func = (UserDefinedFunction)sets.get(iSet);
                    BaseFunction function = new BaseFunction(category, func.getName(), func.getDisplayName(), func.getDescription(), func.getInsertString(), func.getInsertString(), USER_DEFINED_HELP_FILE);
                    category.addFunction((Function)function);
                }
                model.addNewCategory(category);
                try (FileOutputStream strmOutput = new FileOutputStream(sFileName);){
                    model.saveXML(strmOutput);
                }
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            try {
                this.addLogLines(this.m_libServer.getLog());
            }
            catch (WsAppServerFailException ex) {
                ex.printStackTrace();
            }
        } else {
            MessageUtil.displayMessage((String)bundle.formatString("UserDefinedFunctionModel.Information.NoSetsToImport.txt", (Object)this.m_oLibrary.getName()), (int)2, (int)-1);
        }
        return true;
    }

    public List previewFunctionSets(boolean bNative, List typesSelected) {
        List<UserDefinedFunction> sets;
        block16: {
            sets = new ArrayList();
            if (!this.m_oLibrary.getDBMSType().isNativeFunctionSetsSupported() && !this.m_oLibrary.getDBMSType().isModelManagerFunctionSetsSupported()) {
                return null;
            }
            try {
                MVAResultSet rsltSet2;
                if (!this.m_libServer.isOpen()) {
                    this.m_libServer.open();
                }
                if (bNative) {
                    try {
                        rsltSet2 = this.m_libServer.submitSQLStatement(this.m_oLibrary.getDBMSType().getNativeFunctionSetsQuery(this.m_oLibrary, this.isQuotesNeeded()).toString());
                        if (rsltSet2 != null) {
                            sets = this.m_oLibrary.getDBMSType().createNativeFunctionsFromQueryResults(rsltSet2);
                        }
                    }
                    catch (WsAppServerFailException rsltSet2) {
                    }
                    catch (SQLException rsltSet2) {
                        // empty catch block
                    }
                }
                if (typesSelected.size() <= 0) break block16;
                try {
                    rsltSet2 = this.m_libServer.submitSQLStatement(this.m_oLibrary.getDBMSType().getModelManagerFunctionSetsQuery(this.m_oLibrary, this.isQuotesNeeded(), typesSelected).toString());
                    if (rsltSet2 != null) {
                        UserDefinedFunction func;
                        String name = null;
                        String signature = null;
                        String oldName = null;
                        String sDescription = bundle.getString("UserDefinedFunctionModel.ImportUserDefinedFunctionsDescription.txt");
                        while (rsltSet2.next()) {
                            name = rsltSet2.getString(2).trim();
                            if (!name.equals(oldName) && oldName != null) {
                                func = new UserDefinedFunction(oldName, signature, sDescription, oldName);
                                sets.add(func);
                                signature = null;
                            }
                            signature = rsltSet2.getString(3).trim();
                            oldName = name;
                        }
                        rsltSet2.close();
                        if (name.equals(oldName) && oldName != null) {
                            func = new UserDefinedFunction(oldName, signature, sDescription, oldName);
                            sets.add(func);
                        }
                    }
                }
                catch (WsAppServerFailException rsltSet3) {
                }
                catch (SQLException rsltSet3) {}
            }
            catch (WsAppServerFailException exc) {
                exc.printStackTrace();
            }
        }
        return sets;
    }

    public List getFunctionSetTypes() {
        ArrayList<String> types = new ArrayList<String>();
        if (this.m_oLibrary.getDBMSType().isNativeFunctionSetsSupported()) {
            types.add(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"));
        }
        try {
            MVAResultSet rsltSet;
            if (this.m_libServer == null || !this.m_oLibrary.getDBMSType().isModelManagerFunctionSetsSupported()) {
                return types;
            }
            if (!this.m_libServer.isOpen()) {
                this.m_libServer.open();
            }
            if ((rsltSet = this.m_libServer.submitSQLStatement(this.m_oLibrary.getDBMSType().getModelManagerProjectsQuery(this.m_oLibrary, this.isQuotesNeeded()).toString())) != null) {
                while (rsltSet.next()) {
                    types.add(rsltSet.getString(1).trim() + "(" + rsltSet.getString(2).trim() + ")");
                }
                rsltSet.close();
            }
        }
        catch (WsAppServerFailException wsAppServerFailException) {
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return types;
    }

    public void showSASLog(String sMessage) {
        int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)1, (int)0);
        if (eAnswer == 0) {
            SASLogDialog dlg = new SASLogDialog((Frame)Workspace.getWorkspace(), bundle.getString("UserDefinedFunctionsModel.LogTitle.txt"), true, this.m_logLinesHolder);
            dlg.show();
        }
    }

    public LogListHolder getLogLinesHolder() {
        return this.m_logLinesHolder;
    }

    protected void clearLog() {
        this.m_logLinesHolder = new LogListHolder(new String[0], new Integer[0]);
    }

    private StringBuffer getBufferFromLogLines() {
        StringBuffer log = new StringBuffer();
        if (this.m_logLinesHolder != null) {
            String[] lines = this.m_logLinesHolder.getLineArray();
            for (int i = 0; i < lines.length; ++i) {
                log.append(lines[i]);
            }
        }
        return log;
    }

    protected void addLogLine(String line, int type, String label) {
        this.addLogLine(line, new Integer(type), label);
    }

    protected void addLogLine(String line, Integer type, String label) {
        ArrayList<LineType> lstLineTypes;
        String[] lines = null;
        LineType[] lineTypes = null;
        if (this.m_logLinesHolder != null) {
            lines = this.m_logLinesHolder.getLineArray();
            lineTypes = this.m_logLinesHolder.getLineTypes();
        }
        ArrayList<String> lstLines = lines != null ? new ArrayList<String>(Arrays.asList(lines)) : new ArrayList();
        ArrayList<Object> arrayList = lstLineTypes = lineTypes != null ? new ArrayList<LineType>(Arrays.asList(lineTypes)) : new ArrayList();
        if (label != null && label.length() > 0) {
            line = label + " " + line;
        }
        lstLines.add(line);
        lstLineTypes.add((LineType)type);
        String[] arrayLines = lstLines.toArray(new String[lstLines.size()]);
        Integer[] arrayTypes = new Integer[lstLineTypes.size()];
        for (int i = 0; i < lstLineTypes.size(); ++i) {
            Object value = lstLineTypes.get(i);
            arrayTypes[i] = value instanceof Integer ? (Integer)lstLineTypes.get(i) : new Integer(((LineType)lstLineTypes.get(i)).value());
        }
        this.m_logLinesHolder = new LogListHolder(arrayLines, arrayTypes);
        this.msgWindow.addMessage(line);
    }

    protected void addLogLines(LogListHolder logHolder) {
        int i;
        StringBuffer logBuffer = new StringBuffer();
        LineType[] logTypes = logHolder.getLineTypes();
        String[] logLines = logHolder.getLineArray();
        for (i = 0; i < logLines.length; ++i) {
            logBuffer.append(logLines[i]).append("\n");
        }
        for (i = 0; i < logLines.length; ++i) {
            this.addLogLine(logLines[i], new Integer(logTypes[i].value()), "");
        }
        Workspace.getDefaultLogger().error((Object)logBuffer.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLibrary(SimpleObject oLibrary) throws MdException, WsAppServerCodeException, WsAppServerFailException, WsAppServerLibraryException, RemoteException {
        if (this.m_model == null) {
            this.m_model = new BaseModel();
            this.m_model.setModelEventsEnabled(false);
        }
        OMRAdapter omr = new OMRAdapter(this.m_model, Workspace.getMdFactory(), "SQLSetOperatorsListPanel.loadTable");
        SASLibrary mdoLibrary = null;
        try {
            if (oLibrary == null) {
                return;
            }
            mdoLibrary = (SASLibrary)omr.acquireOMRObject(oLibrary.getID(), "SASLibrary");
            this.m_oLibrary = (ILibrary)omr.acquireObjectUsingTemplate((Root)mdoLibrary);
            this.m_oLibrary.loadFromOMR(omr);
            IDBMSType iDBMSType = this.m_oLibrary.getDBMSType();
            if (this.m_defaultServer == null) {
                this.m_defaultServer = WsAppServer.createDefaultAppServer((boolean)true);
            }
            this.m_libServer = LibraryUtil.interactiveAccessPath((SASLibrary)mdoLibrary, (WsAppServer)this.m_defaultServer, (String)"");
            this.clearLog();
        }
        finally {
            omr.dispose();
        }
    }

    public String getContainer() {
        return this.m_sContainer;
    }

    public void setContainer(String container) {
        if (container.equals(this.m_sContainer)) {
            return;
        }
        this.m_sContainer = container;
    }

    public boolean isQuotesNeeded() {
        List libOptions = this.m_oLibrary.getOptionsList();
        boolean quoteCol = false;
        boolean quoteTable = false;
        for (int iOption = 0; iOption < libOptions.size(); ++iOption) {
            IProperty option = (IProperty)libOptions.get(iOption);
            if (option.getPropertyName().equals("PRESERVE_COL_NAMES")) {
                quoteCol = true;
            }
            if (!option.getPropertyName().equals("PRESERVE_TAB_NAMES")) continue;
            quoteTable = true;
        }
        return quoteTable || quoteCol;
    }
}

