/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class UniqueKeyColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(UniqueKeyColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 11;
    private static final int HIDDEN_COLUMNS = 1;
    public static final int NAME_COLUMN = 0;
    public static final int DESCRIPTION_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int LENGTH_COLUMN = 3;
    public static final int INFORMAT_COLUMN = 4;
    public static final int FORMAT_COLUMN = 5;
    public static final int IS_NULLABLE_COLUMN = 6;
    public static final int SUMMARY_ROLE_COLUMN = 7;
    public static final int SORT_ORDER_COLUMN = 8;
    public static final int BEGIN_POSITION_COLUMN = 9;
    public static final int END_POSITION_COLUMN = 10;
    private static final int NAME_WIDTH = 100;
    private static final int DESCRIPTION_WIDTH = 110;
    private static final int TYPE_WIDTH = 75;
    private static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    private static final int IS_NULLABLE_WIDTH = 100;
    private static final int SUMMARY_ROLE_WIDTH = 100;
    private static final int SORT_ORDER_WIDTH = 100;
    private static final int BEGIN_POSITION_WIDTH = 50;
    private static final int END_POSITION_WIDTH = 50;
    private IKey m_key;
    private boolean m_bOverlapAllowed;
    private IModelListener m_lsnrModel;

    public UniqueKeyColumnsTableModel(IKey key) {
        this.m_key = key;
        this.m_lsnrModel = this.createModelListener();
        this.m_key.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_key.getModel().removeModelListener(this.m_lsnrModel);
    }

    public IModelListener createModelListener() {
        return new ModelListener();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        String[] saRoles = ColumnUIUtilities.getViewSummaryRoles();
        String[] saSorts = ColumnUIUtilities.getViewSortOrders();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("UniqueKeyColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("UniqueKeyColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsEnumeratedTableColumn(2, bundle.getString("UniqueKeyColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[3] = new LengthTableColumn();
        this.m_aColumns[4] = new InformatTableColumn();
        this.m_aColumns[5] = new FormatTableColumn();
        this.m_aColumns[6] = new WsBooleanTableColumn(6, bundle.getString("UniqueKeyColumnsTableModel.IsNullable.txt"), 100);
        this.m_aColumns[7] = new WsEnumeratedTableColumn(7, bundle.getString("UniqueKeyColumnsTableModel.SummaryRole.txt"), 100, saRoles);
        this.m_aColumns[8] = new WsEnumeratedTableColumn(8, bundle.getString("UniqueKeyColumnsTableModel.SortOrder.txt"), 100, saSorts);
        this.m_aColumns[9] = new BeginPositionTableColumn();
        this.m_aColumns[10] = new EndPositionTableColumn();
        this.m_aColumns[this.getColumnCount()] = new WsObjectTableColumn();
        this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
    }

    public void setOverlappingColumnsAllowed(boolean bOverlapAllowed) {
        this.m_bOverlapAllowed = bOverlapAllowed;
    }

    public boolean isOverlappingColumnsAllowed() {
        return this.m_bOverlapAllowed;
    }

    public int getColumnCount() {
        return 11;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object value, int iRow, int iColumn) {
        IColumn col = this.getColumnForRow(iRow);
        if (iColumn == 0) {
            col.setName((String)value);
        } else if (iColumn == 1) {
            col.setDescription((String)value);
        } else if (iColumn == 2) {
            col.setType(ColumnUIUtilities.getModelType((String)value));
        } else if (iColumn == 3) {
            col.setLength(((Integer)value).intValue());
        } else if (iColumn == 4) {
            col.setInformat(ColumnUIUtilities.getModelInformat((String)value));
        } else if (iColumn == 5) {
            col.setFormat(ColumnUIUtilities.getModelFormat((String)value));
        } else if (iColumn == 6) {
            col.setNullable(((Boolean)value).booleanValue());
        } else if (iColumn == 7) {
            col.setSummaryRole(ColumnUIUtilities.getModelSummaryRole((String)value));
        } else if (iColumn == 8) {
            col.setSortOrder(ColumnUIUtilities.getModelSortOrder((String)value));
        } else if (iColumn == 9) {
            this.m_key.getModel().startCompoundUndoable();
            try {
                col.setBeginPosition(((Integer)value).intValue());
            }
            finally {
                this.m_key.getModel().endCompoundUndoable();
            }
        } else if (iColumn == 10) {
            this.m_key.getModel().startCompoundUndoable();
            try {
                col.setEndPosition(((Integer)value).intValue());
            }
            finally {
                this.m_key.getModel().endCompoundUndoable();
            }
        } else {
            super.setValueAt(value, iRow, iColumn);
        }
    }

    public void moveDataToModel() {
        this.clear();
        IColumn[] aColumns = this.m_key.getColumns();
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            this.m_lData.add(this.createRowValues(aColumns[iColumn]));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    private List createRowValues(IColumn col) {
        ArrayList lValues = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
        this.addVisibleValues(col, lValues);
        this.addHiddenValues(col, lValues);
        return lValues;
    }

    protected void addVisibleValues(IColumn col, List lValues) {
        lValues.add(col.getName());
        lValues.add(col.getDescription());
        lValues.add(ColumnUIUtilities.getViewType(col.getType()));
        lValues.add(new Integer(col.getLength()));
        lValues.add(ColumnUIUtilities.getViewInformat(col.getInformat()));
        lValues.add(ColumnUIUtilities.getViewFormat(col.getFormat()));
        lValues.add(col.isNullable());
        lValues.add(ColumnUIUtilities.getViewSummaryRole(col.getSummaryRole()));
        lValues.add(ColumnUIUtilities.getViewSortOrder(col.getSortOrder()));
        lValues.add(new Integer(col.getBeginPosition()));
        lValues.add(new Integer(col.getEndPosition()));
    }

    protected void addHiddenValues(IColumn col, List lValues) {
        lValues.add(col);
    }

    public IKey getTable() {
        return this.m_key;
    }

    public int getRowIndex(String sColumnID) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (!this.getColumnForRow(iRow).getID().equals(sColumnID)) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getColumnForRow(iRow) != col) continue;
            return iRow;
        }
        return -1;
    }

    public IColumn getColumnForRow(int iRow) {
        return (IColumn)this.getValueAt(iRow, this.getColumnCount());
    }

    private int getBeginPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 9);
    }

    private int getEndPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 10);
    }

    public String createUniqueNameForNewColumn() {
        return (String)this.m_aColumns[0].createDefaultValue();
    }

    private void addColumn(IColumn col) {
        int iRow = this.m_key.getColumnsList().indexOf(col);
        this.insertRow(iRow - 1, this.createRowValues(col));
    }

    private void removeColumn(IColumn col) {
        this.deleteRow(this.getRowIndex(col));
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                UniqueKeyColumnsTableModel.this.moveDataToModel();
            } else if (obj == UniqueKeyColumnsTableModel.this.m_key) {
                if (sType == "Key:ColumnAdded") {
                    UniqueKeyColumnsTableModel.this.addColumn((IColumn)ev.getData());
                } else if (sType == "Key:ColumnRemoved") {
                    UniqueKeyColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                }
            } else if (obj instanceof IColumn) {
                IColumn col = (IColumn)obj;
                int iRowIndex = UniqueKeyColumnsTableModel.this.getRowIndex(col);
                if (iRowIndex == -1) {
                    return;
                }
                if (sType == "Object:NameChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(col.getName(), iRowIndex, 0);
                } else if (sType == "Object:DescriptionChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(col.getDescription(), iRowIndex, 1);
                } else if (sType == "Column:LengthChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(new Integer(col.getLength()), iRowIndex, 3);
                } else if (sType == "Column:TypeChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewType(col.getType()), iRowIndex, 2);
                    UniqueKeyColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                } else if (sType == "Column:InformatChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewInformat(col.getInformat()), iRowIndex, 4);
                } else if (sType == "Column:FormatChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewFormat(col.getFormat()), iRowIndex, 5);
                } else if (sType == "Column:NullableChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(col.isNullable(), iRowIndex, 6);
                } else if (sType == "Column:SummaryRoleChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewSummaryRole(col.getSummaryRole()), iRowIndex, 7);
                } else if (sType == "Column:SortOrderChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewSortOrder(col.getSortOrder()), iRowIndex, 8);
                } else if (sType == "Column:BeginPositionChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(new Integer(col.getBeginPosition()), iRowIndex, 9);
                } else if (sType == "Column:EndPositionChanged") {
                    UniqueKeyColumnsTableModel.super.setValueAt(new Integer(col.getEndPosition()), iRowIndex, 10);
                } else if (sType == "Object:NoteAdded" || sType == "Object:NoteRemoved" || sType == "Object:DocumentAdded" || sType == "Object:DocumentRemoved" || sType == "Object:ExtendedAttributeAdded" || sType == "Object:ExtendedAttributeRemoved") {
                    UniqueKeyColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                }
            }
        }
    }

    private class LengthTableColumn
    extends WsIntegerTableColumn {
        public LengthTableColumn() {
            super(3, bundle.getString("UniqueKeyColumnsTableModel.Length.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (oValue.equals(this.getMissingValue())) {
                return true;
            }
            int iValue = (Integer)oValue;
            int eType = UniqueKeyColumnsTableModel.this.getColumnForRow(iRow).getType();
            if (eType == 1) {
                if (iValue < 3 || iValue > 8) {
                    String sMessage = bundle.getString("ColumnsTableModel.Error.NumericInvalidLength.txt");
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                return true;
            }
            if (eType == 0 && (iValue < 1 || iValue > Short.MAX_VALUE)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.CharacterInvalidLength.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class InformatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public InformatTableColumn() {
            super(4, bundle.getString("UniqueKeyColumnsTableModel.Informat.txt"), 75);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = UniqueKeyColumnsTableModel.this.getColumnForRow(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    private class FormatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public FormatTableColumn() {
            super(5, bundle.getString("UniqueKeyColumnsTableModel.Format.txt"), 75);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = UniqueKeyColumnsTableModel.this.getColumnForRow(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    private class BeginPositionTableColumn
    extends WsIntegerTableColumn {
        public BeginPositionTableColumn() {
            super(9, bundle.getString("UniqueKeyColumnsTableModel.BeginPosition.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (UniqueKeyColumnsTableModel.this.m_bOverlapAllowed) {
                return true;
            }
            int begin = (Integer)oValue;
            if (iRow != 0 && begin <= UniqueKeyColumnsTableModel.this.getEndPosition(iRow - 1)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin < 1) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionLessThan1.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin > UniqueKeyColumnsTableModel.this.getEndPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class EndPositionTableColumn
    extends WsIntegerTableColumn {
        public EndPositionTableColumn() {
            super(10, bundle.getString("UniqueKeyColumnsTableModel.EndPosition.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (UniqueKeyColumnsTableModel.this.m_bOverlapAllowed) {
                return true;
            }
            int end = (Integer)oValue;
            if (end < UniqueKeyColumnsTableModel.this.getBeginPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.EndPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (iRow < UniqueKeyColumnsTableModel.this.getRowCount() - 1 && end >= UniqueKeyColumnsTableModel.this.getBeginPosition(iRow + 1)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.EndPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = UniqueKeyColumnsTableModel.this.getColumnForRow(iRow);
            this.setIcon(ColumnUIUtilities.getTypeIcon(col));
            return this;
        }
    }
}

