/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.IWorkTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IDataTransform;
import com.sas.etl.models.job.ITransformTableOptions;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.visuals.common.OptionsCollectionPane;
import com.sas.wadmin.visuals.common.TransformTableOptionComparator;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class TransformTableOptionsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(TransformTableOptionsTab.class);
    private IDataTransform m_transform;
    private OptionsCollectionPane m_optionsPane;
    private WAComboBox m_cbTables;
    private boolean m_bShowRequiredCheckbox = true;
    private IModelListener m_modelListener;

    public TransformTableOptionsTab(IDataTransform model, String sHelpMapID, boolean bShowRequiredCheckbox, String sName) {
        this(model, sHelpMapID, bShowRequiredCheckbox);
        this.setName(sName);
    }

    public TransformTableOptionsTab(IDataTransform model, String sHelpMapID, boolean bShowRequiredCheckbox) {
        this.m_transform = model;
        this.m_bShowRequiredCheckbox = bShowRequiredCheckbox;
        this.m_modelListener = new cModelListener();
        this.m_transform.getModel().addModelListener(this.m_modelListener);
        this.initialize();
        this.setName(bundle.getString("TransformTableOptionsTab.Name.txt"));
    }

    protected void initialize() {
        this.m_cbTables = new WAComboBox();
        this.m_cbTables.setEditable(false);
        this.m_cbTables.setSorted(true);
        this.m_cbTables.setSortComparator((Comparator)new TransformTableOptionComparator());
        this.m_cbTables.setToolTipText(bundle.getString("TransformTableOptionsTab.Tables.tip"));
        this.m_cbTables.setRenderer((ListCellRenderer)new cTableOptionsListCellRenderer());
        this.m_cbTables.addItemListener((ItemListener)new cShowTableOptions());
        this.m_optionsPane = new OptionsCollectionPane(this.m_bShowRequiredCheckbox);
        this.listenForDataChangesTo(this.m_optionsPane);
        this.m_optionsPane.setWAUndoManager(this.getWAUndoManager());
        this.loadTables();
        Dimension prefSize = this.getPreferredSize();
        JLabel lblTables = WsUIUtilities.createLabelForComponent((JComponent)this.m_cbTables, (String)bundle.getString("TransformTableOptionsTab.Tables.txt"));
        lblTables.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.setLayout(new GridBagLayout());
        this.add(lblTables, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)this.m_cbTables, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_optionsPane), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.setPreferredSize(prefSize);
    }

    private void loadTables() {
        Object selectedItem = this.m_cbTables.getSelectedItem();
        this.m_cbTables.removeAllItems();
        this.m_cbTables.addItems((Object[])this.m_transform.getTableOptionObjects());
        if (this.m_cbTables.getIndexOf(selectedItem) > -1) {
            this.m_cbTables.setSelectedItem(selectedItem);
        } else if (this.m_cbTables.getItemCount() > 0) {
            this.m_cbTables.setSelectedIndex(0);
        }
        this.m_cbTables.setMinimumSize(this.m_cbTables.getPreferredSize());
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_optionsPane.setEditable(editable);
    }

    public void setHelpTopic(String helpid) {
        super.setHelpTopic(helpid);
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_optionsPane.moveDataToStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.loadTables();
        this.m_optionsPane.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void saveSettingsAndCleanUp() {
        this.m_transform.getModel().removeModelListener(this.m_modelListener);
        super.saveSettingsAndCleanUp();
        this.m_optionsPane.saveSettingsAndCleanUp();
    }

    public String getHelpTopic() {
        String help = null;
        if (this.m_optionsPane != null) {
            help = this.m_optionsPane.getHelpTopic();
            ITransformTableOptions dataSetOptions = (ITransformTableOptions)this.m_cbTables.getSelectedItem();
            if (dataSetOptions != null) {
                help = help + (dataSetOptions.isAccessTypeInput() ? "_input" : "_output");
            }
        }
        return help;
    }

    public boolean validateData() {
        return true;
    }

    protected void setPromptPanel() {
        ITransformTableOptions dataSetOptions = (ITransformTableOptions)this.m_cbTables.getSelectedItem();
        this.m_optionsPane.setPromptModel(dataSetOptions != null ? dataSetOptions.getOptionModel() : null);
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String type = ev.getType();
            if (ev.getModelObject() == TransformTableOptionsTab.this.m_transform && ("DataTransform.TransformTableOptionAddded".equals(type) || "DataTransform.TransformTableOptionRemoved".equals(type))) {
                TransformTableOptionsTab.this.loadTables();
            }
        }
    }

    private class cTableOptionsListCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            label.setIcon(null);
            label.setText("");
            if (value instanceof ITransformTableOptions) {
                ITransformTableOptions option = (ITransformTableOptions)value;
                IPhysicalTable table = option.getOptionTable();
                Icon icon = null;
                if (table != null) {
                    icon = table instanceof IWorkTable ? AppIconFactory.getAppInstance().getIconForPrivateType("Type:WorkTable", 16) : AppIconFactory.getAppInstance().getIconForSimpleObject((SimpleObject)table, 16);
                }
                label.setIcon(icon);
                label.setText(table != null ? table.getName() + " (" + option.getDisplayName() + ")" : "");
            }
            return label;
        }
    }

    private class cShowTableOptions
    implements ItemListener {
        private cShowTableOptions() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            TransformTableOptionsTab.this.setPromptPanel();
        }
    }
}

