/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class SaveAsDialog
extends WAStandardDialog {
    private static final WAdminResource bundle = WAdminResource.getBundle(SaveAsDialog.class);
    public static final String DEFAULT_FILE_NAME = "sourcecode.sas";
    public static final String DEFAULT_METADATA_NAME = bundle.getString("SaveAsDialog.MetadataNameDefault.txt");
    public static final String DEFAULT_METADATA_DESC = bundle.getString("SaveAsDialog.MetadataDescriptionDefault.txt");
    private ButtonGroup m_bgpTypes;
    private JRadioButton m_rbnMetadata;
    private JRadioButton m_rbnFile;
    private WsAbstractToggleAction m_actMetadata;
    private WsAbstractToggleAction m_actFile;
    private JLabel m_lblMetadataName;
    private WATextField m_txtMetadataName;
    private JLabel m_lblMetadataDescription;
    private WATextArea m_txaMetadataDescription;
    private JScrollPane m_scrMetadataDescription;
    private WsAppServerPanel m_pnlExecutionHosts;
    private JLabel m_lblFileLocation;
    private WATextField m_txtFileLocation;
    private JLabel m_lblFileName;
    private WATextField m_txtFileName;
    private JButton m_btnBrowse;
    private WsAbstractAction m_actBrowse;
    private WAPanel m_pnlSaveAs = new cSaveAsPanel();
    private WAPanel m_pnlMetadata;
    private WAPanel m_pnlFile;
    private String m_sDefaultFileName;
    private String m_sDefaultMetadataName;
    private String m_sDefaultMetadataDesc;

    public SaveAsDialog(Frame frmParent) {
        super(frmParent, bundle.getString("SaveAsDialog.Name.txt"), true);
        this.setMainPanel(this.m_pnlSaveAs);
        this.m_sDefaultFileName = DEFAULT_FILE_NAME;
        this.m_sDefaultMetadataName = DEFAULT_METADATA_NAME;
        this.m_sDefaultMetadataDesc = DEFAULT_METADATA_DESC;
    }

    public void show() {
        this.m_pnlMain = this.m_pnlSaveAs;
        super.show();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.getMainPanel().moveDataToView();
    }

    public void setDefaultFileName(String defaultName) {
        this.m_sDefaultFileName = defaultName;
    }

    public void setDefaultMetadataName(String defaultName) {
        this.m_sDefaultMetadataName = defaultName;
    }

    public void setDefaultMetadataDesc(String defaultDesc) {
        this.m_sDefaultMetadataDesc = defaultDesc;
    }

    public WAPanel getSaveAsPanel() {
        return this.m_pnlSaveAs;
    }

    public boolean isSaveAsMetadata() {
        return this.m_rbnMetadata.isSelected();
    }

    public void setSaveAsMetadata(boolean saveAsMetadata) {
        if (saveAsMetadata) {
            this.m_rbnMetadata.setSelected(true);
        } else {
            this.m_rbnFile.setSelected(true);
        }
        this.updatePanels();
    }

    private void updatePanels() {
        this.m_pnlMetadata.setEditable(this.isEditable() && this.m_rbnMetadata.isSelected());
        this.m_pnlFile.setEditable(this.isEditable() && this.m_rbnFile.isSelected());
    }

    public String getMetadataName() {
        return this.m_txtMetadataName.getText().trim();
    }

    public void setMetadataName(String name) {
        this.m_txtMetadataName.setText(name);
    }

    public String getMetadataDescription() {
        return this.m_txaMetadataDescription.getText();
    }

    public void setMetadataDescription(String description) {
        this.m_txaMetadataDescription.setText(description);
    }

    public WsAppServer getFileServer() {
        WsAppServer server = this.m_pnlExecutionHosts.getAppServer();
        if (server != null) {
            return server;
        }
        return WsAppServer.createDefaultAppServer();
    }

    public void setFileServer(String serverId) {
        this.m_pnlExecutionHosts.setSelectedServerFQID(serverId);
        try {
            this.m_pnlExecutionHosts.populateStore();
            this.m_pnlExecutionHosts.moveDataToView();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public String getFileLocation() {
        return this.m_txtFileLocation.getText().trim();
    }

    public void setFileLocation(String location) {
        this.m_txtFileLocation.setText(location);
    }

    public String getFileName() {
        return this.m_txtFileName.getText().trim();
    }

    public void setFileName(String fileName) {
        this.m_txtFileName.setText(fileName);
    }

    public String getStatusText() throws RemoteException, MdException {
        if (this.m_rbnMetadata.isSelected()) {
            return bundle.formatString("SaveAsDialog.MetadataStatusLabel.fmt", (Object)this.getMetadataName());
        }
        return bundle.formatString("SaveAsDialog.FileStatusLabel.fmt", (Object)this.getFileServer().getServerName(), (Object)this.getFileName());
    }

    protected WsAbstractAction createBrowseAction() {
        return new cBrowseAction();
    }

    protected WsAbstractToggleAction createMetadataAction() {
        return new cMetadataAction();
    }

    protected WsAbstractToggleAction createFileAction() {
        return new cFileAction();
    }

    private class cSaveAsPanel
    extends WAPanel {
        public cSaveAsPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            SaveAsDialog.this.m_actMetadata = SaveAsDialog.this.createMetadataAction();
            SaveAsDialog.this.m_actFile = SaveAsDialog.this.createFileAction();
            SaveAsDialog.this.m_rbnMetadata = WsUIUtilities.createRadioButton((WsAbstractToggleAction)SaveAsDialog.this.m_actMetadata);
            SaveAsDialog.this.m_rbnFile = WsUIUtilities.createRadioButton((WsAbstractToggleAction)SaveAsDialog.this.m_actFile);
            SaveAsDialog.this.m_bgpTypes = new ButtonGroup();
            SaveAsDialog.this.m_bgpTypes.add(SaveAsDialog.this.m_rbnMetadata);
            SaveAsDialog.this.m_bgpTypes.add(SaveAsDialog.this.m_rbnFile);
            SaveAsDialog.this.m_pnlMetadata = new cMetadataPanel();
            SaveAsDialog.this.m_pnlFile = new cFilePanel();
            SaveAsDialog.this.m_actMetadata.setSelected(true);
            this.setHelpProduct("wdb");
            this.setHelpTopic("save_as_win");
            SaveAsDialog.this.updatePanels();
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(SaveAsDialog.this.m_rbnMetadata, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)SaveAsDialog.this.m_pnlMetadata, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 5, 5, 0), 0, 0));
            this.add(SaveAsDialog.this.m_rbnFile, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add((Component)SaveAsDialog.this.m_pnlFile, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 0, 0), 0, 0));
        }

        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            super.populateStore();
            SaveAsDialog.this.m_pnlMetadata.populateStore();
            SaveAsDialog.this.m_pnlFile.populateStore();
            this.setStorePopulated(true);
        }

        public void moveDataToView() throws MdException, RemoteException {
            this.setListeningForChanges(false);
            super.moveDataToView();
            SaveAsDialog.this.m_pnlMetadata.moveDataToView();
            SaveAsDialog.this.m_pnlFile.moveDataToView();
            this.setListeningForChanges(true);
        }

        public void moveDataToStore() throws MdException, RemoteException {
            if (this.hasDataChanged()) {
                return;
            }
            super.moveDataToStore();
            if (SaveAsDialog.this.m_rbnFile.isSelected()) {
                SaveAsDialog.this.m_pnlFile.moveDataToStore();
            } else {
                SaveAsDialog.this.m_pnlMetadata.moveDataToStore();
            }
            this.setDataChanged(false);
        }

        public boolean validateData() {
            if (SaveAsDialog.this.m_rbnFile.isSelected()) {
                return SaveAsDialog.this.m_pnlFile.validateData();
            }
            return SaveAsDialog.this.m_pnlMetadata.validateData();
        }
    }

    private class cBrowseAction
    extends WsAbstractAction {
        public cBrowseAction() {
            super(bundle, "SaveAsDialog.cBrowseAction", 256);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String fileLocation = SaveAsDialog.this.getFileServer().promptForDirectory("", "", null);
                if (fileLocation != null) {
                    SaveAsDialog.this.m_txtFileLocation.setText(fileLocation);
                }
            }
            catch (WsAppServerFailException we) {
                MessageUtil.displayMessage((String)we.getLocalizedMessage(), (int)0);
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class cMetadataAction
    extends WsAbstractToggleAction {
        public cMetadataAction() {
            super(bundle, "SaveAsDialog.MetadataLabel", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SaveAsDialog.this.updatePanels();
        }
    }

    private class cFileAction
    extends WsAbstractToggleAction {
        public cFileAction() {
            super(bundle, "SaveAsDialog.FileLabel", 256);
        }

        public void actionPerformed(ActionEvent e) {
            SaveAsDialog.this.updatePanels();
        }
    }

    private class cFilePanel
    extends WAPanel {
        public cFilePanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            SaveAsDialog.this.m_pnlExecutionHosts = new WsAppServerPanel(null, false);
            SaveAsDialog.this.m_pnlExecutionHosts.setUpdateDefault(false);
            SaveAsDialog.this.m_pnlExecutionHosts.setDisplayDefault(false);
            this.listenForDataChangesTo((WAPanel)SaveAsDialog.this.m_pnlExecutionHosts);
            SaveAsDialog.this.m_txtFileLocation = new WATextField();
            SaveAsDialog.this.m_lblFileLocation = WsUIUtilities.createLabelForComponent((JComponent)SaveAsDialog.this.m_txtFileLocation, (String)bundle.getString("SaveAsDialog.FileLocation.txt"));
            SaveAsDialog.this.m_txtFileName = new WATextField();
            SaveAsDialog.this.m_lblFileName = WsUIUtilities.createLabelForComponent((JComponent)SaveAsDialog.this.m_txtFileName, (String)bundle.getString("SaveAsDialog.FileName.txt"));
            SaveAsDialog.this.m_actBrowse = SaveAsDialog.this.createBrowseAction();
            SaveAsDialog.this.m_btnBrowse = WsUIUtilities.createTextButton((WsAbstractAction)SaveAsDialog.this.m_actBrowse);
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add((Component)SaveAsDialog.this.m_pnlExecutionHosts, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.add(SaveAsDialog.this.m_lblFileLocation, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 10), 0, 0));
            this.add((Component)SaveAsDialog.this.m_txtFileLocation, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 10), 0, 0));
            this.add(SaveAsDialog.this.m_btnBrowse, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
            this.add(SaveAsDialog.this.m_lblFileName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.add((Component)SaveAsDialog.this.m_txtFileName, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void populateStore() throws MdException, RemoteException {
            if (this.isStorePopulated()) {
                return;
            }
            SaveAsDialog.this.m_pnlExecutionHosts.populateStore();
            this.setStorePopulated(true);
        }

        public void moveDataToView() throws MdException, RemoteException {
            super.moveDataToView();
            if ("".equals(SaveAsDialog.this.m_txtFileName.getText())) {
                SaveAsDialog.this.m_txtFileName.setText(SaveAsDialog.this.m_sDefaultFileName != null && SaveAsDialog.this.m_sDefaultFileName.length() > 0 ? SaveAsDialog.this.m_sDefaultFileName : SaveAsDialog.DEFAULT_FILE_NAME);
            }
            SaveAsDialog.this.m_pnlExecutionHosts.moveDataToView();
        }

        public void moveDataToStore() throws MdException, RemoteException {
            super.moveDataToStore();
            SaveAsDialog.this.m_pnlExecutionHosts.moveDataToStore();
        }

        public void setEditable(boolean bEditable) {
            SaveAsDialog.this.m_pnlExecutionHosts.setEditable(bEditable);
            SaveAsDialog.this.m_txtFileLocation.setEditable(bEditable);
            SaveAsDialog.this.m_txtFileName.setEditable(bEditable);
            SaveAsDialog.this.m_actBrowse.setEnabled(bEditable);
        }

        public boolean validateData() {
            if (SaveAsDialog.this.getFileName().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("SaveAsDialog.Error.NoFileName.txt"), (int)0);
                return false;
            }
            if (SaveAsDialog.this.getFileLocation().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("SaveAsDialog.Error.NoFileLocation.txt"), (int)0);
                return false;
            }
            if (SaveAsDialog.this.getFileServer() == null) {
                MessageUtil.displayMessage((String)bundle.getString("SaveAsDialog.Error.NoAppServer.txt"), (int)0);
                return false;
            }
            try {
                if (!SaveAsDialog.this.getFileServer().doesFileExist(SaveAsDialog.this.getFileLocation())) {
                    MessageUtil.displayMessage((String)bundle.formatString("SaveAsDialog.Error.InvalidFileLocation.fmt", (Object)SaveAsDialog.this.getFileLocation()), (int)0);
                    return false;
                }
            }
            catch (WsAppServerFailException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                return false;
            }
            catch (GenericError ge) {
                MessageUtil.displayMessage((String)ge.getLocalizedMessage(), (int)0);
                return false;
            }
            return true;
        }
    }

    private class cMetadataPanel
    extends WAPanel {
        public cMetadataPanel() {
            this.initialize();
            this.layoutWidgets();
        }

        protected void initialize() {
            SaveAsDialog.this.m_txtMetadataName = new WATextField();
            SaveAsDialog.this.m_txtMetadataName.setMaxCharacters(60);
            SaveAsDialog.this.m_txaMetadataDescription = new WATextArea();
            SaveAsDialog.this.m_txaMetadataDescription.setMaxCharacters(200);
            SaveAsDialog.this.m_txaMetadataDescription.setLineWrap(true);
            SaveAsDialog.this.m_txaMetadataDescription.setWrapStyleWord(true);
            SaveAsDialog.this.m_txaMetadataDescription.setRows(5);
            SaveAsDialog.this.m_lblMetadataName = WsUIUtilities.createLabelForComponent((JComponent)SaveAsDialog.this.m_txtMetadataName, (String)bundle.getString("SaveAsDialog.MetadataName.txt"));
            SaveAsDialog.this.m_lblMetadataDescription = WsUIUtilities.createLabelForComponent((JComponent)SaveAsDialog.this.m_txaMetadataDescription, (String)bundle.getString("SaveAsDialog.MetadataDescription.txt"));
            SaveAsDialog.this.m_scrMetadataDescription = new JScrollPane((Component)SaveAsDialog.this.m_txaMetadataDescription, 20, 31);
            WsUIUtilities.adjustScrollPanePreferredSize((JScrollPane)SaveAsDialog.this.m_scrMetadataDescription);
        }

        public void moveDataToView() throws MdException, RemoteException {
            super.moveDataToView();
            if ("".equals(SaveAsDialog.this.m_txtMetadataName.getText())) {
                SaveAsDialog.this.m_txtMetadataName.setText(SaveAsDialog.this.m_sDefaultMetadataName != null && SaveAsDialog.this.m_sDefaultMetadataName.length() > 0 ? SaveAsDialog.this.m_sDefaultMetadataName : DEFAULT_METADATA_NAME);
            }
            if ("".equals(SaveAsDialog.this.m_txaMetadataDescription.getText())) {
                SaveAsDialog.this.m_txaMetadataDescription.setText(SaveAsDialog.this.m_sDefaultMetadataDesc != null && SaveAsDialog.this.m_sDefaultMetadataDesc.length() > 0 ? SaveAsDialog.this.m_sDefaultMetadataDesc : DEFAULT_METADATA_DESC);
            }
        }

        protected void layoutWidgets() {
            this.setLayout(new GridBagLayout());
            this.add(SaveAsDialog.this.m_lblMetadataName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.add((Component)SaveAsDialog.this.m_txtMetadataName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.add(SaveAsDialog.this.m_lblMetadataDescription, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 5), 0, 0));
            this.add(SaveAsDialog.this.m_scrMetadataDescription, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        public void setEditable(boolean bEditable) {
            SaveAsDialog.this.m_txtMetadataName.setEditable(bEditable);
            SaveAsDialog.this.m_txaMetadataDescription.setEnabled(bEditable);
        }

        public boolean validateData() {
            if (SaveAsDialog.this.getMetadataName().trim().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("SaveAsDialog.Error.NoMetadataName.txt"), (int)0);
                return false;
            }
            return true;
        }
    }
}

