/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.editor.CodeEditorPane;
import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IOMRPersistable;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.impl.OMRAdapter;
import com.sas.etl.models.job.ICodeGenerationEnvironment;
import com.sas.etl.models.job.ICodeGenerator;
import com.sas.etl.models.job.ICodeSegment;
import com.sas.etl.models.job.ICodeSource;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.job.IUserWrittenCodeContainer;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.etl.models.other.IServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.ServerContext;
import com.sas.wadmin.visuals.common.CodeGenerationController;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.wadmin.visuals.common.CodePane;
import com.sas.wadmin.visuals.common.ModelUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.visuals.WsAppServerPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.BadLocationException;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class ProcessTab
extends WAPropertyTab {
    private static WAdminResource bundle = WAdminResource.getBundle(ProcessTab.class);
    private static final int AUTOMATIC = 0;
    private static final int USER_WRITTEN_BODY = 1;
    private static final int USER_WRITTEN_ALL = 2;
    private static final String AUTOMATIC_NAME = bundle.getString("ProcessTab.CodeGeneration.Automatic.txt");
    private static final String USER_WRITTEN_BODY_NAME = bundle.getString("ProcessTab.CodeGeneration.UserWrittenBody.txt");
    private static final String USER_WRITTEN_ALL_NAME = bundle.getString("ProcessTab.CodeGeneration.UserWrittenAll.txt");
    private int m_iUserWrittenState;
    private JCheckBox m_ckbExcludeTransformation;
    private JPanel m_pnlCodeGeneration;
    private CodePane m_pnlCodePane;
    private WAComboBox m_cmbUserWrittenModes;
    private JLabel m_lblUserWrittenModes;
    private ActionListener m_lsrUserWrittenModes;
    private WsAppServerPanel m_pnlExecutionHosts;
    private JButton m_btnViewStepCode;
    private JButton m_btnScrollToEditableCode;
    private PropertyChangeListener m_lstnServerChange;
    private IModelListener m_lstnModelListener;
    protected WsAbstractAction m_actViewStepCode;
    protected WsAbstractAction m_actScrollToEditableCode;
    private int m_intHeaderLength;
    protected CodeGenerationController m_controller;
    private boolean m_bUserWrittenOnly;
    private boolean m_bDisplayAutomaticUW;
    private boolean m_bShowExcludeTransformation;
    private boolean m_bShowServerPanel;
    private boolean m_bIsChangingUserWrittenState = false;
    private boolean m_bDisposed = false;

    public ProcessTab(CodeGenerationController codeGenerator, boolean bShowExcludeTransformation, boolean bShowServerPanel) {
        this(codeGenerator, bShowExcludeTransformation, bShowServerPanel, false);
    }

    public ProcessTab(ICodeGenerator codeGenerator, boolean bShowExcludeTransformation, boolean bShowServerPanel) {
        this(new CodeGenerationController(codeGenerator), bShowExcludeTransformation, bShowServerPanel, false);
    }

    public ProcessTab(CodeGenerationController codeGenerator, boolean bShowExcludeTransformation, boolean bShowServerPanel, boolean bUserWrittenOnly) {
        this(codeGenerator, bShowExcludeTransformation, bShowServerPanel, bUserWrittenOnly, true);
    }

    public ProcessTab(ICodeGenerator codeGenerator, boolean bShowExcludeTransformation, boolean bShowServerPanel, boolean bUserWrittenOnly) {
        this(new CodeGenerationController(codeGenerator), bShowExcludeTransformation, bShowServerPanel, bUserWrittenOnly, true);
    }

    public ProcessTab(CodeGenerationController codeGenerator, boolean bShowExcludeTransformation, boolean bShowServerPanel, boolean bUserWrittenOnly, boolean bDisplayAutoUW) {
        this.setName(bundle.getString("ProcessTab.Name.txt"));
        this.m_controller = codeGenerator;
        this.m_bShowExcludeTransformation = bShowExcludeTransformation;
        this.m_bShowServerPanel = bShowServerPanel;
        this.m_bUserWrittenOnly = bUserWrittenOnly;
        this.m_bDisplayAutomaticUW = bDisplayAutoUW;
        this.createListeners();
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_ckbExcludeTransformation = WsUIUtilities.createCheckBox((WsAbstractToggleAction)this.createExcludeTransformationToggleAction());
        this.m_cmbUserWrittenModes = new WAComboBox();
        if (!this.m_bUserWrittenOnly) {
            this.m_cmbUserWrittenModes.addItem((Object)AUTOMATIC_NAME);
        }
        this.m_cmbUserWrittenModes.addItem((Object)USER_WRITTEN_BODY_NAME);
        this.m_cmbUserWrittenModes.addItem((Object)USER_WRITTEN_ALL_NAME);
        this.m_lblUserWrittenModes = WsUIUtilities.createLabelForComponent((JComponent)this.m_cmbUserWrittenModes, (String)bundle.getString("ProcessTab.CodeGeneration.txt"));
        this.m_lsrUserWrittenModes = new cUserWrittenModesListener();
        this.m_cmbUserWrittenModes.addActionListener(this.m_lsrUserWrittenModes);
        this.m_iUserWrittenState = this.m_controller.getCodeGenerator().isUsingUserWrittenCode() || this.m_bUserWrittenOnly ? (this.m_controller.getCodeGenerator().isGenerateDISHeaderAndFooters() ? 1 : 2) : 0;
        this.m_pnlCodeGeneration = new JPanel();
        this.m_pnlCodeGeneration.setBorder(WsUIUtilities.createTitledBorder((String)bundle.getString("ProcessTab.CodeGeneration.txt")));
        this.m_pnlCodePane = this.createCodePane();
        this.m_pnlCodePane.setBorder(BorderFactory.createEtchedBorder());
        this.listenForDataChangesTo(this.m_pnlCodePane.getEditor());
        this.listenForDataChangesTo((WAPanel)this.m_pnlCodePane);
        if (this.m_bDisplayAutomaticUW) {
            this.listenForDataChangesTo(this.m_ckbExcludeTransformation);
            this.listenForDataChangesTo((JComboBox)this.m_cmbUserWrittenModes);
        }
        this.m_pnlExecutionHosts = new WsAppServerPanel(null, false);
        this.m_pnlExecutionHosts.setUpdateDefault(false);
        this.m_pnlExecutionHosts.setDisplayDefault(true);
        this.m_pnlExecutionHosts.addPropertyChangeListener(this.m_lstnServerChange);
        this.listenForDataChangesTo((WAPanel)this.m_pnlExecutionHosts);
        this.m_actViewStepCode = this.createViewStepCodeAction();
        this.m_btnViewStepCode = new JButton((Action)this.m_actViewStepCode);
        this.m_actScrollToEditableCode = this.createScrollToEditableCodeAction();
        this.m_btnScrollToEditableCode = WsUIUtilities.createFlatTextIconButton((WsAbstractAction)this.m_actScrollToEditableCode);
        this.setHelpProduct("wdb");
        this.setHelpTopic("code_tab");
    }

    protected void createListeners() {
        this.m_lstnServerChange = new cServerChangeListener();
        this.m_lstnModelListener = new cModelListener();
        this.m_controller.getCodeGenerator().getModel().addModelListener(this.m_lstnModelListener);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add(this.m_lblUserWrittenModes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 2, 5, 5), 0, 0));
        this.add((Component)this.m_cmbUserWrittenModes, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.m_btnScrollToEditableCode, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        if (this.m_bShowExcludeTransformation) {
            this.add(this.m_ckbExcludeTransformation, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.add((Component)((Object)this.m_pnlCodePane), new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 2, 0), 0, 0));
        if (this.m_bShowServerPanel) {
            this.add((Component)this.m_pnlExecutionHosts, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(8, 2, 0, 0), 0, 0));
        }
        if (this.m_bShowExcludeTransformation) {
            this.add(this.m_btnViewStepCode, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    public void populateStore() throws MdException, RemoteException {
        if (this.isStorePopulated()) {
            return;
        }
        this.m_pnlExecutionHosts.populateStore();
        this.setStorePopulated(true);
    }

    public void moveDataToView() throws MdException, RemoteException {
        Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.updateView();
        }
        catch (CodegenException cge) {
            MessageUtil.displayMessage((String)cge.getLocalizedMessage(), (int)0);
        }
        catch (MdException me) {
            MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (BadServerDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
        catch (ServerException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() throws MdException, RemoteException, CodegenException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException {
        this.setListeningForChanges(false);
        if (this.m_controller.getCodeGenerator() instanceof IJob && this.m_controller.getCodeGenerator().getModel().isEditable()) {
            ((IJob)this.m_controller.getCodeGenerator()).addAllUnorderedTransformsToControlOrder();
        }
        IModel model = this.m_controller.getCodeGenerator().getModel();
        boolean bUndo = model.isUndoSupported();
        model.setUndoSupported(false);
        try {
            if (this.m_bShowServerPanel) {
                IServer server = this.m_controller.getCodeGenerator().getExecutionServer();
                if (server != null) {
                    this.m_pnlExecutionHosts.setSelectedServerFQID(server.getID());
                }
                this.m_pnlExecutionHosts.moveDataToView();
            }
            IUserWrittenCodeContainer uw = this.m_controller.getCodeGenerator().getUserWrittenCode();
            if (this.m_controller.getCodeGenerator().isUsingUserWrittenCode() || this.m_bUserWrittenOnly) {
                if (uw.getUserWrittenSourceCode() == null) {
                    uw.createUserWrittenSourceCodeText(bundle.getString("SaveAsDialog.MetadataNameDefault.txt"));
                }
                if (this.m_controller.getCodeGenerator().isGenerateDISHeaderAndFooters()) {
                    this.setUserWrittenStateImpl(1, true);
                } else {
                    this.setUserWrittenStateImpl(2, true);
                }
            } else {
                this.setUserWrittenStateImpl(0, true);
            }
            if (this.m_bShowExcludeTransformation) {
                this.setTransformEnabledImpl(this.m_controller.getCodeGenerator().isCodeGenerationEnabled());
            }
            this.m_pnlCodePane.setDataChanged(false);
        }
        finally {
            model.setUndoSupported(bUndo);
            this.setListeningForChanges(true);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        if (!this.hasDataChanged()) {
            return;
        }
        if (this.m_controller.getCodeGenerator().isUsingUserWrittenCode()) {
            this.saveUserWrittenCode();
        }
        this.setDataChanged(false);
    }

    protected IServer getServerObjectFromAppServerPanel() throws RemoteException, MdException {
        this.m_pnlExecutionHosts.moveDataToStore();
        return this.getServerByFQID(this.m_pnlExecutionHosts.getSelectedServerFQID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IServer getServerByFQID(String serverId) {
        IModel model;
        IServer server = null;
        if (serverId != null && serverId.length() > 0 && (server = (IServer)(model = this.m_controller.getCodeGenerator().getModel()).getObject(serverId)) == null) {
            server = model.getObjectFactory().createServer(serverId);
            try {
                OMRAdapter omr = new OMRAdapter(model, Workspace.getMdFactory(), "acquireServer");
                model.setUndoSupported(false);
                try {
                    omr.populateFor((IOMRPersistable)server);
                    server.loadFromOMR(omr);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                finally {
                    model.setUndoSupported(true);
                    omr.dispose();
                }
            }
            catch (RemoteException ex) {
                Workspace.handleRemoteException((RemoteException)ex);
            }
        }
        return server;
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        if (this.m_pnlExecutionHosts != null && this.m_lstnServerChange != null) {
            this.m_pnlExecutionHosts.removePropertyChangeListener(this.m_lstnServerChange);
        }
        if (this.m_controller != null) {
            this.m_controller.getCodeGenerator().getModel().removeModelListener(this.m_lstnModelListener);
            this.m_controller.dispose();
            this.m_controller = null;
        }
        this.m_pnlCodePane.saveSettingsAndCleanUp();
        this.m_bDisposed = true;
    }

    public boolean validateData() {
        return this.m_iUserWrittenState == 0 || this.m_pnlCodePane.validateData();
    }

    public Component getDefaultFocusComponent() {
        return this.m_pnlCodePane.getDefaultFocusComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveUserWrittenCode() {
        IUserWrittenCodeContainer uw = this.m_controller.getCodeGenerator().getUserWrittenCode();
        ICodeSource codeSource = uw.getUserWrittenSourceCode();
        if (codeSource == null) {
            uw.createUserWrittenSourceCodeText(bundle.getString("SaveAsDialog.MetadataNameDefault.txt"));
        }
        IModel model = this.m_controller.getCodeGenerator().getModel();
        model.startCompoundUndoable();
        try {
            if (codeSource == null) {
                codeSource = uw.createUserWrittenSourceCodeText(bundle.getString("SaveAsDialog.MetadataNameDefault.txt"));
            }
            try {
                codeSource.setCode(this.m_pnlCodePane.getEditableText(this.m_iUserWrittenState == 1));
            }
            catch (ServerException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
        finally {
            model.endCompoundUndoable();
        }
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        this.m_pnlCodePane.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.setEnabled(bEditable);
    }

    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        if (this.isEditable() || !bEnabled) {
            this.m_ckbExcludeTransformation.setEnabled(bEnabled);
            this.m_cmbUserWrittenModes.setEnabled(bEnabled);
            this.m_pnlCodePane.setEditable(bEnabled);
            this.m_pnlExecutionHosts.setEditable(bEnabled);
        }
    }

    public boolean save() {
        if (!this.m_controller.getCodeGenerator().isUsingUserWrittenCode()) {
            this.setDataChanged(false);
            return true;
        }
        if (this.m_pnlCodePane.save()) {
            this.saveUserWrittenCode();
            this.setDataChanged(false);
            return true;
        }
        return false;
    }

    public CodePane getCodePane() {
        return this.m_pnlCodePane;
    }

    protected CodePane createCodePane() {
        return new CodePane(this.m_controller.getCodeGenerator().getUserWrittenCode(), this.m_controller);
    }

    private void setTransformEnabled(boolean bEnabled) {
        this.m_controller.getCodeGenerator().getModel().startCompoundUndoable();
        try {
            this.m_controller.getCodeGenerator().setCodeGenerationEnabled(bEnabled);
            this.setTransformEnabledImpl(bEnabled);
        }
        finally {
            this.m_controller.getCodeGenerator().getModel().endCompoundUndoable();
        }
    }

    private void setTransformEnabledImpl(boolean bEnabled) {
        this.m_ckbExcludeTransformation.setSelected(!bEnabled);
        this.m_bIsChangingUserWrittenState = true;
        try {
            if (!(this.m_iUserWrittenState != 1 && this.m_iUserWrittenState != 2 || bEnabled)) {
                this.saveUserWrittenCode();
            }
            this.setUserWrittenStateImpl(this.m_iUserWrittenState, true);
        }
        catch (MdException ex) {
            MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
        }
        catch (BadServerDefinitionException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (ServerException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        catch (CodegenException ex) {
            MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
        }
        finally {
            this.m_bIsChangingUserWrittenState = false;
        }
        this.setEnabled(bEnabled);
        if (this.isEditable()) {
            if (bEnabled) {
                this.m_pnlCodePane.setEditable(this.m_iUserWrittenState != 0);
            } else {
                this.m_ckbExcludeTransformation.setEnabled(true);
            }
        }
        this.m_actViewStepCode.setEnabled(bEnabled);
    }

    private boolean showReloadCodePrompt() {
        boolean bReloadCode;
        block5: {
            if (this.m_iUserWrittenState == 0) {
                ICodeSource userWritten = this.m_controller.getCodeGenerator().getUserWrittenCode().getUserWrittenSourceCode();
                try {
                    if (userWritten != null && userWritten.getCode().length() > 0) {
                        int iReloadCode = MessageUtil.displayMessage((String)bundle.getString("ProcessTab.ReloadUserWritten.txt"), (String)bundle.getString("ProcessTab.ReloadUserWritten.title.txt"), (int)3, (int)0);
                        bReloadCode = iReloadCode == 0;
                        break block5;
                    }
                    bReloadCode = false;
                }
                catch (ServerException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                    bReloadCode = false;
                }
            } else {
                bReloadCode = true;
            }
        }
        return bReloadCode;
    }

    private void setUserWrittenState(int iState, boolean bReloadCode) throws MdException, RemoteException, CodegenException, ServerException, BadLibraryDefinitionException, BadServerDefinitionException {
        if (iState == this.m_iUserWrittenState) {
            return;
        }
        if (iState != 0 && iState != 1 && iState != 2) {
            throw new IllegalArgumentException("illegal user written state: " + iState);
        }
        this.m_bIsChangingUserWrittenState = true;
        this.m_controller.setCodeNeedingUpdate();
        this.m_controller.getCodeGenerator().getModel().startCompoundUndoable();
        try {
            this.m_controller.getCodeGenerator().getModel().undoableEditHappened((UndoableEdit)new SetUserWrittenStateUndoable(this.m_iUserWrittenState, iState));
            if (this.m_iUserWrittenState == 1 || this.m_iUserWrittenState == 2) {
                this.saveUserWrittenCode();
            }
            this.m_controller.getCodeGenerator().setUseUserWrittenCode(iState != 0);
            this.setUserWrittenStateImpl(iState, bReloadCode);
        }
        finally {
            this.m_controller.getCodeGenerator().getModel().endCompoundUndoable();
            this.m_bIsChangingUserWrittenState = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserWrittenStateImpl(int iState, boolean bReloadCode) throws RemoteException, MdException, CodegenException, BadServerDefinitionException, BadLibraryDefinitionException, ServerException {
        if (this.m_bDisposed) {
            return;
        }
        boolean bResetLocation = (this.m_iUserWrittenState != 0 || !bReloadCode) && iState != 0;
        CodeEditorPane cep = this.getCodePane().getEditorPane();
        int oldVisibleLocation = cep.viewToModel(cep.getVisibleRect().getLocation());
        int iHeaderLength = 0;
        int headerLengthMultiplier = 0;
        if (this.m_iUserWrittenState == 0) {
            headerLengthMultiplier = this.m_bShowExcludeTransformation ? 1 : 0;
            if (iState == 2 && this.m_bShowExcludeTransformation) {
                bResetLocation = false;
            }
        } else if (this.m_iUserWrittenState == 1 && iState == 2) {
            headerLengthMultiplier = -1;
        } else if (this.m_iUserWrittenState == 2 && iState == 1) {
            headerLengthMultiplier = 1;
        }
        this.m_pnlCodePane.setCodeGenerationEnvironment(this.m_controller.getEnvironment());
        this.m_iUserWrittenState = iState;
        this.m_actScrollToEditableCode.setEnabled(this.m_iUserWrittenState == 1);
        if (iState == 0) {
            try {
                this.m_controller.getCodeGenerator().setGenerateDISHeaderAndFooters(true);
                if (this.m_controller.getCodeGenerator().isUsingUserWrittenCode() || this.m_bShowExcludeTransformation) {
                    this.m_controller.getBodyCode(true);
                }
                this.m_controller.getCode();
            }
            finally {
                this.m_pnlCodePane.setEditable(false);
                this.m_pnlCodePane.setText(this.m_controller.getCode(false).toString());
                this.m_cmbUserWrittenModes.setSelectedItem((Object)AUTOMATIC_NAME);
            }
        } else if (iState == 1) {
            this.m_pnlCodePane.setEditable(this.isEditable());
            iHeaderLength = this.m_pnlCodePane.setCodeSource(this.m_controller, this.m_controller.getCodeGenerator().getUserWrittenCode(), bReloadCode, true);
            this.m_cmbUserWrittenModes.setSelectedItem((Object)USER_WRITTEN_BODY_NAME);
            this.m_controller.getCodeGenerator().setGenerateDISHeaderAndFooters(true);
        } else if (iState == 2) {
            this.m_pnlCodePane.setEditable(this.isEditable());
            iHeaderLength = this.m_pnlCodePane.setCodeSource(this.m_controller, this.m_controller.getCodeGenerator().getUserWrittenCode(), bReloadCode, false);
            this.m_cmbUserWrittenModes.setSelectedItem((Object)USER_WRITTEN_ALL_NAME);
            this.m_controller.getCodeGenerator().setGenerateDISHeaderAndFooters(false);
        } else {
            throw new IllegalArgumentException("illegal user written state: " + iState);
        }
        this.m_intHeaderLength = iHeaderLength;
        if (bResetLocation) {
            try {
                int textLength = cep.getCodeEditorDocument().getLength() - 1;
                if (textLength < 0) {
                    textLength = 0;
                }
                cep.scrollRectToVisible(cep.modelToView(textLength));
                int newVisibleLocation = oldVisibleLocation + iHeaderLength * headerLengthMultiplier;
                if (newVisibleLocation < 0) {
                    newVisibleLocation = 0;
                }
                cep.setCaretPosition(textLength);
                if (newVisibleLocation < textLength) {
                    cep.setCaretPosition(newVisibleLocation);
                }
            }
            catch (BadLocationException e) {
                cep.setCaretPosition(0);
                Workspace.getDefaultLogger().debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void scrollToUserWrittenBody() {
        CodeEditorPane cep = this.getCodePane().getEditorPane();
        Rectangle oldPostion = cep.getVisibleRect();
        try {
            Rectangle newPostion = cep.modelToView(this.m_intHeaderLength - 1);
            newPostion.y += oldPostion.height;
            cep.scrollRectToVisible(newPostion);
            cep.setCaretPosition(this.m_intHeaderLength);
        }
        catch (BadLocationException e) {
            cep.scrollRectToVisible(oldPostion);
        }
    }

    protected WsAbstractToggleAction createExcludeTransformationToggleAction() {
        return new cExcludeTransformationToggleAction();
    }

    protected WsAbstractAction createViewStepCodeAction() {
        return new cViewStepCodeAction();
    }

    protected WsAbstractAction createScrollToEditableCodeAction() {
        return new cScrollToEditableCodeAction();
    }

    private class cUserWrittenModesListener
    implements ActionListener {
        private cUserWrittenModesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block10: {
                String sMode = (String)ProcessTab.this.m_cmbUserWrittenModes.getSelectedItem();
                ProcessTab.this.m_cmbUserWrittenModes.transferFocusUpCycle();
                try {
                    if (AUTOMATIC_NAME.equals(sMode)) {
                        ProcessTab.this.setUserWrittenState(0, false);
                        break block10;
                    }
                    if (USER_WRITTEN_BODY_NAME.equals(sMode)) {
                        ProcessTab.this.setUserWrittenState(1, ProcessTab.this.showReloadCodePrompt());
                        break block10;
                    }
                    if (USER_WRITTEN_ALL_NAME.equals(sMode)) {
                        ProcessTab.this.setUserWrittenState(2, ProcessTab.this.showReloadCodePrompt());
                        break block10;
                    }
                    throw new IllegalArgumentException("invalid user written mode - " + sMode);
                }
                catch (MdException ex) {
                    MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                }
                catch (RemoteException ex2) {
                    Workspace.handleRemoteException((RemoteException)ex2);
                }
                catch (BadServerDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (ServerException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (BadLibraryDefinitionException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
                catch (CodegenException ex) {
                    MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                }
            }
        }
    }

    private class cServerChangeListener
    implements PropertyChangeListener {
        private cServerChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (ProcessTab.this.isListeningForChanges() && "AppServerChanged".equals(event.getPropertyName())) {
                Object newValue = event.getNewValue();
                IServer newServer = null;
                if (newValue != null && newValue instanceof ServerContext) {
                    try {
                        newServer = ProcessTab.this.getServerByFQID(((ServerContext)newValue).getFQID());
                    }
                    catch (RemoteException exc) {
                        Workspace.handleRemoteException((RemoteException)exc);
                    }
                }
                ProcessTab.this.m_controller.getCodeGenerator().setExecutionServer(newServer);
            }
        }
    }

    private class cModelListener
    implements IModelListener {
        private cModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            block19: {
                if (ProcessTab.this.m_bIsChangingUserWrittenState) {
                    return;
                }
                boolean bWasListeningForChanges = ProcessTab.this.isListeningForChanges();
                ProcessTab.this.setListeningForChanges(false);
                try {
                    String type = ev.getType();
                    if (ev.getModelObject() != ProcessTab.this.m_controller.getCodeGenerator()) break block19;
                    if ("ITransform:ExecutionServerChanged".equals(type)) {
                        IServer server = ProcessTab.this.m_controller.getCodeGenerator().getExecutionServer();
                        ProcessTab.this.m_pnlExecutionHosts.setSelectedServerFQID(server != null ? server.getID() : null);
                        try {
                            ProcessTab.this.m_pnlExecutionHosts.moveDataToView();
                        }
                        catch (RemoteException exc) {
                            Workspace.handleRemoteException((RemoteException)exc);
                        }
                        catch (MdException exc) {
                            MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                        }
                        break block19;
                    }
                    if ("ITransform:CodeGenerationEnabledChanged".equals(type)) {
                        ProcessTab.this.setTransformEnabledImpl(((ICodeGenerator)ev.getModelObject()).isCodeGenerationEnabled());
                        break block19;
                    }
                    if (!"ICodeGenerator:GenerateDISHeaderAndFootersChanged".equals(type) && !"IUserWrittenCode:activeChanged".equals(type) && !"IUserWrittenCode:codeChanged".equals(type)) break block19;
                    try {
                        if (ProcessTab.this.m_controller.getCodeGenerator().isUsingUserWrittenCode()) {
                            if (ProcessTab.this.m_controller.getCodeGenerator().isGenerateDISHeaderAndFooters()) {
                                ProcessTab.this.setUserWrittenStateImpl(1, true);
                            } else {
                                ProcessTab.this.setUserWrittenStateImpl(2, true);
                            }
                            break block19;
                        }
                        ProcessTab.this.setUserWrittenStateImpl(0, false);
                    }
                    catch (MdException ex) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
                    }
                    catch (RemoteException ex2) {
                        Workspace.handleRemoteException((RemoteException)ex2);
                    }
                    catch (BadServerDefinitionException ex) {
                        MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    }
                    catch (ServerException ex) {
                        MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    }
                    catch (BadLibraryDefinitionException ex) {
                        MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    }
                    catch (CodegenException ex) {
                        MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
                    }
                }
                finally {
                    ProcessTab.this.setListeningForChanges(bWasListeningForChanges);
                }
            }
        }
    }

    private class SetUserWrittenStateUndoable
    extends AbstractUndoableEdit {
        private int m_iOldUserWrittenState;
        private int m_iNewUserWrittenState;

        public SetUserWrittenStateUndoable(int iOldState, int iNewState) {
            this.m_iOldUserWrittenState = iOldState;
            this.m_iNewUserWrittenState = iNewState;
        }

        @Override
        public void undo() {
            super.undo();
            try {
                ProcessTab.this.setUserWrittenStateImpl(this.m_iOldUserWrittenState, true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }

        @Override
        public void redo() {
            super.redo();
            try {
                ProcessTab.this.setUserWrittenStateImpl(this.m_iNewUserWrittenState, true);
            }
            catch (MdException ex) {
                MessageUtil.displayMetadataExceptionMessage((MdException)ex, (String)"Reading");
            }
            catch (RemoteException ex2) {
                Workspace.handleRemoteException((RemoteException)ex2);
            }
            catch (BadServerDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (BadLibraryDefinitionException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
            catch (CodegenException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class cExcludeTransformationToggleAction
    extends WsAbstractToggleAction {
        public cExcludeTransformationToggleAction() {
            super(bundle, "ProcessTab.cExcludeTransformationToggleAction", 0);
        }

        public void actionPerformed(ActionEvent e) {
            ProcessTab.this.setTransformEnabled(!ProcessTab.this.m_ckbExcludeTransformation.isSelected());
        }
    }

    private class cViewStepCodeAction
    extends WsAbstractAction {
        public cViewStepCodeAction() {
            super(bundle, "ProcessTab.cViewStepCodeAction", 288);
        }

        public void actionPerformed(ActionEvent event) {
            if (ProcessTab.this.m_controller.getCodeGenerator().isUsingUserWrittenCode()) {
                ProcessTab.this.saveUserWrittenCode();
            }
            try {
                ICodeGenerationEnvironment cgEnvironment = CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(ProcessTab.this.m_controller.getCodeGenerator().getJob(), ModelUIUtilities.acquireModelForDefaultSASAppServer(ProcessTab.this.m_controller.getCodeGenerator().getModel()));
                ICodeSegment codeSegment = ProcessTab.this.m_controller.getCodeGenerator().getCompleteCode(cgEnvironment);
                if (codeSegment != null) {
                    CodePane codePane = new CodePane(ProcessTab.this.m_controller.getCodeGenerator().getUserWrittenCode());
                    codePane.setText(codeSegment.getGeneratedCode().toString());
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.getString("ProcessTab.ViewStepCodeDialog.title.txt"), true, (WAPanel)codePane);
                    dlg.setEditable(false);
                    dlg.setResizable(true);
                    dlg.setPreferredSize(new Dimension(600, 500));
                    dlg.show();
                }
            }
            catch (CodegenException cge) {
                MessageUtil.displayMessage((String)cge.getLocalizedMessage(), (int)0);
            }
            catch (MdException me) {
                MessageUtil.displayMetadataExceptionMessage((MdException)me, (String)"Reading");
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (BadServerDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
            catch (ServerException ex) {
                MessageUtil.displayMessage((String)ex.getLocalizedMessage(), (int)0);
            }
        }
    }

    private class cScrollToEditableCodeAction
    extends WsAbstractAction {
        public cScrollToEditableCodeAction() {
            super(bundle, "ProcessTab.cScrollToEditableCodeAction", 18);
        }

        public void actionPerformed(ActionEvent event) {
            ProcessTab.this.scrollToUserWrittenBody();
        }
    }
}

