/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IParametersContainer;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.IJob;
import com.sas.etl.models.prompts.impl.PromptUtils;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.wadmin.prompts.visuals.PromptDesignTimePanel;
import com.sas.wadmin.prompts.visuals.PromptXMLDialog;
import com.sas.wadmin.visuals.common.ParametersSelectorPanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;

public class ParameterPanel
extends PromptDesignTimePanel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ParameterPanel.class);
    protected PropertyChangeListener m_promptChangeListener;
    protected IModelListener m_lsnrModel;

    public ParameterPanel(PromptGroupInterface promptGroup, boolean allowImportParameters, IParametersContainer parmContainer, boolean showImportExport, boolean generatedTransform) {
        super(promptGroup, allowImportParameters, parmContainer, showImportExport, generatedTransform);
        if (parmContainer != null) {
            this.setModel(parmContainer.getModel());
        }
    }

    @Override
    protected void createListeners() {
        this.m_promptChangeListener = new cPromptPanelPropertyChangeListener();
        this.m_pnlPrompt.addPropertyChangeListener(this.m_promptChangeListener);
        this.m_lsnrModel = new ModelListener();
        IParametersContainer container = this.getContainer();
        if (container != null) {
            container.getModel().addModelListener(this.m_lsnrModel);
        }
    }

    @Override
    protected PropertyChangeListener getPromptPanelListener() {
        return this.m_promptChangeListener;
    }

    private IParametersContainer getContainer() {
        Object obj = this.getOwner();
        if (obj instanceof IParametersContainer) {
            return (IParametersContainer)obj;
        }
        return null;
    }

    @Override
    public void setPromptGroup(PromptGroupInterface promptGroup) {
        this.m_promptGroup = PromptUtils.copyPromptGroup((UserContextInterface)Workspace.getWorkspace().getUserContext(), (PromptGroupInterface)promptGroup);
        super.setPromptGroup(this.m_promptGroup);
    }

    @Override
    protected PropertyChangeListener createPromptPropertyChangeListener() {
        return new cPromptPanelPropertyChangeListener();
    }

    @Override
    protected WsAbstractAction createImportXMLAction() {
        return new cImportPromptXMLAction();
    }

    @Override
    protected WsAbstractAction createImportAction() {
        return new cImportPromptsAction();
    }

    @Override
    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        IParametersContainer container = this.getContainer();
        if (container != null) {
            container.getModel().removeModelListener(this.m_lsnrModel);
        }
    }

    protected class cPromptPanelPropertyChangeListener
    implements PropertyChangeListener {
        protected cPromptPanelPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ParameterPanel.this.isListeningForChanges() && (ev.getPropertyName().equals("addOperation") || ev.getPropertyName().equals("deleteOperation") || ev.getPropertyName().equals("moveOperation") || ev.getPropertyName().equals("editOperation") || ev.getPropertyName().equals("shareOperation"))) {
                ParameterPanel.this.getContainer().setPromptGroup(PromptUtils.copyPromptGroup((UserContextInterface)Workspace.getWorkspace().getUserContext(), (PromptGroupInterface)ParameterPanel.this.getPromptGroup()));
            }
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent ev) {
            ParameterPanel.this.setListeningForChanges(false);
            try {
                String sType = ev.getType();
                IObject obj = ev.getModelObject();
                if (obj == ParameterPanel.this.getContainer() && "IParametersContainer:PromptGroupChanged".equals(sType)) {
                    IParametersContainer container = (IParametersContainer)obj;
                    ParameterPanel.this.setPromptGroup(container.getPromptGroup());
                }
            }
            finally {
                ParameterPanel.this.setListeningForChanges(true);
            }
        }
    }

    protected class cImportPromptXMLAction
    extends WsAbstractAction {
        public cImportPromptXMLAction() {
            super(bundle, "ParameterPanel.ImportPromptXML");
        }

        public void actionPerformed(ActionEvent e) {
            PromptXMLDialog exportDialog = new PromptXMLDialog(false);
            exportDialog.show();
            PromptGroupInterface pGroup = exportDialog.getPromptGroup();
            if (pGroup != null) {
                ParameterPanel.this.setPromptGroup(pGroup);
                ParameterPanel.this.getContainer().setPromptGroup(PromptUtils.copyPromptGroup((UserContextInterface)Workspace.getWorkspace().getUserContext(), (PromptGroupInterface)pGroup));
            }
        }
    }

    protected class cImportPromptsAction
    extends WsAbstractAction {
        public cImportPromptsAction() {
            super(bundle, "ParameterPanel.ImportParameters");
        }

        public void actionPerformed(ActionEvent e) {
            IParametersContainer container = ParameterPanel.this.getContainer();
            if (container == null || !(container instanceof IJob)) {
                return;
            }
            IJob job = (IJob)container;
            String name = job.getName();
            WAStandardDialog importDialog = new WAStandardDialog((Frame)Workspace.getWorkspace(), bundle.formatString("ParameterPanel.ImportDialog.Title.txt", (Object)name), true);
            ParametersSelectorPanel parmPanel = new ParametersSelectorPanel(job);
            importDialog.setMainPanel((WAPanel)parmPanel);
            importDialog.show();
            List selList = parmPanel.getSelectedObjects();
            PromptGroup promptGroup = (PromptGroup)ParameterPanel.this.m_pnlPrompt.getRootPromptGroup();
            if (selList != null) {
                ArrayList<PromptDefinitionInterface> duplicates = new ArrayList<PromptDefinitionInterface>();
                int selSize = selList.size();
                for (int i = 0; i < selSize; ++i) {
                    PromptDefinitionInterface sel = (PromptDefinitionInterface)selList.get(i);
                    if (promptGroup.getPromptDefinition(sel.getPromptName(), true) == null) continue;
                    duplicates.add(sel);
                }
                if (!duplicates.isEmpty()) {
                    MessageUtil.displayListMessage((String)bundle.getString("ParameterPanel.DuplicatePromptName.txt"), duplicates, (int)2);
                } else {
                    promptGroup.addPromptDefinitions(selList);
                    container.setPromptGroup(PromptUtils.copyPromptGroup((UserContextInterface)Workspace.getWorkspace().getUserContext(), (PromptGroupInterface)promptGroup));
                }
            }
        }
    }
}

