/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.job.transforms.common.IOrderBy;
import com.sas.etl.models.job.transforms.common.ISQLSortingColumn;
import com.sas.etl.models.job.transforms.common.ISortColumn;
import com.sas.wadmin.visuals.common.AbstractSQLSelectorTableModel;
import com.sas.wadmin.visuals.common.TablesPaletteTreeModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.util.ArrayList;
import java.util.List;

public class OrderBySelectorTableModel
extends AbstractSQLSelectorTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(OrderBySelectorTableModel.class);
    private static final String DEFAULTCOLUMNORDER = "ascending";
    protected static final int ASC_DESC_COL = 2;
    protected static final int COLUMN_REF_COL = 3;
    protected static final int ORDERBYCOLUMN_COL = 4;
    private ModelListener m_lsnrModel;

    public OrderBySelectorTableModel(IOrderBy groupBy) {
        this.m_mdlSorting = groupBy;
        this.m_aColumns = new WsAbstractTableColumn[5];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("AbstractSQLSelectorTableModel.TableName.txt"), 75);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("AbstractSQLSelectorTableModel.ColumnName.txt"), 100);
        this.m_aColumns[2] = new AbstractSQLSelectorTableModel.cListTableColumn(2, bundle.getString("OrderBySelectorTableModel.SortOrder.txt"), 75, this.getSortOrderTranslatedValues(), this.getSortOrderUnTranslatedValues(), DEFAULTCOLUMNORDER);
        this.m_aColumns[3] = new AbstractSQLSelectorTableModel.cListTableColumn(3, bundle.getString("AbstractSQLSelectorTableModel.ColumnRef.txt"), 75, this.getColumnReferenceTranslatedValues(), this.getColumnReferenceUnTranslatedValues(), DEFAULTCOLUMNREFERENCE);
        this.m_aColumns[4] = new WsObjectTableColumn();
        this.m_aColumns[4].setModelIndex(4);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1].setEditable(false);
        this.addSQLModelListener();
        this.m_lsnrModel = new ModelListener();
        this.m_mdlSorting.getModel().addModelListener((IModelListener)this.m_lsnrModel);
    }

    @Override
    public int getAscDescColumnIndex() {
        return 2;
    }

    @Override
    public int getObjectColumnIndex() {
        return 4;
    }

    @Override
    public boolean hasAscendingDescendingColumn() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List createRowValues(Object obj) {
        if (obj instanceof TablesPaletteTreeModel.cColumnNode) {
            ArrayList<String> lRowValues = new ArrayList<String>();
            this.m_lsnrModel.setStopUpdating(true);
            this.m_mdlSorting.getModel().startCompoundUndoable();
            try {
                TablesPaletteTreeModel.cColumnNode columnTreeNode = (TablesPaletteTreeModel.cColumnNode)((Object)obj);
                String sColName = columnTreeNode.getName();
                IColumn oColumn = (IColumn)columnTreeNode.getData();
                ITable oTable = columnTreeNode.getTable();
                String sTableName = oTable.getName();
                ISQLSortingColumn orderByColumn = this.m_mdlSorting.getModel().getObjectFactory().createNewSQLSortingColumn(this.m_mdlSorting.getID(), oColumn);
                orderByColumn.setName(sTableName + "." + sColName);
                this.m_mdlSorting.addSortColumn((ISortColumn)orderByColumn);
                lRowValues.add(sTableName);
                lRowValues.add(sColName);
                lRowValues.add(DEFAULTCOLUMNORDER);
                lRowValues.add(DEFAULTCOLUMNREFERENCE);
                lRowValues.add((String)orderByColumn);
            }
            finally {
                this.m_lsnrModel.setStopUpdating(false);
                this.m_mdlSorting.getModel().endCompoundUndoable();
            }
            return lRowValues;
        }
        if (obj instanceof List) {
            ArrayList lRowValues = new ArrayList();
            lRowValues = (ArrayList)obj;
            return lRowValues;
        }
        return null;
    }

    public Object getRow(int iRow) {
        String sTable = (String)this.getValueAt(iRow, 0);
        String sName = (String)this.getValueAt(iRow, 1);
        String sOrder = (String)this.getValueAt(iRow, 2);
        String sRef = (String)this.getValueAt(iRow, 3);
        ISortColumn groupByColumn = (ISortColumn)this.getValueAt(iRow, 4);
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sOrder);
        lRowValues.add(sRef);
        lRowValues.add((String)groupByColumn);
        return lRowValues;
    }

    @Override
    public void updateSortingColumn(Object value, int row, int column) {
        ISQLSortingColumn oColumn = (ISQLSortingColumn)this.m_mdlSorting.getSortColumnList().get(row);
        switch (column) {
            case 2: {
                oColumn.setDirection((String)value);
                break;
            }
            case 3: {
                oColumn.setColumnReference(Integer.parseInt((String)value));
            }
        }
    }

    private void addSortingColumnToTable(ISQLSortingColumn oColumn, int iIndex) {
        if (iIndex < this.getRowCount() && this.getValueAt(iIndex, 4) == oColumn) {
            return;
        }
        String sTable = oColumn.getColumn().getTable().getName();
        String sName = oColumn.getColumn().getName();
        String sDirection = oColumn.getDirection();
        String sRef = Integer.toString(oColumn.getColumnReference());
        ArrayList<String> lRowValues = new ArrayList<String>();
        lRowValues.add(sTable);
        lRowValues.add(sName);
        lRowValues.add(sDirection);
        lRowValues.add(sRef);
        lRowValues.add((String)oColumn);
        this.m_lData.add(iIndex, lRowValues);
        ++this.m_nRowInstances;
        this.fireTableRowsInserted(iIndex, iIndex);
    }

    private void deleteSortingColumnFromTable(ISQLSortingColumn oColumn) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(4) != oColumn) continue;
            List lDeleted = (List)this.m_lData.remove(iRow);
            this.fireTableRowDeleted(iRow, lDeleted);
            break;
        }
    }

    private List getSortOrderTranslatedValues() {
        ArrayList<String> sortOrderTranslated = new ArrayList<String>();
        sortOrderTranslated.add(bundle.getString("OrderBySelectorTableModel.Ascending.txt"));
        sortOrderTranslated.add(bundle.getString("OrderBySelectorTableModel.Descending.txt"));
        return sortOrderTranslated;
    }

    private List getSortOrderUnTranslatedValues() {
        ArrayList<String> sortOrderUnTranslated = new ArrayList<String>();
        sortOrderUnTranslated.add(DEFAULTCOLUMNORDER);
        sortOrderUnTranslated.add("descending");
        return sortOrderUnTranslated;
    }

    public void saveSettingsAndCleanUp() {
        this.removeSQLModelListener();
        this.m_mdlSorting.getModel().removeModelListener((IModelListener)this.m_lsnrModel);
    }

    private class ModelListener
    implements IModelListener {
        private boolean m_bStopUpdating = false;

        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            if (this.isStopUpdating()) {
                return;
            }
            String sType = ev.getType();
            if (sType.equalsIgnoreCase("SortingColumn:ReferenceChanged")) {
                ISQLSortingColumn oColumn;
                int iRow;
                if (ev.getModelObject() instanceof ISQLSortingColumn && (iRow = OrderBySelectorTableModel.this.m_mdlSorting.indexOfSortColumn((ISortColumn)(oColumn = (ISQLSortingColumn)ev.getModelObject()))) >= 0) {
                    OrderBySelectorTableModel.this.setValueAt(Integer.toString(oColumn.getColumnReference()), iRow, 3);
                }
            } else if (sType.equalsIgnoreCase("SortingColumn:DirectionChanged")) {
                ISQLSortingColumn oColumn;
                int iRow;
                if (ev.getData() instanceof ISQLSortingColumn && (iRow = OrderBySelectorTableModel.this.m_mdlSorting.indexOfSortColumn((ISortColumn)(oColumn = (ISQLSortingColumn)ev.getModelObject()))) >= 0) {
                    OrderBySelectorTableModel.this.setValueAt(oColumn.getDirection(), iRow, 2);
                }
            } else if (sType.equalsIgnoreCase("Sorting:ColumnAdded")) {
                ISQLSortingColumn oColumn;
                int iRow;
                if (ev.getData() instanceof ISQLSortingColumn && (iRow = OrderBySelectorTableModel.this.m_mdlSorting.indexOfSortColumn((ISortColumn)(oColumn = (ISQLSortingColumn)ev.getData()))) >= 0) {
                    OrderBySelectorTableModel.this.addSortingColumnToTable(oColumn, iRow);
                }
            } else if (sType.equalsIgnoreCase("Sorting:ColumnRemoved") && ev.getData() instanceof ISQLSortingColumn) {
                ISQLSortingColumn oColumn = (ISQLSortingColumn)ev.getData();
                OrderBySelectorTableModel.this.deleteSortingColumnFromTable(oColumn);
            }
        }

        public void setStopUpdating(boolean bStopUpdating) {
            this.m_bStopUpdating = bStopUpdating;
        }

        public boolean isStopUpdating() {
            return this.m_bStopUpdating;
        }
    }
}

