/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.prompts.IPromptModel;
import com.sas.metadata.remote.MdException;
import com.sas.plugins.PluginLoader;
import com.sas.wadmin.visuals.common.OptionsPane;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class OptionsTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(OptionsTab.class);
    protected OptionsPane m_attrPanel = null;
    protected IPromptModel m_model = null;
    protected static String DEFAULT_HELPID = "options_tab";
    private static String DEFAULT_HELPPRODUCT = "wdb";
    private boolean m_bShowRequiredCheckbox = true;
    private String m_helpClass = null;

    public OptionsTab(IPromptModel newModel, String helpMapID, boolean showRequiredCheckbox, String sName) {
        this(newModel, DEFAULT_HELPPRODUCT, helpMapID, showRequiredCheckbox, sName);
    }

    public OptionsTab(IPromptModel newModel, String helpMapID, boolean showRequiredCheckbox) {
        this(newModel, DEFAULT_HELPPRODUCT, helpMapID, showRequiredCheckbox, bundle.getString("OptionsTab.Name.txt"));
    }

    public OptionsTab(IPromptModel newModel, String helpProduct, String helpMapID, boolean showRequiredCheckbox) {
        this(newModel, helpProduct, helpMapID, showRequiredCheckbox, bundle.getString("OptionsTab.Name.txt"));
    }

    public OptionsTab(IPromptModel newModel, String helpProduct, String helpMapID, boolean showRequiredCheckbox, String sName) {
        this(newModel, helpProduct, helpMapID, showRequiredCheckbox, sName, null);
    }

    public OptionsTab(IPromptModel newModel, String helpProduct, String helpMapID, String helpClass, boolean showRequiredCheckbox) {
        this(newModel, helpProduct, helpMapID, showRequiredCheckbox, bundle.getString("OptionsTab.Name.txt"), helpClass);
    }

    public OptionsTab(IPromptModel newModel, String helpProduct, String helpMapID, boolean showRequiredCheckbox, String sName, String helpClass) {
        this.m_model = newModel;
        this.m_bShowRequiredCheckbox = showRequiredCheckbox;
        this.initialize();
        if (helpMapID != null && helpMapID.length() > 0) {
            this.setHelpTopic(helpMapID);
        } else {
            this.setHelpTopic(DEFAULT_HELPID);
        }
        if (helpProduct != null && helpProduct.length() > 0) {
            this.setHelpProduct(helpProduct);
        } else {
            this.setHelpProduct(DEFAULT_HELPPRODUCT);
        }
        this.m_helpClass = helpClass;
        this.setName(sName);
    }

    protected void initialize() {
        super.initialize();
        if (this.m_model != null) {
            this.m_attrPanel = new OptionsPane(this.m_model, this.m_bShowRequiredCheckbox);
        }
        this.m_attrPanel.setHelpTopic(this.m_sHelpTopic);
        this.listenForDataChangesTo(this.m_attrPanel);
        this.m_attrPanel.setWAUndoManager(this.getWAUndoManager());
        this.setLayout(new GridBagLayout());
        this.add((Component)((Object)this.m_attrPanel), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.m_attrPanel.setEditable(editable);
    }

    public void setHelpTopic(String helpid) {
        super.setHelpTopic(helpid);
        this.m_attrPanel.setHelpTopic(helpid);
    }

    public void setHelpProduct(String helpProduct) {
        super.setHelpProduct(helpProduct);
        this.m_attrPanel.setHelpProduct(helpProduct);
    }

    public ClassLoader getHelpClassLoader() {
        if (this.m_helpClass == null) {
            return super.getHelpClassLoader();
        }
        PluginLoader pl = Workspace.getWorkspace().getPluginLoader();
        ClassLoader cl = pl.getClassLoader(this.m_helpClass);
        return cl;
    }

    public void moveDataToStore() throws MdException, RemoteException {
        this.m_attrPanel.moveDataToStore();
    }

    public void moveDataToView() throws MdException, RemoteException {
        this.setListeningForChanges(false);
        this.m_attrPanel.moveDataToView();
        this.setListeningForChanges(true);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        this.m_attrPanel.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return this.m_attrPanel.validateData();
    }
}

