/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IDocumentsContainer;
import com.sas.etl.models.INotesAndDocumentsContainer;
import com.sas.etl.models.INotesContainer;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.DocumentsPane;
import com.sas.wadmin.visuals.common.NotesPane;
import com.sas.wadmin.visuals.common.PrivateNotePane;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;

public class NotesTab
extends WAPropertyTab {
    private static final WAdminResource bundle = WAdminResource.getBundle(NotesTab.class);
    private INotesAndDocumentsContainer m_container;
    private WsAbstractAction m_actDelete;
    private PrivateNotePane m_pnlPrivateNote;
    private NotesPane m_pnlNotes;
    private DocumentsPane m_pnlDocuments;

    public NotesTab(INotesAndDocumentsContainer container) {
        this.m_container = container;
        this.setName(bundle.getString("NotesTab.Title.txt"));
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("shared");
        this.setHelpTopic("notestab");
    }

    public boolean validateData() {
        if (!this.m_pnlPrivateNote.validateData()) {
            return false;
        }
        if (!this.m_pnlNotes.validateData()) {
            return false;
        }
        return this.m_pnlDocuments.validateData();
    }

    public boolean doDataExchange(boolean bSaveToModel) throws MdException, RemoteException {
        try {
            boolean bl = this.m_pnlPrivateNote.doDataExchange(bSaveToModel) && this.m_pnlNotes.doDataExchange(bSaveToModel) && this.m_pnlDocuments.doDataExchange(bSaveToModel);
            return bl;
        }
        finally {
            this.setDataChanged(false);
            this.waum.discardAllEdits();
        }
    }

    public void moveDataToView() {
        try {
            String sNote = this.m_container.getPrivateNote();
            if (sNote != null && !sNote.equals("")) {
                this.m_pnlPrivateNote.setContents(sNote);
            }
            this.m_pnlDocuments.moveDataToView();
            this.m_pnlNotes.moveDataToView();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public void moveDataToStore() {
        try {
            this.m_pnlPrivateNote.moveDataToStore();
            this.m_pnlNotes.moveDataToStore();
            this.m_pnlDocuments.moveDataToStore();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Reading");
        }
    }

    public void saveSettingsAndCleanUp() {
        this.m_pnlPrivateNote.saveSettingsAndCleanUp();
        this.m_pnlNotes.saveSettingsAndCleanUp();
        this.m_pnlDocuments.saveSettingsAndCleanUp();
    }

    public void updateWorkspaceUIComponents(boolean bActive) {
        super.updateWorkspaceUIComponents(bActive);
        if (this.m_actDelete == null) {
            this.m_actDelete = this.m_pnlNotes.getDeleteAction();
        }
        this.m_actDelete.setActive(bActive);
        this.m_pnlPrivateNote.updateWorkspaceUIComponents(bActive);
        this.m_pnlNotes.updateWorkspaceUIComponents(bActive);
        this.m_pnlDocuments.updateWorkspaceUIComponents(bActive);
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_pnlPrivateNote.setEditable(bEditable);
        this.m_pnlNotes.setEditable(bEditable);
        this.m_pnlDocuments.setEditable(bEditable);
    }

    protected void initialize() {
        this.m_pnlPrivateNote = new PrivateNotePane(this.m_container);
        this.m_pnlNotes = new NotesPane((INotesContainer)this.m_container);
        this.m_pnlDocuments = new DocumentsPane((IDocumentsContainer)this.m_container);
        this.listenForDataChangesTo(this.m_pnlPrivateNote);
        this.listenForDataChangesTo(this.m_pnlNotes);
        this.listenForDataChangesTo(this.m_pnlDocuments);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.m_pnlNotes.setPreferredSize(new Dimension(550, 200));
        this.m_pnlDocuments.setPreferredSize(new Dimension(550, 200));
        this.add((Component)((Object)this.m_pnlPrivateNote), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlNotes), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)((Object)this.m_pnlDocuments), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.5, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

