/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.INotesContainer;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.other.INote;
import com.sas.workspace.WsEditableListModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;

public class NotesListModel
extends AbstractListModel
implements WsEditableListModel {
    INotesContainer m_container;
    IModelListener m_lsnrModel;
    List m_lObjects;

    public NotesListModel(INotesContainer container) {
        this.m_container = container;
        this.m_lObjects = new ArrayList();
        this.initialize();
    }

    private void initialize() {
        this.m_lObjects.addAll(this.m_container.getNotesList());
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
    }

    public Object getValueAt(int iValue) {
        return this.m_container.getNotes()[iValue].getName();
    }

    public boolean isCellEditable(int iValue) {
        return false;
    }

    public void setValueAt(int iValue, Object value) {
        this.m_container.getNotes()[iValue].setName((String)value);
        this.fireContentsChanged(this, iValue, iValue);
    }

    @Override
    public Object getElementAt(int arg0) {
        return this.m_container.getNotes()[arg0].getName();
    }

    @Override
    public int getSize() {
        return this.m_container.getNotes().length;
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "Object:NoteAdded") {
                INote oNote = (INote)ev.getData();
                int iIndex = NotesListModel.this.m_container.getNotesList().indexOf(oNote);
                if (iIndex != -1) {
                    NotesListModel.this.m_lObjects.add(iIndex, oNote);
                    NotesListModel.this.fireIntervalAdded(this, iIndex, iIndex);
                }
            } else if (sType == "Object:NoteRemoved") {
                INote oNote = (INote)ev.getData();
                int iIndex = NotesListModel.this.m_lObjects.indexOf(oNote);
                if (iIndex != -1) {
                    NotesListModel.this.m_lObjects.remove(iIndex);
                    NotesListModel.this.fireIntervalRemoved(this, iIndex, iIndex);
                }
            } else if (sType == "Object:NameChanged" && ev.getModelObject() instanceof INote) {
                INote oNote = (INote)ev.getModelObject();
                int iIndex = NotesListModel.this.m_container.getNotesList().indexOf(oNote);
                if (iIndex != -1) {
                    NotesListModel.this.setValueAt(iIndex, oNote.getName());
                }
            }
        }
    }
}

