/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.workspace.WATextPane;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractIconFactory;
import com.sas.workspace.WsUIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class NotePreviewPane
extends JPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(NotePreviewPane.class);
    protected JLabel m_lblText;
    protected WATextPane m_pnlText;
    protected JScrollPane m_scrText;
    protected JPopupMenu m_menuPopup;
    protected JToolBar m_barTools;
    protected WsAbstractAction m_actCut;
    protected WsAbstractAction m_actCopy;
    protected WsAbstractAction m_actPaste;
    protected boolean m_bEditable = true;
    protected UndoableEditListener m_lsnrUndoableEdit;
    protected DocumentListener m_lsnrDocument;
    protected StyledDocument m_mdlDocument;

    public NotePreviewPane() {
        this.initialize();
        this.layoutWidgets();
    }

    public WATextPane getTextPane() {
        return this.m_pnlText;
    }

    public JLabel getTextLabel() {
        return this.m_lblText;
    }

    public String getContents() {
        StringWriter sw = new StringWriter();
        StyledDocument sd = this.m_pnlText.getStyledDocument();
        try {
            this.m_pnlText.getEditorKit().write(sw, (Document)sd, 0, sd.getLength());
        }
        catch (BadLocationException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sw.toString();
    }

    public void setContents(String sText) {
        this.m_mdlDocument = new HTMLDocument();
        this.m_pnlText.setStyledDocument(this.m_mdlDocument);
        if (sText != null && sText.length() != 0) {
            try {
                StringReader sr = new StringReader(sText);
                this.m_pnlText.getEditorKit().read(sr, (Document)this.m_mdlDocument, 0);
                this.m_pnlText.setCaretPosition(1);
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.m_lsnrUndoableEdit != null) {
            this.m_mdlDocument.addUndoableEditListener(this.m_lsnrUndoableEdit);
        }
        if (this.m_lsnrDocument != null) {
            this.m_mdlDocument.addDocumentListener(this.m_lsnrDocument);
        }
    }

    public void setEditable(boolean bEditable) {
        this.m_bEditable = bEditable;
        this.m_pnlText.setEditable(bEditable);
        this.m_actCut.setEnabled(bEditable && this.isEnabled() && this.m_pnlText.getSelectedText() != null);
        this.m_actPaste.setEnabled(bEditable && this.isEnabled());
    }

    public boolean isEditable() {
        return this.m_bEditable;
    }

    @Override
    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.m_pnlText.setEnabled(bEnabled);
        this.m_actCut.setEnabled(bEnabled && this.isEditable() && this.m_pnlText.getSelectedText() != null);
        this.m_actCopy.setEnabled(bEnabled && this.m_pnlText.getSelectedText() != null);
        this.m_actPaste.setEnabled(bEnabled && this.isEditable());
    }

    public void setUndoableEditListener(UndoableEditListener l) {
        this.m_lsnrUndoableEdit = l;
        if (this.m_mdlDocument != null) {
            this.m_mdlDocument.addUndoableEditListener(l);
        }
    }

    public void setDocumentListener(DocumentListener l) {
        this.m_lsnrDocument = l;
        if (this.m_mdlDocument != null) {
            this.m_mdlDocument.addDocumentListener(l);
        }
    }

    protected void initialize() {
        this.m_pnlText = new WATextPane();
        this.m_pnlText.setAutoSelect(false);
        this.m_pnlText.setSelectionColor((Color)SystemColor.textHighlight);
        this.m_pnlText.setSelectedTextColor((Color)SystemColor.textHighlightText);
        this.m_pnlText.setFont(new Font("dialog", 0, 12));
        this.m_mdlDocument = new HTMLDocument();
        this.m_pnlText.setEditorKit((EditorKit)new HTMLEditorKit());
        this.m_pnlText.setStyledDocument(this.m_mdlDocument);
        this.m_pnlText.getCaret().addChangeListener(new cCaretMovedListener());
        this.m_pnlText.addMouseListener((MouseListener)new cPopupMenuListener());
        this.m_pnlText.addFocusListener((FocusListener)new cFocusListener());
        this.m_lblText = WsUIUtilities.createLabelForComponent((JComponent)this.m_pnlText, (String)bundle.getString("NotePreviewPane.Label.txt"));
        this.m_scrText = new JScrollPane((Component)this.m_pnlText);
        this.createActions();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_lblText, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_barTools, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.m_scrText, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected void createActions() {
        this.m_menuPopup = new JPopupMenu();
        this.m_barTools = new JToolBar();
        this.m_barTools.setBorder(BorderFactory.createEmptyBorder());
        this.m_barTools.setRollover(true);
        this.m_actCut = new CutAction();
        this.m_actCopy = new CopyAction();
        this.m_actPaste = new PasteAction();
        JButton btnCut = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCut);
        JButton btnCopy = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actCopy);
        JButton btnPaste = WsUIUtilities.createFlatToolButton((WsAbstractAction)this.m_actPaste);
        btnCut.setFocusable(false);
        btnCopy.setFocusable(false);
        btnPaste.setFocusable(false);
        this.m_barTools.add(btnCut);
        this.m_barTools.add(btnCopy);
        this.m_barTools.add(btnPaste);
        this.m_barTools.addSeparator();
        this.m_menuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actCut));
        this.m_menuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actCopy));
        this.m_menuPopup.add(WsUIUtilities.createMenuItem((WsAbstractAction)this.m_actPaste));
        this.m_menuPopup.addSeparator();
    }

    protected String getAcceleratorText(KeyStroke accelerator) {
        StringBuffer sAccelerator = new StringBuffer();
        if (accelerator != null) {
            sAccelerator.append(" (");
            int modifiers = accelerator.getModifiers();
            if (modifiers > 0) {
                sAccelerator.append(KeyEvent.getKeyModifiersText(modifiers));
                sAccelerator.append("+");
            }
            sAccelerator.append(KeyEvent.getKeyText(accelerator.getKeyCode()));
            sAccelerator.append(")");
        }
        return sAccelerator.toString();
    }

    protected class cCaretMovedListener
    implements ChangeListener {
        protected cCaretMovedListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (NotePreviewPane.this.m_pnlText.getSelectedText() != null) {
                if (NotePreviewPane.this.isEnabled()) {
                    NotePreviewPane.this.m_actCopy.setEnabled(true);
                    NotePreviewPane.this.m_actCut.setEnabled(NotePreviewPane.this.isEditable());
                }
                return;
            }
            NotePreviewPane.this.m_actCopy.setEnabled(false);
            NotePreviewPane.this.m_actCut.setEnabled(false);
            int iOff = Math.max(((Caret)e.getSource()).getDot() - 1, 0);
            StyledDocument doc = (StyledDocument)NotePreviewPane.this.m_pnlText.getDocument();
            AttributeSet setAttrs = doc.getCharacterElement(iOff).getAttributes();
        }

        protected boolean isAttribute(AttributeSet setAttrs, Object oAttribute) {
            Boolean bAttribute = (Boolean)setAttrs.getAttribute(oAttribute);
            return bAttribute != null && bAttribute != false;
        }
    }

    protected class cPopupMenuListener
    extends MouseAdapter {
        protected cPopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && NotePreviewPane.this.m_pnlText.isEnabled()) {
                NotePreviewPane.this.m_menuPopup.show((Component)NotePreviewPane.this.m_pnlText, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && NotePreviewPane.this.m_pnlText.isEnabled()) {
                if (NotePreviewPane.this.m_pnlText.getSelectedText() == null) {
                    int newDot = NotePreviewPane.this.m_pnlText.getUI().viewToModel((JTextComponent)NotePreviewPane.this.m_pnlText, e.getPoint());
                    NotePreviewPane.this.m_pnlText.getCaret().setDot(newDot);
                }
                NotePreviewPane.this.m_menuPopup.show((Component)NotePreviewPane.this.m_pnlText, e.getX(), e.getY());
            }
        }
    }

    protected class cFocusListener
    implements FocusListener {
        protected cFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            NotePreviewPane.this.m_actCut.setActive(true);
            NotePreviewPane.this.m_actCopy.setActive(true);
            NotePreviewPane.this.m_actPaste.setActive(true);
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!NotePreviewPane.this.m_menuPopup.isShowing()) {
                NotePreviewPane.this.m_actCut.setActive(false);
                NotePreviewPane.this.m_actCopy.setActive(false);
                NotePreviewPane.this.m_actPaste.setActive(false);
            }
        }
    }

    private class CutAction
    extends WsAbstractAction {
        public CutAction() {
            super(bundle, "NotePreviewPane.Action.Cut", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Cut"));
            this.setAccelerator(KeyStroke.getKeyStroke(88, 2));
            this.setToolTipText(this.getToolTipText() + NotePreviewPane.this.getAcceleratorText(this.getAccelerator()));
        }

        public void actionPerformed(ActionEvent ev) {
            NotePreviewPane.this.m_pnlText.cut();
        }
    }

    private class CopyAction
    extends WsAbstractAction {
        public CopyAction() {
            super(bundle, "NotePreviewPane.Action.Copy", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Copy"));
            this.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.setToolTipText(this.getToolTipText() + NotePreviewPane.this.getAcceleratorText(this.getAccelerator()));
        }

        public void actionPerformed(ActionEvent ev) {
            NotePreviewPane.this.m_pnlText.copy();
        }
    }

    private class PasteAction
    extends WsAbstractAction {
        public PasteAction() {
            super(bundle, "NotePreviewPane.Action.Paste", 0);
            this.setIcon(WsAbstractIconFactory.getInstance().getIconForAction("Common:Paste"));
            this.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.setToolTipText(this.getToolTipText() + NotePreviewPane.this.getAcceleratorText(this.getAccelerator()));
        }

        public void actionPerformed(ActionEvent ev) {
            NotePreviewPane.this.m_pnlText.paste();
        }
    }
}

