/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModel;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.app.AppIconFactory;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleBrowseObject;
import com.sas.workspace.models.tree.AbstractTreeModel;
import com.sas.workspace.models.tree.AbstractTreeNode;
import com.sas.workspace.models.tree.IDataTreeNode;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.models.tree.UserFolderTreeNode;
import java.lang.reflect.InvocationTargetException;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class IndexTreeModel
extends AbstractTreeModel {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTreeModel.class);
    protected IPhysicalTable m_oTable;
    protected IModelListener m_lsnrModel;
    protected int m_nIndexNodes;
    protected int m_iClusteredCount;

    public IndexTreeModel(IPhysicalTable oTable) {
        super(Workspace.getWorkspace().getUserContext(), null);
        this.m_oTable = oTable;
        this.setRoot((TreeNode)((Object)new cRootNode()));
        this.createModelListener();
    }

    protected void installListeners() throws RemoteException {
    }

    protected void uninstallListeners() throws RemoteException {
        this.removeModelListener();
    }

    private void createModelListener() {
        this.m_lsnrModel = new ModelListener();
        this.m_oTable.getModel().addModelListener(this.m_lsnrModel);
    }

    private void removeModelListener() {
        this.m_oTable.getModel().removeModelListener(this.m_lsnrModel);
    }

    public boolean isIndexNameUnique(String sName, IndexTreeNode nodeIndexToSkip) {
        ITreeNode nodeRoot = (ITreeNode)this.getRoot();
        int nIndexes = nodeRoot.getChildCount();
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            TreeNode nodeIndex = nodeRoot.getChildAt(iIndex);
            if (nodeIndex == nodeIndexToSkip || !nodeIndex.toString().equals(sName)) continue;
            return false;
        }
        return true;
    }

    public void moveDataToModel() throws MdException, RemoteException {
        this.setRoot(this.createRootNode());
        this.m_iClusteredCount = 0;
        IIndex[] alIndexes = this.m_oTable.getIndexes();
        int nIndexes = alIndexes.length;
        for (int iIndex = 0; iIndex < nIndexes; ++iIndex) {
            IIndex oIndex = alIndexes[iIndex];
            this.m_iClusteredCount += oIndex.isClustered() ? 1 : 0;
            IndexTreeNode nodeIndex = this.createIndexNode(oIndex);
            this.insertNodeInto((MutableTreeNode)((Object)nodeIndex), (MutableTreeNode)((ITreeNode)this.getRoot()), iIndex);
        }
        this.m_nIndexNodes = nIndexes;
    }

    protected TreeNode createRootNode() {
        cRootNode rootNode = new cRootNode();
        rootNode.setTreeModel((ITreeModel)this);
        return rootNode;
    }

    public IIndex createIndex() {
        IModel mdl = this.m_oTable.getModel();
        IIndex oIndex = null;
        mdl.startCompoundUndoable();
        try {
            oIndex = this.m_oTable.createNewIndex();
        }
        finally {
            mdl.endCompoundUndoable();
        }
        return oIndex;
    }

    protected IndexTreeNode createIndexNode(IIndex oIndex) {
        IndexTreeNode nodeIndex = new IndexTreeNode(oIndex);
        List lCols = oIndex.getColumnsList();
        for (int iColumn = 0; iColumn < lCols.size(); ++iColumn) {
            IndexTreeNode nodeColumn = this.createColumnNode((IColumn)lCols.get(iColumn));
            if (nodeColumn == null) continue;
            this.addChild((ITreeNode)nodeColumn, (ITreeNode)nodeIndex);
        }
        nodeIndex.setTreeModel((ITreeModel)this);
        return nodeIndex;
    }

    public IndexTreeNode createColumnNode(IColumn oColumn) {
        IndexTreeNode node = null;
        if (this.m_oTable.containsColumn(oColumn)) {
            node = new IndexTreeNode(oColumn);
            node.setTreeModel((ITreeModel)this);
        }
        return node;
    }

    public int getClusteredCount() {
        return this.m_iClusteredCount;
    }

    public void addChild(final ITreeNode newNode, final ITreeNode parentNode, int iIndex) {
        if (SwingUtilities.isEventDispatchThread()) {
            int iChild;
            int nChildren = parentNode.getChildCount();
            if (newNode instanceof UserFolderTreeNode) {
                iChild = 0;
            } else if (parentNode.isSorted()) {
                ITreeNode nodeChild;
                for (iChild = 0; iChild < nChildren && ((nodeChild = (ITreeNode)parentNode.getChildAt(iChild)) instanceof UserFolderTreeNode || this.m_comparator.compare(nodeChild, newNode) <= 0); ++iChild) {
                }
            } else {
                iChild = iIndex;
            }
            newNode.setTreeModel((ITreeModel)this);
            this.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)parentNode, iChild);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        IndexTreeModel.this.addChild(newNode, parentNode);
                    }
                });
            }
            catch (InterruptedException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                Workspace.getDefaultLogger().error((Object)"", (Throwable)ex);
            }
        }
    }

    public void addChild(IDataTreeNode newNode) {
    }

    public void addChildren(ITreeNode parentNode) {
    }

    public List findParentNodes(SimpleBrowseObject object) {
        return null;
    }

    public boolean isValidParent(ITreeNode parentNode, ITreeNode childNode) {
        return true;
    }

    public class cRootNode
    extends AbstractTreeNode
    implements ITreeNode {
        public cRootNode() {
            super((Object)"");
        }

        public Icon getIcon() {
            return null;
        }

        public boolean isFolder() {
            return true;
        }
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            if (sType == "PhysicalTable:IndexAdded") {
                IIndex oIndex = (IIndex)ev.getData();
                IndexTreeModel.this.addChild((ITreeNode)IndexTreeModel.this.createIndexNode(oIndex), (ITreeNode)IndexTreeModel.this.getRoot());
            } else if (sType == "PhysicalTable:IndexRemoved") {
                IIndex oIndex = (IIndex)ev.getData();
                List lNodes = IndexTreeModel.this.findNodes(oIndex.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IndexTreeNode nodeIndex = (IndexTreeNode)((Object)lNodes.get(0));
                IndexTreeModel.this.removeChild((ITreeNode)nodeIndex);
            } else if (sType == "Index:ColumnAdded") {
                IColumn oColumn = (IColumn)ev.getData();
                IIndex oIndex = (IIndex)ev.getModelObject();
                int iIndex = oIndex.getColumnsList().indexOf(oColumn);
                List lNodes = IndexTreeModel.this.findNodes(oIndex.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IndexTreeNode nodeCol = IndexTreeModel.this.createColumnNode(oColumn);
                IndexTreeNode nodeIndex = (IndexTreeNode)((Object)lNodes.get(0));
                IndexTreeModel.this.addChild((ITreeNode)nodeCol, (ITreeNode)nodeIndex, iIndex);
            } else if (sType == "Index:ColumnRemoved") {
                IColumn oColumn = (IColumn)ev.getData();
                IIndex oIndex = (IIndex)ev.getModelObject();
                List lNodes = IndexTreeModel.this.findNodes(oColumn.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                for (int iColumn = 0; iColumn < lNodes.size(); ++iColumn) {
                    IndexTreeNode nodeCol = (IndexTreeNode)((Object)lNodes.get(iColumn));
                    if (((IndexTreeNode)((Object)nodeCol.getParent())).getIndex() != oIndex) continue;
                    IndexTreeModel.this.removeChild((ITreeNode)nodeCol);
                }
            } else if (sType == "Object:NameChanged" && ev.getModelObject() instanceof IIndex) {
                IIndex oIndex = (IIndex)ev.getModelObject();
                List lNodes = IndexTreeModel.this.findNodes(oIndex.getID());
                if (lNodes == null || lNodes.size() == 0) {
                    return;
                }
                IndexTreeNode nodeIndex = (IndexTreeNode)((Object)lNodes.get(0));
                nodeIndex.rename(oIndex.getName());
                IndexTreeModel.this.nodeChanged((TreeNode)((Object)nodeIndex));
            } else if (sType == "Index:ClusterChanged") {
                IIndex oIndex = (IIndex)ev.getModelObject();
                if (IndexTreeModel.this.m_oTable.getIndexesList().contains(oIndex)) {
                    IndexTreeModel.this.m_iClusteredCount = IndexTreeModel.this.m_iClusteredCount + (oIndex.isClustered() ? 1 : -1);
                }
            }
        }
    }

    public class IndexTreeNode
    extends AbstractTreeNode
    implements IDataTreeNode {
        protected boolean m_bIndex;
        protected IIndex m_oIndex;
        protected IColumn m_oColumn;

        public IndexTreeNode(IIndex oIndex) {
            super((Object)oIndex.getName());
            this.m_oIndex = oIndex;
            this.m_bIndex = true;
            this.setSorted(false);
        }

        public IndexTreeNode(IColumn oColumn) {
            super((Object)oColumn.getName());
            this.m_oColumn = oColumn;
            this.m_bIndex = false;
            this.setSorted(false);
            this.setAllowsChildren(false);
        }

        public boolean isIndex() {
            return this.m_bIndex;
        }

        public IColumn getColumn() {
            return this.m_oColumn;
        }

        public IIndex getIndex() {
            return this.m_oIndex;
        }

        public boolean delete() {
            return false;
        }

        public Object getData() {
            return this.m_bIndex ? this.m_oIndex : this.m_oColumn;
        }

        public String getID() {
            return this.m_bIndex ? this.m_oIndex.getID() : this.m_oColumn.getID();
        }

        public String getType() {
            return null;
        }

        public boolean isDeleteAllowed() {
            return true;
        }

        public boolean isRenameAllowed() {
            return this.m_bIndex;
        }

        public boolean isValidName(String sNewName) {
            if (this.m_bIndex && !IndexTreeModel.this.isIndexNameUnique(sNewName, this)) {
                return false;
            }
            return sNewName != null && sNewName.length() > 0;
        }

        public void rename(String sNewName) {
            if (this.m_bIndex) {
                this.m_oIndex.setName(sNewName);
            } else {
                this.m_oColumn.setName(sNewName);
            }
            this.setUserObject(sNewName);
        }

        public void update() {
        }

        public Icon getIcon() {
            return this.m_bIndex ? AppIconFactory.getInstance().getIconForPrivateType("Type:Index") : ColumnUIUtilities.getTypeIcon(this.m_oColumn);
        }

        public boolean isFolder() {
            return this.m_bIndex;
        }

        public String getName() {
            return this.m_bIndex ? this.m_oIndex.getName() : this.m_oColumn.getName();
        }
    }
}

