/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IIndex;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.dbmstypes.SASType;
import com.sas.etl.models.data.dbmstypes.TERADATAType;
import com.sas.wadmin.visuals.common.ColumnsTableModel;
import com.sas.wadmin.visuals.common.IndexTreeModel;
import com.sas.workspace.DNDObject;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsActionContext;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsDefaultClipboardOwner;
import com.sas.workspace.WsDragSourceAdapter;
import com.sas.workspace.WsPopupMenuRequestListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.tree.ITreeModel;
import com.sas.workspace.models.tree.ITreeNode;
import com.sas.workspace.visuals.tree.AbstractBaseTree;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class IndexTree
extends AbstractBaseTree {
    private static WAdminResource bundle = WAdminResource.getBundle(IndexTree.class);
    public static final String UNIQUE = "Unique";
    public static final String NOMISS = "NoMiss";
    public static final String CLUSTERED = "Clustered";
    public static final String PRIMARY = "Primary";
    public static final String ASYNCINDEX = "ASYNCINDEX";
    protected IPhysicalTable m_oTable;
    protected ColumnsTableModel m_mdlTable;
    protected IndexTreeModel m_mdlIndexes;
    protected WsPopupMenuRequestListener m_lsnrPopupMenuRequest;
    protected boolean m_bDragInProgress;
    protected boolean m_bNonDefaultDND;
    protected IndexTreeModel.IndexTreeNode[] m_aDragNodes;

    public IndexTree(IndexTreeModel mdlIndexes, ColumnsTableModel mdlTable) {
        super((ITreeModel)mdlIndexes);
        this.setUI(this.createUI());
        new DropTarget((Component)((Object)this), 3, this.createDropTargetListener(), true);
        this.createDragGestureRecognizer();
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.setAutoscrolls(true);
        this.setScrollsOnExpand(true);
        this.setSelectionModel(this.createSelectionModel());
        this.m_mdlIndexes = mdlIndexes;
        this.m_mdlTable = mdlTable;
    }

    protected WsActionContextInterface createActionContext() {
        return new WsActionContext("IndexesTab", (WsSelectionProvider)this);
    }

    public boolean isDragInProgress() {
        return this.m_bDragInProgress;
    }

    public void setMetadataTable(IPhysicalTable oTable) {
        this.m_oTable = oTable;
    }

    public IPhysicalTable getMetadataTable() {
        return this.m_oTable;
    }

    public void setPopupMenuRequestListener(WsPopupMenuRequestListener lsnrPopupMenuRequest) {
        this.m_lsnrPopupMenuRequest = lsnrPopupMenuRequest;
    }

    public WsPopupMenuRequestListener getPopupMenuRequestListener() {
        return this.m_lsnrPopupMenuRequest;
    }

    protected void firePopupMenuRequested(MouseEvent e) {
        if (this.m_lsnrPopupMenuRequest != null) {
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    protected void onPopup(Component component, int x, int y) {
        if (this.isContextMenusEnabled()) {
            if (!this.isEnabled() || this.m_lsnrPopupMenuRequest == null) {
                return;
            }
            Point pt = new Point(x, y);
            pt = SwingUtilities.convertPoint((Component)((Object)this), pt, component);
            MouseEvent e = new MouseEvent(component, 501, 0L, 0, pt.x, pt.y, 1, true);
            this.m_lsnrPopupMenuRequest.popupMenuRequested(e);
        }
    }

    public void addNewIndex() {
        if (!this.stopNodeEditing()) {
            return;
        }
        IIndex oIndex = this.m_mdlIndexes.createIndex();
        if (oIndex != null) {
            List lIndex = this.m_mdlIndexes.findNodes(oIndex.getID());
            IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)lIndex.get(0));
            TreePath pathIndex = new TreePath(nodeIndex.getPath());
            this.setSelectionPath(pathIndex);
            this.scrollPathToVisible(pathIndex);
            this.startEditingAtPath(pathIndex);
        } else {
            MessageUtil.displayMessage((String)bundle.getString("IndexTree.CouldNotCreateIndex.txt"), (int)0);
        }
    }

    public void renameSelectedIndex() {
        IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        TreePath pathIndex = new TreePath(nodeIndex.getPath());
        this.startEditingAtPath(pathIndex);
    }

    public boolean isIndexSelected() {
        IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        return nodeIndex != null && nodeIndex.isIndex();
    }

    public void setSelectedIndexProperty(String sProperty, boolean bValue) {
        IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        this.setIndexProperty(nodeIndex.getIndex(), sProperty, bValue);
    }

    public boolean getSelectedIndexProperty(String sProperty) {
        IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        return this.getIndexProperty(nodeIndex.getIndex(), sProperty);
    }

    public void cut() {
        this.copy();
        this.deleteSelectedNodes();
    }

    public void copy() {
        DNDObject clipColumns = new DNDObject();
        TreePath[] aPaths = this.getSelectionPaths();
        int nPaths = aPaths.length;
        for (int iPath = 0; iPath < nPaths; ++iPath) {
            IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)aPaths[iPath].getLastPathComponent());
            clipColumns.add((Object)nodeColumn.getColumn());
        }
        this.getToolkit().getSystemClipboard().setContents((Transferable)clipColumns, (ClipboardOwner)new WsDefaultClipboardOwner());
    }

    public void paste() {
        List lColumns = this.getListFromTransferable(this.getToolkit().getSystemClipboard().getContents((Object)this));
        if (lColumns == null) {
            return;
        }
        IndexTreeModel.IndexTreeNode nodeSelected = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        IndexTreeModel.IndexTreeNode nodeIndex = this.getIndexNodeForNode(nodeSelected);
        this.expandPath(this.getSelectionPath());
        if (this.validateColumns(lColumns, nodeIndex, true)) {
            int iInsertIndex = this.getInsertIndex(nodeIndex, nodeSelected);
            this.addColumnsToModel(lColumns, nodeIndex.getIndex(), iInsertIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSelectedNodes() {
        TreePath[] aPaths = this.getSelectionPaths();
        int nPaths = aPaths.length;
        this.m_oTable.getModel().startCompoundUndoable();
        try {
            IIndex oIndex;
            IndexTreeModel.IndexTreeNode node;
            for (int iPath = 0; iPath < nPaths - 1; ++iPath) {
                node = (IndexTreeModel.IndexTreeNode)((Object)aPaths[iPath].getLastPathComponent());
                IIndex iIndex = oIndex = node.isIndex() ? node.getIndex() : this.getIndexNodeForNode(node).getIndex();
                if (this.isPrimaryKeyUsingIndex(oIndex)) {
                    MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
                    return;
                }
                if (node.isIndex()) {
                    this.removeIndexFromModel(node.getIndex());
                    continue;
                }
                this.removeColumnFromModel(node.getColumn(), this.getIndexNodeForNode(node).getIndex());
            }
            node = (IndexTreeModel.IndexTreeNode)((Object)aPaths[nPaths - 1].getLastPathComponent());
            IIndex iIndex = oIndex = node.isIndex() ? node.getIndex() : this.getIndexNodeForNode(node).getIndex();
            if (this.isPrimaryKeyUsingIndex(oIndex)) {
                MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
                return;
            }
            IndexTreeModel.IndexTreeNode nodeToSelect = (IndexTreeModel.IndexTreeNode)((Object)node.getNextSibling());
            if (nodeToSelect == null) {
                nodeToSelect = (IndexTreeModel.IndexTreeNode)((Object)node.getPreviousSibling());
            }
            if (nodeToSelect == null && !node.isIndex()) {
                nodeToSelect = (IndexTreeModel.IndexTreeNode)((Object)node.getParent());
            }
            if (node.isIndex()) {
                this.removeIndexFromModel(node.getIndex());
            } else {
                this.removeColumnFromModel(node.getColumn(), this.getIndexNodeForNode(node).getIndex());
            }
            if (nodeToSelect != null) {
                this.setSelectionPath(new TreePath(nodeToSelect.getPath()));
            }
        }
        finally {
            this.m_oTable.getModel().endCompoundUndoable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSelectedColumnsUp() {
        int[] aRows = this.getSelectionRows();
        Arrays.sort(aRows);
        int nRows = aRows.length;
        this.m_oTable.getModel().startCompoundUndoable();
        try {
            int iRow = 0;
            while (iRow < nRows) {
                IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)this.getPathForRow(aRows[iRow]).getLastPathComponent());
                IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)nodeColumn.getParent());
                int iColumn = nodeIndex.getIndex((TreeNode)((Object)nodeColumn));
                if (this.isPrimaryKeyUsingIndex(nodeIndex.getIndex())) {
                    MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)nodeIndex.getIndex().getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
                    return;
                }
                this.removeColumnFromModel(nodeColumn.getColumn(), nodeIndex.getIndex());
                this.addColumnToModel(nodeColumn.getColumn(), nodeIndex.getIndex(), iColumn - 1);
                int n = iRow++;
                aRows[n] = aRows[n] - 1;
            }
        }
        finally {
            this.m_oTable.getModel().endCompoundUndoable();
        }
        this.setSelectionRows(aRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveSelectedColumnsDown() {
        int[] aRows = this.getSelectionRows();
        Arrays.sort(aRows);
        int nRows = aRows.length;
        this.m_oTable.getModel().startCompoundUndoable();
        try {
            int iRow = nRows - 1;
            while (iRow >= 0) {
                IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)this.getPathForRow(aRows[iRow]).getLastPathComponent());
                IndexTreeModel.IndexTreeNode nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)nodeColumn.getParent());
                int iColumn = nodeIndex.getIndex((TreeNode)((Object)nodeColumn));
                if (this.isPrimaryKeyUsingIndex(nodeIndex.getIndex())) {
                    MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)nodeIndex.getIndex().getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
                    return;
                }
                this.removeColumnFromModel(nodeColumn.getColumn(), nodeIndex.getIndex());
                this.addColumnToModel(nodeColumn.getColumn(), nodeIndex.getIndex(), iColumn + 1);
                int n = iRow--;
                aRows[n] = aRows[n] + 1;
            }
        }
        finally {
            this.m_oTable.getModel().endCompoundUndoable();
        }
        this.setSelectionRows(aRows);
    }

    public void addColumns(List lColumns) {
        IndexTreeModel.IndexTreeNode nodeSelected = (IndexTreeModel.IndexTreeNode)((Object)this.getLastSelectedPathComponent());
        IndexTreeModel.IndexTreeNode nodeIndex = this.getIndexNodeForNode(nodeSelected);
        if (nodeIndex.getIndex() != null) {
            // empty if block
        }
        this.expandPath(this.getSelectionPath());
        if (this.validateColumns(lColumns, nodeIndex, false)) {
            int iInsertIndex = this.getInsertIndex(nodeIndex, nodeSelected);
            this.addColumnsToModel(lColumns, nodeIndex.getIndex(), iInsertIndex);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean validateData() {
        if (!this.stopNodeEditing()) {
            return false;
        }
        boolean bSASTable = this.m_oTable.getDBMSType() instanceof SASType;
        boolean bTeradata = this.m_oTable.getDBMSType() instanceof TERADATAType;
        ArrayList<IColumn> lSimpleColumns = new ArrayList<IColumn>();
        ArrayList<String> iPrimarys = new ArrayList<String>();
        ITreeNode nodeRoot = this.getRoot();
        int nIndexes = nodeRoot.getChildCount();
        int iIndex = 0;
        while (true) {
            IIndex oIndex;
            block15: {
                String sIndex;
                String sMessage;
                int nColumns;
                IndexTreeModel.IndexTreeNode nodeIndex;
                block16: {
                    block13: {
                        block14: {
                            boolean bPrimaryKeyUsingIndex;
                            if (iIndex >= nIndexes) break block13;
                            nodeIndex = (IndexTreeModel.IndexTreeNode)((Object)nodeRoot.getChildAt(iIndex));
                            oIndex = nodeIndex.getIndex();
                            if (oIndex != null && (bPrimaryKeyUsingIndex = this.isPrimaryKeyUsingIndex(oIndex)) && !oIndex.isUnique()) {
                                int answer = MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexUniqueError.txt", (Object)nodeIndex.getIndex().getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)1, (int)0);
                                if (answer == 0) {
                                    oIndex.setUnique(true);
                                    return true;
                                }
                                return false;
                            }
                            nColumns = nodeIndex.getChildCount();
                            if (nColumns == 0) {
                                this.setSelectionPath(new TreePath(nodeIndex.getPath()));
                                String sMessage2 = bundle.formatString("IndexTree.EmptyIndexError.fmt", (Object)nodeIndex.getName());
                                MessageUtil.displayMessage((String)sMessage2, (int)0);
                                return false;
                            }
                            if (nColumns != 1) break block14;
                            if (bSASTable) {
                                IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)nodeIndex.getChildAt(0));
                                IColumn oColumn = nodeColumn.getColumn();
                                if (lSimpleColumns.contains(oColumn)) {
                                    this.setSelectionPath(new TreePath(nodeColumn.getPath()));
                                    String sMessage3 = bundle.formatString("IndexTree.ColumnInMultipleSimpleIndexes.fmt", (Object)nodeColumn.getName());
                                    MessageUtil.displayMessage((String)sMessage3, (int)0);
                                    return false;
                                }
                                lSimpleColumns.add(oColumn);
                                String sIndex2 = nodeIndex.getName();
                                String sColumn = nodeColumn.getName();
                                if (!sIndex2.equals(sColumn)) {
                                    this.setSelectionPath(new TreePath(nodeIndex.getPath()));
                                    if (!this.m_mdlIndexes.isIndexNameUnique(sColumn, null)) {
                                        sMessage = bundle.formatString("IndexTree.SimpleIndexError.fmt", (Object)sIndex2, (Object)sColumn);
                                        MessageUtil.displayMessage((String)sMessage, (int)0);
                                        return false;
                                    }
                                    sMessage = bundle.formatString("IndexTree.RenameSimpleIndex.fmt", (Object)sIndex2, (Object)sColumn);
                                    int eAnswer = MessageUtil.displayMessage((String)sMessage, (int)2, (int)0);
                                    if (eAnswer != 0) {
                                        return false;
                                    }
                                    nodeIndex.rename(sColumn);
                                    this.m_mdlIndexes.nodeChanged((TreeNode)((Object)nodeIndex));
                                }
                            }
                            break block15;
                        }
                        if (!bSASTable) break block15;
                        sIndex = nodeIndex.getName();
                        break block16;
                    }
                    if (bTeradata && iPrimarys.size() > 1) {
                        MessageUtil.displayListMessage((String)bundle.getString("IndexTree.TooManyPrimaryIndexes.txt"), iPrimarys);
                        return false;
                    }
                    return true;
                }
                for (int i = 0; i < nColumns; ++i) {
                    IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)nodeIndex.getChildAt(i));
                    IColumn oColumn = nodeColumn.getColumn();
                    if (!sIndex.equalsIgnoreCase(oColumn.getName())) continue;
                    sMessage = bundle.formatString("IndexTree.InvalidCompositeIndexName.txt", (Object)sIndex);
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
            }
            if (oIndex != null && oIndex.isPrimary()) {
                iPrimarys.add(oIndex.getName());
            }
            ++iIndex;
        }
    }

    private boolean isPrimaryKeyUsingIndex(IIndex oIndex) {
        IKey oKey = this.m_oTable.getPrimaryKey();
        if (oKey == null || oIndex == null) {
            return false;
        }
        IIndex[] aIndexes = this.m_oTable.getIndexes();
        boolean hasDifferentMatchingIndex = false;
        for (int iIndex = 0; iIndex < aIndexes.length; ++iIndex) {
            if (aIndexes[iIndex] == oIndex || !this.m_oTable.indexMatchesUniqueKey(aIndexes[iIndex], oKey)) continue;
            hasDifferentMatchingIndex = true;
            break;
        }
        if (hasDifferentMatchingIndex) {
            return false;
        }
        List alCols1 = oKey.getColumnsList();
        List alCols2 = oIndex.getColumnsList();
        if (alCols1 != null && alCols2 != null && oKey.getColumnsList().size() != oIndex.getColumnsList().size()) {
            return false;
        }
        for (int iCol = 0; iCol < alCols1.size(); ++iCol) {
            if (alCols2.contains(alCols1.get(0))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnsToModel(List lColumns, IIndex oIndex, int iStartIndex) {
        if (this.isPrimaryKeyUsingIndex(oIndex)) {
            MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
            return;
        }
        this.m_oTable.getModel().startCompoundUndoable();
        try {
            for (int iCol = 0; iCol < lColumns.size(); ++iCol) {
                oIndex.getColumnsList().add(iStartIndex + iCol, lColumns.get(iCol));
            }
        }
        finally {
            this.m_oTable.getModel().endCompoundUndoable();
        }
    }

    private void addColumnToModel(IColumn oColumn, IIndex oIndex, int iStartIndex) {
        if (this.isPrimaryKeyUsingIndex(oIndex)) {
            MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
            return;
        }
        oIndex.getColumnsList().add(iStartIndex, oColumn);
    }

    private void removeColumnFromModel(IColumn oColumn, IIndex oIndex) {
        if (this.isPrimaryKeyUsingIndex(oIndex)) {
            MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
            return;
        }
        oIndex.getColumnsList().remove(oColumn);
    }

    private void removeIndexFromModel(IIndex oIndex) {
        if (this.isPrimaryKeyUsingIndex(oIndex)) {
            MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)oIndex.getName(), (Object)this.m_oTable.getPrimaryKey().getName()), (int)0);
            return;
        }
        this.m_oTable.getIndexesList().remove(oIndex);
    }

    private void setIndexProperty(IIndex oIndex, String sProperty, boolean bValue) {
        if (sProperty.equals(UNIQUE)) {
            oIndex.setUnique(bValue);
        } else if (sProperty.equals(CLUSTERED)) {
            oIndex.setClustered(bValue);
        } else if (sProperty.equals(NOMISS)) {
            oIndex.setNoMissingValues(bValue);
        } else if (sProperty.equals(PRIMARY)) {
            oIndex.setPrimary(bValue);
        } else if (sProperty.equals(ASYNCINDEX)) {
            oIndex.setUserProperty(ASYNCINDEX, bValue ? "Yes" : "No");
        }
    }

    private boolean getIndexProperty(IIndex oIndex, String sProperty) {
        if (sProperty.equals(UNIQUE)) {
            return oIndex.isUnique();
        }
        if (sProperty.equals(CLUSTERED)) {
            return oIndex.isClustered();
        }
        if (sProperty.equals(NOMISS)) {
            return oIndex.isNoMissingValues();
        }
        if (sProperty.equals(PRIMARY)) {
            return oIndex.isPrimary();
        }
        if (sProperty.equals(ASYNCINDEX)) {
            return "Yes".equals(oIndex.getUserProperty(ASYNCINDEX));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeColumnNodes(IndexTreeModel.IndexTreeNode[] nodes) {
        this.m_oTable.getModel().startCompoundUndoable();
        try {
            for (int iNode = 0; iNode < nodes.length; ++iNode) {
                IndexTreeModel.IndexTreeNode node = nodes[iNode];
                this.removeColumnFromModel(node.getColumn(), this.getIndexNodeForNode(node).getIndex());
            }
        }
        finally {
            this.m_oTable.getModel().endCompoundUndoable();
        }
    }

    protected ITreeNode getRoot() {
        return (ITreeNode)this.m_mdlIndexes.getRoot();
    }

    protected boolean stopNodeEditing() {
        this.stopEditing();
        return !this.isEditing();
    }

    protected void insertNodeImpl(IndexTreeModel.IndexTreeNode nodeChild, IndexTreeModel.IndexTreeNode nodeParent, int iInsert) {
        this.cancelEditing();
        this.m_mdlIndexes.insertNodeInto((MutableTreeNode)((Object)nodeChild), (MutableTreeNode)((Object)nodeParent), iInsert);
    }

    protected void removeNodeImpl(IndexTreeModel.IndexTreeNode node) {
        this.cancelEditing();
        this.m_mdlIndexes.removeNodeFromParent((MutableTreeNode)((Object)node));
    }

    protected List getListFromTransferable(Transferable t) {
        if (t.isDataFlavorSupported(DNDObject.dndObjectDataFlavor)) {
            try {
                return (List)t.getTransferData(DNDObject.dndObjectDataFlavor);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected IndexTreeModel.IndexTreeNode getIndexNodeForNode(IndexTreeModel.IndexTreeNode node) {
        if (node.isIndex()) {
            return node;
        }
        return (IndexTreeModel.IndexTreeNode)((Object)node.getParent());
    }

    protected int getInsertIndex(IndexTreeModel.IndexTreeNode nodeIndex, IndexTreeModel.IndexTreeNode nodeInsertBefore) {
        if (nodeIndex == nodeInsertBefore) {
            return 0;
        }
        return nodeIndex.getIndex((TreeNode)((Object)nodeInsertBefore));
    }

    protected boolean validateColumns(List lColumns, IndexTreeModel.IndexTreeNode nodeIndex, boolean bExternal) {
        String sTableFQID = this.m_oTable.getID();
        int nSourceColumns = lColumns.size();
        for (int iSourceColumn = 0; iSourceColumn < nSourceColumns; ++iSourceColumn) {
            String sColumnTableFQID;
            Object obj = lColumns.get(iSourceColumn);
            if (bExternal && !(obj instanceof IColumn)) {
                String sMessage = bundle.getString("IndexTree.InvalidTypeError.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            IColumn oColumn = (IColumn)obj;
            if (bExternal && !sTableFQID.equals(sColumnTableFQID = oColumn.getTable().getID())) {
                String sMessage = bundle.getString("IndexTree.InvalidTableError.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            String sColumnFQID = oColumn.getID();
            int nIndexColumns = nodeIndex.getChildCount();
            for (int iIndexColumn = 0; iIndexColumn < nIndexColumns; ++iIndexColumn) {
                IndexTreeModel.IndexTreeNode nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)nodeIndex.getChildAt(iIndexColumn));
                if (!sColumnFQID.equals(nodeColumn.getColumn().getID())) continue;
                String sMessage = bundle.formatString("IndexTree.DuplicateColumnError.fmt", (Object)nodeColumn.getColumn().getName());
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
        }
        return true;
    }

    protected DragGestureRecognizer createDragGestureRecognizer() {
        return new cDragGestureRecognizer(new DragSource(), (Component)((Object)this), 3, this.createDragGestureListener());
    }

    protected DragGestureListener createDragGestureListener() {
        return new cDragGestureListener();
    }

    protected DragSourceListener createDragSourceListener() {
        return new cDragSourceListener();
    }

    protected DropTargetListener createDropTargetListener() {
        return new cDropTargetListener();
    }

    protected TreeUI createUI() {
        return new cIndexTreeUI();
    }

    protected TreeSelectionModel createSelectionModel() {
        return new cSelectionModel();
    }

    protected DefaultCellEditor createCellEditor(JTextField txt) {
        return new cCellEditor(txt);
    }

    protected cNonDefaultDNDMenu createNonDefaultDNDMenu(List lColumns, IndexTreeModel.IndexTreeNode[] aRemoveNodes) {
        return new cNonDefaultDNDMenu(lColumns, aRemoveNodes);
    }

    protected class cDragGestureRecognizer
    extends MouseDragGestureRecognizer {
        static final int dragThreshold = 5;
        protected static final int ButtonMask = 20;
        protected static final int KeysMask = 3;

        protected cDragGestureRecognizer(DragSource src, Component cmp, int fActions, DragGestureListener lsnrDragGesture) {
            super(src, cmp, fActions, lsnrDragGesture);
        }

        protected int mapDragOperationFromModifiers(MouseEvent e) {
            int fAllModifiers = e.getModifiers();
            if ((fAllModifiers & 0xFFFFFFE8) != 0) {
                return 0;
            }
            int fButtons = fAllModifiers & 0x14;
            if (fButtons == 16 || fButtons == 4) {
                int fKeys = fAllModifiers & 3;
                if (fKeys == 0) {
                    return 2;
                }
                if (fKeys == 3) {
                    return 0x40000000;
                }
                if (fKeys == 2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!this.events.isEmpty()) {
                int opDrag = this.mapDragOperationFromModifiers(e);
                if (opDrag == 0) {
                    return;
                }
                MouseEvent evtTrigger = (MouseEvent)this.events.get(0);
                Point ptTrigger = evtTrigger.getPoint();
                Point ptCurrent = e.getPoint();
                int dx = Math.abs(ptTrigger.x - ptCurrent.x);
                int dy = Math.abs(ptTrigger.y - ptCurrent.y);
                if (dx > 5 || dy > 5) {
                    this.fireDragGestureRecognized(opDrag, ptTrigger);
                } else {
                    this.appendEvent(e);
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.events.clear();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.events.clear();
            if (this.mapDragOperationFromModifiers(e) != 0) {
                this.appendEvent(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.events.clear();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (!this.events.isEmpty()) {
                int dragAction = this.mapDragOperationFromModifiers(e);
                if (dragAction != 0) {
                    this.appendEvent(e);
                    this.fireDragGestureRecognized(dragAction, ((MouseEvent)this.getTriggerEvent()).getPoint());
                } else {
                    this.events.clear();
                }
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class cDragGestureListener
    implements DragGestureListener {
        protected cDragGestureListener() {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent e) {
            TreePath[] aPaths;
            if (!IndexTree.this.isEditable()) {
                return;
            }
            InputEvent ie = e.getTriggerEvent();
            if (ie.isControlDown() || ie.isShiftDown()) {
                return;
            }
            if (ie instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)ie;
                Point pt = me.getPoint();
                if (IndexTree.this.getPathForLocation(pt.x, pt.y) == null) {
                    return;
                }
            }
            if ((aPaths = IndexTree.this.getSelectionPaths()) == null) {
                return;
            }
            IndexTreeModel.IndexTreeNode nodeSelected = (IndexTreeModel.IndexTreeNode)((Object)aPaths[0].getLastPathComponent());
            if (nodeSelected.isRoot() || nodeSelected.isIndex()) {
                return;
            }
            IndexTree.this.m_bNonDefaultDND = (ie.getModifiers() & 4) == 4;
            IndexTree.this.m_aDragNodes = new IndexTreeModel.IndexTreeNode[aPaths.length];
            DNDObject dragColumns = new DNDObject();
            int nPaths = aPaths.length;
            for (int iPath = 0; iPath < nPaths; ++iPath) {
                IndexTreeModel.IndexTreeNode nodeColumn;
                IndexTree.this.m_aDragNodes[iPath] = nodeColumn = (IndexTreeModel.IndexTreeNode)((Object)aPaths[iPath].getLastPathComponent());
                dragColumns.add((Object)nodeColumn.getColumn());
            }
            e.getDragSource().startDrag(e, null, (Transferable)dragColumns, IndexTree.this.createDragSourceListener());
        }
    }

    protected class cDragSourceListener
    extends WsDragSourceAdapter {
        protected cDragSourceListener() {
        }

        public void dragDropEnd(DragSourceDropEvent e) {
            IndexTree.this.m_bNonDefaultDND = false;
            IndexTree.this.m_aDragNodes = null;
        }
    }

    protected class cDropTargetListener
    implements DropTargetListener {
        protected cDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            IndexTree.this.clearSelection();
            e.acceptDrag(0);
            IndexTree.this.m_bDragInProgress = true;
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            IndexTree.this.m_bDragInProgress = false;
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            WsUIUtilities.autoscrollForDragEvent((DropTargetDragEvent)e);
            IndexTreeModel.IndexTreeNode node = this.getDropTargetNode(e.getLocation());
            if (node == null) {
                e.rejectDrag();
            } else if (IndexTree.this.m_aDragNodes == null) {
                e.acceptDrag(1);
            } else {
                e.acceptDrag(e.getDropAction());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void drop(DropTargetDropEvent e) {
            List lColumns;
            IndexTree.this.m_bDragInProgress = false;
            Point ptDrop = e.getLocation();
            IndexTreeModel.IndexTreeNode node = this.getDropTargetNode(ptDrop);
            if (node != null && (lColumns = IndexTree.this.getListFromTransferable(e.getTransferable())) != null) {
                boolean bSame;
                boolean bMove;
                boolean bExternal;
                IndexTreeModel.IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(node);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, node);
                if (IndexTree.this.m_bNonDefaultDND) {
                    IndexTree.this.m_bNonDefaultDND = false;
                    boolean bSameIndex = IndexTree.this.m_aDragNodes[0].getParent() == nodeIndex;
                    cNonDefaultDNDMenu mnu = IndexTree.this.createNonDefaultDNDMenu(lColumns, IndexTree.this.m_aDragNodes);
                    mnu.setCopyEnabled(!bSameIndex);
                    mnu.show((Component)((Object)IndexTree.this), ptDrop.x, ptDrop.y);
                    e.acceptDrop(e.getDropAction());
                    IndexTree.this.m_aDragNodes = null;
                    return;
                }
                boolean bl = bExternal = IndexTree.this.m_aDragNodes == null;
                if (!bExternal) {
                    bMove = (e.getDropAction() & 2) != 0;
                    bSame = IndexTree.this.m_aDragNodes[0].getParent() == nodeIndex;
                } else {
                    bMove = false;
                    bSame = false;
                }
                if (bExternal || !bMove || !bSame) {
                    IndexTree.this.expandPath(IndexTree.this.getSelectionPath());
                    if (!IndexTree.this.validateColumns(lColumns, nodeIndex, bExternal)) {
                        e.rejectDrop();
                        return;
                    }
                }
                e.acceptDrop(bMove ? 2 : 1);
                IndexTree.this.m_oTable.getModel().startCompoundUndoable();
                try {
                    IndexTreeModel.IndexTreeNode nodeIndexSource;
                    if (bMove && IndexTree.this.isPrimaryKeyUsingIndex((nodeIndexSource = IndexTree.this.getIndexNodeForNode(IndexTree.this.m_aDragNodes[0])).getIndex())) {
                        MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)nodeIndexSource.getIndex().getName(), (Object)IndexTree.this.m_oTable.getPrimaryKey().getName()), (int)0);
                        return;
                    }
                    if (IndexTree.this.isPrimaryKeyUsingIndex(nodeIndex.getIndex())) {
                        MessageUtil.displayMessage((String)bundle.formatString("IndexTree.PrimaryKeyIndexError.txt", (Object)nodeIndex.getIndex().getName(), (Object)IndexTree.this.m_oTable.getPrimaryKey().getName()), (int)0);
                        return;
                    }
                    if (bMove) {
                        IndexTree.this.removeColumnNodes(IndexTree.this.m_aDragNodes);
                    }
                    IndexTree.this.addColumnsToModel(lColumns, nodeIndex.getIndex(), iInsertIndex);
                }
                finally {
                    IndexTree.this.m_oTable.getModel().endCompoundUndoable();
                }
                IndexTree.this.m_aDragNodes = null;
                return;
            }
            e.rejectDrop();
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        protected IndexTreeModel.IndexTreeNode getDropTargetNode(Point pt) {
            IndexTreeModel.IndexTreeNode node;
            TreePath path = IndexTree.this.getPathForLocation(pt.x, pt.y);
            if (path != null && !(node = (IndexTreeModel.IndexTreeNode)((Object)path.getLastPathComponent())).isRoot()) {
                IndexTree.this.setSelectionPath(path);
                return node;
            }
            IndexTree.this.clearSelection();
            return null;
        }
    }

    protected class cIndexTreeUI
    extends BasicTreeUI {
        protected cIndexTreeUI() {
        }

        @Override
        protected MouseListener createMouseListener() {
            return new cMouseHandler();
        }

        public class cMouseHandler
        extends BasicTreeUI.MouseHandler {
            public cMouseHandler() {
                super(cIndexTreeUI.this);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!cIndexTreeUI.this.tree.isEnabled()) {
                    return;
                }
                if (cIndexTreeUI.this.tree.isEditing() && !cIndexTreeUI.this.tree.stopEditing()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    this.triggerPopup(e);
                    return;
                }
                if (cIndexTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                    cIndexTreeUI.this.tree.requestFocus();
                } else {
                    super.mousePressed(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!cIndexTreeUI.this.tree.isEnabled()) {
                    return;
                }
                if (e.isPopupTrigger()) {
                    this.triggerPopup(e);
                    return;
                }
                if (cIndexTreeUI.this.tree.getSelectionCount() > 1 && !e.isControlDown() && !e.isShiftDown() && this.isPointOnSelectedPath(e.getPoint())) {
                    MouseEvent ePressed = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), false, e.getButton());
                    super.mousePressed(ePressed);
                }
                super.mouseReleased(e);
            }

            protected boolean isPointOnSelectedPath(Point pt) {
                TreePath path = IndexTree.this.getPathForLocation(pt.x, pt.y);
                return path != null && cIndexTreeUI.this.tree.isPathSelected(path);
            }

            protected void triggerPopup(MouseEvent e) {
                TreePath path = IndexTree.this.getPathForLocation(e.getX(), e.getY());
                if (path != null && !cIndexTreeUI.this.tree.isPathSelected(path)) {
                    cIndexTreeUI.this.tree.setSelectionPath(path);
                }
                IndexTree.this.firePopupMenuRequested(e);
            }
        }
    }

    protected class cSelectionModel
    extends DefaultTreeSelectionModel {
        protected cSelectionModel() {
        }

        @Override
        public void addSelectionPaths(TreePath[] aPaths) {
            Object node = (IndexTreeModel.IndexTreeNode)((Object)IndexTree.this.getLastSelectedPathComponent());
            if (node == null) {
                node = (TreeNode)aPaths[0].getLastPathComponent();
            }
            if (!this.isSelectionValid(aPaths, node.getParent())) {
                this.setSelectionToFirstPath(aPaths);
            } else {
                super.addSelectionPaths(aPaths);
            }
        }

        @Override
        public void setSelectionPaths(TreePath[] aPaths) {
            if (!this.isSelectionValid(aPaths, ((TreeNode)aPaths[0].getLastPathComponent()).getParent())) {
                this.setSelectionToFirstPath(aPaths);
            } else {
                super.setSelectionPaths(aPaths);
            }
        }

        protected boolean isSelectionValid(TreePath[] aPaths, TreeNode nodeParent) {
            int nPaths = aPaths.length;
            for (int iPath = 0; iPath < nPaths; ++iPath) {
                IndexTreeModel.IndexTreeNode nodeTest = (IndexTreeModel.IndexTreeNode)((Object)aPaths[iPath].getLastPathComponent());
                if (nodeTest.getParent() == nodeParent) continue;
                return false;
            }
            return true;
        }

        protected void setSelectionToFirstPath(TreePath[] aPaths) {
            TreePath[] aNewPaths = new TreePath[]{aPaths[0]};
            super.setSelectionPaths(aNewPaths);
        }
    }

    protected class cCellEditor
    extends DefaultCellEditor {
        public cCellEditor(JTextField txt) {
            super(txt);
            this.setClickCountToStart(1);
        }

        @Override
        public boolean isCellEditable(EventObject e) {
            if (IndexTree.this.isIndexSelected() && IndexTree.this.getSelectionCount() == 1) {
                return super.isCellEditable(e);
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            String sName = (String)this.getCellEditorValue();
            if (sName.trim().length() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("IndexTree.NoNameError.txt"), (int)0);
                return false;
            }
            IndexTreeModel.IndexTreeNode nodeSelectedIndex = (IndexTreeModel.IndexTreeNode)((Object)IndexTree.this.getLastSelectedPathComponent());
            if (!IndexTree.this.m_mdlIndexes.isIndexNameUnique(sName, nodeSelectedIndex)) {
                MessageUtil.displayMessage((String)bundle.getString("IndexTree.DuplicateNameError.txt"), (int)0);
                return false;
            }
            return super.stopCellEditing();
        }
    }

    protected class cNonDefaultDNDMenu
    extends JPopupMenu {
        WsAbstractAction m_actMove;
        WsAbstractAction m_actCopy;
        WsAbstractAction m_actCancel;
        List m_lColumns;
        IndexTreeModel.IndexTreeNode[] m_aRemoveNodes;

        public cNonDefaultDNDMenu(List lColumns, IndexTreeModel.IndexTreeNode[] aRemoveNodes) {
            this.m_lColumns = lColumns;
            this.m_aRemoveNodes = aRemoveNodes;
            this.m_actMove = this.createMoveAction();
            this.m_actCopy = this.createCopyAction();
            this.m_actCancel = this.createCancelAction();
            this.add((Action)this.m_actMove);
            this.add((Action)this.m_actCopy);
            this.addSeparator();
            this.add((Action)this.m_actCancel);
        }

        public void setCopyEnabled(boolean bEnabled) {
            this.m_actCopy.setEnabled(bEnabled);
        }

        public void setMoveEnabled(boolean bEnabled) {
            this.m_actMove.setEnabled(bEnabled);
        }

        protected WsAbstractAction createCopyAction() {
            return new cCopyAction();
        }

        protected WsAbstractAction createMoveAction() {
            return new cMoveAction();
        }

        protected WsAbstractAction createCancelAction() {
            return new cCancelAction();
        }

        protected class cCopyAction
        extends WsAbstractAction {
            public cCopyAction() {
                super(bundle, "IndexTree.Copy", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                IndexTreeModel.IndexTreeNode nodeDrop = (IndexTreeModel.IndexTreeNode)((Object)IndexTree.this.getSelectionPath().getLastPathComponent());
                IndexTreeModel.IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(nodeDrop);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, nodeDrop);
                if (!IndexTree.this.validateColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, false)) {
                    return;
                }
                IndexTree.this.addColumnsToModel(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex.getIndex(), iInsertIndex);
            }
        }

        protected class cMoveAction
        extends WsAbstractAction {
            public cMoveAction() {
                super(bundle, "IndexTree.Move", false, false);
            }

            public void actionPerformed(ActionEvent e) {
                IndexTreeModel.IndexTreeNode nodeDrop = (IndexTreeModel.IndexTreeNode)((Object)IndexTree.this.getSelectionPath().getLastPathComponent());
                IndexTreeModel.IndexTreeNode nodeIndex = IndexTree.this.getIndexNodeForNode(nodeDrop);
                int iInsertIndex = IndexTree.this.getInsertIndex(nodeIndex, nodeDrop);
                if (cNonDefaultDNDMenu.this.m_aRemoveNodes[0].getParent() != nodeIndex && !IndexTree.this.validateColumns(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex, false)) {
                    return;
                }
                IndexTree.this.addColumnsToModel(cNonDefaultDNDMenu.this.m_lColumns, nodeIndex.getIndex(), iInsertIndex);
                IndexTree.this.removeColumnNodes(cNonDefaultDNDMenu.this.m_aRemoveNodes);
            }
        }

        protected class cCancelAction
        extends WsAbstractAction {
            public cCancelAction() {
                super(bundle, "IndexTree.Cancel", false, false);
            }

            public void actionPerformed(ActionEvent e) {
            }
        }
    }
}

