/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.ILibrary;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.dualselector.DualListSelector;
import com.sas.wadmin.visuals.common.UserDefinedFunctionsModel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractBrowsableTextField;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsAppServerLibraryException;
import com.sas.workspace.WsCompoundIcon;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.visuals.expression.Category;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import com.sas.workspace.visuals.expression.PropertiesFunctionsModel;
import com.sas.workspace.visuals.expression.UserDefinedFunction;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ImportUserDefinedFunctionsPanel
extends WAPanel {
    private static WAdminResource bundle = WAdminResource.getBundle(ImportUserDefinedFunctionsPanel.class);
    private UserDefinedFunctionsModel m_udfModel;
    private DualListSelector m_dlsFunctionSets;
    private DefaultListModel m_lstFunctionSetTypesSource;
    private DefaultListModel m_lstFunctionSetTypesTarget;
    private DualListener m_lsnrFunctionSetTypes;
    private OpRequestUI m_request;
    private JLabel m_lblContainer;
    private WAComboBox m_cmbContainer;
    private PropertiesFunctionsModel m_mdlCategories;
    private ArrayList m_lCategories;
    private ItemListener m_lsnItem;
    private JLabel m_lblLibrary;
    private WsAbstractBrowsableTextField m_txtLibrary;
    private ILibrary m_oLibrary;
    private JButton m_btnPreview;
    private WsAbstractAction m_actPreview;
    private JButton m_btnImport;
    private WsAbstractAction m_actImport;

    public ImportUserDefinedFunctionsPanel() {
        this.initialize();
        this.layoutWidgets();
        this.setHelpProduct("wdb");
        this.setHelpTopic("user_def_function");
    }

    protected void initialize() {
        this.m_udfModel = new UserDefinedFunctionsModel();
        this.m_cmbContainer = new WAComboBox();
        this.m_cmbContainer.setEditable(true);
        this.m_lblContainer = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_cmbContainer, (WAdminResource)bundle, (String)"ImportUserDefinedFunctionsPanel.Label.Container");
        this.m_mdlCategories = this.loadCategories();
        this.m_lCategories = new ArrayList();
        for (int iCategory = 0; iCategory < this.m_mdlCategories.getCategories().length; ++iCategory) {
            Category category = this.m_mdlCategories.getCategories()[iCategory];
            this.m_lCategories.add(category.getName());
        }
        this.m_cmbContainer.addItems((List)this.m_lCategories);
        this.m_lsnItem = new cItemListener();
        this.m_cmbContainer.addItemListener(this.m_lsnItem);
        if (this.m_lCategories.size() > 0) {
            this.m_cmbContainer.setSelectedIndex(0);
            this.m_udfModel.setContainer((String)this.m_lCategories.get(0));
        }
        this.m_txtLibrary = new cLibraryTextField();
        this.m_txtLibrary.getBrowseButton().setToolTipText(bundle.getString("ImportUserDefinedFunctionsPanel.cLibraryTextField.Browse.tip"));
        this.m_txtLibrary.setEditable(false);
        this.m_txtLibrary.getBrowseButton().setEnabled(true);
        this.m_lblLibrary = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_txtLibrary, (WAdminResource)bundle, (String)"ImportUserDefinedFunctionsPanel.LibraryLabel");
        this.m_lstFunctionSetTypesSource = new DefaultListModel();
        this.m_lstFunctionSetTypesTarget = new DefaultListModel();
        this.m_lsnrFunctionSetTypes = new DualListener();
        this.m_lstFunctionSetTypesTarget.addListDataListener(this.m_lsnrFunctionSetTypes);
        this.m_lstFunctionSetTypesSource.addListDataListener(this.m_lsnrFunctionSetTypes);
        this.m_dlsFunctionSets = new DualListSelector();
        this.m_dlsFunctionSets.setPreferredSize(new Dimension(100, 125));
        this.m_dlsFunctionSets.setDragAndDropEnabled(false);
        this.m_dlsFunctionSets.setAlternatingSingleButtonStyle(false);
        this.m_dlsFunctionSets.setModel((ListModel)this.m_lstFunctionSetTypesSource);
        this.m_dlsFunctionSets.setTargetModel((ListModel)this.m_lstFunctionSetTypesTarget);
        this.m_actPreview = new PreviewAction();
        this.m_actImport = new ImportAction();
        this.m_btnPreview = new JButton((Action)this.m_actPreview);
        this.m_btnImport = new JButton((Action)this.m_actImport);
        this.setPreferredSize(new Dimension(450, 500));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel panFunctionSets = new JPanel();
        TitledBorder titledBorder = WsUIUtilities.createTitledBorder((String)bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSetsPanel.title.txt"));
        panFunctionSets.setBorder(titledBorder);
        panFunctionSets.setLayout(new GridBagLayout());
        panFunctionSets.add((Component)this.m_dlsFunctionSets, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblContainer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.add((Component)this.m_cmbContainer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 10, 10), 0, 0));
        JPanel panLibFunctions = new JPanel();
        panLibFunctions.setLayout(new GridBagLayout());
        TitledBorder border = WsUIUtilities.createTitledBorder((String)bundle.getString("ImportUserDefinedFunctionsPanel.LibFunctionsPanel.title.txt"));
        panLibFunctions.setBorder(border);
        panLibFunctions.add((Component)this.m_lblLibrary, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
        panLibFunctions.add((Component)this.m_txtLibrary, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panLibFunctions.add((Component)panFunctionSets, new GridBagConstraints(0, 2, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 10, 0), 0, 0));
        panLibFunctions.add((Component)new JPanel(), new GridBagConstraints(0, 3, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add(panLibFunctions, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 10), 0, 0));
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new GridBagLayout());
        btnPanel.add((Component)this.m_btnPreview, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        btnPanel.add((Component)this.m_btnImport, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 10), 0, 0));
        this.add(btnPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 4, 2, 2, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void loadFunctionSetTypes() {
        ArrayList types = new ArrayList();
        try {
            if (this.m_udfModel.getLibrary() != null) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                types = (ArrayList)this.m_udfModel.getFunctionSetTypes();
                if (this.m_lstFunctionSetTypesSource.size() > 0) {
                    this.m_lstFunctionSetTypesSource.clear();
                }
                if (this.m_lstFunctionSetTypesTarget.size() > 0) {
                    this.m_lstFunctionSetTypesTarget.clear();
                }
                for (int iType = 0; iType < types.size(); ++iType) {
                    this.m_lstFunctionSetTypesSource.addElement((String)types.get(iType));
                }
            }
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private PropertiesFunctionsModel loadCategories() {
        String sUDFunctionsFileName;
        String sTeradataFunctions;
        PropertiesFunctionsModel mdl = new PropertiesFunctionsModel();
        mdl.load(new WAdminResource(ExpressionPanel.class, "Functions"), "SQL.");
        String sExtraFunctions = System.getProperty("ExpressionPanelAdditionalFunctionsPath");
        if (sExtraFunctions != null) {
            try {
                FileInputStream strmExtra = new FileInputStream(sExtraFunctions);
                try {
                    mdl.loadXML((InputStream)strmExtra);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().warn((Object)("Error reading categories:" + ex.getLocalizedMessage()));
                }
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().warn((Object)("Invalid path specified for categories: " + ex.getLocalizedMessage()));
            }
        }
        if ((sTeradataFunctions = System.getProperty("ExpressionPanelTeradataFunctionsPath")) != null) {
            try {
                FileInputStream strmExtra = new FileInputStream(sTeradataFunctions);
                try {
                    mdl.loadXML((InputStream)strmExtra);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().warn((Object)("Error reading categories:" + ex.getLocalizedMessage()));
                }
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().warn((Object)("Invalid path specified for categories: " + ex.getLocalizedMessage()));
            }
        }
        if ((sUDFunctionsFileName = System.getProperty("UserDefinedFunctionsPath")) == null) {
            Workspace.getWorkspace();
            sUDFunctionsFileName = Workspace.getAppDataFilePath((String)"UserDefinedFunctions.xml");
        }
        if (sUDFunctionsFileName != null) {
            try {
                FileInputStream strmUDFs = new FileInputStream(sUDFunctionsFileName);
                try {
                    mdl.loadXML((InputStream)strmUDFs);
                }
                catch (IOException ex) {
                    Workspace.getDefaultLogger().warn((Object)("Error reading additional expression panel functions:" + ex.getLocalizedMessage()));
                }
            }
            catch (FileNotFoundException ex) {
                Workspace.getDefaultLogger().warn((Object)("Invalid path specified for additional expression panel functions: " + ex.getLocalizedMessage()));
            }
        }
        return mdl;
    }

    private boolean isValidLibrary() {
        if (this.m_udfModel.getLibrary() != null && !this.m_udfModel.getLibrary().getDBMSType().isModelManagerFunctionSetsSupported() && !this.m_udfModel.getLibrary().getDBMSType().isNativeFunctionSetsSupported()) {
            String errMsg = bundle.getString("ImportUserDefinedFunctionsPanel.UnSupportedLibrarySelected.Error.txt");
            String title = bundle.getString("ImportUserDefinedFunctionsPanel.UnSupporedLibrarySelected.Title.txt");
            MessageUtil.displayMessage((String)errMsg, (String)title, (int)0, (int)-1);
            return false;
        }
        return true;
    }

    private class cItemListener
    implements ItemListener {
        private cItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            WAComboBox cmBox = (WAComboBox)e.getSource();
            Object item = cmBox.getSelectedItem();
            ImportUserDefinedFunctionsPanel.this.m_udfModel.setContainer((String)item);
        }
    }

    private class cLibraryTextField
    extends WsAbstractBrowsableTextField {
        private cLibraryTextField() {
        }

        public void setEnabled(boolean bEnabled) {
            this.m_txt.setEnabled(false);
            this.m_btn.setEnabled(bEnabled && this.isEditable());
        }

        public boolean isEnabled() {
            return this.m_btn.isEnabled();
        }

        public void setEditable(boolean bEditable) {
            this.m_txt.setEditable(false);
            this.m_btn.setEnabled(bEditable && this.isEnabled());
        }

        public boolean isEditable() {
            return this.m_btn.isEnabled();
        }

        protected Border createTextFieldBorder() {
            if (WsUIUtilities.isXPThemeActive()) {
                return new EmptyBorder(1, 5, 1, 0);
            }
            return new EmptyBorder(1, 1, 1, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void showDialog() {
            ObjectSelectorPanel pnl = new ObjectSelectorPanel(Workspace.getWorkspace().getUserContext(), 2);
            pnl.setSelectedObject((SimpleObject)ImportUserDefinedFunctionsPanel.this.m_udfModel.getLibrary());
            pnl.setSelectionOptional(true);
            pnl.setHelpProduct("shared");
            pnl.setHelpTopic("select_library_win");
            String sTitle = bundle.getString("ImportUserDefinedFunctionsPanel.cLibraryTextField.LibrarySelector.title.txt");
            WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true, (WAPanel)pnl);
            dlg.setResizable(true);
            dlg.show();
            if (dlg.getReturnValue() == 1) {
                Window parent = SwingUtilities.getWindowAncestor((Component)((Object)this));
                try {
                    if (parent != null) {
                        parent.setCursor(Cursor.getPredefinedCursor(3));
                    }
                    SimpleObject lib = pnl.getSelectedObject();
                    try {
                        ImportUserDefinedFunctionsPanel.this.m_udfModel.setLibrary(lib);
                    }
                    catch (MdException exc) {
                        MessageUtil.displayMetadataExceptionMessage((MdException)exc, (String)"Accessing");
                    }
                    catch (RemoteException re) {
                        Workspace.handleRemoteException((RemoteException)re);
                    }
                    catch (WsAppServerCodeException exc) {
                        MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
                    }
                    catch (WsAppServerFailException exc) {
                        MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
                    }
                    catch (WsAppServerLibraryException exc) {
                        MessageUtil.displayDetailsMessage((String)exc.getLocalizedMessage(), (String)exc.getLocalizedMessage());
                    }
                    if (lib != null) {
                        ImportUserDefinedFunctionsPanel.this.m_txtLibrary.setText(lib.getName());
                        if (ImportUserDefinedFunctionsPanel.this.isValidLibrary()) {
                            ImportUserDefinedFunctionsPanel.this.loadFunctionSetTypes();
                        }
                    } else {
                        ImportUserDefinedFunctionsPanel.this.m_txtLibrary.setText(null);
                    }
                }
                finally {
                    if (parent != null) {
                        parent.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            }
        }
    }

    private class DualListener
    implements ListDataListener {
        private DualListener() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }
    }

    private class PreviewAction
    extends WsAbstractAction {
        public PreviewAction() {
            super(bundle, "ImportUserDefinedFunctionsPanel.Preview", 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (ImportUserDefinedFunctionsPanel.this.m_udfModel.getLibrary() == null || ImportUserDefinedFunctionsPanel.this.m_udfModel.getContainer() == null || ImportUserDefinedFunctionsPanel.this.m_udfModel.getContainer().equals("")) {
                MessageUtil.displayMessage((String)bundle.getString("ImportUserDefinedFunctionModel.Warning.NeedCategoryandLibrary.txt"), (int)0, (int)-1);
                return;
            }
            if (ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ImportUserDefinedFunctionModel.Warning.NeedTypesSelected.txt"), (int)0, (int)-1);
                return;
            }
            ImportUserDefinedFunctionsPanel.this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                List sets = null;
                ArrayList<String> typesSelected = new ArrayList<String>();
                boolean bNative = ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.contains(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"));
                if (ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() > 1 || ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() == 1 && !ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.contains(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"))) {
                    Enumeration targetList = ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.elements();
                    while (targetList.hasMoreElements()) {
                        String target = (String)targetList.nextElement();
                        if (target.equals(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"))) continue;
                        typesSelected.add(target);
                    }
                }
                if ((sets = ImportUserDefinedFunctionsPanel.this.m_udfModel.previewFunctionSets(bNative, typesSelected)) != null) {
                    ArrayList<String> names = new ArrayList<String>();
                    for (int iSet = 0; iSet < sets.size(); ++iSet) {
                        UserDefinedFunction func = (UserDefinedFunction)sets.get(iSet);
                        names.add(func.getDisplayName());
                    }
                    Object[] aSets = names.toArray();
                    PreviewPanel pnlFunctions = new PreviewPanel(aSets);
                    String sTitle = bundle.getString("ImportUserDefinedFunctionsPanel.PreviewDialog.Title.txt");
                    WAStandardDialog dlg = new WAStandardDialog((Frame)Workspace.getWorkspace(), sTitle, true);
                    dlg.setCloseButtonVisible(true);
                    dlg.setCancelButtonVisible(false);
                    dlg.setOKButtonVisible(false);
                    dlg.setHelpButtonVisible(false);
                    dlg.setMainPanel((WAPanel)pnlFunctions);
                    dlg.setResizable(true);
                    dlg.show();
                }
            }
            finally {
                ImportUserDefinedFunctionsPanel.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    private class ImportAction
    extends WsAbstractAction {
        public ImportAction() {
            super(bundle, "ImportUserDefinedFunctionsPanel.Import", 0);
        }

        public void actionPerformed(ActionEvent e) {
            if (ImportUserDefinedFunctionsPanel.this.m_udfModel.getLibrary() == null || ImportUserDefinedFunctionsPanel.this.m_udfModel.getContainer() == null || ImportUserDefinedFunctionsPanel.this.m_udfModel.getContainer().equals("")) {
                MessageUtil.displayMessage((String)bundle.getString("ImportUserDefinedFunctionModel.Warning.NeedCategoryandLibrary.txt"), (int)0, (int)-1);
                return;
            }
            if (ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() == 0) {
                MessageUtil.displayMessage((String)bundle.getString("ImportUserDefinedFunctionModel.Warning.NeedTypesSelected.txt"), (int)0, (int)-1);
                return;
            }
            OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.formatString("ImportUserDefinedFunctionsPanel.ImportProgressIndicator.Message.txt", (Object)ImportUserDefinedFunctionsPanel.this.m_udfModel.getContainer(), (Object)ImportUserDefinedFunctionsPanel.this.m_udfModel.getLibrary().getName()), bundle.getString("ImportUserDefinedFunctionsPanel.ImportProgressIndicator.Title.txt"));
            request.setDelayBeforeProgressCancelDialog(200);
            cBacgroundThread backgroundThread = new cBacgroundThread(request);
            try {
                request.executeWithCancel((Runnable)backgroundThread);
                String sMessage = bundle.formatString("ImportUserDefinedFunctionsPanel.ImportComplete.txt", (Object)ImportUserDefinedFunctionsPanel.this.m_udfModel.getNumberOfUDFsImported());
                ImportUserDefinedFunctionsPanel.this.m_udfModel.showSASLog(sMessage);
            }
            catch (InterruptedException ex) {
                return;
            }
        }
    }

    private class cBacgroundThread
    implements Runnable {
        private OpRequestUI m_request;

        public cBacgroundThread(OpRequestUI request) {
            this.m_request = request;
        }

        @Override
        public void run() {
            Thread.currentThread().setName("ImportUDFs");
            if (ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() == 0) {
                return;
            }
            Object sets = null;
            ArrayList<String> typesSelected = new ArrayList<String>();
            boolean bNative = ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.contains(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"));
            if (ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() > 1 || ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.size() == 1 && !ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.contains(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"))) {
                Enumeration targetList = ImportUserDefinedFunctionsPanel.this.m_lstFunctionSetTypesTarget.elements();
                while (targetList.hasMoreElements()) {
                    String target = (String)targetList.nextElement();
                    if (target.equals(bundle.getString("ImportUserDefinedFunctionsPanel.FunctionSets.Native.txt"))) continue;
                    typesSelected.add(target);
                }
            }
            ImportUserDefinedFunctionsPanel.this.m_udfModel.importFunctionSets(bNative, typesSelected);
        }
    }

    private class PreviewPanel
    extends WAPanel {
        private Object[] m_aFunctions;
        private JLabel m_lblUDFs;
        private JList m_lUDFs;
        private JScrollPane m_spUDFs;

        public PreviewPanel(Object[] aFunctions) {
            this.m_aFunctions = aFunctions;
            this.initialize();
        }

        protected void initialize() {
            this.m_lUDFs = new JList<Object>(this.m_aFunctions);
            this.m_lUDFs.setCellRenderer(new cListCellRenderer());
            this.m_spUDFs = new JScrollPane(this.m_lUDFs);
            this.m_spUDFs.setPreferredSize(new Dimension(250, 300));
            this.m_lblUDFs = WsUIUtilities.createLabelAndToolTipForComponent((JComponent)this.m_lUDFs, (WAdminResource)bundle, (String)"PreviewPanel.Label.UserDefinedFunctions");
            this.setLayout(new BorderLayout());
            this.add(this.m_lblUDFs, "North");
            this.add(this.m_spUDFs, "Center");
        }

        private class cListCellRenderer
        extends DefaultListCellRenderer {
            private cListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                WsCompoundIcon iconCompound = new WsCompoundIcon();
                iconCompound.setIconGap(1);
                Icon icon = bundle.getIcon("PreviewPanel.Function.image");
                iconCompound.addIcon(icon);
                this.setText((String)value);
                if (iconCompound.getIconCount() == 0) {
                    this.setIcon(null);
                } else {
                    this.setIcon((Icon)iconCompound);
                }
                return this;
            }
        }
    }
}

