/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.externalfile.IDelimitedExternalFile;
import com.sas.etl.models.data.externalfile.IStructuredExternalFile;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.rio.MVAResultSet;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerCodeException;
import com.sas.workspace.WsAppServerFailException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ImportNewColumnsFromHeader {
    private IExternalTable m_mdlTable;
    private IStructuredExternalFile m_mdlFile;
    private int m_headerLine;

    public ImportNewColumnsFromHeader(IExternalTable model, int record) {
        this.m_mdlTable = model;
        this.m_mdlFile = model.getFile();
        this.m_headerLine = record;
    }

    public List getColumnNames() throws SQLException, WsAppServerFailException, WsAppServerCodeException, BadServerDefinitionException {
        SASCodeGeneration sbSource = new SASCodeGeneration();
        sbSource.addSourceCode("data work.colsTable ;\n");
        int startRecordValue = Integer.parseInt(this.m_mdlFile.getStartingRecordNumber());
        int numObsValue = Integer.parseInt(this.m_mdlFile.getNumberOfRecords().equals("") ? "0" : this.m_mdlFile.getNumberOfRecords());
        boolean missoverSet = false;
        if (this.m_mdlTable.isDelimited()) {
            missoverSet = !((IDelimitedExternalFile)this.m_mdlTable.getFile()).isRecordWrappingEnabled();
        }
        String infileOptions = this.m_mdlFile.getAdditionalInfileOptions();
        this.m_mdlFile.setStartingRecordNumber("" + this.m_headerLine);
        this.m_mdlFile.setNumberOfRecords("1");
        this.m_mdlFile.setAdditionalInfileOptions(infileOptions);
        if (this.m_mdlTable.isDelimited()) {
            ((IDelimitedExternalFile)this.m_mdlFile).setRecordWrappingEnabled(true);
        }
        sbSource.addSourceCode(this.m_mdlTable.getInfileStatement());
        this.m_mdlFile.setStartingRecordNumber("" + startRecordValue);
        this.m_mdlFile.setNumberOfRecords("" + numObsValue);
        this.m_mdlFile.setAdditionalInfileOptions(infileOptions);
        if (this.m_mdlTable.isDelimited()) {
            ((IDelimitedExternalFile)this.m_mdlFile).setRecordWrappingEnabled(!missoverSet);
        }
        int numColumns = 0;
        sbSource.addSourceCode("\n\n");
        if (this.m_mdlTable.isDelimited()) {
            sbSource.addSourceCode("length Name $32.; \n");
            sbSource.addSourceCode("input Name $ @@; \n");
            sbSource.addSourceCode("run;\n");
        } else {
            IColumn[] cList = this.m_mdlTable.getColumns();
            if (cList != null && cList.length > 0) {
                int i;
                for (i = 0; i < cList.length; ++i) {
                    if (i == 0) {
                        numColumns = 1;
                    }
                    ++numColumns;
                }
                for (i = 0; i < cList.length; ++i) {
                    IColumn col = cList[i];
                    if (i == 0) {
                        sbSource.addSourceCode("input \n");
                    }
                    sbSource.indent();
                    sbSource.addSourceCode("@  ");
                    sbSource.addSourceCode(String.valueOf(col.getBeginPosition()));
                    int colLength = col.getEndPosition() - col.getBeginPosition() + 1;
                    sbSource.addSourceCode(" Name" + i + " $" + colLength + ". \n");
                    sbSource.unIndent();
                }
                sbSource.unIndent();
                sbSource.addSourceCode(";\n run;\n");
            }
        }
        Workspace.getDefaultLogger().debug((Object)sbSource.getSource());
        WsAppServer appServer = WsAppServer.createAppServer((String)this.m_mdlFile.getServer().getID());
        if (appServer == null) {
            return new ArrayList();
        }
        appServer.submitSASCode(sbSource.getSource());
        String sqlStmt = "";
        sqlStmt = this.m_mdlTable.isDelimited() ? "Select Name from work.colsTable ;" : "Select * from work.colsTable ;";
        MVAResultSet fieldList = appServer.submitSQLStatement(sqlStmt);
        ArrayList<String> l_columnList = new ArrayList<String>(100);
        if (this.m_mdlTable.isDelimited()) {
            while (fieldList.next()) {
                String colName = fieldList.getString(1).trim();
                l_columnList.add(colName);
            }
        } else {
            while (fieldList.next()) {
                for (int j = 1; j < numColumns; ++j) {
                    String colName = fieldList.getString(j).trim();
                    l_columnList.add(colName);
                }
            }
        }
        try {
            fieldList.close();
        }
        catch (SQLException sqlE) {
            Workspace.getDefaultLogger().error((Object)"", (Throwable)sqlE);
        }
        return l_columnList;
    }
}

