/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IForeignKey;
import com.sas.etl.models.data.IKey;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.tableview.TableView;
import com.sas.wadmin.visuals.common.ColumnUIUtilities;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.WsDefaultTableCellRenderer;
import com.sas.workspace.WsDialogTableCellEditor;
import com.sas.workspace.WsDialogTableCellEditorInterface;
import com.sas.workspace.WsEnumeratedTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class ForeignKeyColumnsTableModel
extends WsAbstractTableModel {
    private static final WAdminResource bundle = WAdminResource.getBundle(ForeignKeyColumnsTableModel.class);
    private static final int VISIBLE_COLUMNS = 13;
    private static final int HIDDEN_COLUMNS = 2;
    public static final int NAME_COLUMN = 0;
    public static final int DESCRIPTION_COLUMN = 1;
    public static final int TYPE_COLUMN = 2;
    public static final int LENGTH_COLUMN = 3;
    public static final int INFORMAT_COLUMN = 4;
    public static final int FORMAT_COLUMN = 5;
    public static final int IS_NULLABLE_COLUMN = 6;
    public static final int SUMMARY_ROLE_COLUMN = 7;
    public static final int SORT_ORDER_COLUMN = 8;
    public static final int BEGIN_POSITION_COLUMN = 9;
    public static final int END_POSITION_COLUMN = 10;
    public static final int ASSOCIATION_COLUMN = 11;
    public static final int ASSOCIATION_TABLE_COLUMN = 12;
    private static final int KEY_COLUMN_OBJECT_COLUMN = 13;
    private static final int PARTNER_COLUMN_OBJECT_COLUMN = 14;
    private static final int ASSOCIATION_WIDTH = 100;
    private static final int NAME_WIDTH = 100;
    private static final int DESCRIPTION_WIDTH = 110;
    private static final int TYPE_WIDTH = 75;
    private static final int LENGTH_WIDTH = 50;
    private static final int INFORMAT_WIDTH = 75;
    private static final int FORMAT_WIDTH = 75;
    private static final int IS_NULLABLE_WIDTH = 100;
    private static final int SUMMARY_ROLE_WIDTH = 100;
    private static final int SORT_ORDER_WIDTH = 100;
    private static final int BEGIN_POSITION_WIDTH = 50;
    private static final int END_POSITION_WIDTH = 50;
    private static final int ASSOCIATION_TABLE_WIDTH = 100;
    private IForeignKey m_key;
    private boolean m_bOverlapAllowed;
    private IModelListener m_lsnrModel;
    private ActionListener m_lsnrBrowse;

    public ForeignKeyColumnsTableModel(IForeignKey key) {
        this.m_key = key;
        this.m_lsnrModel = this.createModelListener();
        this.m_key.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_key.getModel().removeModelListener(this.m_lsnrModel);
    }

    public IModelListener createModelListener() {
        return new ModelListener();
    }

    protected void createColumnDefinitions() {
        String[] saTypes = ColumnUIUtilities.getViewTypes();
        String[] saRoles = ColumnUIUtilities.getViewSummaryRoles();
        String[] saSorts = ColumnUIUtilities.getViewSortOrders();
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[11] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 11, bundle.getString("ForeignKeyColumnsTableModel.Association.txt"), 100, 32);
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("ForeignKeyColumnsTableModel.Column.txt"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ForeignKeyColumnsTableModel.ColumnDescr.txt"), 110, 200);
        this.m_aColumns[2] = new WsEnumeratedTableColumn(2, bundle.getString("ForeignKeyColumnsTableModel.Type.txt"), 75, saTypes);
        this.m_aColumns[3] = new LengthTableColumn();
        this.m_aColumns[4] = new InformatTableColumn();
        this.m_aColumns[5] = new FormatTableColumn();
        this.m_aColumns[6] = new WsBooleanTableColumn(6, bundle.getString("ForeignKeyColumnsTableModel.IsNullable.txt"), 100);
        this.m_aColumns[7] = new WsEnumeratedTableColumn(7, bundle.getString("ForeignKeyColumnsTableModel.SummaryRole.txt"), 100, saRoles);
        this.m_aColumns[8] = new WsEnumeratedTableColumn(8, bundle.getString("ForeignKeyColumnsTableModel.SortOrder.txt"), 100, saSorts);
        this.m_aColumns[9] = new BeginPositionTableColumn();
        this.m_aColumns[10] = new EndPositionTableColumn();
        this.m_aColumns[12] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 12, bundle.getString("ForeignKeyColumnsTableModel.AssociationTable.txt"), 100, 32);
        this.m_aColumns[13] = new WsObjectTableColumn();
        this.m_aColumns[14] = new WsObjectTableColumn();
        this.m_aColumns[11].setCellRenderer((TableCellRenderer)((Object)new AssociationNameCellRenderer()));
        this.m_aColumns[0].setCellRenderer((TableCellRenderer)((Object)new ColumnNameCellRenderer()));
        this.m_aColumns[0].setCellEditor((TableCellEditor)new WsDialogTableCellEditor());
        this.m_aColumns[11].setEditable(false);
        this.m_aColumns[0].setEditable(true);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[6].setEditable(false);
        this.m_aColumns[7].setEditable(false);
        this.m_aColumns[8].setEditable(false);
        this.m_aColumns[9].setEditable(false);
        this.m_aColumns[10].setEditable(false);
        this.m_aColumns[12].setEditable(false);
    }

    public void setOverlappingColumnsAllowed(boolean bOverlapAllowed) {
        this.m_bOverlapAllowed = bOverlapAllowed;
    }

    public boolean isOverlappingColumnsAllowed() {
        return this.m_bOverlapAllowed;
    }

    public void setDialog(WsDialogTableCellEditorInterface dlg) {
        WsDialogTableCellEditor editor = (WsDialogTableCellEditor)this.m_aColumns[0].getCellEditor();
        editor.setTextEditable(false);
        editor.setClicksToStart(1);
        editor.setDialog(dlg);
        editor.setStopEditingOnDialogClose(true);
    }

    public int getColumnCount() {
        return 13;
    }

    public int getHiddenColumnCount() {
        return 2;
    }

    public void moveDataToModel() {
        this.clear();
        IColumn[] aColumns = this.m_key.getColumns();
        IKey partnerKey = null;
        try {
            partnerKey = this.m_key.loadPartnerKeyFromOMR();
        }
        catch (RemoteException e) {
            Workspace.handleRemoteException((RemoteException)e);
        }
        catch (MdException e) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e, (String)"Accessing");
        }
        for (int iColumn = 0; iColumn < aColumns.length; ++iColumn) {
            this.m_lData.add(this.createRowValues(aColumns[iColumn], this.m_key.getPartnerKeyColumn(aColumns[iColumn])));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
        if (partnerKey == null) {
            this.m_aColumns[0].setEditable(false);
        }
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not implemented.  changes are immediately made to the model");
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not implemented.  Model does not use a store");
    }

    private List createRowValues(IColumn keyColumn, IColumn partnerColumn) {
        ArrayList lValues = new ArrayList(this.getColumnCount() + this.getHiddenColumnCount());
        this.addVisibleValues(keyColumn, partnerColumn, lValues);
        this.addHiddenValues(keyColumn, partnerColumn, lValues);
        return lValues;
    }

    protected void addVisibleValues(IColumn keyColumn, IColumn partnerColumn, List lValues) {
        String partnerColumnName = partnerColumn != null ? partnerColumn.getName() : "";
        String partnerTableName = partnerColumn != null ? partnerColumn.getTable().getName() : "";
        lValues.add(keyColumn.getName());
        lValues.add(keyColumn.getDescription());
        lValues.add(ColumnUIUtilities.getViewType(keyColumn.getType()));
        lValues.add(new Integer(keyColumn.getLength()));
        lValues.add(ColumnUIUtilities.getViewInformat(keyColumn.getInformat()));
        lValues.add(ColumnUIUtilities.getViewFormat(keyColumn.getFormat()));
        lValues.add(keyColumn.isNullable());
        lValues.add(ColumnUIUtilities.getViewSummaryRole(keyColumn.getSummaryRole()));
        lValues.add(ColumnUIUtilities.getViewSortOrder(keyColumn.getSortOrder()));
        lValues.add(new Integer(keyColumn.getBeginPosition()));
        lValues.add(new Integer(keyColumn.getEndPosition()));
        lValues.add(partnerColumnName);
        lValues.add(partnerTableName);
    }

    protected void addHiddenValues(IColumn keyColumn, IColumn partnerColumn, List lValues) {
        lValues.add(keyColumn);
        lValues.add(partnerColumn);
    }

    public IForeignKey getKey() {
        return this.m_key;
    }

    public int getRowIndex(String sColumnID) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (!this.getColumnForRow(iRow).getID().equals(sColumnID)) continue;
            return iRow;
        }
        return -1;
    }

    public int getRowIndex(IColumn col) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            if (this.getColumnForRow(iRow) != col) continue;
            return iRow;
        }
        return -1;
    }

    public IColumn getColumnForRow(int iRow) {
        return (IColumn)this.getValueAt(iRow, this.getColumnCount());
    }

    public IColumn getPartnerColumnForRow(int iRow) {
        return (IColumn)this.getValueAt(iRow, this.getColumnCount() + 1);
    }

    private int getBeginPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 9);
    }

    private int getEndPosition(int iRow) {
        return (Integer)this.getValueAt(iRow, 10);
    }

    public String createUniqueNameForNewColumn() {
        return (String)this.m_aColumns[0].createDefaultValue();
    }

    private void addColumn(IColumn col) {
        int iRow = this.m_key.getColumnsList().indexOf(col);
        IColumn partnerColumn = this.m_key.getPartnerKeyColumn(col);
        this.insertRow(iRow - 1, this.createRowValues(col, partnerColumn));
    }

    private void removeColumn(IColumn col) {
        this.deleteRow(this.getRowIndex(col));
    }

    public void setColumn(int index, IColumn column) {
        this.setValueAt(column, index, 13);
        IColumn partnerColumn = this.m_key.getPartnerKeyColumn(column);
        this.setValueAt(partnerColumn, index, 14);
    }

    public void setKeyColumn(IColumn keyColumn, IColumn partnerColumn) {
        for (int rowIndex = 0; rowIndex < this.getRowCount(); ++rowIndex) {
            IColumn currentPartnerColumn = (IColumn)this.getValueAt(rowIndex, 14);
            if (currentPartnerColumn != partnerColumn) continue;
            this.setKeyColumn(rowIndex, keyColumn);
            break;
        }
    }

    private void setKeyColumn(int rowIndex, IColumn keyColumn) {
        this.setValueAt(keyColumn, rowIndex, 13);
        this.setValueAt(keyColumn != null ? keyColumn.getName() : "", rowIndex, 0);
        this.fireTableCellUpdated(rowIndex, 0);
    }

    protected class ModelListener
    implements IModelListener {
        protected ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                ForeignKeyColumnsTableModel.this.moveDataToModel();
            } else if (obj == ForeignKeyColumnsTableModel.this.m_key) {
                if (sType == "ForeignKey:ColumnAdded") {
                    ForeignKeyColumnsTableModel.this.addColumn((IColumn)ev.getData());
                } else if (sType == "ForeignKey:ColumnRemoved") {
                    ForeignKeyColumnsTableModel.this.removeColumn((IColumn)ev.getData());
                } else if (sType == "ForeignKey:ColumnReplaced") {
                    IColumn keyColumn = (IColumn)ev.getData();
                    IColumn partnerColumn = (IColumn)ev.getAdditionalData();
                    ForeignKeyColumnsTableModel.this.setKeyColumn(keyColumn, partnerColumn);
                }
            } else if (obj instanceof IColumn) {
                IColumn col = (IColumn)obj;
                int iRowIndex = ForeignKeyColumnsTableModel.this.getRowIndex(col);
                if (iRowIndex == -1) {
                    return;
                }
                if (sType == "Object:NameChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(col.getName(), iRowIndex, 0);
                } else if (sType == "Object:DescriptionChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(col.getDescription(), iRowIndex, 1);
                } else if (sType == "Column:LengthChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(new Integer(col.getLength()), iRowIndex, 3);
                } else if (sType == "Column:TypeChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewType(col.getType()), iRowIndex, 2);
                    ForeignKeyColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                } else if (sType == "Column:InformatChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewInformat(col.getInformat()), iRowIndex, 4);
                } else if (sType == "Column:FormatChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewFormat(col.getFormat()), iRowIndex, 5);
                } else if (sType == "Column:NullableChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(col.isNullable(), iRowIndex, 6);
                } else if (sType == "Column:SummaryRoleChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewSummaryRole(col.getSummaryRole()), iRowIndex, 7);
                } else if (sType == "Column:SortOrderChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(ColumnUIUtilities.getViewSortOrder(col.getSortOrder()), iRowIndex, 8);
                } else if (sType == "Column:BeginPositionChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(new Integer(col.getBeginPosition()), iRowIndex, 9);
                } else if (sType == "Column:EndPositionChanged") {
                    ForeignKeyColumnsTableModel.super.setValueAt(new Integer(col.getEndPosition()), iRowIndex, 10);
                } else if (sType == "Object:NoteAdded" || sType == "Object:NoteRemoved" || sType == "Object:DocumentAdded" || sType == "Object:DocumentRemoved" || sType == "Object:ExtendedAttributeAdded" || sType == "Object:ExtendedAttributeRemoved") {
                    ForeignKeyColumnsTableModel.this.fireTableCellUpdated(iRowIndex, 0);
                }
            }
        }
    }

    private class LengthTableColumn
    extends WsIntegerTableColumn {
        public LengthTableColumn() {
            super(3, bundle.getString("ForeignKeyColumnsTableModel.Length.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (oValue.equals(this.getMissingValue())) {
                return true;
            }
            int iValue = (Integer)oValue;
            int eType = ForeignKeyColumnsTableModel.this.getColumnForRow(iRow).getType();
            if (eType == 1) {
                if (iValue < 3 || iValue > 8) {
                    String sMessage = bundle.getString("ColumnsTableModel.Error.NumericInvalidLength.txt");
                    MessageUtil.displayMessage((String)sMessage, (int)0);
                    return false;
                }
                return true;
            }
            if (eType == 0 && (iValue < 1 || iValue > Short.MAX_VALUE)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.CharacterInvalidLength.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class InformatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public InformatTableColumn() {
            super(4, bundle.getString("ForeignKeyColumnsTableModel.Informat.txt"), 75);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = ForeignKeyColumnsTableModel.this.getColumnForRow(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterInformats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericInformats());
            }
        }
    }

    private class FormatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public FormatTableColumn() {
            super(5, bundle.getString("ForeignKeyColumnsTableModel.Format.txt"), 75);
            this.setEditorEditable(true);
        }

        public void populate(JTable tbl, int row, int col) {
            IColumn column = ForeignKeyColumnsTableModel.this.getColumnForRow(row = ((WsTable)tbl).convertRowIndexToModel(row));
            if (column.getType() == 0) {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultCharacterFormats());
            } else {
                this.setPossibleValues(WsColumnMetadataUtil.getDefaultNumericFormats());
            }
        }
    }

    private class BeginPositionTableColumn
    extends WsIntegerTableColumn {
        public BeginPositionTableColumn() {
            super(9, bundle.getString("ForeignKeyColumnsTableModel.BeginPosition.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (ForeignKeyColumnsTableModel.this.m_bOverlapAllowed) {
                return true;
            }
            int begin = (Integer)oValue;
            if (iRow != 0 && begin <= ForeignKeyColumnsTableModel.this.getEndPosition(iRow - 1)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin < 1) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionLessThan1.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (begin > ForeignKeyColumnsTableModel.this.getEndPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.BeginPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    protected class EndPositionTableColumn
    extends WsIntegerTableColumn {
        public EndPositionTableColumn() {
            super(10, bundle.getString("ForeignKeyColumnsTableModel.EndPosition.txt"), 50);
        }

        public boolean validateValue(Object oValue, WsAbstractTableModel mdlTable, int iRow) {
            if (ForeignKeyColumnsTableModel.this.m_bOverlapAllowed) {
                return true;
            }
            int end = (Integer)oValue;
            if (end < ForeignKeyColumnsTableModel.this.getBeginPosition(iRow)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.EndPositionTooSmall.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            if (iRow < ForeignKeyColumnsTableModel.this.getRowCount() - 1 && end >= ForeignKeyColumnsTableModel.this.getBeginPosition(iRow + 1)) {
                String sMessage = bundle.getString("ColumnsTableModel.Error.EndPositionTooLarge.txt");
                MessageUtil.displayMessage((String)sMessage, (int)0);
                return false;
            }
            return true;
        }
    }

    private class AssociationNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private AssociationNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = ForeignKeyColumnsTableModel.this.getColumnForRow(iRow);
            this.setIcon(ColumnUIUtilities.getTypeIcon(col));
            if (value instanceof String && ((String)value).length() <= 0) {
                this.setIcon(null);
            }
            return this;
        }
    }

    private class ColumnNameCellRenderer
    extends WsDefaultTableCellRenderer {
        private ColumnNameCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable tbl, Object value, boolean bSelected, boolean bFocused, int iRow, int iCol) {
            super.getTableCellRendererComponent(tbl, value, bSelected, bFocused, iRow, iCol);
            if (tbl instanceof TableView) {
                iRow = ((TableView)tbl).convertRowIndexToModel(iRow);
            }
            IColumn col = ForeignKeyColumnsTableModel.this.getColumnForRow(iRow);
            this.setIcon(ColumnUIUtilities.getTypeIcon(col));
            JButton btn = WsUIUtilities.createBrowseButton();
            btn.addActionListener(ForeignKeyColumnsTableModel.this.m_lsnrBrowse);
            btn.setEnabled(tbl.isCellEditable(iRow, iCol));
            JPanel pnl = new JPanel(new BorderLayout());
            pnl.add((Component)((Object)this), "Center");
            pnl.add((Component)btn, "East");
            pnl.setBackground(tbl.getBackground());
            return pnl;
        }
    }
}

