/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.codegen.ValidateSASCode;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.job.ITextExpression;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.ExtractTransformModel;
import com.sas.etl.models.job.transforms.splitter.IRowSelector;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DefaultFunctionTree;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.MdException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ExtractRowSelectorTab
extends WAPropertyTab
implements ActionListener {
    private static WAdminResource bundle = WAdminResource.getBundle(ExtractRowSelectorTab.class);
    protected ExpressionBuilderPanel m_builder;
    protected IRowSelector m_rowSelector;
    protected String m_sExpression;
    protected IColumn[] m_aCols;
    protected ITable[] m_aTables;
    protected boolean m_bUseSQLSyntax = false;
    protected boolean m_bTokenizeExpression = false;
    protected boolean m_bUseQuotes = false;
    protected ValidateSASCode m_validateSASCode;
    protected String m_columnGroupNodeName;
    private ExtractTransformModel transformModel;

    public ExtractRowSelectorTab(ExtractTransformModel transformModel, IColumn[] mappedColumns, boolean bUseSQLSyntax, boolean bEnableValidate) {
        this(transformModel.getRowSelector(), mappedColumns, bUseSQLSyntax, bEnableValidate);
        this.transformModel = transformModel;
        this.setUseQuotes(transformModel.isQuotingNeeded());
    }

    public ExtractRowSelectorTab(IRowSelector rowSelector, IColumn[] mappedColumns, boolean bUseSQLSyntax, boolean bEnableValidate) {
        ITable[] iTableArray;
        this.setName(bundle.getString("ExtractRowSelectorTab.title.txt"));
        this.m_rowSelector = rowSelector;
        ITable tab = rowSelector.getTable();
        if (tab != null) {
            ITable[] iTableArray2 = new ITable[1];
            iTableArray = iTableArray2;
            iTableArray2[0] = tab;
        } else {
            iTableArray = new ITable[]{};
        }
        ITable[] tables = iTableArray;
        this.m_aTables = tables;
        this.m_aCols = mappedColumns != null ? mappedColumns : new IColumn[]{};
        this.setUseQuotes(tab != null ? tab.isQuoted() : false);
        this.setUseSQLSyntax(bUseSQLSyntax);
        this.initialize();
        this.layoutWidgets();
        this.m_builder.setValidationButtonVisible(bEnableValidate);
        if (tab != null && bEnableValidate) {
            try {
                this.setupValidateButton();
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    public ExtractRowSelectorTab(IRowSelector rowSelector) {
        this(rowSelector, null, true, false);
    }

    public ExtractRowSelectorTab(IRowSelector rowSelector, IColumn[] mappedColumns) {
        this(rowSelector, mappedColumns, true, false);
    }

    public ExtractRowSelectorTab(IRowSelector rowSelector, IColumn[] mappedColumns, boolean bUseSQLSyntax) {
        this(rowSelector, mappedColumns, bUseSQLSyntax, false);
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_aCols, this.m_aTables));
        try {
            ITextExpression exp = this.m_rowSelector.getExpression();
            String txt = exp != null ? exp.getText(null, this.useQuotes(), false) : "";
            this.m_builder.setExpressionText(txt);
        }
        catch (RemoteException e1) {
            Workspace.handleRemoteException((RemoteException)e1);
        }
        catch (CodegenException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (MdException e1) {
            MessageUtil.displayMetadataExceptionMessage((MdException)e1, (String)"Accessing");
        }
        catch (BadServerDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (BadLibraryDefinitionException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        catch (ServerException e1) {
            MessageUtil.displayMessage((String)e1.getLocalizedMessage(), (int)0);
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        if (this.isEditable()) {
            this.m_rowSelector.getModel().startCompoundUndoable();
            try {
                String text = this.m_builder.getExpressionText();
                ITextExpression expression = this.m_rowSelector.getExpression();
                if (expression == null) {
                    expression = this.m_rowSelector.createNewTextExpression();
                }
                expression.setText(text, this.m_rowSelector.getTable() != null ? this.m_rowSelector.getTable().getColumns() : null);
            }
            finally {
                this.m_rowSelector.getModel().endCompoundUndoable();
            }
        }
    }

    public boolean validateData() {
        ExpressionBuilderPanel.LineInfo lineInfo = this.m_builder.computeMaxLineLength();
        return lineInfo.getLine().length() <= 255 || 1 != SASCodeGeneration.displayLineLengthMessage((String)lineInfo.getLine(), (int)lineInfo.getLineNumber());
    }

    protected void initialize() {
        this.m_builder = this.createExpressionPanel();
        this.m_builder.setMaximumLineLength(255);
        this.listenForDataChangesTo((JTextComponent)this.m_builder.getExpressionTextPane());
        this.setHelpTopic("about");
        this.setHelpProduct("expbuild");
        this.m_columnGroupNodeName = bundle.getString("ExpressionBuilderTab.MappedColumnsNode.txt");
    }

    protected ExpressionBuilderPanel createExpressionPanel() {
        return new ExpressionPanel();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_builder, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_builder.setReadOnly(false);
    }

    public void saveSettingsAndCleanUp() {
        this.m_builder.dispose();
        super.saveSettingsAndCleanUp();
    }

    public boolean useSQLSyntax() {
        return this.m_bUseSQLSyntax;
    }

    public void setUseSQLSyntax(boolean useSQLSyntax) {
        this.m_bUseSQLSyntax = useSQLSyntax;
    }

    public void setColumnGroupNodeName(String name) {
        this.m_columnGroupNodeName = name;
    }

    public boolean useQuotes() {
        return this.m_bUseQuotes;
    }

    public void setUseQuotes(boolean bUseQuotes) {
        this.m_bUseQuotes = bUseQuotes;
    }

    public void setExpression(String sExpression) {
        this.m_builder.setExpressionText(sExpression);
    }

    public String getExpression() {
        return this.m_builder.getExpressionText();
    }

    public void setupValidateButton() throws BadLibraryDefinitionException {
        this.m_validateSASCode = new ValidateSASCode();
        this.m_builder.setValidationButtonVisible(true);
        this.m_builder.addValidateActionListener((ActionListener)this);
        if (this.m_aCols != null) {
            this.m_validateSASCode.addTables(this.m_aCols);
        }
        if (this.m_aTables != null) {
            this.m_validateSASCode.addTables(this.m_aTables);
        }
        StringBuffer sasPreExpressionSyntax = new StringBuffer();
        StringBuffer sasPostExpressionSyntax = new StringBuffer();
        if (this.useSQLSyntax()) {
            sasPreExpressionSyntax.append("proc sql;\n");
            sasPreExpressionSyntax.append("   validate \n");
            sasPreExpressionSyntax.append("   select * from ");
            for (int i = 0; i < this.m_aTables.length; ++i) {
                if (i > 0) {
                    sasPreExpressionSyntax.append(",");
                }
                sasPreExpressionSyntax.append(this.m_aTables[i].getFullNameQuotedAsNeeded(null, this.m_aTables[i].isQuoted(), false));
            }
            sasPreExpressionSyntax.append("\n");
            sasPostExpressionSyntax.append("quit;\n");
        } else {
            sasPreExpressionSyntax.append("data null;\n");
            sasPreExpressionSyntax.append("   set ");
            if (this.m_aTables != null) {
                for (int i = 0; i < this.m_aTables.length; ++i) {
                    if (i > 0) {
                        sasPreExpressionSyntax.append(" ");
                    }
                    if (this.m_aTables[i] == null) continue;
                    sasPreExpressionSyntax.append(this.m_aTables[i].getFullNameQuotedAsNeeded(null, this.m_aTables[i].isQuoted(), false));
                }
            }
            sasPreExpressionSyntax.append(";\n");
            sasPostExpressionSyntax.append("run cancel;\n");
        }
        this.m_validateSASCode.setPreExpression(sasPreExpressionSyntax.toString());
        this.m_validateSASCode.setClause(ValidateSASCode.WHERE);
        this.m_validateSASCode.setPostExpression(sasPostExpressionSyntax.toString());
    }

    public ValidateSASCode getValidateSASCode() {
        return this.m_validateSASCode;
    }

    public void setValidateSASCode(ValidateSASCode validateSASCode) {
        this.m_validateSASCode = validateSASCode;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        String expression = this.m_builder.getExpressionText();
        if (expression == null || expression.trim().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("ExpressionBuilderTab.NoExpression.txt"), (int)0);
            return;
        }
        if (this.m_aTables.length <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("ExpressionBuilderTab.NoSourceTables.txt"), (int)0);
            return;
        }
        this.validateSyntax(expression.trim());
    }

    private void validateSyntax(String sExpression) {
        this.m_validateSASCode.setExpression(sExpression);
        if (this.m_validateSASCode.getWsAppServer() != null) {
            if (this.m_validateSASCode.getWsAppServer().isOpen()) {
                this.m_validateSASCode.doValidate();
            } else {
                try {
                    this.m_validateSASCode.getWsAppServer().open();
                    this.m_validateSASCode.doValidate();
                }
                catch (WsAppServerFailException wsAppServerFailException) {
                    // empty catch block
                }
            }
        }
    }

    class MyDataSourceTree
    extends DefaultTreeModel
    implements DataSourceTreeInterface {
        MyDataSourceTree(IColumn[] cols) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols);
            this.setRoot(initRoot);
        }

        MyDataSourceTree(IColumn[] cols, ITable[] tbls) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols, tbls);
            this.setRoot(initRoot);
        }

        protected TreeNode buildRootNode(IColumn[] cols) {
            if (cols == null) {
                return null;
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            for (int i = 0; i < cols.length; ++i) {
                IColumn col = cols[i];
                ColumnNode colNode = new ColumnNode(col);
                rootNode.add(colNode);
            }
            return rootNode;
        }

        protected TreeNode buildRootNode(IColumn[] cols, ITable[] tbls) {
            int i;
            if (!(cols != null && cols.length != 0 || tbls != null && tbls.length != 0)) {
                return null;
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            DefaultMutableTreeNode mappedNode = new DefaultMutableTreeNode(ExtractRowSelectorTab.this.m_columnGroupNodeName);
            if (cols != null && cols.length > 0) {
                for (i = 0; i < cols.length; ++i) {
                    IColumn col = cols[i];
                    ColumnNode colNode = new ColumnNode(col, ExtractRowSelectorTab.this.useSQLSyntax());
                    mappedNode.add(colNode);
                }
                if (cols.length > 0) {
                    rootNode.add(mappedNode);
                }
            }
            for (i = 0; i < tbls.length; ++i) {
                ITable tbl = tbls[i];
                TableNode tblNode = new TableNode(tbl);
                rootNode.add(tblNode);
                IColumn[] columns = tbl.getColumns();
                for (int iCol = 0; iCol < columns.length; ++iCol) {
                    IColumn col = columns[iCol];
                    ColumnNode colNode = new ColumnNode(col);
                    tblNode.add(colNode);
                }
            }
            return rootNode;
        }

        public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
            return new SourceNodeRenderer();
        }

        class ColumnNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;
            private IColumn m_column;

            ColumnNode(String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            ColumnNode(IColumn col, boolean bUseInsertNameForDisplay) {
                this(col);
                if (bUseInsertNameForDisplay) {
                    this.m_displayName = this.m_insertName;
                    this.setUserObject(this.m_insertName);
                }
            }

            ColumnNode(IColumn col) {
                this.m_column = col;
                this.setUserObject(col.getName());
                this.m_name = col.getName();
                this.m_displayName = col.getName();
                this.m_description = col.getDescription();
                this.m_insertName = ExtractRowSelectorTab.this.useSQLSyntax() ? col.getFullColumnName(ExtractRowSelectorTab.this.useQuotes()) : col.getColumnName(ExtractRowSelectorTab.this.useQuotes());
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName;
            }

            public IColumn getColumn() {
                return this.m_column;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class TableNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private ITable m_table;
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;

            TableNode(ITable tbl, String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_table = tbl;
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            TableNode(ITable tbl) {
                String name = "";
                if (tbl != null) {
                    name = tbl instanceof IPhysicalTable ? ((IPhysicalTable)tbl).getSASTableName() : tbl.getName();
                    this.m_description = tbl.getDescription();
                    this.m_table = tbl;
                    this.m_name = name;
                    this.m_displayName = name;
                    this.m_insertName = null;
                    this.setUserObject(name);
                }
            }

            public ITable getTable() {
                return this.m_table;
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class SourceNodeRenderer
        extends DefaultTreeCellRenderer {
            public SourceNodeRenderer() {
                this.setLeafIcon(WorkspaceTree.getDefaultLeafIcon());
                this.setOpenIcon(WorkspaceTree.getOpenedFolderIcon());
                this.setClosedIcon(WorkspaceTree.getClosedFolderIcon());
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
                JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
                Icon icon = null;
                if (node instanceof TableNode) {
                    ITable table = ((TableNode)node).getTable();
                    icon = table instanceof IExternalTable ? WAdminResource.getTypeIcon((String)"ExternalTable", (boolean)true) : WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
                } else if (node instanceof ColumnNode) {
                    IColumn col = ((ColumnNode)node).getColumn();
                    icon = WsColumnMetadataUtil.getColumnTypeIcon((int)col.getType());
                }
                if (icon != null) {
                    lbl.setIcon(icon);
                }
                return lbl;
            }
        }
    }

    protected class FunctionTree
    extends DefaultFunctionTree {
        protected FunctionTree() {
        }

        public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
            return new FunctionGroupRenderer();
        }

        protected class FunctionGroupRenderer
        extends DefaultTreeCellRenderer {
            protected FunctionGroupRenderer() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
                JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
                lbl.setIcon(bSelected ? WorkspaceTree.getOpenedFolderIcon() : WorkspaceTree.getClosedFolderIcon());
                return lbl;
            }
        }
    }
}

