/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.etl.models.IExtendedAttributesContainer;
import com.sas.etl.models.IModelListener;
import com.sas.etl.models.IObject;
import com.sas.etl.models.impl.ModelEvent;
import com.sas.etl.models.other.IExtendedAttribute;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsMetadataTableColumn;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsUniqueNameTableColumn;
import java.util.ArrayList;
import java.util.List;

public class ExtendedAttributesTableModel
extends WsAbstractTableModel {
    private static WAdminResource bundle = WAdminResource.getBundle(ExtendedAttributesTableModel.class);
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    private static final int DESCR_COLUMN = 2;
    private static final int EXTENSION_COLUMN = 3;
    private static final int NAME_WIDTH = 100;
    private static final int VALUE_WIDTH = 100;
    private static final int DESCR_WIDTH = 200;
    private static final int VISIBLE_COLUMNS = 3;
    private static final int HIDDEN_COLUMNS = 1;
    private IExtendedAttributesContainer m_container;
    private IModelListener m_lsnrModel;

    public ExtendedAttributesTableModel(IExtendedAttributesContainer container) {
        this.m_container = container;
        this.m_lsnrModel = new ModelListener();
        this.m_container.getModel().addModelListener(this.m_lsnrModel);
        this.createColumnDefinitions();
    }

    public void dispose() {
        this.m_container.getModel().removeModelListener(this.m_lsnrModel);
        this.m_container = null;
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsUniqueNameTableColumn((WsAbstractTableModel)this, 0, bundle.getString("ExtendedAttributesTableModel.Name.txt"), 100, 60);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("ExtendedAttributesTableModel.Value.txt"), 100, 256);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("ExtendedAttributesTableModel.Description.txt"), 200, 200);
        this.m_aColumns[3] = new WsMetadataTableColumn();
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void setValueAt(Object value, int iRow, int iColumn) {
        IExtendedAttribute ea = (IExtendedAttribute)this.getValueAt(iRow, 3);
        if (iColumn == 0) {
            ea.setName((String)value);
        } else if (iColumn == 2) {
            ea.setDescription((String)value);
        } else if (iColumn == 1) {
            ea.setValue((String)value);
        }
    }

    public void populateStore() {
        throw new UnsupportedOperationException("populateStore not supported.  Model does not use a store.");
    }

    public void moveDataToModel() {
        this.clear();
        IExtendedAttribute[] aEAs = this.m_container.getExtendedAttributes();
        for (int iEA = 0; iEA < aEAs.length; ++iEA) {
            this.m_lData.add(this.createRowValues(aEAs[iEA]));
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = this.m_lData.size() + 1;
    }

    public void moveDataToStore() {
        throw new UnsupportedOperationException("moveDataToStore not supported.  Changes are made directly to model.");
    }

    private List createRowValues(IExtendedAttribute ea) {
        ArrayList<String> lValues = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
        lValues.add(ea.getName());
        lValues.add(ea.getValue());
        lValues.add(ea.getDescription());
        lValues.add((String)ea);
        return lValues;
    }

    public int getRowIndex(IExtendedAttribute ea) {
        for (int iRow = 0; iRow < this.m_lData.size(); ++iRow) {
            List lValues = (List)this.m_lData.get(iRow);
            if (lValues.get(3) != ea) continue;
            return iRow;
        }
        return -1;
    }

    public IExtendedAttribute getExtendedAttributeForRow(int iRow) {
        return (IExtendedAttribute)this.getValueAt(iRow, 3);
    }

    public String createUniqueNameForNewExtendedAttribute() {
        return (String)this.m_aColumns[0].createDefaultValue();
    }

    private class ModelListener
    implements IModelListener {
        private ModelListener() {
        }

        public void modelChanged(ModelEvent ev) {
            IExtendedAttribute ea;
            int iRow;
            String sType = ev.getType();
            IObject obj = ev.getModelObject();
            if (sType == "ModelController:UnknownChanges") {
                ExtendedAttributesTableModel.this.moveDataToModel();
            } else if (obj == ExtendedAttributesTableModel.this.m_container) {
                if (sType == "Object:ExtendedAttributeAdded") {
                    IExtendedAttribute ea2 = (IExtendedAttribute)ev.getData();
                    int iInsert = ExtendedAttributesTableModel.this.m_container.getExtendedAttributesList().indexOf(ea2);
                    ExtendedAttributesTableModel.this.insertRow(iInsert - 1, ExtendedAttributesTableModel.this.createRowValues(ea2));
                } else if (sType == "Object:ExtendedAttributeRemoved") {
                    ExtendedAttributesTableModel.this.deleteRow(ExtendedAttributesTableModel.this.getRowIndex((IExtendedAttribute)ev.getData()));
                }
            } else if (obj instanceof IExtendedAttribute && (iRow = ExtendedAttributesTableModel.this.getRowIndex(ea = (IExtendedAttribute)obj)) != -1) {
                if (sType == "Object:NameChanged") {
                    ExtendedAttributesTableModel.super.setValueAt(ea.getName(), iRow, 0);
                } else if (sType == "Object:DescriptionChanged") {
                    ExtendedAttributesTableModel.super.setValueAt(ea.getDescription(), iRow, 2);
                } else if (sType == "ExtendedAttribute:Value") {
                    ExtendedAttributesTableModel.super.setValueAt(ea.getValue(), iRow, 1);
                }
            }
        }
    }
}

