/*
 * Decompiled with CFR 0.152.
 */
package com.sas.wadmin.visuals.common;

import com.sas.codegen.ValidateSASCode;
import com.sas.etl.models.ServerException;
import com.sas.etl.models.data.BadLibraryDefinitionException;
import com.sas.etl.models.data.IColumn;
import com.sas.etl.models.data.IExternalTable;
import com.sas.etl.models.data.IPhysicalTable;
import com.sas.etl.models.data.ITable;
import com.sas.etl.models.data.impl.BaseExternalTable;
import com.sas.etl.models.job.impl.CodegenException;
import com.sas.etl.models.job.transforms.sql.IAliasTable;
import com.sas.etl.models.other.BadServerDefinitionException;
import com.sas.expressions.visuals.DataSourceNodeInterface;
import com.sas.expressions.visuals.DataSourceTreeInterface;
import com.sas.expressions.visuals.DataValuesInterface;
import com.sas.expressions.visuals.DistinctValuesInterface;
import com.sas.expressions.visuals.ExpressionBuilderPanel;
import com.sas.expressions.visuals.FormattedValuesInterface;
import com.sas.metadata.remote.MdException;
import com.sas.wadmin.visuals.common.CodeGenerationEnvironmentFactory;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.SASCodeGeneration;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceTree;
import com.sas.workspace.WsColumnMetadataUtil;
import com.sas.workspace.visuals.expression.ExpressionPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class ExpressionBuilderTab
extends WAPropertyTab
implements ActionListener {
    private static WAdminResource bundle = WAdminResource.getBundle(ExpressionBuilderTab.class);
    protected ExpressionBuilderPanel m_builder;
    protected String m_sExpression;
    protected IColumn[] m_aCols;
    protected ITable[] m_aTables;
    protected boolean m_bUseSQLSyntax = false;
    protected boolean m_bTokenizeExpression = false;
    protected boolean m_bUseQuotes = false;
    protected ValidateSASCode m_validateSASCode;
    protected boolean m_bUseValidateSelect = false;
    private static final String PREF_WINDOW_WIDTH = "PrefExpressionWindowWidth";
    private static final String PREF_WINDOW_HEIGHT = "PrefExpressionWindowHeight";
    protected String m_columnGroupNodeName;

    public ExpressionBuilderTab(IColumn[] cols, ITable[] tables, boolean bUseSQLSyntax, boolean bEnableValidate) {
        this.m_aCols = cols;
        this.m_aTables = tables;
        boolean bUseQuotes = false;
        if (tables != null) {
            for (int i = 0; i < tables.length; ++i) {
                ITable table = tables[i];
                if (!table.isQuoted()) continue;
                bUseQuotes = true;
            }
        }
        this.setUseQuotes(bUseQuotes);
        this.setUseSQLSyntax(bUseSQLSyntax);
        this.initialize();
        this.layoutWidgets();
        if (bEnableValidate) {
            try {
                this.setupValidateButton();
            }
            catch (BadLibraryDefinitionException e) {
                MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
            }
        }
    }

    public ExpressionBuilderTab(IColumn[] cols, ITable[] tables, boolean bUseSQLSyntax) {
        this(cols, tables, bUseSQLSyntax, true);
    }

    public void populateStore() {
    }

    public void moveDataToView() {
        this.setListeningForChanges(false);
        if (this.m_aTables == null || this.m_aTables.length == 0) {
            if (this.m_aCols != null && this.m_aCols.length > 0) {
                this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_aCols));
            } else {
                Workspace.getDefaultLogger().debug((Object)"Nothing to put out to the expression builder tree");
            }
        } else {
            this.m_builder.setDataSourceTreeModel((TreeModel)new MyDataSourceTree(this.m_aCols, this.m_aTables));
        }
        this.setListeningForChanges(true);
    }

    public void moveDataToStore() {
        this.m_sExpression = this.m_builder.getExpressionText();
    }

    public boolean validateData() {
        ExpressionBuilderPanel.LineInfo lineInfo = this.m_builder.computeMaxLineLength();
        return lineInfo.getLine().length() <= 255 || 1 != SASCodeGeneration.displayLineLengthMessage((String)lineInfo.getLine(), (int)lineInfo.getLineNumber());
    }

    protected void initialize() {
        this.m_builder = this.createExpressionPanel();
        int iWidth = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(PREF_WINDOW_WIDTH, this.m_builder.getWidth());
        int iHeight = Workspace.getWorkspace().getAppDefaultsFile().getPropertyInt(PREF_WINDOW_HEIGHT, this.m_builder.getHeight());
        if (iWidth != this.m_builder.getWidth() || iHeight != this.m_builder.getHeight()) {
            this.m_builder.setPreferredSize(new Dimension(iWidth, iHeight));
        }
        ((ExpressionPanel)this.m_builder).restoreSettings("ExpressionBuilderTab", Workspace.getWorkspace().getAppDefaultsFile());
        this.m_builder.setMaximumLineLength(255);
        this.listenForDataChangesTo((JTextComponent)this.m_builder.getExpressionTextPane());
        this.setHelpTopic("about");
        this.setHelpProduct("expbuild");
        this.m_columnGroupNodeName = bundle.getString("ExpressionBuilderTab.MappedColumnsNode.txt");
    }

    protected ExpressionBuilderPanel createExpressionPanel() {
        return new ExpressionPanel();
    }

    protected void layoutWidgets() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_builder, "Center");
    }

    public void setEditable(boolean bEditable) {
        super.setEditable(bEditable);
        this.m_builder.setReadOnly(false);
    }

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(PREF_WINDOW_WIDTH, this.m_builder.getWidth());
        Workspace.getWorkspace().getAppDefaultsFile().setPropertyInt(PREF_WINDOW_HEIGHT, this.m_builder.getHeight());
        ((ExpressionPanel)this.m_builder).saveSettings("ExpressionBuilderTab", Workspace.getWorkspace().getAppDefaultsFile());
        this.m_builder.dispose();
    }

    public boolean useSQLSyntax() {
        return this.m_bUseSQLSyntax;
    }

    public void setUseSQLSyntax(boolean useSQLSyntax) {
        this.m_bUseSQLSyntax = useSQLSyntax;
    }

    public void setUseValidateSelect(boolean useValidateSelect) {
        try {
            this.m_bUseValidateSelect = useValidateSelect;
            StringBuffer sasSelectBeginSyntax = new StringBuffer();
            StringBuffer sasFromClauseForSelectSyntax = new StringBuffer();
            boolean bFromEFI = false;
            if (this.m_aTables[0] instanceof BaseExternalTable) {
                bFromEFI = true;
                StringBuffer datastep = new StringBuffer();
                BaseExternalTable beTable = (BaseExternalTable)this.m_aTables[0];
                try {
                    datastep = beTable.getDataStepCodeToCreateTable(CodeGenerationEnvironmentFactory.getInstance().createCodeGenerationEnvironment(null, null), "", true, "", false);
                }
                catch (RemoteException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (CodegenException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (MdException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (BadServerDefinitionException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                catch (ServerException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
                }
                sasSelectBeginSyntax.append(datastep.toString());
            }
            sasSelectBeginSyntax.append("proc sql;\n");
            sasSelectBeginSyntax.append("   validate \n");
            sasSelectBeginSyntax.append("   select ");
            sasFromClauseForSelectSyntax.append(" from ");
            if (this.m_aTables != null && !bFromEFI) {
                for (int i = 0; i < this.m_aTables.length; ++i) {
                    if (i > 0) {
                        sasFromClauseForSelectSyntax.append(",");
                    }
                    sasFromClauseForSelectSyntax.append(this.getTableNameAndAliasFor(this.m_aTables[i]));
                }
            } else {
                sasFromClauseForSelectSyntax.append("work.etls_EFITable");
            }
            sasFromClauseForSelectSyntax.append(";\n");
            sasFromClauseForSelectSyntax.append("quit;\n");
            this.m_validateSASCode.setSelectBegin(sasSelectBeginSyntax.toString());
            this.m_validateSASCode.setSelectFromClause(sasFromClauseForSelectSyntax.toString());
            this.m_validateSASCode.setValidateSelect(useValidateSelect);
        }
        catch (BadLibraryDefinitionException e) {
            MessageUtil.displayMessage((String)e.getLocalizedMessage(), (int)0);
        }
    }

    public boolean useValidateSelect() {
        return this.m_bUseValidateSelect;
    }

    public void setColumnGroupNodeName(String name) {
        this.m_columnGroupNodeName = name;
    }

    public boolean useQuotes() {
        return this.m_bUseQuotes;
    }

    public void setUseQuotes(boolean bUseQuotes) {
        this.m_bUseQuotes = bUseQuotes;
    }

    public void setExpression(String sExpression) {
        this.m_builder.setExpressionText(sExpression);
    }

    public String getExpression() {
        return this.m_builder.getExpressionText();
    }

    public void setupValidateButton() throws BadLibraryDefinitionException {
        this.m_validateSASCode = new ValidateSASCode();
        this.m_builder.setValidationButtonVisible(true);
        this.m_builder.addValidateActionListener((ActionListener)this);
        if (this.m_aCols != null) {
            this.m_validateSASCode.addTables(this.m_aCols);
        }
        if (this.m_aTables != null) {
            this.m_validateSASCode.addTables(this.m_aTables);
        }
        StringBuffer sasPreExpressionSyntax = new StringBuffer();
        StringBuffer sasPostExpressionSyntax = new StringBuffer();
        if (this.useSQLSyntax()) {
            sasPreExpressionSyntax.append("proc sql;\n");
            sasPreExpressionSyntax.append("   validate \n");
            sasPreExpressionSyntax.append("   select * from ");
            if (this.m_aTables != null) {
                for (int i = 0; i < this.m_aTables.length; ++i) {
                    if (i > 0) {
                        sasPreExpressionSyntax.append(",");
                    }
                    sasPreExpressionSyntax.append(this.getTableNameAndAliasFor(this.m_aTables[i]));
                }
            }
            sasPreExpressionSyntax.append("\n");
            sasPostExpressionSyntax.append("quit;\n");
        } else {
            sasPreExpressionSyntax.append("data null;\n");
            sasPreExpressionSyntax.append("   set ");
            for (int i = 0; i < this.m_aTables.length; ++i) {
                if (i > 0) {
                    sasPreExpressionSyntax.append(" ");
                }
                sasPreExpressionSyntax.append(this.m_aTables[i].getFullNameQuotedAsNeeded(null, this.m_aTables[i].isQuoted(), false));
            }
            sasPreExpressionSyntax.append(";\n");
            sasPostExpressionSyntax.append("run cancel;\n");
        }
        this.m_validateSASCode.setPreExpression(sasPreExpressionSyntax.toString());
        this.m_validateSASCode.setClause(ValidateSASCode.WHERE);
        this.m_validateSASCode.setPostExpression(sasPostExpressionSyntax.toString());
    }

    private String getTableNameAndAliasFor(ITable table) throws BadLibraryDefinitionException {
        IAliasTable aliasTable;
        StringBuffer phrase = new StringBuffer();
        phrase.append(table.getFullNameQuotedAsNeeded(null, table.isQuoted(), false));
        if (table instanceof IAliasTable && (aliasTable = (IAliasTable)table).getAliasedTable() instanceof IPhysicalTable && aliasTable.isAliased()) {
            IPhysicalTable physicalTable = (IPhysicalTable)aliasTable.getAliasedTable();
            String aliasWord = physicalTable.getDBMSType().getTableAliasKeyword(false);
            if (aliasWord != null && aliasWord.length() > 0) {
                phrase.append(aliasWord);
            }
            phrase.append(aliasTable.getAliasName());
        }
        return phrase.toString();
    }

    public void setClause(String clause) {
        this.m_validateSASCode.setClause(clause);
    }

    public ValidateSASCode getValidateSASCode() {
        return this.m_validateSASCode;
    }

    public void setValidateSASCode(ValidateSASCode validateSASCode) {
        this.m_validateSASCode = validateSASCode;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        String expression = this.m_builder.getExpressionText();
        if (expression == null || expression.trim().length() == 0) {
            MessageUtil.displayMessage((String)bundle.getString("ExpressionBuilderTab.NoExpression.txt"), (int)0);
            return;
        }
        if (this.m_aTables.length <= 0) {
            MessageUtil.displayMessage((String)bundle.getString("ExpressionBuilderTab.NoSourceTables.txt"), (int)0);
            return;
        }
        this.validateSyntax(expression.trim());
    }

    private void validateSyntax(String sExpression) {
        this.m_validateSASCode.setExpression(sExpression);
        this.m_validateSASCode.doValidate();
    }

    class MyDataSourceTree
    extends DefaultTreeModel
    implements DataSourceTreeInterface {
        MyDataSourceTree(IColumn[] cols) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols);
            this.setRoot(initRoot);
        }

        MyDataSourceTree(IColumn[] cols, ITable[] tbls) {
            super(new DefaultMutableTreeNode());
            TreeNode initRoot = this.buildRootNode(cols, tbls);
            this.setRoot(initRoot);
        }

        protected TreeNode buildRootNode(IColumn[] cols) {
            if (cols == null) {
                Workspace.getDefaultLogger().error((Object)bundle.getString("ExpressionBuilderTab.missingcols.txt"));
                return null;
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            for (int i = 0; i < cols.length; ++i) {
                IColumn col = cols[i];
                ColumnNode colNode = new ColumnNode(col);
                rootNode.add(colNode);
            }
            return rootNode;
        }

        protected TreeNode buildRootNode(IColumn[] cols, ITable[] tbls) {
            int i;
            if (!(cols != null && cols.length != 0 || tbls != null && tbls.length != 0)) {
                Workspace.getDefaultLogger().error((Object)bundle.getString("ExpressionBuilderTab.missingdata.txt"));
                return null;
            }
            DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
            DefaultMutableTreeNode mappedNode = new DefaultMutableTreeNode(ExpressionBuilderTab.this.m_columnGroupNodeName);
            if (cols != null && cols.length > 0) {
                for (i = 0; i < cols.length; ++i) {
                    IColumn col = cols[i];
                    ColumnNode colNode = new ColumnNode(col, ExpressionBuilderTab.this.useSQLSyntax());
                    mappedNode.add(colNode);
                }
                if (cols.length > 0) {
                    rootNode.add(mappedNode);
                }
            }
            for (i = 0; i < tbls.length; ++i) {
                ITable tbl = tbls[i];
                TableNode tblNode = new TableNode(tbl);
                rootNode.add(tblNode);
                IColumn[] columns = tbl.getColumns();
                for (int iCol = 0; iCol < columns.length; ++iCol) {
                    IColumn col = columns[iCol];
                    ColumnNode colNode = new ColumnNode(col);
                    tblNode.add(colNode);
                }
            }
            return rootNode;
        }

        public TreeCellRenderer getJTreeCellRenderer(JTree tree) {
            return new SourceNodeRenderer();
        }

        class ColumnNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;
            private IColumn m_column;

            ColumnNode(String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            ColumnNode(IColumn col, boolean bUseInsertNameForDisplay) {
                this(col);
                if (bUseInsertNameForDisplay) {
                    this.m_displayName = this.m_insertName;
                    this.setUserObject(this.m_insertName);
                }
            }

            ColumnNode(IColumn col) {
                this.m_column = col;
                this.setUserObject(col.getName());
                this.m_name = col.getName();
                this.m_displayName = col.getName();
                this.m_description = col.getDescription();
                this.m_insertName = ExpressionBuilderTab.this.useSQLSyntax() ? col.getFullColumnName(ExpressionBuilderTab.this.useQuotes()) : col.getColumnName(ExpressionBuilderTab.this.useQuotes());
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName != null ? this.m_insertName + " " : null;
            }

            public IColumn getColumn() {
                return this.m_column;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class TableNode
        extends DefaultMutableTreeNode
        implements DataSourceNodeInterface {
            private ITable m_table;
            private String m_name;
            private String m_displayName;
            private String m_description;
            private String m_insertName;

            TableNode(ITable tbl, String name, String displayName, String desc, String insertName) {
                super(displayName);
                this.m_table = tbl;
                this.m_name = name;
                this.m_displayName = displayName;
                this.m_description = desc;
                this.m_insertName = insertName;
            }

            TableNode(ITable tbl) {
                String name = "";
                name = tbl instanceof IPhysicalTable ? ((IPhysicalTable)tbl).getSASTableName() : tbl.getName();
                this.m_description = tbl.getDescription();
                this.m_table = tbl;
                this.m_name = name;
                this.m_displayName = name;
                this.m_insertName = null;
                this.setUserObject(name);
            }

            public ITable getTable() {
                return this.m_table;
            }

            public String getName() {
                return this.m_name;
            }

            public String getDisplayName() {
                return this.m_displayName;
            }

            public String getDescription() {
                return this.m_description;
            }

            public String getToolTip() {
                return this.m_description;
            }

            public String getInsertName() {
                return this.m_insertName;
            }

            public DataValuesInterface getDataValuesInterface() {
                return null;
            }

            public DistinctValuesInterface getDistinctValuesInterface() {
                return null;
            }

            public FormattedValuesInterface getFormattedValuesInterface() {
                return null;
            }
        }

        protected class SourceNodeRenderer
        extends DefaultTreeCellRenderer {
            public SourceNodeRenderer() {
                this.setLeafIcon(WorkspaceTree.getDefaultLeafIcon());
                this.setOpenIcon(WorkspaceTree.getOpenedFolderIcon());
                this.setClosedIcon(WorkspaceTree.getClosedFolderIcon());
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object node, boolean bSelected, boolean bExpanded, boolean bLeaf, int iRow, boolean bHasFocus) {
                JLabel lbl = (JLabel)super.getTreeCellRendererComponent(tree, node, bSelected, bExpanded, bLeaf, iRow, bHasFocus);
                Icon icon = null;
                if (node instanceof TableNode) {
                    ITable table = ((TableNode)node).getTable();
                    icon = table instanceof IExternalTable ? WAdminResource.getTypeIcon((String)"ExternalTable", (boolean)true) : WAdminResource.getTypeIcon((String)"PhysicalTable", (boolean)true);
                } else if (node instanceof ColumnNode) {
                    IColumn col = ((ColumnNode)node).getColumn();
                    icon = WsColumnMetadataUtil.getColumnTypeIcon((int)col.getType());
                }
                if (icon != null) {
                    lbl.setIcon(icon);
                }
                return lbl;
            }
        }
    }

    @Deprecated
    protected class cExpressionBuilderPanel
    extends ExpressionPanel {
        public cExpressionBuilderPanel() {
        }

        public cExpressionBuilderPanel(int defaultTabsShown) {
            super(defaultTabsShown);
        }

        public JSplitPane getSplitPane() {
            if (this.getFunctionsTab() != null) {
                return this.getFunctionsTab().getSplitPane();
            }
            return null;
        }
    }
}

